/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.HashUtil;

public class VirtualComponent
implements IVirtualComponent {
    IPath runtimePath;
    IProject componentProject;
    IVirtualFolder rootFolder;
    String componentTypeId;
    private int flag = 0;

    protected VirtualComponent() {
    }

    public VirtualComponent(IProject aProject, IPath aRuntimePath) {
        if (aProject == null) {
            throw new NullPointerException();
        }
        this.componentProject = aProject;
        this.runtimePath = aRuntimePath;
        this.rootFolder = ComponentCore.createFolder(this.componentProject, (IPath)new Path("/"));
    }

    public IVirtualComponent getComponent() {
        return this;
    }

    public String getName() {
        return this.getProject().getName();
    }

    public String getDeployedName() {
        StructureEdit core = null;
        IProject project = this.getProject();
        try {
            WorkbenchComponent component;
            if (project != null && this.getName() != null && (core = StructureEdit.getStructureEditForRead(project)) != null && core.getComponent() != null && (component = core.getComponent()).getName() != null && component.getName().length() > 0) {
                String string = component.getName();
                return string;
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        return this.getProject().getName();
    }

    public boolean exists() {
        IProject project = this.getProject();
        return ModuleCoreNature.isFlexibleProject(project);
    }

    public Properties getMetaProperties() {
        StructureEdit core = null;
        Properties props = new Properties();
        try {
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core == null) {
                Properties properties = props;
                return properties;
            }
            WorkbenchComponent component = core.getComponent();
            if (component == null) {
                Properties properties = props;
                return properties;
            }
            EList propList = component.getProperties();
            if (propList != null) {
                int i = 0;
                while (i < propList.size()) {
                    Property property = (Property)propList.get(i);
                    String name = property.getName();
                    String value = property.getValue();
                    if (value == null) {
                        value = "";
                        String message = "WARNING:  The component file in " + this.getProject().getName() + " has no value defined for the property: " + name;
                        ModulecorePlugin.logError(4, message, null);
                    }
                    props.setProperty(name, value);
                    ++i;
                }
            }
            Properties properties = props;
            return properties;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    public void setMetaProperties(Properties properties) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            EList propList = component.getProperties();
            if (properties != null && !properties.isEmpty()) {
                Enumeration<Object> itr = properties.keys();
                while (itr.hasMoreElements()) {
                    String key = (String)itr.nextElement();
                    Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
                    prop.setName(key);
                    prop.setValue(properties.getProperty(key));
                    int i = 0;
                    while (i < propList.size()) {
                        Property existing = (Property)propList.get(i);
                        if (existing.getName().equals(key)) {
                            propList.remove(existing);
                            break;
                        }
                        ++i;
                    }
                    propList.add(prop);
                }
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public void clearMetaProperties() {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            component.getProperties().clear();
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public void setMetaProperty(String key, String value) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            EList properties = component.getProperties();
            int i = 0;
            while (i < properties.size()) {
                Property existing = (Property)properties.get(i);
                if (existing.getName().equals(key)) {
                    properties.remove(existing);
                    break;
                }
                ++i;
            }
            Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
            prop.setName(key);
            prop.setValue(value);
            component.getProperties().add((Object)prop);
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public IPath[] getMetaResources() {
        StructureEdit moduleCore = null;
        ArrayList metaResources = new ArrayList();
        try {
            WorkbenchComponent component;
            moduleCore = StructureEdit.getStructureEditForRead(this.getProject());
            if (moduleCore != null && (component = moduleCore.getComponent()) != null) {
                metaResources.addAll(component.getMetadataResources());
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
        return metaResources.toArray(new IPath[metaResources.size()]);
    }

    public void setMetaResources(IPath[] theMetaResourcePaths) {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component != null) {
                int i = 0;
                while (i < theMetaResourcePaths.length) {
                    if (!component.getMetadataResources().contains((Object)theMetaResourcePaths[i])) {
                        component.getMetadataResources().add((Object)theMetaResourcePaths[i]);
                    }
                    ++i;
                }
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    public int getType() {
        return 64;
    }

    public boolean isBinary() {
        boolean ret = (this.flag & 1) == 1;
        return ret;
    }

    public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = moduleCore.getComponent();
            if (component == null) {
                component = moduleCore.createWorkbenchModule(this.getProject().getName());
            }
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    public IVirtualReference[] getReferences() {
        StructureEdit core = null;
        ArrayList<IVirtualReference> references = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    if (referencedComponent == null) continue;
                    IVirtualReference vReference = StructureEdit.createVirtualReference(this, referencedComponent);
                    if (vReference != null) {
                        vReference.setArchiveName(referencedComponent.getArchiveName());
                    }
                    if (vReference == null || vReference.getReferencedComponent() == null || !vReference.getReferencedComponent().exists()) continue;
                    references.add(vReference);
                }
            }
            IVirtualReference[] iVirtualReferenceArray = references.toArray(new IVirtualReference[references.size()]);
            return iVirtualReferenceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    public void addReferences(IVirtualReference[] references) {
        if (references == null || references.length == 0) {
            return;
        }
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            if (core == null) {
                return;
            }
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent referencedComponent = null;
            ComponentcoreFactory factory = ComponentcorePackage.eINSTANCE.getComponentcoreFactory();
            int i = 0;
            while (i < references.length) {
                if (references[i] != null) {
                    referencedComponent = factory.createReferencedComponent();
                    referencedComponent.setDependencyType(DependencyType.get(references[i].getDependencyType()));
                    referencedComponent.setRuntimePath(references[i].getRuntimePath());
                    IVirtualComponent comp = references[i].getReferencedComponent();
                    if (comp != null && !comp.isBinary()) {
                        referencedComponent.setHandle(ModuleURIUtil.fullyQualifyURI(comp.getProject()));
                    } else if (comp != null) {
                        referencedComponent.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI(comp.getName()));
                    }
                    if (component != null) {
                        component.getReferencedComponents().add((Object)referencedComponent);
                    }
                    referencedComponent.setArchiveName(references[i].getArchiveName());
                }
                ++i;
            }
            if (component != null) {
                this.cleanUpReferences(component);
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    private void cleanUpReferences(WorkbenchComponent component) {
        EList referencedComponents = component.getReferencedComponents();
        Iterator iter = referencedComponents.iterator();
        while (iter.hasNext()) {
            IVirtualReference vReference;
            ReferencedComponent referencedComponent = (ReferencedComponent)iter.next();
            if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference(this, referencedComponent)) != null && vReference.getReferencedComponent() != null && vReference.getReferencedComponent().exists()) continue;
            iter.remove();
        }
    }

    public void setReferences(IVirtualReference[] references) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent referencedComponent = null;
            component.getReferencedComponents().clear();
            ComponentcoreFactory factory = ComponentcorePackage.eINSTANCE.getComponentcoreFactory();
            int i = 0;
            while (i < references.length) {
                referencedComponent = factory.createReferencedComponent();
                referencedComponent.setDependencyType(DependencyType.get(references[i].getDependencyType()));
                referencedComponent.setRuntimePath(references[i].getRuntimePath());
                IVirtualComponent comp = references[i].getReferencedComponent();
                if (!comp.isBinary()) {
                    referencedComponent.setHandle(ModuleURIUtil.fullyQualifyURI(references[i].getReferencedComponent().getProject()));
                } else {
                    referencedComponent.setHandle(ModuleURIUtil.archiveComponentfullyQualifyURI(references[i].getReferencedComponent().getName()));
                }
                referencedComponent.setArchiveName(references[i].getArchiveName());
                component.getReferencedComponents().add((Object)referencedComponent);
                ++i;
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    public int hashCode() {
        int hash = HashUtil.SEED;
        hash = HashUtil.hash((int)hash, (Object)this.getProject().getName());
        hash = HashUtil.hash((int)hash, (Object)this.getName());
        hash = HashUtil.hash((int)hash, (boolean)this.isBinary());
        return hash;
    }

    public boolean equals(Object anOther) {
        if (anOther instanceof IVirtualComponent) {
            IVirtualComponent otherComponent = (IVirtualComponent)anOther;
            return this.getProject().equals((Object)otherComponent.getProject()) && this.getName().equals(otherComponent.getName()) && this.isBinary() == otherComponent.isBinary();
        }
        return false;
    }

    public IVirtualReference getReference(String aComponentName) {
        IVirtualReference[] refs = this.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            if (reference.getReferencedComponent() != null && reference.getReferencedComponent().getName().equals(aComponentName)) {
                return reference;
            }
            ++i;
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public IVirtualFolder getRootFolder() {
        return this.rootFolder;
    }

    public IProject getProject() {
        return this.componentProject;
    }

    public IVirtualComponent[] getReferencingComponents() {
        IProject[] handles = DependencyGraphManager.getInstance().getDependencyGraph().getReferencingComponents(this.getProject());
        IVirtualComponent[] result = new IVirtualComponent[handles.length];
        int i = 0;
        while (i < handles.length) {
            result[i] = ComponentCore.createComponent(handles[i]);
            ++i;
        }
        return result;
    }

    public void removeReference(IVirtualReference aReference) {
        StructureEdit core = null;
        try {
            core = StructureEdit.getStructureEditForWrite(this.getProject());
            if (core == null || aReference == null) {
                return;
            }
            WorkbenchComponent component = core.getComponent();
            ReferencedComponent refComponent = this.getWorkbenchReferencedComponent(aReference, component);
            if (component != null && refComponent != null) {
                component.getReferencedComponents().remove((Object)refComponent);
            }
        }
        finally {
            if (core != null) {
                core.saveIfNecessary(null);
                core.dispose();
            }
        }
    }

    protected ReferencedComponent getWorkbenchReferencedComponent(IVirtualReference aReference, WorkbenchComponent component) {
        if (aReference == null || aReference.getReferencedComponent() == null || component == null) {
            return null;
        }
        EList referencedComponents = component.getReferencedComponents();
        int i = 0;
        while (i < referencedComponents.size()) {
            ReferencedComponent ref = (ReferencedComponent)referencedComponents.get(i);
            if (!aReference.getReferencedComponent().isBinary() ? ref.getHandle().equals((Object)ModuleURIUtil.fullyQualifyURI(aReference.getReferencedComponent().getProject())) : ref.getHandle().equals((Object)ModuleURIUtil.archiveComponentfullyQualifyURI(aReference.getReferencedComponent().getName()))) {
                return ref;
            }
            ++i;
        }
        return null;
    }

    public IVirtualReference[] getAllReferences() {
        StructureEdit core = null;
        ArrayList<IVirtualReference> references = new ArrayList<IVirtualReference>();
        try {
            WorkbenchComponent component;
            core = StructureEdit.getStructureEditForRead(this.getProject());
            if (core != null && core.getComponent() != null && (component = core.getComponent()) != null) {
                EList referencedComponents = component.getReferencedComponents();
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    if (referencedComponent == null) continue;
                    IVirtualReference vReference = StructureEdit.createVirtualReference(this, referencedComponent);
                    if (vReference != null) {
                        vReference.setArchiveName(referencedComponent.getArchiveName());
                    }
                    if (vReference == null || vReference.getReferencedComponent() == null) continue;
                    references.add(vReference);
                }
            }
            IVirtualReference[] iVirtualReferenceArray = references.toArray(new IVirtualReference[references.size()]);
            return iVirtualReferenceArray;
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
    }

    public String toString() {
        return this.componentProject.toString();
    }
}

