/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.JavaSearchBugsTests;
import org.eclipse.wst.jsdt.core.tests.model.SearchTests;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public class JavaSearchBugsTests
extends AbstractJavaSearchTests
implements IJavaScriptSearchConstants {
    private static final int UI_DECLARATIONS = 48;
    static /* synthetic */ Class class$0;

    public JavaSearchBugsTests(String name) {
        super(name);
        this.endChar = "";
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchBugsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchBugsTests.buildModelTestSuite(clazz);
    }

    IJavaScriptSearchScope getJavaSearchScopeBugs() {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("JavaSearchBugs")});
    }

    IJavaScriptSearchScope getJavaSearchScopeBugs(String packageName, boolean addSubpackages) throws JavaScriptModelException {
        if (packageName == null) {
            return this.getJavaSearchScopeBugs();
        }
        return this.getJavaSearchPackageScope("JavaSearchBugs", packageName, addSubpackages);
    }

    public IJavaScriptUnit getWorkingCopy(String path, String source) throws JavaScriptModelException {
        if (this.wcOwner == null) {
            this.wcOwner = new WorkingCopyOwner(){};
        }
        return this.getWorkingCopy(path, source, this.wcOwner, null);
    }

    protected void search(IJavaScriptElement element, int limitTo) throws CoreException {
        this.search(element, limitTo, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)this.resultCollector);
    }

    protected void search(IJavaScriptElement element, int limitTo, int matchRule) throws CoreException {
        this.search(element, limitTo, matchRule, this.getJavaSearchScopeBugs(), (SearchRequestor)this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, this.getJavaSearchScopeBugs(), this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule) throws CoreException {
        this.search(patternString, searchFor, limitTo, matchRule, this.getJavaSearchScopeBugs(), this.resultCollector);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        JAVA_PROJECT = this.setUpJavaProject("JavaSearchBugs", "1.5");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("JavaSearchBugs");
        super.tearDownSuite();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultCollector = new TestCollector();
        this.resultCollector.showInsideDoc = false;
        this.resultCollector.showAccuracy = true;
    }

    public void testBug41018() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b41018/A.js", "package b41018;\npublic class A {\n\tprotected void anotherMethod() {\n\t\tmethodA(null);\n\t}\n\tprivate Object methodA(ClassB.InnerInterface arg3) {\n\t\treturn null;\n\t}\n}\nclass ClassB implements InterfaceB {\n}\ninterface InterfaceB {\n\tinterface InnerInterface {\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("A");
        IFunction method = type.getFunction("methodA", new String[]{"QClassB.InnerInterface;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b41018/A.java void b41018.A.anotherMethod() [methodA(null)] EXACT_MATCH");
    }

    public void testBug70827() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b70827/A.js", "package b70827;\nclass A {\n\tprivate void privateMethod() {\n\t}\n}\nclass Second extends A {\n\tvoid call() {\n\t\tint i= privateMethod();\n\t}\n\tint privateMethod() {\n\t\treturn 1;\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("A");
        IFunction method = type.getFunction("privateMethod", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("");
    }

    public void testBug71279() throws CoreException {
        AbstractJavaSearchTests.JavaSearchResultCollector result = new AbstractJavaSearchTests.JavaSearchResultCollector(){

            public void beginReporting() {
                this.results.append("Starting search...");
            }

            public void endReporting() {
                this.results.append("\nDone searching.");
            }
        };
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b71279/AA.js", "package b71279;\npublic class AA {\n\tUnknown ref;\n}\n");
        new SearchEngine(this.workingCopies).searchDeclarationsOfReferencedTypes((IJavaScriptElement)this.workingCopies[0], (SearchRequestor)result, null);
        this.assertSearchResults("Starting search...\nDone searching.", result);
    }

    public void testBug72866() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b72866/A.js", "package b72866;\npublic abstract class A {\n\tpublic abstract void foo(V v);\n}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b72866/SX.js", "package b72866;\npublic class SX extends A {\n\tpublic void foo(V v) {\n\t    v.bar(this);\n\t}\n}\n", owner, true);
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b72866/V.js", "package b72866;\npublic class V {\n\tvoid bar(A a) {}\n\tvoid bar(X x) {}\n\tvoid bar(SX s) {}\n}\n", owner, true);
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b72866/X.js", "package b72866;\npublic class X extends A {\n\tpublic void foo(V v) {\n\t    v.bar(this);\n\t}\n}\n", owner, true);
        IType type = this.workingCopies[2].getType("V");
        IFunction method = type.getFunction("bar", new String[]{"QX;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b72866/X.java void b72866.X.foo(V) [bar(this)] EXACT_MATCH");
    }

    public void testBug73112a() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b73112/A.js", "package b73112;\npublic class A {\n    int fieldA73112a = 1, fieldA73112b = new Integer(2).intValue(), fieldA73112c = fieldA73112a + fieldA73112b;\n    int fieldA73112d;\n    \n    public void method(){}\n}\n");
        this.search("fieldA73112*", 4, 3);
        this.assertSearchResults("src/b73112/A.java b73112.A.fieldA73112a [fieldA73112a] EXACT_MATCH\nsrc/b73112/A.java b73112.A.fieldA73112b [fieldA73112b] EXACT_MATCH\nsrc/b73112/A.java b73112.A.fieldA73112c [fieldA73112c] EXACT_MATCH\nsrc/b73112/A.java b73112.A.fieldA73112c [fieldA73112a] EXACT_MATCH\nsrc/b73112/A.java b73112.A.fieldA73112c [fieldA73112b] EXACT_MATCH\nsrc/b73112/A.java b73112.A.fieldA73112d [fieldA73112d] EXACT_MATCH");
    }

    public void testBug73112b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = super.getWorkingCopy("/JavaSearchBugs/src/b73112/B.js", "package b73112;\npublic class B {\n    int fieldB73112a, fieldB73112b = 10;\n    int fieldB73112c = fieldB73112a + fieldB73112b, fieldB73112d = fieldB73112c + fieldB73112a, fieldB73112e;\n    \n    public void method(){}\n}\n");
        this.search("fieldB73112*", 4, 3);
        this.assertSearchResults("src/b73112/B.java b73112.B.fieldB73112a [fieldB73112a] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112b [fieldB73112b] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112c [fieldB73112c] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112c [fieldB73112a] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112c [fieldB73112b] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112d [fieldB73112d] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112d [fieldB73112c] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112d [fieldB73112a] EXACT_MATCH\nsrc/b73112/B.java b73112.B.fieldB73112e [fieldB73112e] EXACT_MATCH");
    }

    public void testBug73336() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[6];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/A.js", "package b73336;\npublic class A {}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/AA.js", "package b73336;\npublic class AA extends A {}\n", owner, true);
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/B.js", "package b73336;\npublic class B extends X<A, A> {\n\t<T> void foo(T t) {}\n}\n", owner, true);
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/C.js", "package b73336;\npublic class C implements I<A> {\n\tpublic void foo() {\n\t\tB b = new B();\n\t\tb.<A>foo(new A());\n\t}\n}\n", owner, true);
        this.workingCopies[4] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/I.js", "package b73336;\npublic interface I<T>  {\n\tpublic void foo();\n}\n", owner, true);
        this.workingCopies[5] = this.getWorkingCopy("/JavaSearchBugs/src/b73336/X.js", "package b73336;\npublic class X<T, U> {\n\t<V> void foo(V v) {}\n\tclass Member<T> {\n\t\tvoid foo() {}\n\t}\n}\n", owner, true);
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b73336/AA.java b73336.AA [A] EXACT_MATCH\nsrc/b73336/B.java b73336.B [A] EXACT_MATCH\nsrc/b73336/B.java b73336.B [A] EXACT_MATCH\nsrc/b73336/C.java b73336.C [A] EXACT_MATCH\nsrc/b73336/C.java void b73336.C.foo() [A] EXACT_MATCH\nsrc/b73336/C.java void b73336.C.foo() [A] EXACT_MATCH");
    }

    public void testBug73336b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b73336b/A.js", "package b73336b;\npublic class A {}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b73336b/B.js", "package b73336b;\npublic class B extends X<A, A> {\n}\n", owner, true);
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b73336b/C.js", "package b73336b;\npublic class C extends X<A, A>.Member<A> {\n\tpublic C() {\n\t\tnew X<A, A>().super();\n\t}\n}\n", owner, true);
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b73336b/X.js", "package b73336b;\npublic class X<T, U> {\n\t<V> void foo(V v) {}\n\tclass Member<T> {\n\t\tvoid foo() {}\n\t}\n}\n", owner, true);
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b73336b/B.java b73336b.B [A] EXACT_MATCH\nsrc/b73336b/B.java b73336b.B [A] EXACT_MATCH\nsrc/b73336b/C.java b73336b.C [A] EXACT_MATCH\nsrc/b73336b/C.java b73336b.C [A] EXACT_MATCH\nsrc/b73336b/C.java b73336b.C [A] EXACT_MATCH\nsrc/b73336b/C.java b73336b.C() [A] EXACT_MATCH\nsrc/b73336b/C.java b73336b.C() [A] EXACT_MATCH");
    }

    public void testBug73336c() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b73336c/A.js", "package b73336c;\npublic class A {}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b73336c/B.js", "package b73336c;\npublic class B extends X<A, A> {\n}\n", owner, true);
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b73336c/C.js", "package b73336c;\npublic class C implements X<A, A>.Interface<A>  {\n\tvoid bar() {}\n}\n", owner, true);
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b73336c/X.js", "package b73336c;\npublic class X<T, U> {\n\tinterface Interface<V> {\n\t\tvoid bar();\n\t}\n}\n", owner, true);
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b73336c/B.java b73336c.B [A] EXACT_MATCH\nsrc/b73336c/B.java b73336c.B [A] EXACT_MATCH\nsrc/b73336c/C.java b73336c.C [A] EXACT_MATCH\nsrc/b73336c/C.java b73336c.C [A] EXACT_MATCH\nsrc/b73336c/C.java b73336c.C [A] EXACT_MATCH");
    }

    public void testBug73696() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b73696/C.js", "package b73696;\npublic class C implements  I {\n}", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b73696/I.js", "package b73696;\npublic interface I {}\n", owner, true);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])this.workingCopies);
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(null, null, null, 'I', 2);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopies[1]}).search((SearchPattern)pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        pattern = new TypeDeclarationPattern(null, null, null, 'C', 2);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopies[0]}).search((SearchPattern)pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/b73696/I.java b73696.I [I] EXACT_MATCH\nsrc/b73696/C.java b73696.C [C] EXACT_MATCH");
    }

    public void testBug74776() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b74776/A.js", "package b74776;\npublic class A {\n\t/**\n\t * @deprecated Use {@link #foo(IRegion)} instead\n\t * @param r\n\t */\n\tvoid foo(Region r) {\n\t\tfoo((IRegion)r);\n\t}\n\tvoid foo(IRegion r) {\n\t}\n}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b74776/IRegion.js", "package b74776;\npublic interface IRegion {\n}\n", owner, true);
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b74776/Region.js", "package b74776;\npublic class Region implements IRegion {\n\n}\n", owner, true);
        IType type = this.workingCopies[0].getType("A");
        IFunction method = type.getFunction("foo", new String[]{"QRegion;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("");
    }

    public void testBug75816() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/test75816.jar", "", "Test.class").getType();
        IType innerType = type.getType("Inner");
        IFunction[] methods = innerType.getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Wrong number of method.", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("lib/test75816.jar Test.Inner Test.newInner(java.lang.Object) EXACT_MATCH");
    }

    private void setUpBug77093() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b77093/X.js", "package b77093;\npublic class X {\n\tclass Z {\n\t}\n\tZ[][] z_arrays;\n\tX() {\n\t\tthis(new Z[10][]);\n\t}\n\tX(Z[][] arrays) {\n\t\tz_arrays = arrays;\n\t}\n\tprivate void foo(Z[] args) {\n\t}\n\tvoid bar() {\n\t\tfor (int i=0; i<z_arrays.length; i++)\n\t\t\tfoo(z_arrays[i]);\n\t}\n}");
    }

    public void testBug77093constructor() throws CoreException {
        this.setUpBug77093();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("X", new String[]{"[[QZ;"});
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("src/b77093/X.java b77093.X() [this(new Z[10][]);] EXACT_MATCH\nsrc/b77093/X.java b77093.X(Z[][]) [X] EXACT_MATCH");
    }

    public void testBug77093field() throws CoreException {
        this.setUpBug77093();
        IType type = this.workingCopies[0].getType("X");
        IField field = type.getField("z_arrays");
        this.search((IJavaScriptElement)field, 3);
        this.assertSearchResults("src/b77093/X.java b77093.X.z_arrays [z_arrays] EXACT_MATCH\nsrc/b77093/X.java b77093.X(Z[][]) [z_arrays] EXACT_MATCH\nsrc/b77093/X.java void b77093.X.bar() [z_arrays] EXACT_MATCH\nsrc/b77093/X.java void b77093.X.bar() [z_arrays] EXACT_MATCH");
    }

    public void testBug77093method() throws CoreException {
        this.setUpBug77093();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"[QZ;"});
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("src/b77093/X.java void b77093.X.foo(Z[]) [foo] EXACT_MATCH\nsrc/b77093/X.java void b77093.X.bar() [foo(z_arrays[i])] EXACT_MATCH");
    }

    public void testBug77388() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b77388/Test.js", "package b77388;\nclass Test {\n\tTest(int a, int b) {\t}\n\tvoid take(Test mc) { }\n\tvoid run() {\n\t\ttake( new Test(1, 2) ); // space in \") )\" is in match\n\t}\n}");
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("Test", new String[]{"I", "I"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b77388/Test.java void b77388.Test.run() [new Test(1, 2)] EXACT_MATCH");
    }

    public void testBug78082() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b78082/M.js", "package b78082;\npublic class M {\n\tstatic int VAL=78082;\n}\n", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b78082/XY.js", "package b78082;\nimport static b78082.M.VAL;\npublic class XY {\n\tdouble val = VAL;\n\tdouble val2= b78082.M.VAL;\n}\n", owner, true);
        IType type = this.workingCopies[0].getType("M");
        IField field = type.getField("VAL");
        this.search((IJavaScriptElement)field, 3);
        this.assertSearchResults("src/b78082/M.java b78082.M.VAL [VAL] EXACT_MATCH\nsrc/b78082/XY.java [VAL] EXACT_MATCH\nsrc/b78082/XY.java b78082.XY.val [VAL] EXACT_MATCH\nsrc/b78082/XY.java b78082.XY.val2 [VAL] EXACT_MATCH");
    }

    public void testBug79267() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79267/Test.js", "package b79267;\npublic class Test {\n\tprivate static final X<String, String> BEFORE\t= new X<String, String>(4);\n\n\tstatic {\n\t\tBEFORE.put(\"key1\",\"value1\");\n\t\tBEFORE.put(\"key2\",\"value2\");\n\t}\n\t\n\tprivate static final X<Y, Object>\tobjectToPrimitiveMap\t= new X<Y, Object>(8);\n\n\tstatic {\n\t\tobjectToPrimitiveMap.put(new Y<Object>(new Object()), new Object());\n\t}\n}\n\nclass X<T, U> {\n\tX(int x) {}\n\tvoid put(T t, U u) {}\n}\n\nclass Y<T> {\n\tY(T t) {}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        IField field = type.getField("BEFORE");
        this.search((IJavaScriptElement)field, 2);
        field = type.getField("objectToPrimitiveMap");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b79267/Test.java b79267.Test.static {} [BEFORE] EXACT_MATCH\nsrc/b79267/Test.java b79267.Test.static {} [BEFORE] EXACT_MATCH\nsrc/b79267/Test.java b79267.Test.static {} [objectToPrimitiveMap] EXACT_MATCH");
    }

    public void testBug79378() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79378/A.js", "package b79378;\npublic class Test {\n\tvoid foo79378(String s, RuntimeException[] exceptions) {}\n\tvoid foo79378(RuntimeException[] exceptions) {}\n\tvoid call() {\n\t\tString s= null; \n\t\tException[] exceptions= null;\n\t\tfoo79378(s, exceptions);\n\t}\n}\n");
        IFunction[] methods = this.workingCopies[0].getType("Test").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)3, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("src/b79378/A.java void b79378.Test.call() [foo79378(s, exceptions)] POTENTIAL_MATCH");
    }

    public void testBug79378b() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79378/A.js", "package b79378;\npublic class Test {\n\tvoid foo79378(String s, RuntimeException[] exceptions) {}\n\tvoid foo79378(RuntimeException[] exceptions) {}\n\tvoid call() {\n\t\tString s= null; \n\t\tException[] exceptions= null;\n\t\tfoo79378(s, exceptions);\n\t}\n}\n");
        IFunction[] methods = this.workingCopies[0].getType("Test").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)3, (int)methods.length);
        this.search((IJavaScriptElement)methods[1], 2);
        this.assertSearchResults("");
    }

    public void testBug79803() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79803/A.js", "package b79803;\nclass A<A> {\n    A a;\n    b79803.A pa= new b79803.A();\n}\n");
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2, ERASURE_RULE);
        this.assertSearchResults("src/b79803/A.java b79803.A.pa [b79803.A] EXACT_MATCH\nsrc/b79803/A.java b79803.A.pa [b79803.A] EXACT_MATCH");
    }

    public void testBug79803string() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79803/A.js", "package b79803;\nclass A<A> {\n    A a;\n    b79803.A pa= new b79803.A();\n}\n");
        this.search("A", 0, 2);
        this.assertSearchResults("src/b79803/A.java b79803.A.a [A] EXACT_MATCH\nsrc/b79803/A.java b79803.A.pa [A] EXACT_MATCH\nsrc/b79803/A.java b79803.A.pa [A] EXACT_MATCH");
    }

    public void testBug79860() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79860/X.js", "package b79860;\npublic class X<T extends A> { }\nclass A { }", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b79860/Y.js", "package b79860;\npublic class Y<T extends B&I1&I2&I3> { }\nclass B { }\ninterface I1 {}\ninterface I2 {}\ninterface I3 {}\n", owner, true);
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b79860/X.java b79860.X [A] EXACT_MATCH");
    }

    public void testBug79860string() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79860/X.js", "package b79860;\npublic class X<T extends A> { }\nclass A { }", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b79860/Y.js", "package b79860;\npublic class Y<T extends B&I1&I2&I3> { }\nclass B { }\ninterface I1 {}\ninterface I2 {}\ninterface I3 {}\n", owner, true);
        this.search("I?", 0, 2);
        this.assertSearchResults("src/b79860/Y.java b79860.Y [I1] EXACT_MATCH\nsrc/b79860/Y.java b79860.Y [I2] EXACT_MATCH\nsrc/b79860/Y.java b79860.Y [I3] EXACT_MATCH");
    }

    private void setUpBug79990() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79990/Test.js", "package b79990;\nclass Test<T> {\n    public void first(Exception num) {}\n    public void second(T t) {}\n}\nclass Sub extends Test<Exception> {\n    public void first(Exception num) {}\n    public void second(Exception t) {}\n}\n");
    }

    public void testBug79990() throws CoreException {
        this.setUpBug79990();
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[0];
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b79990/Test.java void b79990.Test.first(Exception) [first] EXACT_MATCH\nsrc/b79990/Test.java void b79990.Sub.first(Exception) [first] EXACT_MATCH");
    }

    public void testBug79990b() throws CoreException {
        this.setUpBug79990();
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[1];
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b79990/Test.java void b79990.Test.second(T) [second] EXACT_MATCH\nsrc/b79990/Test.java void b79990.Sub.second(Exception) [second] EXACT_MATCH");
    }

    public void testBug79990c() throws CoreException {
        this.setUpBug79990();
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[1];
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b79990/Test.java void b79990.Test.second(T) [second] EXACT_MATCH\nsrc/b79990/Test.java void b79990.Sub.second(Exception) [second] EXACT_MATCH");
    }

    public void testBug79990d() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b79990/Test.js", "package b79990;\npublic class Test<T> {\n\tvoid methodT(T t) {}\n}\nclass Sub<X> extends Test<X> {\n\tvoid methodT(X x) {} // overrides Super#methodT(T)\n}\n");
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[0];
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b79990/Test.java void b79990.Test.methodT(T) [methodT] EXACT_MATCH\nsrc/b79990/Test.java void b79990.Sub.methodT(X) [methodT] EXACT_MATCH");
    }

    public void testBug80084() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80084/Test.js", "package b80084;\nclass List<T> {}\npublic class Test {\n  void foo(List<Exception> le) {}\n  void bar() {\n    List<Exception> le = new List<Exception>();\n    foo(le);\n  }\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QList<QException;>;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b80084/Test.java void b80084.Test.bar() [foo(le)] EXACT_MATCH");
    }

    private void setUpBug80194() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80194/Test.js", "package b80194;\ninterface Map<K, V> {}\nclass HashMap<K, V> implements Map {}\npublic class Test {\n\tvoid callDoSomething() {\n\t\tfinal Map<String, Object> map = new HashMap<String, Object>();\n\t\tdoSomething(map);\n\t\tdoSomething(map, true);\n\t\tdoSomething(true);\n\t}\n\tvoid doSomething(final Map<String, Object> map) {}\n\tvoid doSomething(final Map<String, Object> map, final boolean flag) {}\n\tvoid doSomething(final boolean flag) {}\n}\n");
    }

    public void testBug80194() throws CoreException, JavaScriptModelException {
        this.setUpBug80194();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("doSomething", new String[]{"QMap<QString;QObject;>;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(map)] EXACT_MATCH");
    }

    public void testBug80194b() throws CoreException, JavaScriptModelException {
        this.setUpBug80194();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("doSomething", new String[]{"QMap<QString;QObject;>;", "Z"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(map, true)] EXACT_MATCH");
    }

    public void testBug80194string1() throws CoreException, JavaScriptModelException {
        this.setUpBug80194();
        this.search("doSomething(boolean)", 1, 3);
        this.assertSearchResults("src/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(map)] EXACT_MATCH\nsrc/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(true)] EXACT_MATCH\nsrc/b80194/Test.java void b80194.Test.doSomething(boolean) [doSomething] EXACT_MATCH");
    }

    public void testBug80194string2() throws CoreException, JavaScriptModelException {
        this.setUpBug80194();
        this.search("doSomething(Map<String,Object>)", 1, 3);
        this.assertSearchResults("src/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(map)] EXACT_MATCH\nsrc/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(true)] EXACT_MATCH\nsrc/b80194/Test.java void b80194.Test.doSomething(Map<String,Object>) [doSomething] EXACT_MATCH");
    }

    public void testBug80194string3() throws CoreException, JavaScriptModelException {
        this.setUpBug80194();
        this.search("doSomething(Map<String,Object>,boolean)", 1, 3);
        this.assertSearchResults("src/b80194/Test.java void b80194.Test.callDoSomething() [doSomething(map, true)] EXACT_MATCH\nsrc/b80194/Test.java void b80194.Test.doSomething(Map<String,Object>, boolean) [doSomething] EXACT_MATCH");
    }

    public void testBug80223() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        WorkingCopyOwner owner = new WorkingCopyOwner(){};
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80223/a/A.js", "package b80223.a;\npublic class A {\n    void m() {}\n}", owner, true);
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b80223/b/B.js", "package b80223.b;\npublic class B extends b80223.a.A {\n    void m() {}\n}", owner, true);
        IType type = this.workingCopies[0].getType("A");
        IFunction method = type.getFunction("m", new String[0]);
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b80223/a/A.java void b80223.a.A.m() [m] EXACT_MATCH");
    }

    private void setUpBug80264_Methods() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80264/Methods.js", "package b80264;\nclass Methods {\n    Methods stable() { return null; }\n    Methods covariant() { return null; }\n}\nclass MethodsSub extends Methods {\n    Methods stable() { return null; }\n    MethodsSub covariant() { return null; }\n}\nclass MethodsOther {\n    Methods stable() { return null; }\n    Methods covariant() { return null; }\n}\n");
    }

    public void testBug80264_Methods() throws CoreException {
        this.setUpBug80264_Methods();
        IType type = this.workingCopies[0].getType("Methods");
        IFunction[] methods = type.getFunctions();
        this.search((IJavaScriptElement)methods[0], 0);
        this.search((IJavaScriptElement)methods[1], 0);
        this.assertSearchResults("src/b80264/Methods.java Methods b80264.Methods.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsSub.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.Methods.covariant() [covariant] EXACT_MATCH\nsrc/b80264/Methods.java MethodsSub b80264.MethodsSub.covariant() [covariant] EXACT_MATCH");
    }

    public void testBug80264_MethodsIgnoreDeclaringType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Methods();
        IType type = this.workingCopies[0].getType("Methods");
        IFunction[] methods = type.getFunctions();
        this.search((IJavaScriptElement)methods[0], 16);
        this.search((IJavaScriptElement)methods[1], 16);
        this.assertSearchResults("src/b80264/Methods.java Methods b80264.Methods.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsSub.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsOther.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.Methods.covariant() [covariant] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsOther.covariant() [covariant] EXACT_MATCH");
    }

    public void testBug80264_MethodsIgnoreReturnType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Methods();
        IType type = this.workingCopies[0].getType("Methods");
        IFunction[] methods = type.getFunctions();
        this.search((IJavaScriptElement)methods[0], 32);
        this.search((IJavaScriptElement)methods[1], 32);
        this.assertSearchResults("src/b80264/Methods.java Methods b80264.Methods.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsSub.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.Methods.covariant() [covariant] EXACT_MATCH\nsrc/b80264/Methods.java MethodsSub b80264.MethodsSub.covariant() [covariant] EXACT_MATCH");
    }

    public void testBug80264_MethodsIgnoreBothTypes() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Methods();
        IType type = this.workingCopies[0].getType("Methods");
        IFunction[] methods = type.getFunctions();
        this.search((IJavaScriptElement)methods[0], 48);
        this.search((IJavaScriptElement)methods[1], 48);
        this.assertSearchResults("src/b80264/Methods.java Methods b80264.Methods.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsSub.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsOther.stable() [stable] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.Methods.covariant() [covariant] EXACT_MATCH\nsrc/b80264/Methods.java MethodsSub b80264.MethodsSub.covariant() [covariant] EXACT_MATCH\nsrc/b80264/Methods.java Methods b80264.MethodsOther.covariant() [covariant] EXACT_MATCH");
    }

    private void setUpBug80264_Classes() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80264/Classes.js", "package b80264;\nclass Classes {\n    class Inner {}\n}\nclass ClassesSub extends Classes {\n    class Inner {}\n}\nclass ClassesOther {\n    class Inner {}\n}\n");
    }

    public void testBug80264_Classes() throws CoreException {
        this.setUpBug80264_Classes();
        IType type = this.workingCopies[0].getType("Classes").getType("Inner");
        this.search((IJavaScriptElement)type, 0);
        this.assertSearchResults("src/b80264/Classes.java b80264.Classes$Inner [Inner] EXACT_MATCH");
    }

    public void testBug80264_ClassesIgnoreDeclaringType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Classes();
        IType type = this.workingCopies[0].getType("Classes").getType("Inner");
        this.search((IJavaScriptElement)type, 16);
        this.assertSearchResults("src/b80264/Classes.java b80264.Classes$Inner [Inner] EXACT_MATCH\nsrc/b80264/Classes.java b80264.ClassesSub$Inner [Inner] EXACT_MATCH\nsrc/b80264/Classes.java b80264.ClassesOther$Inner [Inner] EXACT_MATCH");
    }

    public void testBug80264_ClassesIgnoreReturnType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Classes();
        IType type = this.workingCopies[0].getType("Classes").getType("Inner");
        this.search((IJavaScriptElement)type, 32);
        this.assertSearchResults("src/b80264/Classes.java b80264.Classes$Inner [Inner] EXACT_MATCH");
    }

    public void testBug80264_ClassesIgnoreTypes() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Classes();
        IType type = this.workingCopies[0].getType("Classes").getType("Inner");
        this.search((IJavaScriptElement)type, 48);
        this.assertSearchResults("src/b80264/Classes.java b80264.Classes$Inner [Inner] EXACT_MATCH\nsrc/b80264/Classes.java b80264.ClassesSub$Inner [Inner] EXACT_MATCH\nsrc/b80264/Classes.java b80264.ClassesOther$Inner [Inner] EXACT_MATCH");
    }

    private void setUpBug80264_Fields() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80264/Fields.js", "package b80264;\nclass Fields {\n    Fields field1;\n    Fields field2;\n}\nclass FieldsSub extends Fields {\n    Fields field1;\n    FieldsSub field2;\n}\nclass FieldsOther {\n    Fields field1;\n    Fields field2;\n}\n");
    }

    public void testBug80264_Fields() throws CoreException {
        this.setUpBug80264_Fields();
        IType type = this.workingCopies[0].getType("Fields");
        IField[] fields = type.getFields();
        this.search((IJavaScriptElement)fields[0], 0);
        this.search((IJavaScriptElement)fields[1], 0);
        this.assertSearchResults("src/b80264/Fields.java b80264.Fields.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.Fields.field2 [field2] EXACT_MATCH");
    }

    public void testBug80264_FieldsIgnoreDeclaringType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Fields();
        IType type = this.workingCopies[0].getType("Fields");
        IField[] fields = type.getFields();
        this.search((IJavaScriptElement)fields[0], 16);
        this.search((IJavaScriptElement)fields[1], 16);
        this.assertSearchResults("src/b80264/Fields.java b80264.Fields.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsSub.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsOther.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.Fields.field2 [field2] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsOther.field2 [field2] EXACT_MATCH");
    }

    public void testBug80264_FieldsIgnoreReturnType() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Fields();
        IType type = this.workingCopies[0].getType("Fields");
        IField[] fields = type.getFields();
        this.search((IJavaScriptElement)fields[0], 32);
        this.search((IJavaScriptElement)fields[1], 32);
        this.assertSearchResults("src/b80264/Fields.java b80264.Fields.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.Fields.field2 [field2] EXACT_MATCH");
    }

    public void testBug80264_FieldsIgnoreBothTypes() throws CoreException, JavaScriptModelException {
        this.setUpBug80264_Fields();
        IType type = this.workingCopies[0].getType("Fields");
        IField[] fields = type.getFields();
        this.search((IJavaScriptElement)fields[0], 48);
        this.search((IJavaScriptElement)fields[1], 48);
        this.assertSearchResults("src/b80264/Fields.java b80264.Fields.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsSub.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsOther.field1 [field1] EXACT_MATCH\nsrc/b80264/Fields.java b80264.Fields.field2 [field2] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsSub.field2 [field2] EXACT_MATCH\nsrc/b80264/Fields.java b80264.FieldsOther.field2 [field2] EXACT_MATCH");
    }

    public void testBug80890() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b80890/A.js", "package b80890;\npublic class A {\n\tprotected void foo(Exception e) {}\n\tprotected void foo(String s) {}\n}\nclass B1 extends A {\n\tpublic void bar1() {\n\t\tfoo(null);\n\t}\n}\nclass B2 extends A {\n\tpublic void bar2() {\n\t\tfoo(null);\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("A");
        IFunction method = type.getFunctions()[0];
        this.search((IJavaScriptElement)method, 2);
        method = type.getFunctions()[1];
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b80890/A.java void b80890.B1.bar1() [foo(null)] POTENTIAL_MATCH\nsrc/b80890/A.java void b80890.B2.bar2() [foo(null)] POTENTIAL_MATCH\nsrc/b80890/A.java void b80890.B1.bar1() [foo(null)] POTENTIAL_MATCH\nsrc/b80890/A.java void b80890.B2.bar2() [foo(null)] POTENTIAL_MATCH");
    }

    public void testBug80918() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", this.getExternalJCLPathString("1.5"), "java.lang", "Exception.class").getType();
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{this.getJavaProject("JavaSearchBugs")}, (int)1);
        this.search((IJavaScriptElement)type, 2, 24, scope);
        this.assertSearchResults("");
    }

    public void testBug81084a() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b81084a/Test.js", "package b81084a;\nclass List<E> {}\npublic class Test {\n\tclass Element{}\n\tstatic class Inner {\n\t\tprivate final List<Element> fList1;\n\t\tprivate final List<Test.Element> fList2;\n\t\tpublic Inner(List<Element> list) {\n\t\t\tfList1 = list;\n\t\t\tfList2 = list;\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test").getType("Inner");
        IField field1 = type.getField("fList1");
        this.search((IJavaScriptElement)field1, 2);
        IField field2 = type.getField("fList2");
        this.search((IJavaScriptElement)field2, 2);
        this.assertSearchResults("src/b81084a/Test.java b81084a.Test$Inner(List<Element>) [fList1] EXACT_MATCH\nsrc/b81084a/Test.java b81084a.Test$Inner(List<Element>) [fList2] EXACT_MATCH");
    }

    public void testBug81084string() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b81084a/Test.js", "package b81084a;\nclass List<E> {}\npublic class Test {\n\tclass Element{}\n\tstatic class Inner {\n\t\tprivate final List<Element> fList1;\n\t\tprivate final List<Test.Element> fList2;\n\t\tpublic Inner(List<Element> list) {\n\t\t\tfList1 = list;\n\t\t\tfList2 = list;\n\t\t}\n\t}\n}\n");
        this.search("fList1", 4, 2);
        this.search("fList2", 4, 2);
        this.assertSearchResults("src/b81084a/Test.java b81084a.Test$Inner(List<Element>) [fList1] EXACT_MATCH\nsrc/b81084a/Test.java b81084a.Test$Inner(List<Element>) [fList2] EXACT_MATCH");
    }

    public void testBug81084b() throws CoreException, JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b81084b/Test.js", "package b81084b;\nclass List<E> {}\npublic class Test {\n\tclass Element{}\n\tstatic class Inner {\n\t\tprivate final List<? extends Element> fListb1;\n\t\tprivate final List<? extends Test.Element> fListb2;\n\t\tpublic Inner(List<Element> list) {\n\t\t\tfListb1 = list;\n\t\t\tfListb2 = list;\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test").getType("Inner");
        IField field1 = type.getField("fListb1");
        this.search((IJavaScriptElement)field1, 2);
        IField field2 = type.getField("fListb2");
        this.search((IJavaScriptElement)field2, 2);
        this.assertSearchResults("src/b81084b/Test.java b81084b.Test$Inner(List<Element>) [fListb1] EXACT_MATCH\nsrc/b81084b/Test.java b81084b.Test$Inner(List<Element>) [fListb2] EXACT_MATCH");
    }

    public void testBug81556() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b81556.a", "X81556.js");
        IType type = unit.getType("X81556");
        IFunction method = type.getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b81556/a/A81556.java void b81556.a.A81556.bar(XX81556) [foo()] EXACT_MATCH");
    }

    public void testBug82088method() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b82088/m/Test.js", "package b82088.m;\n/**\n * @see #setA(A)\n */\npublic class Test {\n\tA a;\n\tpublic void setA(A a) {\n\t\tthis.a = a;\n\t}\n}\nclass A {}\n");
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b82088/m/Test.java b82088.m.Test [A] EXACT_MATCH\nsrc/b82088/m/Test.java b82088.m.Test.a [A] EXACT_MATCH\nsrc/b82088/m/Test.java void b82088.m.Test.setA(A) [A] EXACT_MATCH");
    }

    public void testBug82088constructor() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b82088/c/Test.js", "package b82088.c;\n/**\n * @see #Test(A)\n */\npublic class Test {\n\tA a;\n\tTest(A a) {\n\t\tthis.a = a;\n\t}\n}\nclass A {}\n");
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b82088/c/Test.java b82088.c.Test [A] EXACT_MATCH\nsrc/b82088/c/Test.java b82088.c.Test.a [A] EXACT_MATCH\nsrc/b82088/c/Test.java b82088.c.Test(A) [A] EXACT_MATCH");
    }

    private void setUpBug82208() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b82208/Test.js", "package b82208;\ninterface B82208_I {}\nenum B82208_E {}\n@interface B82208_A {}\npublic class B82208 {}\n");
    }

    public void testBug82208_TYPE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 0, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_I [B82208_I] EXACT_MATCH\nsrc/b82208/Test.java b82208.B82208_E [B82208_E] EXACT_MATCH\nsrc/b82208/Test.java b82208.B82208_A [B82208_A] EXACT_MATCH\nsrc/b82208/Test.java b82208.B82208 [B82208] EXACT_MATCH");
    }

    public void testBug82208_CLASS() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 5, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208 [B82208] EXACT_MATCH");
    }

    public void testBug82208_INTERFACE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 6, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_I [B82208_I] EXACT_MATCH");
    }

    public void testBug82208_ENUM() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 7, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_E [B82208_E] EXACT_MATCH");
    }

    public void testBug82208_ANNOTATION_TYPE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 8, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_A [B82208_A] EXACT_MATCH");
    }

    public void testBug82208_CLASS_AND_INTERFACE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 10, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_I [B82208_I] EXACT_MATCH\nsrc/b82208/Test.java b82208.B82208 [B82208] EXACT_MATCH");
    }

    public void testBug82208_CLASS_AND_ENUMERATION() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug82208();
        this.search("B82208*", 9, 3);
        this.assertSearchResults("src/b82208/Test.java b82208.B82208_E [B82208_E] EXACT_MATCH\nsrc/b82208/Test.java b82208.B82208 [B82208] EXACT_MATCH");
    }

    public void testBug82673() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b82673/Test.js", "package b82673;\npublic class Test {\n    void test1() {\n        class Dummy {};\n        Dummy d = new Dummy();\n\t\tnew X();\n    }\n    \n    void test2() {\n        class Dummy {};\n        Dummy d = new Dummy();\n\t\tnew Y();\n    }\n}\nclass X {}\nclass Y {}\n");
        IType type = this.selectType(this.workingCopies[0], "Test").getFunction("test1", new String[0]).getType("Dummy", 1);
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b82673/Test.java void b82673.Test.test1() [Dummy] EXACT_MATCH\nsrc/b82673/Test.java void b82673.Test.test1() [Dummy] EXACT_MATCH");
    }

    public void testBug83012() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83012/Test.js", "package b83012;\n@interface A {\n    String value() default \"\";\n}\n@interface Main {\n\tA first() default @A(\"Void\");\n\tA second();\n}\n\n@Main(first=@A(\"\"), second=@A(\"2\"))\npublic class Test {\n}\n");
        IType type = this.selectType(this.workingCopies[0], "A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b83012/Test.java A b83012.Main.first() [A] EXACT_MATCH\nsrc/b83012/Test.java A b83012.Main.first() [A] EXACT_MATCH\nsrc/b83012/Test.java A b83012.Main.second() [A] EXACT_MATCH\nsrc/b83012/Test.java b83012.Test [A] EXACT_MATCH\nsrc/b83012/Test.java b83012.Test [A] EXACT_MATCH");
    }

    private void setUpBug83230_Explicit() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83230/Test.js", "package b83230;\n@interface Author {\n\tString[] authorName() default \"FREDERIC\";\n\tint[] age();\n\tint ageMin = 20;\n\t@interface Surname {}\n\tclass Address {\n\t\tString city;\n\t\tpublic void foo(Object obj) {}\n\t}\n}\n\n@Author(authorName=\"FREDERIC\", age=41)\npublic class Test {\n\t@Author(authorName={\"FREDERIC\", \"JEROME\"}, age={41, 35} )\n\tTest() {}\n\t@Author(authorName=\"PHILIPPE\", age=37)\n\tvoid foo() {\n\t\t@Author(authorName=\"FREDERIC\", age=41)\n\t\tfinal Object obj = new Object() {};\n\t\t@Author(authorName=\"FREDERIC\", age=41)\n\t\tclass Local {\n\t\t\t@Author(authorName=\"FREDERIC\", age=41)\n\t\t\tString foo() {\n\t\t\t\tAuthor.Address address = new Author.Address();\n\t\t\t\taddress.foo(obj);\n\t\t\t\treturn address.city;\n\t\t\t}\n\t\t}\n\t}\n\t@Author(authorName=\"DAVID\", age=28)\n\tint min = Author.ageMin;\n}\n");
    }

    public void testBug83230_Explicit() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IFunction method = this.selectMethod(this.workingCopies[0], "authorName");
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b83230/Test.java b83230.Test [authorName] EXACT_MATCH\nsrc/b83230/Test.java b83230.Test.min [authorName] EXACT_MATCH\nsrc/b83230/Test.java b83230.Test() [authorName] EXACT_MATCH\nsrc/b83230/Test.java void b83230.Test.foo():Local#1 [authorName] EXACT_MATCH\nsrc/b83230/Test.java String void b83230.Test.foo():Local#1.foo() [authorName] EXACT_MATCH\nsrc/b83230/Test.java void b83230.Test.foo() [authorName] EXACT_MATCH\nsrc/b83230/Test.java void b83230.Test.foo() [authorName] EXACT_MATCH");
    }

    public void testBug83230_Explicit01() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IFunction method = this.selectMethod(this.workingCopies[0], "authorName");
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b83230/Test.java String[] b83230.Author.authorName() [authorName] EXACT_MATCH");
    }

    public void testBug83230_Explicit02() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IType type = this.selectType(this.workingCopies[0], "Address");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b83230/Test.java String void b83230.Test.foo():Local#1.foo() [Author.Address] EXACT_MATCH\nsrc/b83230/Test.java String void b83230.Test.foo():Local#1.foo() [Author.Address] EXACT_MATCH");
    }

    public void testBug83230_Explicit03() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo");
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b83230/Test.java String void b83230.Test.foo():Local#1.foo() [foo(obj)] EXACT_MATCH");
    }

    public void testBug83230_Explicit04() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IField field = this.selectField(this.workingCopies[0], "city");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b83230/Test.java String void b83230.Test.foo():Local#1.foo() [city] EXACT_MATCH");
    }

    public void testBug83230_Explicit05() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83230_Explicit();
        IField field = this.selectField(this.workingCopies[0], "ageMin");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b83230/Test.java b83230.Test.min [ageMin] EXACT_MATCH");
    }

    public void testBug83230_Implicit01() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83230/Test.js", "package b83230;\n@interface Annot {\n\tint value();\n}\n@Annot(41)\npublic class Test {\n\t@Annot(10)\n\tpublic void foo() {}\n\t@Annot(21)\n\tint bar;\n}\n");
        IType type = this.selectType(this.workingCopies[0], "Annot");
        IFunction method = type.getFunction("value", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b83230/Test.java b83230.Test [41] EXACT_MATCH\nsrc/b83230/Test.java b83230.Test.bar [21] EXACT_MATCH\nsrc/b83230/Test.java void b83230.Test.foo() [10] EXACT_MATCH");
    }

    public void testBug83230_Implicit02() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83230/Test.js", "package b83230;\n@interface A {\n    String value() default \"\";\n}\n@interface Main {\n\tA first() default @A(\"Void\");\n\tA second();\n}\n\n@Main(first=@A(\"\"), second=@A(\"2\"))\npublic class Test {\n}\n");
        IType type = this.selectType(this.workingCopies[0], "A");
        IFunction method = type.getFunction("value", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b83230/Test.java A b83230.Main.first() [\"Void\"] EXACT_MATCH\nsrc/b83230/Test.java b83230.Test [\"\"] EXACT_MATCH\nsrc/b83230/Test.java b83230.Test [\"2\"] EXACT_MATCH");
    }

    public void testBug83304() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83304/Test.js", "package b83304;\npublic class Test {\n\tvoid foo() {\n\t\tClass<? extends Throwable> l1= null;\n\t\tClass<Exception> l2= null;\n\t\t\n\t\tClass<String> string_Class;\n\t}\n}\n");
        IType type = this.selectType(this.workingCopies[0], "Class", 3);
        this.search((IJavaScriptElement)type, 2, ERASURE_RULE, this.getJavaSearchWorkingCopiesScope());
        this.assertSearchResults("src/b83304/Test.java void b83304.Test.foo() [Class] ERASURE_MATCH\nsrc/b83304/Test.java void b83304.Test.foo() [Class] ERASURE_MATCH\nsrc/b83304/Test.java void b83304.Test.foo() [Class] EXACT_MATCH");
    }

    private void setUpBug83304_TypeParameterizedElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83304/Types.js", "package b83304;\nimport g1.t.s.def.Generic;\npublic class Types {\n\tpublic Generic gen;\n\tpublic Generic<Object> gen_obj;\n\tpublic Generic<Exception> gen_exc;\n\tpublic Generic<?> gen_wld;\n\tpublic Generic<? extends Throwable> gen_thr;\n\tpublic Generic<? super RuntimeException> gen_run;\n}\n");
    }

    public void testBug83304_TypeParameterizedElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_TypeParameterizedElementPattern();
        IType type = this.selectType(this.workingCopies[0], "Generic", 4);
        this.search((IJavaScriptElement)type, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Types.java [g1.t.s.def.Generic] EQUIVALENT_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen [Generic] EQUIVALENT_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen_obj [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_exc [Generic] EXACT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_wld [Generic] EQUIVALENT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_thr [Generic] EQUIVALENT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_run [Generic] EQUIVALENT_MATCH\nlib/JavaSearch15.jar g1.t.s.def.Generic<T> g1.t.s.def.Generic.foo() ERASURE_MATCH");
    }

    public void testBug83304_TypeGenericElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_TypeParameterizedElementPattern();
        IType type = this.getClassFile("JavaSearchBugs", "lib/JavaSearch15.jar", "g1.t.s.def", "Generic.class").getType();
        this.search((IJavaScriptElement)type, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Types.java [g1.t.s.def.Generic] EQUIVALENT_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen [Generic] ERASURE_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen_obj [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_exc [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_wld [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_thr [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_run [Generic] ERASURE_MATCH\nlib/JavaSearch15.jar g1.t.s.def.Generic<T> g1.t.s.def.Generic.foo() EXACT_MATCH");
    }

    public void testBug83304_TypeStringPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_TypeParameterizedElementPattern();
        this.search("Generic<? super Exception>", 0, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Types.java [Generic] EQUIVALENT_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen [Generic] EQUIVALENT_RAW_MATCH\nsrc/b83304/Types.java b83304.Types.gen_obj [Generic] EQUIVALENT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_exc [Generic] EQUIVALENT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_wld [Generic] EQUIVALENT_MATCH\nsrc/b83304/Types.java b83304.Types.gen_thr [Generic] ERASURE_MATCH\nsrc/b83304/Types.java b83304.Types.gen_run [Generic] ERASURE_MATCH\nlib/JavaSearch15.jar g1.t.s.def.Generic<T> g1.t.s.def.Generic.foo() ERASURE_MATCH");
    }

    private void setUpBug83304_MethodParameterizedElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83304/Methods.js", "package b83304;\nimport g5.m.def.Single;\npublic class Methods {\n\tvoid test() {\n\t\tSingle<Exception> gs = new Single<Exception>();\n\t\tException exc = new Exception();\n\t\tgs.<Throwable>generic(exc);\n\t\tgs.<Exception>generic(exc);\n\t\tgs.<String>generic(\"\");\n\t}\n}\n");
    }

    public void testBug83304_MethodParameterizedElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_MethodParameterizedElementPattern();
        IFunction method = this.selectMethod(this.workingCopies[0], "generic", 2);
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Methods.java void b83304.Methods.test() [generic(exc)] ERASURE_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(exc)] EXACT_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(\"\")] ERASURE_MATCH");
    }

    public void testBug83304_MethodGenericElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_MethodParameterizedElementPattern();
        IType type = this.getClassFile("JavaSearchBugs", "lib/JavaSearch15.jar", "g5.m.def", "Single.class").getType();
        IFunction method = type.getFunction("generic", new String[]{"TU;"});
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Methods.java void b83304.Methods.test() [generic(exc)] ERASURE_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(exc)] ERASURE_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(\"\")] ERASURE_MATCH");
    }

    public void testBug83304_MethodStringPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_MethodParameterizedElementPattern();
        this.search("<Exception>generic", 1, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Methods.java void b83304.Methods.test() [generic(exc)] ERASURE_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(exc)] EXACT_MATCH\nsrc/b83304/Methods.java void b83304.Methods.test() [generic(\"\")] ERASURE_MATCH");
    }

    private void setUpBug83304_ConstructorGenericElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83304/Constructors.js", "package b83304;\nimport g5.c.def.Single;\npublic class Constructors {\n\tvoid test() {\n\t\tException exc= new Exception();\n\t\tnew <Throwable>Single<String>(\"\", exc);\n\t\tnew <Exception>Single<String>(\"\", exc);\n\t\tnew <String>Single<String>(\"\", \"\");\n\t}\n}\n");
    }

    public void testBug83304_ConstructorGenericElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_ConstructorGenericElementPattern();
        IFunction method = this.selectMethod(this.workingCopies[0], "Single", 3);
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Constructors.java void b83304.Constructors.test() [new <Throwable>Single<String>(\"\", exc)] ERASURE_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <Exception>Single<String>(\"\", exc)] EXACT_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <String>Single<String>(\"\", \"\")] ERASURE_MATCH");
    }

    public void testBug83304_ConstructorParameterizedElementPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_ConstructorGenericElementPattern();
        IType type = this.getClassFile("JavaSearchBugs", "lib/JavaSearch15.jar", "g5.c.def", "Single.class").getType();
        IFunction method = type.getFunction("Single", new String[]{"TT;", "TU;"});
        this.search((IJavaScriptElement)method, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Constructors.java void b83304.Constructors.test() [new <Throwable>Single<String>(\"\", exc)] ERASURE_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <Exception>Single<String>(\"\", exc)] ERASURE_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <String>Single<String>(\"\", \"\")] ERASURE_MATCH");
    }

    public void testBug83304_ConstructorStringPattern() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug83304_ConstructorGenericElementPattern();
        this.search("<Exception>Single", 3, 2, ERASURE_RULE);
        this.assertSearchResults("src/b83304/Constructors.java void b83304.Constructors.test() [new <Throwable>Single<String>(\"\", exc)] ERASURE_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <Exception>Single<String>(\"\", exc)] EXACT_MATCH\nsrc/b83304/Constructors.java void b83304.Constructors.test() [new <String>Single<String>(\"\", \"\")] ERASURE_MATCH\nlib/JavaSearch15.jar g5.m.def.Single<T> g5.m.def.Single.returnParamType() ERASURE_MATCH\nlib/JavaSearch15.jar g5.m.def.Single<T> g5.m.def.Single.complete(U, g5.m.def.Single<T>) ERASURE_MATCH");
    }

    private void setUpBug83804_Type() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83804/package-info.js", "/**\n * Valid javadoc.\n * @see Test\n * @see Unknown\n * @see Test#foo()\n * @see Test#unknown()\n * @see Test#field\n * @see Test#unknown\n * @param unexpected\n * @throws unexpected\n * @return unexpected \n */\npackage b83804;\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b83804/Test.js", "/**\n * Invalid javadoc\n */\npackage b83804;\npublic class Test {\n\tpublic int field;\n\tpublic void foo() {}\n}\n");
    }

    public void testBug83804_Type() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug83804_Type();
        IType type = this.workingCopies[1].getType("Test");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b83804/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83804/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83804/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83804/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83804/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug83804_Method() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug83804_Type();
        IFunction[] methods = this.workingCopies[1].getType("Test").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("src/b83804/package-info.java [foo()] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug83804_Field() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug83804_Type();
        IField[] fields = this.workingCopies[1].getType("Test").getFields();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of fields", (int)1, (int)fields.length);
        this.search((IJavaScriptElement)fields[0], 2);
        this.assertSearchResults("src/b83804/package-info.java [field] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug83388() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83388/R.js", "package b83388;\nimport b83388.*;\npublic class R {}\n");
        IImportDeclaration importDeclaration = this.workingCopies[0].getImport("pack");
        JavaSearchBugsTests.assertNotNull((String)("Cannot find \"pack\" import declaration for " + this.workingCopies[0].getElementName()), (Object)importDeclaration);
        SearchPattern pattern = SearchPattern.createPattern((String)"pack", (int)2, (int)0, (int)EXACT_RULE);
        JavaSearchBugsTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        MatchLocator.setFocus((InternalSearchPattern)pattern, (IJavaScriptElement)importDeclaration);
        new SearchEngine(this.workingCopies).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.getJavaSearchScopeBugs(), (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/b83388/R.java b83388 [No source] EXACT_MATCH");
    }

    public void testBug83388b() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83388/R.js", "package b83388;\nimport b83388.*;\npublic class R {}\n");
        IPackageDeclaration packageDeclaration = this.workingCopies[0].getPackageDeclaration("pack");
        JavaSearchBugsTests.assertNotNull((String)("Cannot find \"pack\" import declaration for " + this.workingCopies[0].getElementName()), (Object)packageDeclaration);
        SearchPattern pattern = SearchPattern.createPattern((String)"pack", (int)2, (int)0, (int)EXACT_RULE);
        JavaSearchBugsTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        MatchLocator.setFocus((InternalSearchPattern)pattern, (IJavaScriptElement)packageDeclaration);
        new SearchEngine(this.workingCopies).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.getJavaSearchScopeBugs(), (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/b83388/R.java b83388 [No source] EXACT_MATCH");
    }

    public void testBug83693() throws CoreException {
        this.resultCollector.showRule = true;
        this.resultCollector.showInsideDoc = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83693/A.js", "package b83693;\nimport static b83693.A.m;\n/**\n * @see A#m(int)\n */\nclass A {\n    static void m(int i) {\n        b83693.A.m(i);\n    }\n}");
        IFunction[] methods = this.workingCopies[0].getType("A").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("src/b83693/A.java [b83693.A.m] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/b83693/A.java b83693.A [m(int)] EXACT_MATCH INSIDE_JAVADOC\nsrc/b83693/A.java void b83693.A.m(int) [m(i)] EXACT_MATCH OUTSIDE_JAVADOC");
    }

    public void testBug83716() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b83716/X.js", "package b83716;\npublic class X {\n\tX() {}\n\tX(int x) {}\n}\nclass Y extends X {\n\tY(int y) {\n\t}\n}");
        this.search("X", 3, 2);
        this.assertSearchResults("src/b83716/X.java b83716.Y(int) [Y] EXACT_MATCH");
    }

    private void setUpBug84100() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b84100/X.js", "package b84100;\npublic class X {\n\tvoid foo() {}\n\tvoid foo(String s) {}\n\tvoid foo(String... xs) {}\n\tvoid foo(int x, String... xs) {}\n\tvoid foo(String s, int x, String... xs) {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b84100/Z.js", "package b84100;\npublic class Z {\n\tX x;\n\tvoid foo() {\n\t\tx.foo();\n\t\tx.foo(\"\");\n\t\tx.foo(\"\", \"\");\n\t \tx.foo(\"\", \"\", null);\n\t\tx.foo(3, \"\", \"\");\n\t\tx.foo(\"\", 3, \"\", \"\");\n\t}\n}\n");
    }

    public void testBug84100() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84100();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo", 1);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84100/Z.java void b84100.Z.foo() [foo()] EXACT_MATCH");
    }

    public void testBug84100b() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84100();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo", 2);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84100/Z.java void b84100.Z.foo() [foo(\"\")] EXACT_MATCH");
    }

    public void testBug84100c() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84100();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo", 3);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84100/Z.java void b84100.Z.foo() [foo(\"\", \"\")] EXACT_MATCH\nsrc/b84100/Z.java void b84100.Z.foo() [foo(\"\", \"\", null)] EXACT_MATCH");
    }

    public void testBug84100d() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84100();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo", 4);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84100/Z.java void b84100.Z.foo() [foo(3, \"\", \"\")] EXACT_MATCH");
    }

    public void testBug84100e() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84100();
        IFunction method = this.selectMethod(this.workingCopies[0], "foo", 5);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84100/Z.java void b84100.Z.foo() [foo(\"\", 3, \"\", \"\")] EXACT_MATCH");
    }

    public void testBug84121() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b84121/Test.js", "package b84121;\npublic class Test {\n\tvoid foo(Test... t) {}\n\tvoid foo(int x, Test... t) {}\n\tvoid foo(Test[] t1, Test... t2) {}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b84121/Test.java void b84121.Test.foo(Test ...) [Test] EXACT_MATCH\nsrc/b84121/Test.java void b84121.Test.foo(int, Test ...) [Test] EXACT_MATCH\nsrc/b84121/Test.java void b84121.Test.foo(Test[], Test ...) [Test] EXACT_MATCH\nsrc/b84121/Test.java void b84121.Test.foo(Test[], Test ...) [Test] EXACT_MATCH");
    }

    private void setUpBug84724() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b84724/X.js", "package b84724;\npublic class X {\n\tX(String s) {}\n\tX(String... v) {}\n\tX(int x, String... v) {}\n\tX(String s, int x, String... v) {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b84724/Z.js", "package b84724;\npublic class Z {\n\tvoid foo() {\n\t\tnew X();\n\t\tnew X(\"\");\n\t\tnew X(\"\", \"\");\n\t\tnew X(\"\", \"\", null);\n\t\tnew X(3, \"\", \"\");\n\t\tnew X(\"\", 3, \"\", \"\");\n\t}\n}\n");
    }

    public void testBug84724() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84724();
        IFunction method = this.selectMethod(this.workingCopies[0], "X", 2);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84724/Z.java void b84724.Z.foo() [new X(\"\")] EXACT_MATCH");
    }

    public void testBug84724b() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84724();
        IFunction method = this.selectMethod(this.workingCopies[0], "X", 3);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84724/Z.java void b84724.Z.foo() [new X()] EXACT_MATCH\nsrc/b84724/Z.java void b84724.Z.foo() [new X(\"\", \"\")] EXACT_MATCH\nsrc/b84724/Z.java void b84724.Z.foo() [new X(\"\", \"\", null)] EXACT_MATCH");
    }

    public void testBug84724c() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84724();
        IFunction method = this.selectMethod(this.workingCopies[0], "X", 4);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84724/Z.java void b84724.Z.foo() [new X(3, \"\", \"\")] EXACT_MATCH");
    }

    public void testBug84724d() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84724();
        IFunction method = this.selectMethod(this.workingCopies[0], "X", 5);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b84724/Z.java void b84724.Z.foo() [new X(\"\", 3, \"\", \"\")] EXACT_MATCH");
    }

    private void setUpBug84727() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b84727/A.js", "package b84727;\npublic interface A {\n\tSet<Set<Exception>> getXYZ(List<Set<Exception>> arg);\n\tvoid getXYZ(String s);\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b84727/X.js", "package b84727;\npublic class X {\n\tA a;\n\tvoid foo() {\n\t\ta.getXYZ(new ArrayList());\n\t\ta.getXYZ(\"\");\n\t}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b84727/List.js", "package b84727;\npublic interface List<E> {}\ninterface Set<E> {}\nclass ArrayList<E> implements List<E> {}");
    }

    public void testBug84727() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84727();
        IFunction[] methods = this.workingCopies[0].getType("A").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)2, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("src/b84727/X.java void b84727.X.foo() [getXYZ(new ArrayList())] EXACT_MATCH");
    }

    public void testBug84727b() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug84727();
        IFunction[] methods = this.workingCopies[0].getType("A").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)2, (int)methods.length);
        this.search((IJavaScriptElement)methods[1], 2);
        this.assertSearchResults("src/b84727/X.java void b84727.X.foo() [getXYZ(\"\")] EXACT_MATCH");
    }

    public void testBug85810() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b85810/Test.js", "package b85810;\npublic class Test<E> implements In<Test<E>> {\n\tE e;\n}\ninterface In<T> {}\n");
        ITypeParameter param = this.selectTypeParameter(this.workingCopies[0], "E");
        this.search((IJavaScriptElement)param, 2);
        this.assertSearchResults("src/b85810/Test.java b85810.Test [E] EXACT_MATCH\nsrc/b85810/Test.java b85810.Test.e [E] EXACT_MATCH");
    }

    public void testBug86596() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b86596/aa/link/A.js", "package b86596.aa.link;\npublic interface A {}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b86596/bb/Link.js", "package b86596.bb;\npublic class Link{}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b86596/cc/X.js", "package b86596.cc;\nimport b86596.aa.link.A;\nimport b86596.bb.Link;\npublic class X {\n\tA a;\n\tLink l;\n}\n");
        this.search("Link", 0, 2, 0);
        this.assertSearchResults("src/b86596/cc/X.java [Link] EXACT_RAW_MATCH\nsrc/b86596/cc/X.java b86596.cc.X.l [Link] EXACT_MATCH");
    }

    public void testBug86642() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b86642/A.js", "package b86642;\nclass A {\n\tpublic void m() {}\n\tprotected void f(A a){}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b86642/B.js", "package b86642;\npublic class B extends A{\n\tprotected void f(A a){\n\t\ta.m();\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("A");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b86642/A.java void b86642.A.f(A) [A] EXACT_MATCH\nsrc/b86642/B.java b86642.B [A] EXACT_MATCH\nsrc/b86642/B.java void b86642.B.f(A) [A] EXACT_MATCH");
    }

    public void testBug86293() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b86293.jar", "", "I86293.class").getType();
        IFunction method = type.getFunction("m86293", new String[0]);
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("lib/b86293.jar void <anonymous>.m86293() EXACT_MATCH\nlib/b86293.jar void I86293.m86293() EXACT_MATCH");
    }

    private void setUpBug86380() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b86380/package-info.js", "/**\n * @see Annot#field\n */\n@Annot(value=11)\npackage b86380;\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b86380/Test.js", "package b86380;\n@Annot(12) public class Test {\n\tpublic int field = Annot.field;\n\tpublic void foo() {}\n}\n");
    }

    public void testBug86380_Type() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug86380();
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b86380", "Annot.js");
        IType type = unit.getType("Annot");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b86380/Test.java b86380.Test [Annot] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/b86380/Test.java b86380.Test.field [Annot] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/b86380/package-info.java [Annot] EXACT_MATCH INSIDE_JAVADOC\nsrc/b86380/package-info.java [Annot] EXACT_MATCH OUTSIDE_JAVADOC");
    }

    public void testBug86380_Method() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug86380();
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b86380", "Annot.js");
        IFunction[] methods = unit.getType("Annot").getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of methods", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 2);
        this.assertSearchResults("src/b86380/Test.java b86380.Test [12] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/b86380/package-info.java [value] EXACT_MATCH OUTSIDE_JAVADOC");
    }

    public void testBug86380_Field() throws CoreException {
        this.resultCollector.showInsideDoc = true;
        this.setUpBug86380();
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b86380", "Annot.js");
        IField[] fields = unit.getType("Annot").getFields();
        JavaSearchBugsTests.assertEquals((String)"Invalid number of fields", (int)1, (int)fields.length);
        this.search((IJavaScriptElement)fields[0], 2);
        this.assertSearchResults("src/b86380/Test.java b86380.Test.field [field] EXACT_MATCH OUTSIDE_JAVADOC\nsrc/b86380/package-info.java [field] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug88174() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b88174/Test.js", "package b88174;\npublic enum Test {\n  a {\n    int getTheValue() { // not found\n      return 0;\n    }\n  };\n  abstract int getTheValue();\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b88174/X.js", "package b88174;\npublic class X {\n  X x = new X() {\n    int getTheValue() {\n      return 0;\n    }\n  };\n  int getTheValue() { return 0; }\n}\n");
        IFunction method = this.workingCopies[0].getType("Test").getFunction("getTheValue", new String[0]);
        this.search((IJavaScriptElement)method, 16);
        this.assertSearchResults("src/b88174/Test.java int b88174.Test.a:<anonymous>#1.getTheValue() [getTheValue] EXACT_MATCH\nsrc/b88174/Test.java int b88174.Test.getTheValue() [getTheValue] EXACT_MATCH\nsrc/b88174/X.java int b88174.X.x:<anonymous>#1.getTheValue() [getTheValue] EXACT_MATCH\nsrc/b88174/X.java int b88174.X.getTheValue() [getTheValue] EXACT_MATCH");
    }

    public void testBug87627() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b87627.jar", "b87627", "List.class").getType();
        ITypeParameter[] parameters = type.getTypeParameters();
        JavaSearchBugsTests.assertNotNull((String)(String.valueOf(type.getFullyQualifiedName()) + " should have parameters"), (Object)parameters);
        JavaSearchBugsTests.assertEquals((String)"Wrong number of parameters", (int)1, (int)parameters.length);
        this.search((IJavaScriptElement)parameters[0], 2);
        this.assertSearchResults("lib/b87627.jar b87627.List EXACT_MATCH\nlib/b87627.jar boolean b87627.List.addAll(b87627.Collection<? extends E>) EXACT_MATCH");
    }

    public void testBug88300() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/SubClass.js", "package b88300;\npublic class SubClass extends SuperClass {\n\tprivate void aMethod(String x) {\n\t}\n\tpublic void aMethod(Object x) {\n\t}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/SuperClass.js", "package b88300;\npublic class SuperClass {\n    public void aMethod(Object x) {\n    }\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/User.js", "package b88300;\npublic class User {\n    public void methodUsingSubClassMethod() {\n        SuperClass user = new SubClass();\n        user.aMethod(new Object());\n    }\n}\n");
        IType type = this.workingCopies[0].getType("SubClass");
        this.search((IJavaScriptElement)type.getFunctions()[1], 2);
        this.assertSearchResults("src/b88300/User.java void b88300.User.methodUsingSubClassMethod() [aMethod(new Object())] EXACT_MATCH");
    }

    public void testBug88300b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/SubClass.js", "package b88300;\npublic class SubClass extends SuperClass {\n\tpublic void aMethod(Object x) {\n\t}\n\tprivate void aMethod(String x) {\n\t}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/SuperClass.js", "package b88300;\npublic class SuperClass {\n    public void aMethod(Object x) {\n    }\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/User.js", "package b88300;\npublic class User {\n    public void methodUsingSubClassMethod() {\n        SuperClass user = new SubClass();\n        user.aMethod(new Object());\n    }\n}\n");
        IType type = this.workingCopies[0].getType("SubClass");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("src/b88300/User.java void b88300.User.methodUsingSubClassMethod() [aMethod(new Object())] EXACT_MATCH");
    }

    public void testBug88300c() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/not/fixed/ConditionalFlowInfo.js", "package b88300.not.fixed;\npublic class ConditionalFlowInfo extends FlowInfo {\n\tpublic FlowInfo info;\n\tConditionalFlowInfo(FlowInfo info){\n\t\tthis.info = info;\n\t}\n\tpublic void markAsDefinitelyNull(FieldBinding field) {\n\t\tinfo.markAsDefinitelyNull(field);\n\t}\n\tpublic void markAsDefinitelyNull(LocalVariableBinding local) {\n\t\tinfo.markAsDefinitelyNull(local);\n\t}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/not/fixed/FlowInfo.js", "package b88300.not.fixed;\n\nclass FieldBinding {\n\tint id;\n}\nclass LocalVariableBinding extends FieldBinding {}\n\npublic abstract class FlowInfo {\n\tabstract public void markAsDefinitelyNull(LocalVariableBinding local);\n\tabstract public void markAsDefinitelyNull(FieldBinding field);\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b88300/not/fixed/UnconditionalFlowInfo.js", "package b88300.not.fixed;\npublic class UnconditionalFlowInfo extends FlowInfo {\n\tfinal private void markAsDefinitelyNull(int position) {}\n\tpublic void markAsDefinitelyNull(FieldBinding field) {\n\t\tmarkAsDefinitelyNull(field.id);\n\t}\n\tpublic void markAsDefinitelyNull(LocalVariableBinding local) {\n\t\tmarkAsDefinitelyNull(local.id + 1);\n\t}\n}\n");
        IType type = this.workingCopies[2].getType("UnconditionalFlowInfo");
        this.search((IJavaScriptElement)type.getFunctions()[2], 2);
        this.assertSearchResults("src/b88300/not/fixed/ConditionalFlowInfo.java void b88300.not.fixed.ConditionalFlowInfo.markAsDefinitelyNull(LocalVariableBinding) [markAsDefinitelyNull(local)] EXACT_MATCH");
    }

    public void testBug89686() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b89686/A.js", "package b89686;\npublic enum Color {\n    RED, GREEN(), BLUE(17), PINK((1+(1+1))) {/*anon*/};\n    Color() {}\n    Color(int i) {}\n}");
        IType type = this.workingCopies[0].getType("Color");
        IFunction method = type.getFunction("Color", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b89686/A.java b89686.Color.RED [RED] EXACT_MATCH\nsrc/b89686/A.java b89686.Color.GREEN [GREEN()] EXACT_MATCH");
    }

    public void testBug89686b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b89686/A.js", "package b89686;\npublic enum Color {\n    RED, GREEN(), BLUE(17), PINK((1+(1+1))) {/*anon*/};\n    Color() {}\n    Color(int i) {}\n}");
        IType type = this.workingCopies[0].getType("Color");
        IFunction method = type.getFunction("Color", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/b89686/A.java b89686.Color.BLUE [BLUE(17)] EXACT_MATCH\nsrc/b89686/A.java b89686.Color.PINK [PINK((1+(1+1)))] EXACT_MATCH");
    }

    public void testBug89848() throws CoreException {
        IType classFile = this.getClassFile("JavaSearchBugs", "lib", "b89848", "X.class").getType();
        IFunction method = classFile.getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("lib/b89848/Test.class void b89848.Test.foo() EXACT_MATCH\nlib/b89848/X.class void b89848.X.foo() EXACT_MATCH");
    }

    public void testBug90779() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b90779/A.js", "package b90779;\npublic class A {\n\tpublic A() {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b90779/B.js", "package b90779;\npublic class B {\n\tpublic B() {}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b90779/C.js", "package b90779;\npublic class C {\n\tpublic C() {}\n}\n");
        IType type = this.workingCopies[0].getType("A");
        IFunction[] methods = type.getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Wrong number of methods", (int)1, (int)methods.length);
        this.search((IJavaScriptElement)methods[0], 48);
        this.assertSearchResults("src/b90779/A.java b90779.A() [A] EXACT_MATCH");
    }

    public void testBug90915() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b90915/X.js", "package b90915;\nimport g5.m.def.Single;\npublic class X<T> {\n\tvoid foo() {\n\t\tSingle<String> single = new Single<String>() {\n\t\t\tpublic <U> String generic(U u) { return \"\"; }\n\t\t\tpublic void paramTypesArgs(Single<String> gs) {}\n\t\t};\n\t\tsingle.paramTypesArgs(null);\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("X");
        IFunction[] methods = type.getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Wrong number of methods", (int)1, (int)methods.length);
        IType anonymous = methods[0].getType("", 1);
        JavaSearchBugsTests.assertNotNull((String)"Cannot find anonymous in method foo()", (Object)anonymous);
        methods = anonymous.getFunctions();
        JavaSearchBugsTests.assertEquals((String)"Wrong number of methods", (int)2, (int)methods.length);
        this.search((IJavaScriptElement)methods[1], 2);
        this.assertSearchResults("src/b90915/X.java void b90915.X.foo() [paramTypesArgs(null)] EXACT_MATCH");
    }

    public void testBug91542() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b91542/A.js", "package b91542;\n\nclass A<T> {\n\tvoid a(A<T> a){}\n}\n\nclass B<T> extends A<T> {\n\tprotected void foo() { \n\t\ta(this);\n\t}\n}");
        IType type = this.workingCopies[0].getType("B");
        IFunction method = type.getFunction("foo", new String[0]);
        this.searchDeclarationsOfSentMessages((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("src/b91542/A.java void b91542.A.a(A<T>) [a(A<T> a)] EXACT_MATCH");
    }

    public void testBug91078() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b91078/test/Example.js", "package b91078.test;\nimport b91078.util.HashMap;\nimport b91078.util.Map;\npublic class Example {\n    public Map.Entry logAll(Object obj) {\n    \tif (obj instanceof b91078.util.HashMap) {\n    \t\tHashMap map = (HashMap) obj;\n            return map.entry;\n    \t}\n    \tif (obj instanceof b91078.util.HashMap.Entry) {\n            Map.Entry entry = (Map.Entry) obj;\n            return entry;\n    \t}\n    \treturn null;\n    }\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b91078/util/HashMap.js", "package b91078.util;\npublic class HashMap implements Map {\n\tpublic Entry entry;\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b91078/util/Map.js", "package b91078.util;\npublic interface Map {\n\tclass Entry{}\n}\n");
        this.search("*", 2, 2, this.getJavaSearchWorkingCopiesScope(this.workingCopies[0]));
        this.assertSearchResults("src/b91078/test/Example.java [b91078.util] EXACT_MATCH\nsrc/b91078/test/Example.java [b91078.util] EXACT_MATCH\nsrc/b91078/test/Example.java Map.Entry b91078.test.Example.logAll(Object) [b91078.util] EXACT_MATCH\nsrc/b91078/test/Example.java Map.Entry b91078.test.Example.logAll(Object) [b91078.util] EXACT_MATCH");
    }

    public void testBug92264a() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames("*.lang".toCharArray(), 2, IIndexConstants.ONE_STAR, 2, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.CharSequence\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Comparable\njava.lang.Enum\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable", (Object)requestor);
    }

    public void testBug92264b() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames("*.lang*".toCharArray(), 2, "*tion".toCharArray(), 2, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.CloneNotSupportedException\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.RuntimeException\njava.lang.annotation.Annotation", (Object)requestor);
    }

    public void testBug92264c() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames("*.test*".toCharArray(), 2, IIndexConstants.ONE_STAR, 2, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "Test$Inner\nb123679.test.Test\nb123679.test.Test$StaticClass\nb123679.test.Test$StaticClass$Member\nb124645.test.A_124645\nb124645.test.X_124645\nb127628.Test127628$Member127628\nb95794.Test$Color\npack.age.Test$Member\ntest.Test$StaticClass\ntest.Test$StaticClass$Member", (Object)requestor);
    }

    public void testBug92264d() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames("b12*".toCharArray(), 2, new char[]{'X'}, 1, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b124645.test.X_124645\nb124645.xy.X_124645", (Object)requestor);
    }

    private void setUpBug92944() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b92944/Test.js", "package b92944;\ninterface B92944_I {}\nenum B92944_E {}\n@interface B92944_A {}\npublic class B92944 {}\n");
    }

    public void testBug92944_TYPE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 0, this.getJavaSearchScopeBugs("b92944", true), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944\nb92944.B92944_A\nb92944.B92944_E\nb92944.B92944_I", (Object)requestor);
    }

    public void testBug92944_CLASS() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, IIndexConstants.ONE_STAR, 2, 5, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944", (Object)requestor);
    }

    public void testBug92944_CLASS_AND_INTERFACE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 10, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944\nb92944.B92944_I", (Object)requestor);
    }

    public void testBug92944_CLASS_AND_ENUM() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 9, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944\nb92944.B92944_E", (Object)requestor);
    }

    public void testBug92944_INTERFACE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 6, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944_I", (Object)requestor);
    }

    public void testBug92944_ENUM() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 7, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944_E", (Object)requestor);
    }

    public void testBug92944_ANNOTATION_TYPE() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug92944();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 8, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b92944.B92944_A", (Object)requestor);
    }

    public void testBug93392() throws CoreException {
        TestCollector collector = new TestCollector();
        collector.showAccuracy = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b93392/Test.js", "package b93392;\n@interface Annot {\n\tint value();\n}\n@Annot(41)\npublic class Test {\n\t@Annot(21)\n\tint bar;\n\t@Annot(10)\n\tpublic void foo() {}\n}\n");
        IType type = this.selectType(this.workingCopies[0], "Annot");
        IFunction method = type.getFunction("value", new String[0]);
        this.search((IJavaScriptElement)method, 2, this.getJavaSearchScopeBugs(), collector);
        this.assertSearchResults("src/b93392/Test.java b93392.Test [41] EXACT_MATCH\nsrc/b93392/Test.java b93392.Test.bar [21] EXACT_MATCH\nsrc/b93392/Test.java void b93392.Test.foo() [10] EXACT_MATCH", collector);
        String source = this.workingCopies[0].getSource();
        String str = "@Annot(";
        JavaSearchBugsTests.assertEquals((String)"Invalid number of matches", (int)3, (int)collector.matches.size());
        int index = source.indexOf(str) + str.length();
        JavaSearchBugsTests.assertEquals((String)"Invalid offset for first match", (int)index, (int)((SearchMatch)collector.matches.get(0)).getOffset());
        JavaSearchBugsTests.assertEquals((String)"Invalid length for first match", (int)2, (int)((SearchMatch)collector.matches.get(0)).getLength());
        index = source.indexOf(str, index) + str.length();
        JavaSearchBugsTests.assertEquals((String)"Invalid offset for second match", (int)index, (int)((SearchMatch)collector.matches.get(1)).getOffset());
        JavaSearchBugsTests.assertEquals((String)"Invalid length for second match", (int)2, (int)((SearchMatch)collector.matches.get(1)).getLength());
        index = source.indexOf(str, index) + str.length();
        JavaSearchBugsTests.assertEquals((String)"Invalid offset for last match", (int)index, (int)((SearchMatch)collector.matches.get(2)).getOffset());
        JavaSearchBugsTests.assertEquals((String)"Invalid length for last match", (int)2, (int)((SearchMatch)collector.matches.get(2)).getLength());
    }

    public void testBug94160() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b94160/Test.js", "package b94160;\npublic class Test {\n\t<T> List<T> generateList(Class<T> clazz) {\n\t\treturn new ArrayList<T>();\n\t}\n}\nclass CTest extends Test {\n\tprivate List<String> myList = generateList(String.class);\n\tCTest() {\n\t\tmyList = new ArrayList<String>();\n\t}\n}\ninterface List<E> {}\nclass ArrayList<E> implements List<E> {}");
        IType type = this.workingCopies[0].getType("CTest");
        IField field = type.getField("myList");
        new SearchEngine(this.workingCopies).searchDeclarationsOfSentMessages((IJavaScriptElement)field, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/b94160/Test.java List<T> b94160.Test.generateList(Class<T>) [generateList(Class<T> clazz)] EXACT_MATCH");
    }

    public void testBug94389() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b94389/Test.js", "package b94389;\npublic class Test {\n\tpublic void foo() {}\n\tpublic void foo() {}\n\tpublic void foo() {}\n\tpublic void foo() {}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        IFunction[] methods = type.getFunctions();
        int methodsLength = methods.length;
        IJavaScriptSearchScope scope = this.getJavaSearchScopeBugs();
        int m = 0;
        while (m < methodsLength) {
            TestCollector collector = new TestCollector();
            this.search((IJavaScriptElement)methods[m], 0, scope, collector);
            this.assertSearchResults("src/b94389/Test.java void b94389.Test.foo() [foo]\nsrc/b94389/Test.java void b94389.Test.foo() [foo]\nsrc/b94389/Test.java void b94389.Test.foo() [foo]\nsrc/b94389/Test.java void b94389.Test.foo() [foo]", collector);
            int size = collector.matches.size();
            int i = 0;
            while (i < size) {
                JavaSearchBugsTests.assertEquals((String)("Invalid foo method occurence count (m=" + (m + 1) + ")"), (int)(i + 1), (int)((SourceMethod)methods[i]).occurrenceCount);
                ++i;
            }
            ++m;
        }
    }

    public void testBug94718() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b94718/SetUp.js", "package b94718;\npublic @interface SetUp {\n\tString value() {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b94718/Test.js", "package b94718;\n@SetUp(\"howdy\")\npublic class Test {\n}\n");
        IType type = this.workingCopies[1].getType("SetUp");
        this.search((IJavaScriptElement)type, 2, SearchEngine.createWorkspaceScope());
        this.assertSearchResults("src/b94718/Test.java b94718.Test [SetUp] EXACT_MATCH");
    }

    public void testBug95152_jar01() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T1$T12.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T1$T12$T13.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("lib/b95152.jar b95152.T1() EXACT_MATCH\nlib/b95152.jar b95152.T1() EXACT_MATCH");
    }

    public void testBug95152_jar02() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T2$T22.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T2$T22$T23.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("lib/b95152.jar b95152.T2(int) EXACT_MATCH\nlib/b95152.jar b95152.T2(int) EXACT_MATCH");
    }

    public void testBug95152_jar03() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T3$T32.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T3$T32$T33.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("lib/b95152.jar b95152.T3(b95152.T3) EXACT_MATCH\nlib/b95152.jar b95152.T3(b95152.T3) EXACT_MATCH");
    }

    public void testBug95152_jar04() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T4$T42.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = this.getPackageFragment("JavaSearchBugs", "lib/b95152.jar", "b95152").getClassFile("T4$T42$T43.class").getType();
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("lib/b95152.jar b95152.T4(b95152.T4, java.lang.String) EXACT_MATCH\nlib/b95152.jar b95152.T4(b95152.T4, java.lang.String) EXACT_MATCH");
    }

    public void testBug95152_wc01() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b95152/T.js", "package b95152;\npublic class T {\n\tT2 c2;\n\tT2.T3 c3;\n\tT() {\n\t\tc2 = new T2();\n\t\tc3 = c2.new T3();\n\t}\n\tclass T2 {\n\t\tT2() {}\n\t\tclass T3 {\n\t\t\tT3() {}\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("T").getType("T2");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = type.getType("T3");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("src/b95152/T.java b95152.T() [new T2()] EXACT_MATCH\nsrc/b95152/T.java b95152.T() [c2.new T3()] EXACT_MATCH");
    }

    public void testBug95152_wc02() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b95152/T.js", "package b95152;\npublic class T {\n\tT2 c2;\n\tT2.T3 c3;\n\tT(int c) {\n\t\tc2 = new T2(c);\n\t\tc3 = c2.new T3(c);\n\t}\n\tclass T2 {\n\t\tT2(int x) {}\n\t\tclass T3 {\n\t\t\tT3(int x) {}\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("T").getType("T2");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = type.getType("T3");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("src/b95152/T.java b95152.T(int) [new T2(c)] EXACT_MATCH\nsrc/b95152/T.java b95152.T(int) [c2.new T3(c)] EXACT_MATCH");
    }

    public void testBug95152_wc03() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b95152/T.js", "package b95152;\npublic class T {\n\tT2 c2;\n\tT2.T3 c3;\n\tT(T c) {\n\t\tc2 = new T2(c);\n\t\tc3 = c2.new T3(c2);\n\t}\n\tclass T2 {\n\t\tT2(T c) {}\n\t\tclass T3 {\n\t\t\tT3(T2 c) {}\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("T").getType("T2");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = type.getType("T3");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("src/b95152/T.java b95152.T(T) [new T2(c)] EXACT_MATCH\nsrc/b95152/T.java b95152.T(T) [c2.new T3(c2)] EXACT_MATCH");
    }

    public void testBug95152_wc04() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b95152/T.js", "package b95152;\npublic class T {\n\tT2 c2;\n\tT2.T3 c3;\n\tT(T c, String str) {\n\t\tc2 = new T2(c, str);\n\t\tc3 = c2.new T3(c2, str);\n\t}\n\tclass T2 {\n\t\tT2(T c, String str) {}\n\t\tclass T3 {\n\t\t\tT3(T2 c, String str) {}\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("T").getType("T2");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        type = type.getType("T3");
        this.search((IJavaScriptElement)type.getFunctions()[0], 2);
        this.assertSearchResults("src/b95152/T.java b95152.T(T, String) [new T2(c, str)] EXACT_MATCH\nsrc/b95152/T.java b95152.T(T, String) [c2.new T3(c2, str)] EXACT_MATCH");
    }

    public void testBug95794() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b95794", "Test.js");
        IType type = unit.getType("Test");
        TestCollector occurencesCollector = new TestCollector();
        occurencesCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 3, this.getJavaSearchScopeBugs(), occurencesCollector);
        this.assertSearchResults("src/b95794/Test.java [b95794.Test] EXACT_MATCH\nsrc/b95794/Test.java [b95794.Test] EXACT_MATCH\nsrc/b95794/Test.java b95794.Test [Test] EXACT_MATCH\nsrc/b95794/Test.java b95794.Test.there [Test] EXACT_MATCH", occurencesCollector);
        TestCollector referencesCollector = new TestCollector();
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScopeBugs(), referencesCollector);
        JavaSearchBugsTests.assertEquals((String)"Problem with occurences or references number of matches: ", (int)(occurencesCollector.matches.size() - 1), (int)referencesCollector.matches.size());
    }

    public void testBug95794b() throws CoreException {
        this.resultCollector.showRule = true;
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b95794", "Test.js");
        IType type = unit.getType("Test").getType("Color");
        TestCollector occurencesCollector = new TestCollector();
        occurencesCollector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 3, this.getJavaSearchScopeBugs(), occurencesCollector);
        this.assertSearchResults("src/b95794/Test.java [b95794.Test.Color] EXACT_MATCH\nsrc/b95794/Test.java [b95794.Test.Color] EXACT_MATCH\nsrc/b95794/Test.java void b95794.Test.main(String[]) [Color] EXACT_MATCH\nsrc/b95794/Test.java b95794.Test$Color [Color] EXACT_MATCH", occurencesCollector);
        TestCollector referencesCollector = new TestCollector();
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScopeBugs(), referencesCollector);
        JavaSearchBugsTests.assertEquals((String)"Problem with occurences or references number of matches: ", (int)(occurencesCollector.matches.size() - 1), (int)referencesCollector.matches.size());
    }

    public void testBug95794c() throws CoreException {
        this.resultCollector.showRule = true;
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b95794", "Test.js");
        IField field = unit.getType("Test").getType("Color").getField("WHITE");
        TestCollector occurencesCollector = new TestCollector();
        occurencesCollector.showAccuracy = true;
        this.search((IJavaScriptElement)field, 3, this.getJavaSearchScopeBugs(), occurencesCollector);
        this.assertSearchResults("src/b95794/Test.java [WHITE] EXACT_MATCH\nsrc/b95794/Test.java void b95794.Test.main(String[]) [WHITE] EXACT_MATCH\nsrc/b95794/Test.java b95794.Test$Color.WHITE [WHITE] EXACT_MATCH", occurencesCollector);
        TestCollector referencesCollector = new TestCollector();
        this.search((IJavaScriptElement)field, 2, this.getJavaSearchScopeBugs(), referencesCollector);
        JavaSearchBugsTests.assertEquals((String)"Problem with occurences or references number of matches: ", (int)(occurencesCollector.matches.size() - 1), (int)referencesCollector.matches.size());
    }

    public void testBug96761() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b96761/Generic.js", "package b96761;\npublic class Generic<G> {\n\tvoid take(G g) {\n\t}\n}\nclass Impl extends Generic<RuntimeException> {\n\tvoid take(InterruptedException g) {\n\t}\n\tvoid take(RuntimeException g) {\n\t}\n}");
        IType type = this.workingCopies[0].getType("Generic");
        IFunction method = type.getFunctions()[0];
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("");
    }

    public void testBug96763() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b96763/Test.js", "package b96763;\nclass Test<T> {\n    public void first(Exception num) {}\n    public void second(T t) {}\n}\nclass Sub extends Test<Exception> {\n    public void first(Exception num) {}\n    public void second(Exception t) {}\n}\n");
        IFunction method = this.workingCopies[0].getType("Sub").getFunctions()[0];
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b96763/Test.java void b96763.Test.first(Exception) [first] EXACT_MATCH\nsrc/b96763/Test.java void b96763.Sub.first(Exception) [first] EXACT_MATCH");
    }

    public void testBug96763b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b96763/Test.js", "package b96763;\nclass Test<T> {\n    public void first(Exception num) {}\n    public void second(T t) {}\n}\nclass Sub extends Test<Exception> {\n    public void first(Exception num) {}\n    public void second(Exception t) {}\n}\n");
        IFunction method = this.workingCopies[0].getType("Sub").getFunctions()[1];
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b96763/Test.java void b96763.Test.second(T) [second] EXACT_MATCH\nsrc/b96763/Test.java void b96763.Sub.second(Exception) [second] EXACT_MATCH");
    }

    public void testBug96763c() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b96763/Test.js", "package b96763;\npublic class Test<T> {\n\tvoid methodT(T t) {}\n}\nclass Sub<X> extends Test<X> {\n\tvoid methodT(X x) {} // overrides Super#methodT(T)\n}\n");
        IFunction method = this.workingCopies[0].getType("Sub").getFunctions()[0];
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b96763/Test.java void b96763.Test.methodT(T) [methodT] EXACT_MATCH\nsrc/b96763/Test.java void b96763.Sub.methodT(X) [methodT] EXACT_MATCH");
    }

    public void testBug97087() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.resultCollector.showRule = true;
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97087/Bug.js", "package b97087;\npublic class Bug<Type> {\n    Bug(){}\n}\nclass Foo extends Bug<String>{\n    Foo(){}\n}\nclass Bar extends Bug<Exception>{\n    Bar(){super();}\n}");
        IType type = this.workingCopies[0].getType("Bug");
        IFunction method = type.getFunctions()[0];
        this.search((IJavaScriptElement)method, 2, 16);
        this.assertSearchResults("src/b97087/Bug.java b97087.Foo() [Foo] EXACT_MATCH\nsrc/b97087/Bug.java b97087.Bar() [super();] ERASURE_MATCH");
    }

    public void testBug97120() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", this.getExternalJCLPathString("1.5"), "java.lang", "Throwable.class").getType();
        IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, "E*".toCharArray(), 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.Error\njava.lang.Exception", (Object)requestor);
    }

    public void testBug97322() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97322/Test.js", "package b97322;\nclass Test {\n\tstatic void myMethod(int a, String b) {}\n\tvoid call() {\n\t\tmyMethod(12);\n\t}\n}");
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunctions()[0];
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("");
    }

    public void testBug97547() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97547/IX.js", "package b97547;\npublic interface IX {\n\tpublic interface IX1 {}\n}");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b97547/X.js", "package b97547;\nimport b97547.IX.*;\nclass X {\n\tIX x;\n}");
        IPackageDeclaration[] packages = this.workingCopies[0].getPackageDeclarations();
        JavaSearchBugsTests.assertTrue((String)"Invalid number of packages declaration!", (packages != null && packages.length == 1 ? 1 : 0) != 0);
        this.search((IJavaScriptElement)packages[0], 2);
        this.assertSearchResults("src/b97547/X.java [b97547] EXACT_MATCH");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug97606() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/def/L.js", "package b97606.pack.def;\npublic interface L<E> {}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/def/LL.js", "package b97606.pack.def;\npublic class LL<E> implements L<E> {\n\tpublic Object clone() {\n\t\treturn null;\n\t}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/ref/K.js", "package b97606.pack.ref;\npublic interface K {}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/ref/X.js", "package b97606.pack.ref;\npublic class X implements K {\n\tprivate b97606.pack.def.LL sg;\n\tprotected synchronized b97606.pack.def.L<K> getSG() {\n\t\treturn (sg != null) \n\t\t\t? (b97606.pack.def.L) sg.clone()\n\t\t\t: null;\n\t}\n}\n");
        Path pathDef = new Path("/JavaSearchBugs/src/b97606/pack/def");
        Path pathRef = new Path("/JavaSearchBugs/src/b97606/pack/ref");
        try {
            this.createFolder((IPath)pathDef);
            this.createFolder((IPath)pathRef);
            this.workingCopies[0].commitWorkingCopy(true, null);
            this.workingCopies[1].commitWorkingCopy(true, null);
            this.workingCopies[2].commitWorkingCopy(true, null);
            this.workingCopies[3].commitWorkingCopy(true, null);
            this.resultCollector.showRule = true;
            IType type = this.workingCopies[0].getType("L");
            this.search((IJavaScriptElement)type, 2, 16);
            this.assertSearchResults("src/b97606/pack/def/LL.java b97606.pack.def.LL [L] ERASURE_MATCH\nsrc/b97606/pack/ref/X.java b97606.pack.def.L<K> b97606.pack.ref.X.getSG() [b97606.pack.def.L] ERASURE_MATCH\nsrc/b97606/pack/ref/X.java b97606.pack.def.L<K> b97606.pack.ref.X.getSG() [b97606.pack.def.L] ERASURE_RAW_MATCH");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteFolder((IPath)pathDef);
            this.deleteFolder((IPath)pathRef);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteFolder((IPath)pathDef);
        this.deleteFolder((IPath)pathRef);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug97606b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/def/L.js", "package b97606.pack.def;\npublic interface L<E> {}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/def/LL.js", "package b97606.pack.def;\npublic class LL<E> implements L<E> {\n\tpublic Object clone() {\n\t\treturn null;\n\t}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/ref/K.js", "package b97606.pack.ref;\npublic interface K {}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b97606/pack/ref/X.js", "package b97606.pack.ref;\nimport b97606.pack.def.*;\npublic class X implements K {\n\tprivate LL sg;\n\tprotected synchronized L<K> getSG() {\n\t\treturn (sg != null) \n\t\t\t? (L) sg.clone()\n\t\t\t: null;\n\t}\n}\n");
        Path pathDef = new Path("/JavaSearchBugs/src/b97606/pack/def");
        Path pathRef = new Path("/JavaSearchBugs/src/b97606/pack/ref");
        try {
            this.createFolder((IPath)pathDef);
            this.createFolder((IPath)pathRef);
            this.workingCopies[0].commitWorkingCopy(true, null);
            this.workingCopies[1].commitWorkingCopy(true, null);
            this.workingCopies[2].commitWorkingCopy(true, null);
            this.workingCopies[3].commitWorkingCopy(true, null);
            this.resultCollector.showRule = true;
            IType type = this.workingCopies[0].getType("L");
            this.search((IJavaScriptElement)type, 2, 16);
            this.assertSearchResults("src/b97606/pack/def/LL.java b97606.pack.def.LL [L] ERASURE_MATCH\nsrc/b97606/pack/ref/X.java L<K> b97606.pack.ref.X.getSG() [L] ERASURE_MATCH\nsrc/b97606/pack/ref/X.java L<K> b97606.pack.ref.X.getSG() [L] ERASURE_RAW_MATCH");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteFolder((IPath)pathDef);
            this.deleteFolder((IPath)pathRef);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteFolder((IPath)pathDef);
        this.deleteFolder((IPath)pathRef);
    }

    public void testBug97614() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b97614/W.js", "package b97614;\npublic class W {\n\tprivate final Map<String, Y<?, ? extends b97614.X.XX<?, ?>, ? >> m1 = null;     // (a)\n\tpublic void getStore(final Object o) {\n\t\tm1.get(o);     // (b)\n\t}\n}\ninterface Map<K, V> {\n\tV get(Object k);\n}");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b97614/X.js", "package b97614;\nimport java.io.Serializable;\npublic interface X<T extends X<T, U, V>, \n\t\t\t\t   U extends X.XX<T, V>, \n\t\t\t\t   V extends X.XY> {\n\tpublic interface XX<TT extends X<TT, ?, UU>, \n\t                   UU extends X.XY> \n\t\t\textends\tSerializable {\n\t}\n\tpublic interface XY extends Serializable {\n\t}\n}");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b97614/Y.js", "package b97614;\npublic class Y<T extends X<T, U, V>, U extends X.XX<T, V>, V extends X.XY> {\n}\n");
        IField field = this.workingCopies[0].getType("W").getField("m1");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b97614/W.java void b97614.W.getStore(Object) [m1] EXACT_MATCH");
    }

    public void testBug98378() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b98378/X.js", "package b98378;\npublic class  X implements java.lang.CharSequence {\n\tpublic int length() {\n\t\treturn 1;\n\t}\n}");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b98378/Y.js", "package b98378;\npublic class Y {\n\tpublic int length() {\n\t\treturn -1;\n\t}\n}\n");
        String jclPath = this.getExternalJCLPathString("1.5");
        IType type = this.getClassFile("JavaSearchBugs", jclPath, "java.lang", "CharSequence.class").getType();
        IFunction method = type.getFunction("length", new String[0]);
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type, (WorkingCopyOwner)this.wcOwner));
        this.assertSearchResults(String.valueOf(jclPath) + " int java.lang.CharSequence.length() EXACT_MATCH\n" + jclPath + " int java.lang.String.length() EXACT_MATCH");
    }

    public void testBug98378b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b98378/X.js", "package b98378;\npublic class  X implements java.lang.CharSequence {\n\tpublic int length() {\n\t\treturn 1;\n\t}\n}");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b98378/Y.js", "package b98378;\npublic class Y {\n\tpublic int length() {\n\t\treturn -1;\n\t}\n}\n");
        String jclPath = this.getExternalJCLPathString("1.5");
        IType type = this.getClassFile("JavaSearchBugs", jclPath, "java.lang", "CharSequence.class").getType();
        IFunction method = type.getFunction("length", new String[0]);
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type, (WorkingCopyOwner)this.wcOwner));
        this.assertSearchResults("src/b98378/X.java int b98378.X.length() [length] EXACT_MATCH\n" + jclPath + " int java.lang.CharSequence.length() EXACT_MATCH\n" + jclPath + " int java.lang.String.length() EXACT_MATCH");
    }

    public void testBug99600() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b99600/Test.js", "package b99600;\npublic class Test {\n\tpublic class C1 {}\n\tpublic class C2 {\n\t\tclass C3 {\n\t\t\tint foo(C1 c) { return 0; }\n\t\t}\n\t\tpublic void foo(C1 c, int i) {\n\t\t\tnew C3().foo(c);\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test").getType("C2");
        new SearchEngine(this.workingCopies).searchDeclarationsOfSentMessages((IJavaScriptElement)type, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/b99600/Test.java int b99600.Test$C2$C3.foo(C1) [foo(C1 c)] EXACT_MATCH");
    }

    public void testBug99903_annotation() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/package-info.js", "/**\n * @see Test\n */\n@Annot\npackage b99903;\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/Test.js", "package b99903;\npublic class Test {\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/Annot.js", "package b99903;\npublic @interface Annot {\n}\n");
        IType type = this.workingCopies[2].getType("Annot");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b99903/package-info.java [Annot] EXACT_MATCH");
    }

    public void testBug99903_javadoc() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/package-info.js", "/**\n * @see Test\n */\n@Annot\npackage b99903;\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/Test.js", "package b99903;\npublic class Test {\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b99903/Annot.js", "package b99903;\npublic @interface Annot {\n}\n");
        this.resultCollector.showInsideDoc = true;
        IType type = this.workingCopies[1].getType("Test");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b99903/package-info.java [Test] EXACT_MATCH INSIDE_JAVADOC");
    }

    public void testBug100695() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\tClass<Class>[] foo;\n\tClass<Class>[] bar = foo;\n\tTest() {\n\t\tfoo = null;\n\t}\n}\n");
        IField field = this.workingCopies[0].getType("Test").getField("foo");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b100695/Test.java b100695.Test.bar [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test() [foo] EXACT_MATCH");
    }

    public void testBug100695a() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\tClass<Class>[] foo;\n\tClass<Class>[] bar = foo;\n\tTest() {\n\t\tfoo = null;\n\t}\n}\n");
        IField field = this.workingCopies[0].getType("Test").getField("foo");
        this.search((IJavaScriptElement)field, 3);
        this.assertSearchResults("src/b100695/Test.java b100695.Test.foo [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test.bar [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test() [foo] EXACT_MATCH");
    }

    public void testBug100695b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\tClass<Class> foo;\n\tClass<Class> bar = foo;\n\tTest() {\n\t\tfoo = null;\n\t}\n}\n");
        IField field = this.workingCopies[0].getType("Test").getField("foo");
        this.search((IJavaScriptElement)field, 3);
        this.assertSearchResults("src/b100695/Test.java b100695.Test.foo [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test.bar [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test() [foo] EXACT_MATCH");
    }

    public void testBug100695c() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\tClass[] foo;\n\tClass[] bar = foo;\n\tTest() {\n\t\tfoo = null;\n\t}\n}\n");
        IField field = this.workingCopies[0].getType("Test").getField("foo");
        this.search((IJavaScriptElement)field, 3);
        this.assertSearchResults("src/b100695/Test.java b100695.Test.foo [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test.bar [foo] EXACT_MATCH\nsrc/b100695/Test.java b100695.Test() [foo] EXACT_MATCH");
    }

    public void testBug100695d() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\t  public Class<Class>[] foo(Class<Class>[] a) {\n\t\t  return a;\n\t  }\n\t  void bar() {\n\t\t  foo(new Class[0]);\n\t  }\n}\n");
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[0];
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("src/b100695/Test.java Class<Class>[] b100695.Test.foo(Class<Class>[]) [foo] EXACT_MATCH\nsrc/b100695/Test.java void b100695.Test.bar() [foo(new Class[0])] EXACT_MATCH");
    }

    public void testBug100695e() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\t  public Class<Class> foo(Class<Class> a) {\n\t\t  return a;\n\t  }\n\t  void bar() {\n\t\t  foo(null);\n\t  }\n}\n");
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[0];
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("src/b100695/Test.java Class<Class> b100695.Test.foo(Class<Class>) [foo] EXACT_MATCH\nsrc/b100695/Test.java void b100695.Test.bar() [foo(null)] EXACT_MATCH");
    }

    public void testBug100695f() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100695/Test.js", "package b100695;\npublic class Test {\n\t  public Class[] foo(Class[] a) {\n\t\t  return a;\n\t  }\n\t  void bar() {\n\t\t  foo(new Class[0]);\n\t  }\n}\n");
        IFunction method = this.workingCopies[0].getType("Test").getFunctions()[0];
        this.search((IJavaScriptElement)method, 3);
        this.assertSearchResults("src/b100695/Test.java Class[] b100695.Test.foo(Class[]) [foo] EXACT_MATCH\nsrc/b100695/Test.java void b100695.Test.bar() [foo(new Class[0])] EXACT_MATCH");
    }

    private void setUpBug100772_HierarchyScope_ClassAndSubclass() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Test.js", "package b100772;\nclass Test<T> {\n    public void foo(T t) {}\n    public void foo(Class c) {}\n}\nclass Sub extends Test<String> {\n    public void foo(String str) {}\n    public void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_HierarchyScope_ClassAndSubclass01() throws CoreException {
        this.setUpBug100772_HierarchyScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_ClassAndSubclass02() throws CoreException {
        this.setUpBug100772_HierarchyScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_ClassAndSubclass03() throws CoreException {
        this.setUpBug100772_HierarchyScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_ClassAndSubclass04() throws CoreException {
        this.setUpBug100772_HierarchyScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_ClassAndSubclass05() throws CoreException {
        this.setUpBug100772_HierarchyScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Sub.foo(Exception) [foo] EXACT_MATCH");
    }

    private void setUpBug100772_HierarchyScope_InterfacesAndClass() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Test.js", "package b100772;\ninterface Test<T> {\n    public void foo(T t);\n    public void foo(Class c);\n}\ninterface Sub extends Test<String> {\n    public void foo(String str);\n    public void foo(Exception e);\n}\nclass X implements Test<String> {\n    public void foo(String str) {}\n    public void foo(Class c) {}\n    public void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass01() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass02() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass03() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.X.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass04() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Sub.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass05() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Sub.foo(Exception) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass06() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass07() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.X.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_InterfacesAndClass08() throws CoreException {
        this.setUpBug100772_HierarchyScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.X.foo(Exception) [foo] EXACT_MATCH");
    }

    private void setUpBug100772_HierarchyScope_Complex() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Test.js", "package b100772;\npublic class X<T> implements IX<T> {\n\tpublic void foo(T t) {}\n}\nclass XX extends X<String> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\ninterface IX<U> {\n\tpublic void foo(U u);\n}\nclass Y implements IX<String> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\ninterface IXX<V extends Exception> {\n\tpublic void foo(V v);\n}\nclass Z extends Y implements IXX<Exception> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_HierarchyScope_Complex01() throws CoreException {
        this.setUpBug100772_HierarchyScope_Complex();
        IType type = this.workingCopies[0].getType("IX");
        IFunction method = type.getFunction("foo", new String[]{"QU;"});
        this.search((IJavaScriptElement)method, 0, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.X.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.XX.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.IX.foo(U) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Y.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Z.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_Complex02() throws CoreException {
        this.setUpBug100772_HierarchyScope_Complex();
        IType type = this.workingCopies[0].getType("Z");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.IX.foo(U) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Y.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Z.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_Complex03() throws CoreException {
        this.setUpBug100772_HierarchyScope_Complex();
        IType type = this.workingCopies[0].getType("Z");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.Y.foo(Exception) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.IXX.foo(V) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Z.foo(Exception) [foo] EXACT_MATCH");
    }

    public void testBug100772_HierarchyScope_Complex04() throws CoreException {
        this.setUpBug100772_HierarchyScope_Complex();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48, SearchEngine.createHierarchyScope((IType)type));
        this.assertSearchResults("src/b100772/Test.java void b100772.X.foo(T) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.XX.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.IX.foo(U) [foo] EXACT_MATCH");
    }

    private void setUpBug100772_ProjectScope_ClassAndSubclass() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Test.js", "package b100772;\nclass Test<T> {\n    public void foo(T t) {}\n    public void foo(Class c) {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Sub.js", "package b100772;\nclass Sub extends Test<String> {\n    public void foo(String str) {}\n    public void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_ProjectScope_ClassAndSubclass01() throws CoreException {
        this.setUpBug100772_ProjectScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_ClassAndSubclass02() throws CoreException {
        this.setUpBug100772_ProjectScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_ClassAndSubclass03() throws CoreException {
        this.setUpBug100772_ProjectScope_ClassAndSubclass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_ClassAndSubclass04() throws CoreException {
        this.setUpBug100772_ProjectScope_ClassAndSubclass();
        IType type = this.workingCopies[1].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_ClassAndSubclass05() throws CoreException {
        this.setUpBug100772_ProjectScope_ClassAndSubclass();
        IType type = this.workingCopies[1].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(Exception) [foo] EXACT_MATCH");
    }

    private void setUpBug100772_ProjectScope_InterfacesAndClass() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Test.js", "package b100772;\ninterface Test<T> {\n    public void foo(T t);\n    public void foo(Class c);\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Sub.js", "package b100772;\ninterface Sub extends Test<String> {\n    public void foo(String str);\n    public void foo(Exception e);\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/X.js", "package b100772;\nclass X implements Test<String> {\n    public void foo(String str) {}\n    public void foo(Class c) {}\n    public void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass01() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass02() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass03() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass04() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[1].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass05() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[1].getType("Sub");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(Exception) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(Exception) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass06() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[2].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Test.java void b100772.Test.foo(T) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass07() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[2].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QClass;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Test.java void b100772.Test.foo(Class) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(Class) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_InterfacesAndClass08() throws CoreException {
        this.setUpBug100772_ProjectScope_InterfacesAndClass();
        IType type = this.workingCopies[2].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/Sub.java void b100772.Sub.foo(Exception) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(Exception) [foo] EXACT_MATCH");
    }

    private void setUpBug100772_ProjectScope_Complex() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[6];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/X.js", "package b100772;\npublic class X<T> implements IX<T> {\n\tpublic void foo(T t) {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/XX.js", "package b100772;\nclass XX extends X<String> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/IX.js", "package b100772;\ninterface IX<U> {\n\tpublic void foo(U u);\n}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Y.js", "package b100772;\nclass Y implements IX<String> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\n");
        this.workingCopies[4] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/IXX.js", "package b100772;\ninterface IXX<V extends Exception> {\n\tpublic void foo(V v);\n}\n");
        this.workingCopies[5] = this.getWorkingCopy("/JavaSearchBugs/src/b100772/Z.js", "package b100772;\nclass Z extends Y implements IXX<Exception> {\n\tpublic void foo(String s) {}\n\tpublic void foo(Exception e) {}\n}\n");
    }

    public void testBug100772_ProjectScope_Complex01() throws CoreException {
        this.setUpBug100772_ProjectScope_Complex();
        IType type = this.workingCopies[2].getType("IX");
        IFunction method = type.getFunction("foo", new String[]{"QU;"});
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("src/b100772/IX.java void b100772.IX.foo(U) [foo] EXACT_MATCH\nsrc/b100772/X.java void b100772.X.foo(T) [foo] EXACT_MATCH\nsrc/b100772/XX.java void b100772.XX.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Y.java void b100772.Y.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Z.java void b100772.Z.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_Complex02() throws CoreException {
        this.setUpBug100772_ProjectScope_Complex();
        IType type = this.workingCopies[5].getType("Z");
        IFunction method = type.getFunction("foo", new String[]{"QString;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/IX.java void b100772.IX.foo(U) [foo] EXACT_MATCH\nsrc/b100772/XX.java void b100772.XX.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Y.java void b100772.Y.foo(String) [foo] EXACT_MATCH\nsrc/b100772/Z.java void b100772.Z.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_Complex03() throws CoreException {
        this.setUpBug100772_ProjectScope_Complex();
        IType type = this.workingCopies[5].getType("Z");
        IFunction method = type.getFunction("foo", new String[]{"QException;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/IXX.java void b100772.IXX.foo(V) [foo] EXACT_MATCH\nsrc/b100772/XX.java void b100772.XX.foo(Exception) [foo] EXACT_MATCH\nsrc/b100772/Y.java void b100772.Y.foo(Exception) [foo] EXACT_MATCH\nsrc/b100772/Z.java void b100772.Z.foo(Exception) [foo] EXACT_MATCH");
    }

    public void testBug100772_ProjectScope_Complex04() throws CoreException {
        this.setUpBug100772_ProjectScope_Complex();
        IType type = this.workingCopies[0].getType("X");
        IFunction method = type.getFunction("foo", new String[]{"QT;"});
        this.search((IJavaScriptElement)method, 48);
        this.assertSearchResults("src/b100772/X.java void b100772.X.foo(T) [foo] EXACT_MATCH\nsrc/b100772/IX.java void b100772.IX.foo(U) [foo] EXACT_MATCH\nsrc/b100772/XX.java void b100772.XX.foo(String) [foo] EXACT_MATCH");
    }

    public void testBug108088() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b108088", "Test108088.js");
        IType type = unit.getType("A108088");
        IFunction method = type.getFunction("subroutine", new String[]{"F"});
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)method, (int)2, (int)EXACT_RULE);
        JavaSearchBugsTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        this.search(pattern, this.getJavaSearchScopeBugs(), this.resultCollector);
        this.assertSearchResults("src/b108088/B108088.java void b108088.B108088.doit(A108088, String) [subroutine(1.2f)] EXACT_MATCH");
    }

    private void setUpBug110060_TypePattern() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[5];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AA.js", "package b110060;\npublic class AA {\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AAxx.js", "package b110060;\npublic class AAxx {\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AxxAyy.js", "package b110060;\npublic class AxxAyy {\n}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AxA.js", "package b110060;\npublic class AxA {\n}\n");
        this.workingCopies[4] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/Test.js", "package b110060;\npublic class Test {\n\tAA aa;\n\tAAxx aaxx;\n\tAxA axa;\n\tAxxAyy axxayy;\n}\n");
    }

    public void testBug110060_TypePattern01() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AA", 0, 2, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.aa [AA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [AxA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern02() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AA", 0, 3, 128);
        this.assertSearchResults("src/b110060/AA.java b110060.AA [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx [AAxx] EXACT_MATCH\nsrc/b110060/AxA.java b110060.AxA [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [AA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [AxA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern03() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AAx", 0, 3, 128);
        this.assertSearchResults("src/b110060/AAxx.java b110060.AAxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH");
    }

    public void testBug110060_TypePattern04() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("Axx", 0, 3, 128);
        this.assertSearchResults("src/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern05() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("Ax", 0, 3, 128);
        this.assertSearchResults("src/b110060/AxA.java b110060.AxA [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [AxA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern06() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("A*A*", 0, 3, 128);
        this.assertSearchResults("src/b110060/AA.java b110060.AA [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx [AAxx] EXACT_MATCH\nsrc/b110060/AxA.java b110060.AxA [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [AA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [AxA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.annotation.Annotation EXACT_MATCH");
    }

    public void testBug110060_TypePattern07() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("aa", 0, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_TypePattern08() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("aa", 0, 3, 129);
        this.assertSearchResults("src/b110060/AA.java b110060.AA [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [AA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH");
    }

    public void testBug110060_TypePattern09() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AA", 0, 3, 136);
        this.assertSearchResults("src/b110060/AA.java b110060.AA [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx [AAxx] EXACT_MATCH\nsrc/b110060/AxA.java b110060.AxA [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [AA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [AxA] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern10() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AxAx", 0, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_TypePattern11() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AxxA", 0, 3, 128);
        this.assertSearchResults("src/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_TypePattern12() throws CoreException {
        this.setUpBug110060_TypePattern();
        this.search("AxXA", 0, 3, 128);
        this.assertSearchResults("src/b110060/AxxAyy.java b110060.AxxAyy [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [AxxAyy] EXACT_MATCH");
    }

    public void testBug110060_AllTypeNames01() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 128, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx\nb110060.AxA\nb110060.AxxAyy", (Object)requestor);
    }

    public void testBug110060_AllTypeNames02() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 129, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx\nb110060.AxA\nb110060.AxxAyy", (Object)requestor);
    }

    public void testBug110060_AllTypeNames03() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 136, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx\nb110060.AxA\nb110060.AxxAyy", (Object)requestor);
    }

    public void testBug110060_AllTypeNames04() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 137, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx\nb110060.AxA\nb110060.AxxAyy", (Object)requestor);
    }

    public void testBug110060_AllTypeNames05() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 1, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx", (Object)requestor);
    }

    public void testBug110060_AllTypeNames06() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 8, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA", (Object)requestor);
    }

    public void testBug110060_AllTypeNames07() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "AA".toCharArray(), 9, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx", (Object)requestor);
    }

    public void testBug110060_AllTypeNames08() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 128, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx", (Object)requestor);
    }

    public void testBug110060_AllTypeNames09() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 129, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx", (Object)requestor);
    }

    public void testBug110060_AllTypeNames10() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 136, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "", (Object)requestor);
    }

    public void testBug110060_AllTypeNames11() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 137, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "", (Object)requestor);
    }

    public void testBug110060_AllTypeNames12() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 1, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b110060.AA\nb110060.AAxx", (Object)requestor);
    }

    public void testBug110060_AllTypeNames13() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 8, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "", (Object)requestor);
    }

    public void testBug110060_AllTypeNames14() throws CoreException {
        this.setUpBug110060_TypePattern();
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "aa".toCharArray(), 9, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "", (Object)requestor);
    }

    private void setUpBug110060_ConstructorPattern() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[5];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AA.js", "package b110060;\npublic class AA {\n\tAA() {}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AAxx.js", "package b110060;\npublic class AAxx {\n\tAAxx() {}\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AxxAyy.js", "package b110060;\npublic class AxxAyy {\n\tAxxAyy() {}\n}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/AxA.js", "package b110060;\npublic class AxA {\n\tAxA() {}\n}\n");
        this.workingCopies[4] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/Test.js", "package b110060;\npublic class Test {\n\tAA aa = new AA();\n\tAAxx aaxx = new AAxx();\n\tAxA axa = new AxA();\n\tAxxAyy axxayy = new AxxAyy();\n}\n");
    }

    public void testBug110060_ConstructorPattern01() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("AA", 3, 2, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.aa [new AA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [new AAxx()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [new AxA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [new AxxAyy()] EXACT_MATCH");
    }

    public void testBug110060_ConstructorPattern02() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("AA", 3, 3, 128);
        this.assertSearchResults("src/b110060/AA.java b110060.AA() [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx() [AAxx] EXACT_MATCH\nsrc/b110060/AxA.java b110060.AxA() [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy() [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [new AA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [new AAxx()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [new AxA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [new AxxAyy()] EXACT_MATCH");
    }

    public void testBug110060_ConstructorPattern03() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("AAx", 3, 3, 128);
        this.assertSearchResults("src/b110060/AAxx.java b110060.AAxx() [AAxx] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [new AAxx()] EXACT_MATCH");
    }

    public void testBug110060_ConstructorPattern04() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("Axx", 3, 3, 128);
        this.assertSearchResults("src/b110060/AxxAyy.java b110060.AxxAyy() [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [new AxxAyy()] EXACT_MATCH");
    }

    public void testBug110060_ConstructorPattern05() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("Ax", 3, 3, 128);
        this.assertSearchResults("src/b110060/AxA.java b110060.AxA() [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy() [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [new AxA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [new AxxAyy()] EXACT_MATCH");
    }

    public void testBug110060_ConstructorPattern06() throws CoreException {
        this.setUpBug110060_ConstructorPattern();
        this.search("A*A*", 3, 3, 128);
        this.assertSearchResults("src/b110060/AA.java b110060.AA() [AA] EXACT_MATCH\nsrc/b110060/AAxx.java b110060.AAxx() [AAxx] EXACT_MATCH\nsrc/b110060/AxA.java b110060.AxA() [AxA] EXACT_MATCH\nsrc/b110060/AxxAyy.java b110060.AxxAyy() [AxxAyy] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aa [new AA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aaxx [new AAxx()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axa [new AxA()] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.axxayy [new AxxAyy()] EXACT_MATCH");
    }

    private void setUpBug110060_MethodPattern() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/Test.js", "package b110060;\npublic class Test {\n\tvoid aMethodWithNothingSpecial() {}\n\tvoid aMethodWith1Digit() {}\n\tvoid aMethodWith1DigitAnd_AnUnderscore() {}\n\tvoid aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() {}\n\tvoid otherMethodWhichStartsWithAnotherLetter() {}\n\tvoid testReferences() {\n\t\taMethodWith1Digit();\n\t\taMethodWith1DigitAnd_AnUnderscore();\n\t\taMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores();\n\t\taMethodWithNothingSpecial();\n\t\totherMethodWhichStartsWithAnotherLetter();\n\t}\n}\n");
    }

    public void testBug110060_MethodPattern01() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("MWD", 1, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_MethodPattern02() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("AMWD", 1, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_MethodPattern03() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMWD", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWith1Digit() [aMethodWith1Digit] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1DigitAnd_AnUnderscore() [aMethodWith1DigitAnd_AnUnderscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Digit()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1DigitAnd_AnUnderscore()] EXACT_MATCH");
    }

    public void testBug110060_MethodPattern04() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMW", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWithNothingSpecial() [aMethodWithNothingSpecial] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Digit() [aMethodWith1Digit] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1DigitAnd_AnUnderscore() [aMethodWith1DigitAnd_AnUnderscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Digit()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1DigitAnd_AnUnderscore()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWithNothingSpecial()] EXACT_MATCH");
    }

    public void testBug110060_MethodPattern05() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMethod", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWithNothingSpecial() [aMethodWithNothingSpecial] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Digit() [aMethodWith1Digit] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1DigitAnd_AnUnderscore() [aMethodWith1DigitAnd_AnUnderscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Digit()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1DigitAnd_AnUnderscore()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWithNothingSpecial()] EXACT_MATCH");
    }

    public void testBug110060_MethodPattern06() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMethodWith1", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWith1Digit() [aMethodWith1Digit] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1DigitAnd_AnUnderscore() [aMethodWith1DigitAnd_AnUnderscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Digit()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1DigitAnd_AnUnderscore()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores()] EXACT_MATCH");
    }

    public void testBug110060_MethodPattern07() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("*Method*With*A*", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWithNothingSpecial() [aMethodWithNothingSpecial] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1DigitAnd_AnUnderscore() [aMethodWith1DigitAnd_AnUnderscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.otherMethodWhichStartsWithAnotherLetter() [otherMethodWhichStartsWithAnotherLetter] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1DigitAnd_AnUnderscore()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWithNothingSpecial()] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [otherMethodWhichStartsWithAnotherLetter()] EXACT_MATCH");
    }

    public void testBug110060_MethodPattern08() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMW1D", 1, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_MethodPattern09() throws CoreException {
        this.setUpBug110060_MethodPattern();
        this.search("aMWOOODASU", 1, 3, 128);
        this.assertSearchResults("src/b110060/Test.java void b110060.Test.aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aMethodWith1Or2_Or_3_Or__4__DigitsAnd_Several_Underscores()] EXACT_MATCH");
    }

    private void setUpBug110060_FieldPattern() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110060/Test.js", "package b110060;\npublic class Test {\n\tObject aFieldWithNothingSpecial;\n\tObject aFieldWithS$Dollar;\n\tObject aFieldWith$Several$DollarslAnd1DigitAnd_1Underscore;\n\tObject aStrangeFieldWith$$$$$$$$$$$$$$$SeveraContiguousDollars;\n\tObject otherFieldWhichStartsWithAnotherLetter;\n\tvoid testReferences() {\n\t\tObject o0 = aFieldWithNothingSpecial;\n\t\tObject o1 = aFieldWithS$Dollar;\n\t\tObject o2 = aFieldWith$Several$DollarslAnd1DigitAnd_1Underscore;\n\t\tObject o3 = aStrangeFieldWith$$$$$$$$$$$$$$$SeveraContiguousDollars;\n\t}\n\tObject oF = otherFieldWhichStartsWithAnotherLetter;\n}\n");
    }

    public void testBug110060_FieldPattern01() throws CoreException {
        this.setUpBug110060_FieldPattern();
        this.search("aFWSD", 4, 3, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.aFieldWithS$Dollar [aFieldWithS$Dollar] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.aFieldWith$Several$DollarslAnd1DigitAnd_1Underscore [aFieldWith$Several$DollarslAnd1DigitAnd_1Underscore] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aFieldWithS$Dollar] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aFieldWith$Several$DollarslAnd1DigitAnd_1Underscore] EXACT_MATCH");
    }

    public void testBug110060_FieldPattern02() throws CoreException {
        this.setUpBug110060_FieldPattern();
        this.search("afwsd", 4, 3, 128);
        this.assertSearchResults("");
    }

    public void testBug110060_FieldPattern03() throws CoreException {
        this.setUpBug110060_FieldPattern();
        this.search("aFWS$", 4, 3, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.aFieldWithS$Dollar [aFieldWithS$Dollar] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aFieldWithS$Dollar] EXACT_MATCH");
    }

    public void testBug110060_FieldPattern04() throws CoreException {
        this.setUpBug110060_FieldPattern();
        this.search("aSFWSCD", 4, 3, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.aStrangeFieldWith$$$$$$$$$$$$$$$SeveraContiguousDollars [aStrangeFieldWith$$$$$$$$$$$$$$$SeveraContiguousDollars] EXACT_MATCH\nsrc/b110060/Test.java void b110060.Test.testReferences() [aStrangeFieldWith$$$$$$$$$$$$$$$SeveraContiguousDollars] EXACT_MATCH");
    }

    public void testBug110060_FieldPattern05() throws CoreException {
        this.setUpBug110060_FieldPattern();
        this.search("oF", 4, 3, 128);
        this.assertSearchResults("src/b110060/Test.java b110060.Test.otherFieldWhichStartsWithAnotherLetter [otherFieldWhichStartsWithAnotherLetter] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.oF [oF] EXACT_MATCH\nsrc/b110060/Test.java b110060.Test.oF [otherFieldWhichStartsWithAnotherLetter] EXACT_MATCH");
    }

    public void testBug110291() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110291/Test110291XX.js", "package b110291;\npublic class Test110291XX {\n\tclass Test110291YY {}}\n");
        this.search("Test110291", 3, 0, 1);
        this.assertSearchResults("src/b110291/Test110291XX.java b110291.Test110291XX$Test110291YY [Test110291YY] EXACT_MATCH");
    }

    public void testBug110336a() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\t<TP extends Test> void method(Class<Test> clazz) {\n\t\tTest localVar1 = new Test();\n\t\tClass<Test> localVar2 = new Class<Test>();\n\t\tlocalVar1.method(localVar2);\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java void b110336.Test.method(Class<Test>).TP [Test]\nsrc/b110336/Test.java void b110336.Test.method(Class<Test>).clazz [Test]\nsrc/b110336/Test.java void b110336.Test.method(Class<Test>).localVar1 [Test]\nsrc/b110336/Test.java void b110336.Test.method(Class<Test>).localVar1 [Test]\nsrc/b110336/Test.java void b110336.Test.method(Class<Test>).localVar2 [Test]\nsrc/b110336/Test.java void b110336.Test.method(Class<Test>).localVar2 [Test]", collector);
    }

    public void testBug110336b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\tvoid method1(Test methodParam) {\n\t\tTest localVar1 = new Test(){\n\t\t\tClass c = Test.class;\n\t\t\t<TP extends Test> void foo(){\n\t\t\t\tTest o = (Test) null;\n\t\t\t}\n\t\t};\n\t}\t\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java void b110336.Test.method1(Test):<anonymous>#1 [Test]\nsrc/b110336/Test.java void b110336.Test.method1(Test):<anonymous>#1.c [Test]\nsrc/b110336/Test.java void void b110336.Test.method1(Test):<anonymous>#1.foo().TP [Test]\nsrc/b110336/Test.java void void b110336.Test.method1(Test):<anonymous>#1.foo().o [Test]\nsrc/b110336/Test.java void void b110336.Test.method1(Test):<anonymous>#1.foo().o [Test]\nsrc/b110336/Test.java void b110336.Test.method1(Test).methodParam [Test]\nsrc/b110336/Test.java void b110336.Test.method1(Test).localVar1 [Test]", collector);
    }

    public void testBug110336c() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test<TP extends X> {\n\tX x;\n\n}\nclass X {}\n");
        IType type = this.workingCopies[0].getType("X");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java b110336.Test.TP [X]\nsrc/b110336/Test.java b110336.Test.x [X]", collector);
    }

    public void testBug110336d() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\tTest a1Test = null, b1Test = new Test(), c1Test;\n\tTest a2Test = new Test(), b2Test, c2Test = null;\n\tTest a3Test, b3Test = null, c3Test = new Test();\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java b110336.Test.a1Test [Test]+[b1Test,c1Test]\nsrc/b110336/Test.java b110336.Test.b1Test [Test]\nsrc/b110336/Test.java b110336.Test.a2Test [Test]+[b2Test,c2Test]\nsrc/b110336/Test.java b110336.Test.a2Test [Test]\nsrc/b110336/Test.java b110336.Test.a3Test [Test]+[b3Test,c3Test]\nsrc/b110336/Test.java b110336.Test.c3Test [Test]", collector);
    }

    public void testBug110336e() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\tvoid foo() {\n\t\tTest lv1 = null, lv2 = new Test(), lv3;\n\t\tTest lv4 = new Test(), lv5, lv6 = null;\n\t\tTest lv7, lv8 = null, lv9 = new Test();\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java void b110336.Test.foo().lv1 [Test]+[lv2,lv3]\nsrc/b110336/Test.java void b110336.Test.foo().lv2 [Test]\nsrc/b110336/Test.java void b110336.Test.foo().lv4 [Test]+[lv5,lv6]\nsrc/b110336/Test.java void b110336.Test.foo().lv4 [Test]\nsrc/b110336/Test.java void b110336.Test.foo().lv7 [Test]+[lv8,lv9]\nsrc/b110336/Test.java void b110336.Test.foo().lv9 [Test]", collector);
    }

    public void testBug110336f() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test extends Exception {\n        void foo(Test test1) { // <- no local element\n                Test test2; // <- local element\n                try {\n                        throw new Test();\n                }\n                catch (Test test4) { // <- no local element\n                }\n                for(Test test3;;) {} // <- local element\n        }\n\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java void b110336.Test.foo(Test).test1 [Test]\nsrc/b110336/Test.java void b110336.Test.foo(Test).test2 [Test]\nsrc/b110336/Test.java void b110336.Test.foo(Test) [Test]\nsrc/b110336/Test.java void b110336.Test.foo(Test).test4 [Test]\nsrc/b110336/Test.java void b110336.Test.foo(Test).test3 [Test]", collector);
    }

    public void testBug110336g() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\t{\n\t\tTest lv1 = null, lv2 = new Test(), lv3;\n\t\tTest lv4 = new Test(), lv5, lv6 = null;\n\t\tTest lv7, lv8 = null, lv9 = new Test();\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java b110336.Test.{}.lv1 [Test]+[lv2,lv3]\nsrc/b110336/Test.java b110336.Test.{}.lv2 [Test]\nsrc/b110336/Test.java b110336.Test.{}.lv4 [Test]+[lv5,lv6]\nsrc/b110336/Test.java b110336.Test.{}.lv4 [Test]\nsrc/b110336/Test.java b110336.Test.{}.lv7 [Test]+[lv8,lv9]\nsrc/b110336/Test.java b110336.Test.{}.lv9 [Test]", collector);
    }

    public void testBug110336h() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b110336/Test.js", "package b110336;\npublic class Test {\n\tstatic {\n\t\tTest lv1 = null, lv2 = new Test(), lv3;\n\t\tTest lv4 = new Test(), lv5, lv6 = null;\n\t\tTest lv7, lv8 = null, lv9 = new Test();\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        TypeReferencesCollector collector = new TypeReferencesCollector();
        this.search((IJavaScriptElement)type, 2, EXACT_RULE, this.getJavaSearchScopeBugs(), (SearchRequestor)collector);
        this.assertSearchResults("src/b110336/Test.java b110336.Test.static {}.lv1 [Test]+[lv2,lv3]\nsrc/b110336/Test.java b110336.Test.static {}.lv2 [Test]\nsrc/b110336/Test.java b110336.Test.static {}.lv4 [Test]+[lv5,lv6]\nsrc/b110336/Test.java b110336.Test.static {}.lv4 [Test]\nsrc/b110336/Test.java b110336.Test.static {}.lv7 [Test]+[lv8,lv9]\nsrc/b110336/Test.java b110336.Test.static {}.lv9 [Test]", collector);
    }

    public void testBug110422a() throws CoreException {
        this.search("TestP", 0, 0, 9);
        this.assertSearchResults("lib/b110422.jar b110422.TestPrefix [No source] EXACT_MATCH");
    }

    public void testBug110422b() throws CoreException {
        this.search("TESTP", 0, 0, 1);
        this.assertSearchResults("lib/b110422.jar b110422.TestPrefix [No source] EXACT_MATCH");
    }

    public void testBug113671() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames("java.lang".toCharArray(), 0, CharOperation.NO_CHAR, 1, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.CharSequence\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Comparable\njava.lang.Enum\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable", (Object)requestor);
    }

    public void testBug114539() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b114539/Foo.js", "package b114539;\npublic class Foo {\n\tint bar=Bar.FOO;\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b114539/Bar.js", "package b114539;\npublic class Bar {\n\tprivate static final int FOO=0;\n}\n");
        IField field = this.workingCopies[1].getType("Bar").getField("FOO");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b114539/Foo.java b114539.Foo.bar [FOO] POTENTIAL_MATCH");
    }

    public void testBug116459() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/p1/X.js", "package p1;\nclass X<T> {\n\tX<T> gen;\n\tX<String> param;\n\tX raw;\n}");
        IType type = this.workingCopies[0].getType("X");
        this.resultCollector.showRule = true;
        this.search((IJavaScriptElement)type, 2, ERASURE_RULE);
        this.assertSearchResults("src/p1/X.java p1.X.gen [X] EXACT_MATCH\nsrc/p1/X.java p1.X.param [X] ERASURE_MATCH\nsrc/p1/X.java p1.X.raw [X] ERASURE_RAW_MATCH");
    }

    public void testBug119545() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b119545/Test.js", "package b119545;\nclass Test {\n\tvoid foo(Object o1, Object o2){\n\t\tif (o1.equals(o2)) {}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("Test");
        IFunction method = type.getFunctions()[0];
        this.searchDeclarationsOfSentMessages((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " boolean java.lang.Object.equals(java.lang.Object) EXACT_MATCH");
    }

    public void testBug120816a() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b120816/Test.js", "package b120816;\npublic class Test<E> {\n\tString foo(E e) { return \"\"; }\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b120816/Sub.js", "package b120816;\npublic class Sub extends Test<Exception> {\n\tString foo(RuntimeException e) { return \"\"; }\n\tString foo(Exception e) {\n\t\treturn super.foo(e);\n\t}\n}\n");
        this.search("* String (Exception)", 1, 0);
        this.assertSearchResults("src/b120816/Sub.java String b120816.Sub.foo(Exception) [foo] EXACT_MATCH");
    }

    public void testBug120816b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b120816/Test.js", "package b120816;\npublic class Test<E> {\n\tString foo(E e) { return \"\"; }\n}\nclass Sub extends Test<Exception> {\n\tString foo(RuntimeException e) { return \"\"; }\n\tString foo(Exception e) {\n\t\treturn super.foo(e);\n\t}\n}\n");
        this.search("* String (Exception)", 1, 0);
        this.assertSearchResults("src/b120816/Test.java String b120816.Sub.foo(Exception) [foo] EXACT_MATCH");
    }

    private void setUpBug122442a() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[3];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b122442/I.js", "package b122442;\npublic interface I {}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b122442/II.js", "package b122442;\npublic interface II extends I {}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b122442/X.js", "package b122442;\npublic class X implements I {}\n");
    }

    public void testBug122442a() throws CoreException {
        this.setUpBug122442a();
        this.search("I", 0, 1);
        this.assertSearchResults("src/b122442/II.java b122442.II [I] EXACT_MATCH\nsrc/b122442/X.java b122442.X [I] EXACT_MATCH");
    }

    public void testBug122442b() throws CoreException {
        this.setUpBug122442a();
        this.search("I", 6, 1);
        this.assertSearchResults("src/b122442/II.java b122442.II [I] EXACT_MATCH");
    }

    public void testBug122442c() throws CoreException {
        this.setUpBug122442a();
        this.search("I", 5, 1);
        this.assertSearchResults("src/b122442/X.java b122442.X [I] EXACT_MATCH");
    }

    private void setUpBug122442d() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b122442/User.js", "class Klass {}\ninterface Interface {}\nclass User {\n    void m() {\n        new Klass() {};\n        new Interface() {};\n    }\n}\nclass Sub extends Klass {}");
    }

    public void testBug122442d() throws CoreException {
        this.setUpBug122442d();
        this.search("Interface", 0, 1);
        this.assertSearchResults("src/b122442/User.java void b122442.User.m():<anonymous>#2 [Interface] EXACT_MATCH");
    }

    public void testBug122442e() throws CoreException {
        this.setUpBug122442d();
        this.search("Interface", 6, 1);
        this.assertSearchResults("");
    }

    public void testBug122442f() throws CoreException {
        this.setUpBug122442d();
        this.search("Interface", 5, 1);
        this.assertSearchResults("src/b122442/User.java void b122442.User.m():<anonymous>#2 [Interface] EXACT_MATCH");
    }

    public void testBug122442g() throws CoreException {
        this.setUpBug122442d();
        this.search("Klass", 0, 1);
        this.assertSearchResults("src/b122442/User.java void b122442.User.m():<anonymous>#1 [Klass] EXACT_MATCH\nsrc/b122442/User.java b122442.Sub [Klass] EXACT_MATCH");
    }

    public void testBug122442h() throws CoreException {
        this.setUpBug122442d();
        this.search("Klass", 6, 1);
        this.assertSearchResults("");
    }

    public void testBug122442i() throws CoreException {
        this.setUpBug122442d();
        this.search("Klass", 5, 1);
        this.assertSearchResults("src/b122442/User.java void b122442.User.m():<anonymous>#1 [Klass] EXACT_MATCH\nsrc/b122442/User.java b122442.Sub [Klass] EXACT_MATCH");
    }

    public void testBug123679() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b123679.jar", "pack").getClassFile("I123679.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b123679.jar test.<anonymous> EXACT_MATCH\nlib/b123679.jar test.Test$StaticClass$Member.parent EXACT_MATCH\nlib/b123679.jar test.<anonymous> EXACT_MATCH\nlib/b123679.jar test.Test$StaticClass$Member(test.Test.StaticClass, java.lang.Object) EXACT_MATCH\nlib/b123679.jar test.Test$StaticClass$Member(test.Test.StaticClass, java.lang.Object) EXACT_MATCH\nlib/b123679.jar pack.I123679 test.Test$StaticClass$Member.getParent() EXACT_MATCH");
    }

    public void testBug123679_cu() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b123679.pack", "I123679.js");
        IType type = unit.getType("I123679");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/b123679/test/Test.java [b123679.pack.I123679] EXACT_MATCH\nsrc/b123679/test/Test.java b123679.test.Test$StaticClass$Member.parent [I123679] EXACT_MATCH\nsrc/b123679/test/Test.java b123679.test.Test$StaticClass$Member(Object):<anonymous>#1 [I123679] EXACT_MATCH\nsrc/b123679/test/Test.java b123679.test.Test$StaticClass$Member(Object) [I123679] EXACT_MATCH\nsrc/b123679/test/Test.java b123679.test.Test$StaticClass$Member(Object) [I123679] EXACT_MATCH\nsrc/b123679/test/Test.java I123679 b123679.test.Test$StaticClass$Member.getParent() [I123679] EXACT_MATCH");
    }

    public void testBug123679_wc() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/pack/I122679.js", "package pack;\npublic interface I123679 {\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/test/Test.js", "package test;\nimport pack.I123679;\npublic class Test {\n\tstatic class StaticClass {\n\t\tclass Member {\n\t\t\tprivate I123679 parent;\n\t\t\tMember(Object obj) {\n\t\t\t\tif (obj instanceof I123679) {\n\t\t\t\t\tparent = (I123679) obj;\n\t\t\t\t} else {\n\t\t\t\t\tparent = new I123679() {};\n\t\t\t\t}\n\t\t\t}\n\t\t\tI123679 getParent() {\n\t\t\t\treturn parent;\n\t\t\t}\n\t\t}\n\t}\n}\n");
        IType type = this.workingCopies[0].getType("I123679");
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("src/test/Test.java test.Test$StaticClass$Member.parent [I123679] EXACT_MATCH\nsrc/test/Test.java test.Test$StaticClass$Member(Object):<anonymous>#1 [I123679] EXACT_MATCH\nsrc/test/Test.java test.Test$StaticClass$Member(Object) [I123679] EXACT_MATCH\nsrc/test/Test.java test.Test$StaticClass$Member(Object) [I123679] EXACT_MATCH\nsrc/test/Test.java I123679 test.Test$StaticClass$Member.getParent() [I123679] EXACT_MATCH");
    }

    public void testBug124469a() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b124469.jar pack.E pack.A1.value() EXACT_MATCH\nlib/b124469.jar pack.E[] pack.A1.list() EXACT_MATCH\nlib/b124469.jar pack.E pack.A2.value() EXACT_MATCH\nlib/b124469.jar pack.E[] pack.A2.list() EXACT_MATCH\nlib/b124469.jar pack.E pack.A3.value() EXACT_MATCH\nlib/b124469.jar pack.E[] pack.A3.list() EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469b() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "A1.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b124469.jar pack.A1 pack.A2.annot() EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469c() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "A2.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b124469.jar pack.A2 pack.A3.annot() EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469d() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "A3.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469e() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CC");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH");
    }

    public void testBug124469f() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CF");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH");
    }

    public void testBug124469g() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CM");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469h() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CP");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("");
    }

    public void testBug124469i() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CV");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("");
    }

    public void testBug124469j() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CAC");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH\nlib/b124469.jar test.C EXACT_MATCH");
    }

    public void testBug124469k() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CAF");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH\nlib/b124469.jar test.F.field EXACT_MATCH");
    }

    public void testBug124469l() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CAM");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH\nlib/b124469.jar void test.M.foo() EXACT_MATCH");
    }

    public void testBug124469m() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CAP");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("");
    }

    public void testBug124469n() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b124469.jar", "pack", "E.class").getType();
        IField field = type.getField("CAV");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("");
    }

    public void testBug124489() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Foo.js", "public class Foo<T> {}");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/Bar.js", "public class Bar {\n    Foo<String> f = new Foo<String>();\n    Foo f2 = new Foo();\n}");
        IType type = this.workingCopies[0].getType("Foo");
        this.resultCollector.showRule = true;
        new SearchEngine(this.workingCopies).search(SearchPattern.createPattern((IJavaScriptElement)type, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.getJavaSearchScopeBugs(), (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/Bar.java Bar.f [Foo] ERASURE_MATCH\nsrc/Bar.java Bar.f [Foo] ERASURE_MATCH\nsrc/Bar.java Bar.f2 [Foo] ERASURE_RAW_MATCH\nsrc/Bar.java Bar.f2 [Foo] ERASURE_RAW_MATCH");
    }

    public void testBug124645a() throws CoreException {
        IClassFile classFile = this.getClassFile("JavaSearchBugs", "lib/b124645.jar", "xy", "BE_124645.class");
        IType type = classFile.getType();
        this.search((IJavaScriptElement)type, 1);
        this.assertSearchResults("src/b124645/xy/X_124645.java b124645.xy.X_124645$Y [BE_124645] EXACT_MATCH\nsrc/b124645/xy/Y_124645.java b124645.xy.Y_124645 [BE_124645] EXACT_MATCH\nlib/b124645.jar xy.BX_124645$Y EXACT_MATCH\nlib/b124645.jar xy.BY_124645 EXACT_MATCH");
    }

    public void testBug124645b() throws CoreException {
        IClassFile classFile = this.getClassFile("JavaSearchBugs", "lib/b124645.jar", "test", "BE_124645.class");
        IType type = classFile.getType();
        this.search((IJavaScriptElement)type, 1);
        this.assertSearchResults("src/b124645/test/A_124645.java b124645.test.A_124645 [BE_124645] EXACT_MATCH\nsrc/b124645/test/A_124645.java void b124645.test.A_124645.m():<anonymous>#1 [BE_124645] EXACT_MATCH\nsrc/b124645/test/X_124645.java b124645.test.X_124645 [BE_124645] EXACT_MATCH\nsrc/b124645/test/X_124645.java void b124645.test.X_124645.m():Y_124645#1 [BE_124645] EXACT_MATCH\nlib/b124645.jar test.BA_124645 EXACT_MATCH\nlib/b124645.jar test.<anonymous> EXACT_MATCH\nlib/b124645.jar test.BX_124645 EXACT_MATCH\nlib/b124645.jar test.Y EXACT_MATCH");
    }

    public void testBug124645c() throws CoreException {
        IClassFile classFile = this.getClassFile("JavaSearchBugs", "lib/b124645.jar", "", "BC_124645.class");
        IType type = classFile.getType();
        this.search((IJavaScriptElement)type, 1);
        this.assertSearchResults("lib/b124645.jar <anonymous> EXACT_MATCH");
    }

    public void testBug124645d() throws CoreException {
        IClassFile classFile = this.getClassFile("JavaSearchBugs", "lib/b124645.jar", "", "BI_124645.class");
        IType type = classFile.getType();
        this.search((IJavaScriptElement)type, 1);
        this.assertSearchResults("lib/b124645.jar <anonymous> EXACT_MATCH");
    }

    public void testBug125178() throws CoreException {
        AbstractJavaModelTests.ProblemRequestor problemRequestor = new AbstractJavaModelTests.ProblemRequestor();
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b125178/X.js", "package b125178;\nimport pack.age.Test;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew Test().foo(100);\n\t}\n}\n", new WorkingCopyOwner(){}, problemRequestor);
        JavaSearchBugsTests.assertEquals((String)"CU Should not have any problem!", (String)"----------\n----------\n", (String)problemRequestor.problems.toString());
        IPackageFragment jar = this.getPackageFragment("JavaSearchBugs", "lib/b125178.jar", "pack.age");
        IJavaScriptElement[] children = jar.getChildren();
        JavaSearchBugsTests.assertNotNull((String)"We should have children for in default package of lib/b125178.jar", (Object)children);
        int i = 0;
        int l = children.length;
        while (i < l) {
            JavaSearchBugsTests.assertTrue((String)"Jar should only have class files!", (boolean)(children[i] instanceof ClassFile));
            IType type = ((ClassFile)children[i]).getType();
            if (type.isAnonymous()) {
                this.search((IJavaScriptElement)type, 2);
            }
            ++i;
        }
        this.assertSearchResults("");
    }

    public void testBug126330() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b126330.jar", "").getClassFile("A126330.class").getType();
        this.search((IJavaScriptElement)type, 2);
        this.assertSearchResults("lib/b126330.jar B126330.a EXACT_MATCH");
    }

    public void testBug127628() throws CoreException {
        class DeprecatedTypesRequestor
        extends SearchTests.SearchTypeNameRequestor {
            final /* synthetic */ JavaSearchBugsTests this$0;

            DeprecatedTypesRequestor(JavaSearchBugsTests javaSearchBugsTests) {
                this.this$0 = javaSearchBugsTests;
            }

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if ((modifiers & 0x100000) != 0) {
                    char[] typeName = CharOperation.concat((char[])CharOperation.concatWith((char[][])enclosingTypeNames, (char)'$'), (char[])simpleTypeName, (char)'$');
                    this.results.addElement(new String(CharOperation.concat((char[])packageName, (char[])typeName, (char)'.')));
                }
            }
        }
        DeprecatedTypesRequestor requestor = new DeprecatedTypesRequestor(this);
        new SearchEngine().searchAllTypeNames(null, 0, null, 2, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b127628.Test127628", (Object)requestor);
    }

    public void testBug128877a() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b128877.jar", "pack").getClassFile("Test.class").getType();
        IFunction method = type.getFunction("Test", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("lib/b128877.jar pack.X$Sub(pack.X) EXACT_MATCH");
    }

    public void testBug128877b() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b128877.jar", "pack").getClassFile("Test.class").getType();
        IFunction method = type.getFunction("Test", new String[]{"Ljava.lang.String;"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("lib/b128877.jar pack.X$Sub(pack.X, java.lang.String) EXACT_MATCH");
    }

    public void testBug128877c() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b128877.jar", "pack").getClassFile("Test.class").getType();
        IFunction method = type.getFunction("foo128877", new String[]{"I"});
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("lib/b128877.jar pack.X$Sub(pack.X) EXACT_MATCH");
    }

    private void setUpBug130390() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b130390/TZ.js", "package b130390;\npublic class TZ {\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b130390/TimeZone.js", "package b130390;\npublic class TimeZone{\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b130390/Npe.js", "package b130390;\npublic class Npe {\n}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b130390/NullPointerException.js", "package b130390;\npublic class NullPointerException {\n}\n");
    }

    public void testBug130390() throws CoreException {
        this.setUpBug130390();
        this.search("NuPoEx", 0, 0, 128);
        this.assertSearchResults("src/b130390/NullPointerException.java b130390.NullPointerException [NullPointerException] EXACT_MATCH");
    }

    public void testBug130390b() throws CoreException {
        this.setUpBug130390();
        this.search("NPE", 0, 0, 128);
        this.assertSearchResults("src/b130390/Npe.java b130390.Npe [Npe] EXACT_MATCH\nsrc/b130390/NullPointerException.java b130390.NullPointerException [NullPointerException] EXACT_MATCH");
    }

    public void testBug130390c() throws CoreException {
        this.setUpBug130390();
        this.search("NPE", 0, 0, 136);
        this.assertSearchResults("src/b130390/NullPointerException.java b130390.NullPointerException [NullPointerException] EXACT_MATCH");
    }

    public void testBug130390d() throws CoreException {
        this.setUpBug130390();
        this.search("Npe", 0, 3, 128);
        this.assertSearchResults("src/b130390/Npe.java b130390.Npe [Npe] EXACT_MATCH");
    }

    public void testBug130390e() throws CoreException {
        this.setUpBug130390();
        this.search("Npe", 0, 0, 136);
        this.assertSearchResults("src/b130390/Npe.java b130390.Npe [Npe] EXACT_MATCH");
    }

    public void testBug130390f() throws CoreException {
        this.setUpBug130390();
        this.search("NullPE", 0, 3, 128);
        this.assertSearchResults("src/b130390/NullPointerException.java b130390.NullPointerException [NullPointerException] EXACT_MATCH");
    }

    public void testBug130390g() throws CoreException {
        this.setUpBug130390();
        this.search("TZ", 0, 0, 136);
        this.assertSearchResults("src/b130390/TZ.java b130390.TZ [TZ] EXACT_MATCH\nsrc/b130390/TimeZone.java b130390.TimeZone [TimeZone] EXACT_MATCH");
    }

    public void testBug130390h() throws CoreException {
        this.setUpBug130390();
        this.search("TiZo", 0, 0, 136);
        this.assertSearchResults("src/b130390/TimeZone.java b130390.TimeZone [TimeZone] EXACT_MATCH");
    }

    public void testBug137087() throws CoreException {
        int matchRule = 128;
        String pattern = "runtimeEx";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH");
    }

    public void testBug137087b() throws CoreException {
        int matchRule = 128;
        String pattern = "Runtimeex";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH");
    }

    public void testBug137087c() throws CoreException {
        int matchRule = 128;
        String pattern = "runtimeexception";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.RuntimeException EXACT_MATCH");
    }

    public void testBug137087d() throws CoreException {
        int matchRule = 128;
        String pattern = "Runtimexception";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
    }

    public void testBug137087e() throws CoreException {
        int matchRule = 128;
        String pattern = "IllegalMSException";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.IllegalMonitorStateException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.IllegalMonitorStateException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.IllegalMonitorStateException EXACT_MATCH");
    }

    public void testBug137087f() throws CoreException {
        int matchRule = 128;
        String pattern = "illegalMsExceptionSException";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
    }

    public void testBug137087g() throws CoreException {
        int matchRule = 128;
        String pattern = "clonenotsupportedex";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults("");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087h() throws CoreException {
        int matchRule = 128;
        String pattern = "CloneNotSupportedEx";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087i() throws CoreException {
        int matchRule = 128;
        String pattern = "cloneNotsupportedEx";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087j() throws CoreException {
        int matchRule = 128;
        String pattern = "ClonenotSupportedexc";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087k() throws CoreException {
        int matchRule = 128;
        String pattern = "cloneNotSupportedExcep";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087l() throws CoreException {
        int matchRule = 128;
        String pattern = "Clonenotsupportedexception";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137087m() throws CoreException {
        int matchRule = 128;
        String pattern = "CloneNotSupportedException";
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
        int validatedRule = SearchPattern.validateMatchRule((String)pattern, (int)matchRule);
        if (validatedRule != matchRule) {
            matchRule = 1;
        }
        this.search(pattern, 0, 0, matchRule);
        this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.CloneNotSupportedException EXACT_MATCH");
    }

    public void testBug137984_jar() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b137984.jar", "").getClassFile("CJ.class").getType();
        IField field = type.getField("c3");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("lib/b137984.jar CJ(int) EXACT_MATCH");
    }

    public void testBug137984_cu() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearchBugs", "src", "b137984", "C.js");
        IField field = unit.getType("C").getField("c3");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/b137984/C.java b137984.C(int) [c3] EXACT_MATCH");
    }

    public void testBug137984_wc() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/CW.js", "public class CW {\n\tCW2 c2;\n\tCW2.CW3 c3;\n\tCW(int c) {\n\t\tc2 = new CW2(c);\n\t\tc3 = c2.new CW3(c);\n\t}\n\tclass CW2 {\n\t\tCW2(int x) {}\n\t\tclass CW3 {\n\t\t\tCW3(int x) {}\n\t\t}\n\t}\n}\n");
        IField field = this.workingCopies[0].getType("CW").getField("c3");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/CW.java CW(int) [c3] EXACT_MATCH");
    }

    public void testBug140156() throws CoreException {
        IType type = this.getPackageFragment("JavaSearchBugs", "lib/b140156.jar", "").getClassFile("X.class").getType();
        IFunction method = type.getFunctions()[1];
        JavaSearchBugsTests.assertEquals((String)"Search wrong method!!!", (String)"foo", (String)method.getElementName());
        this.search((IJavaScriptElement)method, 0);
        this.assertSearchResults("lib/b140156.jar void X.foo(List<T>) [No source] EXACT_MATCH");
    }

    public void testBug144044() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/test1/p/Test.js", "package test1.p;\nimport test1.q.X;\npublic class Test {\n\tString foo(X val) {\n\t\treturn val.str;\n\t}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/test1/q/X.js", "package test1.q;\npublic class X {\n\tString str;\n}\n");
        IType type = this.workingCopies[1].getType("X");
        IField field = type.getField("str");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/test1/p/Test.java String test1.p.Test.foo(X) [str] POTENTIAL_MATCH");
    }

    public void testBug144044b() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[4];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/test2/p/Test.js", "package test2.p;\nimport test2.q.X;\npublic class Test {\n\tX foo() {\n\t\treturn X.y_field.z_field.x_field.y_field.z_field.x_field;\n\t}\n}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/test2/q/X.js", "package test2.q;\npublic class X {\n\tpublic static Y y_field;\n}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/test2/q/Y.js", "package test2.q;\npublic class Y {\n\tpublic static Z z_field;\n}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/test2/q/Z.js", "package test2.q;\npublic class Z {\n\tstatic X x_field;\n}\n");
        IType type = this.workingCopies[3].getType("Z");
        IField field = type.getField("x_field");
        this.search((IJavaScriptElement)field, 2);
        this.assertSearchResults("src/test2/p/Test.java X test2.p.Test.foo() [x_field] POTENTIAL_MATCH\nsrc/test2/p/Test.java X test2.p.Test.foo() [x_field] POTENTIAL_MATCH");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug148215_Types() throws CoreException {
        this.addLibraryEntry(JAVA_PROJECT, "/JavaSearchBugs/lib/b148215.jar", false);
        try {
            IType type = this.getClassFile("JavaSearchBugs", "lib/b148215.jar", "test.pack", "Test.class").getType();
            IFunction method = type.getFunctions()[1];
            this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)method, this.resultCollector);
            this.assertSearchResults(this.getExternalJCLPathString("1.5") + " java.lang.Object EXACT_MATCH\n" + this.getExternalJCLPathString("1.5") + " java.lang.String EXACT_MATCH\n" + "lib/b148215.jar test.def.Reference EXACT_MATCH");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug148215_Messages() throws CoreException {
        this.addLibraryEntry(JAVA_PROJECT, "/JavaSearchBugs/lib/b148215.jar", false);
        try {
            IType type = this.getClassFile("JavaSearchBugs", "lib/b148215.jar", "test.pack", "Test.class").getType();
            IFunction method = type.getFunctions()[1];
            this.searchDeclarationsOfSentMessages((IJavaScriptElement)method, this.resultCollector);
            this.assertSearchResults("lib/b148215.jar void test.pack.Test.bar(java.lang.String) EXACT_MATCH\nlib/b148215.jar void test.pack.Test.bar(test.def.Reference) EXACT_MATCH");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug148215_Fields() throws CoreException {
        this.addLibraryEntry(JAVA_PROJECT, "/JavaSearchBugs/lib/b148215.jar", false);
        try {
            IType type = this.getClassFile("JavaSearchBugs", "lib/b148215.jar", "test.pack", "Test.class").getType();
            IFunction method = type.getFunctions()[1];
            this.searchDeclarationsOfAccessedFields((IJavaScriptElement)method, this.resultCollector);
            this.assertSearchResults("lib/b148215.jar test.pack.Test.sField EXACT_MATCH\nlib/b148215.jar test.pack.Test.rField EXACT_MATCH");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.removeLibraryEntry(JAVA_PROJECT, new Path("/JavaSearchBugs/lib/b148215.jar"));
    }

    public void testBug148380_SearchAllTypes_wc() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[4];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b148380/I.js", "package b148380;\npublic interface I {}\n");
        this.workingCopies[1] = this.getWorkingCopy("/JavaSearchBugs/src/b148380/X.js", "package b148380;\npublic class X {}\n");
        this.workingCopies[2] = this.getWorkingCopy("/JavaSearchBugs/src/b148380/Sub.js", "package b148380;\npublic class Sub extends X {}\n");
        this.workingCopies[3] = this.getWorkingCopy("/JavaSearchBugs/src/b148380/Y.js", "package b148380;\npublic class Y {}\n");
        IJavaScriptSearchScope scope = this.getJavaSearchScopeBugs();
        AbstractJavaSearchTests.TypeNameMatchCollector requestor1 = new AbstractJavaSearchTests.TypeNameMatchCollector();
        new SearchEngine(this.workingCopies).searchAllTypeNames("b148380".toCharArray(), 0, null, 0, 0, scope, (TypeNameMatchRequestor)requestor1, 3, null);
        String expected = "class Sub [in [Working copy] Sub.java [in b148380 [in src [in JavaSearchBugs]]]]\nclass X [in [Working copy] X.java [in b148380 [in src [in JavaSearchBugs]]]]\nclass Y [in [Working copy] Y.java [in b148380 [in src [in JavaSearchBugs]]]]\ninterface I [in [Working copy] I.java [in b148380 [in src [in JavaSearchBugs]]]]";
        this.assertSearchResults(expected, (Object)requestor1);
        AbstractJavaSearchTests.TypeNameMatchCollector requestor2 = new AbstractJavaSearchTests.TypeNameMatchCollector();
        new SearchEngine(this.wcOwner).searchAllTypeNames("b148380".toCharArray(), 0, null, 0, 0, scope, (TypeNameMatchRequestor)requestor2, 3, null);
        this.assertSearchResults(expected, (Object)requestor2);
    }

    public void testBug148380_SearchAllTypes_cu() throws CoreException, JavaScriptModelException {
        IJavaScriptSearchScope scope = this.getJavaSearchScopeBugs();
        AbstractJavaSearchTests.TypeNameMatchCollector requestor = new AbstractJavaSearchTests.TypeNameMatchCollector();
        new SearchEngine().searchAllTypeNames(null, 0, "Bug".toCharArray(), 1, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
        this.assertSearchResults("Bug148380 (not open) [in Bug148380.class [in <default> [in lib [in JavaSearchBugs]]]]", (Object)requestor);
    }

    public void testBug148380_SearchAllTypes_cu_wksp() throws CoreException, JavaScriptModelException {
        IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
        AbstractJavaSearchTests.TypeNameMatchCollector requestor = new AbstractJavaSearchTests.TypeNameMatchCollector();
        new SearchEngine().searchAllTypeNames(null, 0, "Bug".toCharArray(), 1, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
        this.assertSearchResults("Bug148380 (not open) [in Bug148380.class [in <default> [in lib [in JavaSearchBugs]]]]", (Object)requestor);
    }

    public void testBug156340() throws CoreException {
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        IPackageFragment fragment = this.getPackageFragment("JavaSearchBugs", this.getExternalJCLPathString(), "java.lang");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{fragment});
        new SearchEngine().searchAllTypeNames(null, 0, CharOperation.NO_CHAR, 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "java.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable", (Object)requestor);
    }

    public void testBug156177() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/b156177/Test.js", "package b156177;\ninterface B156177_I {}\nenum B156177_E {}\n@interface B156177_A {}\npublic class B156177 {}\n");
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, null, 2, 11, this.getJavaSearchWorkingCopiesScope(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "b156177.B156177_A\nb156177.B156177_I", (Object)requestor);
    }

    public void testBug156491() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/pack/Test.js", "package pack;\npublic class Test {\n\tvoid noMatch(Y y) {\n\t\ty.toString();\n\t\ttoString();\n\t}\n\tvoid validMatches(X x) {\n\t\tx.toString();\n\t}\n\tvoid superInvocationMatches(Object o) {\n\t\to.toString();\n\t}\n\tvoid interfaceMatches(I i) {\n\t\ti.toString();\n\t}\n\tvoid subtypeMatches(Sub s) {\n\t\ts.toString();\n\t}\n}\ninterface I {}\nclass X {\n\tpublic String toString() {\n\t\treturn \"X\";\n\t}\n}\nclass Sub extends X {}\nclass Y {\n\tpublic String toString() {\n\t\treturn \"Y\";\n\t}\n}\n");
        IFunction method = this.workingCopies[0].getType("X").getFunction("toString", new String[0]);
        this.resultCollector.showFlavors = 512;
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/pack/Test.java void pack.Test.validMatches(X) [toString()] EXACT_MATCH\nsrc/pack/Test.java void pack.Test.superInvocationMatches(Object) [toString()] EXACT_MATCH SUPER INVOCATION\nsrc/pack/Test.java void pack.Test.subtypeMatches(Sub) [toString()] EXACT_MATCH");
    }

    private void setUpBug156491() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/other/Test.js", "package other;\npublic class Test {\n\tvoid testInterface(I i) {\n\t\ti.test();\n\t}\n\tvoid testSuperInvocation(L1 l) {\n\t\tl.test();\n\t}\n\tvoid testInvocation(L2 l) {\n\t\tl.test();\n\t}\n}\nclass L1 implements I {\n\tpublic void test() {}\n}\ninterface I {\n\tvoid test();\n}\nclass L2 extends L1 {\n\tpublic void test() {}\n}");
    }

    public void testBug156491a() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug156491();
        IFunction method = this.workingCopies[0].getType("L2").getFunction("test", new String[0]);
        this.resultCollector.showFlavors = 512;
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/other/Test.java void other.Test.testInterface(I) [test()] EXACT_MATCH SUPER INVOCATION\nsrc/other/Test.java void other.Test.testSuperInvocation(L1) [test()] EXACT_MATCH SUPER INVOCATION\nsrc/other/Test.java void other.Test.testInvocation(L2) [test()] EXACT_MATCH");
    }

    public void testBug156491b() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug156491();
        IFunction method = this.workingCopies[0].getType("L1").getFunction("test", new String[0]);
        this.resultCollector.showFlavors = 512;
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/other/Test.java void other.Test.testInterface(I) [test()] EXACT_MATCH SUPER INVOCATION\nsrc/other/Test.java void other.Test.testSuperInvocation(L1) [test()] EXACT_MATCH");
    }

    public void testBug160301() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Test.js", "public class Test {\n\tclass A {\n\t\tvoid foo() {}\n\t\tvoid bar() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass B extends A {\n\t\tvoid foo() {}\n\t\tvoid bar() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass C extends B {\n\t\tvoid method() {\n\t\t\tfoo();\n\t\t}\n\t}\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("A").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/Test.java void Test$A.bar() [foo()] EXACT_MATCH");
    }

    public void testBug160301b() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/test/Test.js", "package test;\npublic class Test {\n\tclass A {\n\t\tvoid foo() {}\n\t}\n\tclass B extends A {}\n\tclass C extends B {\n\t\tvoid foo() {}\n\t}\n\tclass D extends C {}\n\tvoid a() {\n\t\tnew A().foo();\n\t}\n\tvoid b() {\n\t\tnew B().foo();\n\t}\n\tvoid c() {\n\t\tnew C().foo();\n\t}\n\tvoid d() {\n\t\tnew D().foo();\n\t}\n\t\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("A").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/test/Test.java void test.Test.a() [foo()] EXACT_MATCH\nsrc/test/Test.java void test.Test.b() [foo()] EXACT_MATCH");
    }

    public void testBug160301_Interface() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Test.js", "public class Test {\n\tinterface I {\n\t\tvoid foo();\n\t}\n\tclass A1 implements I {\n\t\tpublic void foo() {}\n\t\tvoid a1() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass B1 extends A1 {\n\t\tvoid b1() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass C1 extends B1 {\n\t\tpublic void foo() {}\n\t\tvoid c1() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tabstract class A2 implements I {\n\t\tvoid a2() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass B2 extends A2 {\n\t\tpublic void foo() {}\n\t\tvoid b2() {\n\t\t\tfoo();\n\t\t}\n\t}\n\tclass A3 implements I {\n\t\tpublic void foo() {}\n\t\tvoid a3() {\n\t\t\tfoo();\n\t\t}\n\t}\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("I").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/Test.java void Test$A1.a1() [foo()] EXACT_MATCH\nsrc/Test.java void Test$B1.b1() [foo()] EXACT_MATCH\nsrc/Test.java void Test$A2.a2() [foo()] EXACT_MATCH\nsrc/Test.java void Test$B2.b2() [foo()] EXACT_MATCH\nsrc/Test.java void Test$A3.a3() [foo()] EXACT_MATCH");
    }

    public void testBug160301_Abstract() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Test.js", "public class Test {\n\tabstract class Abstract {\n\t\tabstract void foo();\n\t}\n\tclass A1 extends Abstract {\n\t\tpublic void foo() {}\n\t\tvoid a1() {\n\t\t\tfoo(); // valid match as A1.foo() is the first override in sub-class\n\t\t}\n\t}\n\tclass B1 extends A1 {\n\t\tvoid b1() {\n\t\t\tfoo(); // valid match as B1 does not override A.foo()\n\t\t}\n\t}\n\tclass C1 extends B1 {\n\t\tpublic void foo() {}\n\t\tvoid c1() {\n\t\t\tfoo(); // invalid match as C1 does override A.foo()\n\t\t}\n\t}\n\tabstract class A2 extends Abstract {\n\t\tvoid a2() {\n\t\t\tfoo(); // valid match as A2 does not override Abstract.foo()\n\t\t}\n\t}\n\tclass B2 extends A2 {\n\t\tpublic void foo() {}\n\t\tvoid b2() {\n\t\t\tfoo(); // valid match as B2.foo() is the first override in sub-class\n\t\t}\n\t}\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("Abstract").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/Test.java void Test$A1.a1() [foo()] EXACT_MATCH\nsrc/Test.java void Test$B1.b1() [foo()] EXACT_MATCH\nsrc/Test.java void Test$A2.a2() [foo()] EXACT_MATCH\nsrc/Test.java void Test$B2.b2() [foo()] EXACT_MATCH");
    }

    public void testBug160301_Abstract2() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Test.js", "public class Test {\n\tabstract class Abstract {\n\t\tpublic abstract void foo();\n\t}\n\tabstract class A extends Abstract {\n\t\tpublic abstract void foo();\n\t\tvoid a() {\n\t\t\tfoo(); // valid match as A is abstract => does not override Abstract.foo()\n\t\t}\n\t}\n\tclass B extends A {\n\t\tpublic void foo() {}\n\t\tvoid b() {\n\t\t\tfoo(); // valid match as B.foo() is the first override in sub-class\n\t\t}\n\t}\n\tclass C extends B {\n\t\tpublic void foo() {}\n\t\tvoid c() {\n\t\t\tfoo(); // invalid match as C.foo() overrides Abstract.foo() \n\t\t}\n\t}\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("Abstract").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/Test.java void Test$A.a() [foo()] EXACT_MATCH\nsrc/Test.java void Test$B.b() [foo()] EXACT_MATCH");
    }

    public void testBug160301_Abstract3() throws CoreException {
        this.resultCollector.showRule = true;
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/Test.js", "public class Test {\n\tabstract class Abstract {\n\t\tpublic abstract void foo();\n\t}\n\tclass A extends Abstract {\n\t\tpublic void foo() {}\n\t\tvoid a() {\n\t\t\tfoo(); // valid match as A.foo() is the first override in sub-class\n\t\t}\n\t}\n\tabstract class B extends A {\n\t\tpublic abstract void foo();\n\t\tvoid b() {\n\t\t\tfoo(); // invalid match as B.foo() is hidden by the override A.foo()\n\t\t}\n\t}\n\tclass C extends B {\n\t\tpublic void foo() {}\n\t\tvoid c() {\n\t\t\tfoo(); // invalid match as C.foo() overrides A.foo()\n\t\t}\n\t}\n}");
        IFunction method = this.workingCopies[0].getType("Test").getType("Abstract").getFunction("foo", new String[0]);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/Test.java void Test$A.a() [foo()] EXACT_MATCH");
    }

    public void testBug160323() throws CoreException {
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames(null, 0, null, 1, 0, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, null, 1, 0, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        JavaSearchBugsTests.assertTrue((String)"We should get some types!", (collector.size() > 0 ? 1 : 0) != 0);
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug160324a() throws CoreException {
        boolean debug = false;
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames(null, null, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, null, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        if (debug) {
            System.out.println("TypeNameRequestor results: \n" + (Object)((Object)requestor));
        }
        JavaSearchBugsTests.assertTrue((String)"We should get some types!", (collector.size() > 0 ? 1 : 0) != 0);
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug160324b() throws CoreException {
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames(null, (char[][])new char[][]{"Test".toCharArray()}, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, (char[][])new char[][]{"Test".toCharArray()}, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        JavaSearchBugsTests.assertTrue((String)"We should get some types!", (collector.size() > 0 ? 1 : 0) != 0);
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug160324c() throws CoreException {
        boolean debug = false;
        char[][] packagesList = new char[][]{CharOperation.NO_CHAR, "b110422".toCharArray(), "b123679.test".toCharArray(), "b89848".toCharArray(), "b95794".toCharArray(), "pack".toCharArray(), "pack.age".toCharArray()};
        char[][] typesList = new char[][]{"Test".toCharArray(), "TestPrefix".toCharArray()};
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames((char[][])packagesList, (char[][])typesList, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        if (debug) {
            System.out.println("TypeNameMatchRequestor results: \n" + (Object)((Object)collector));
        }
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames((char[][])packagesList, (char[][])typesList, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        if (debug) {
            System.out.println("TypeNameRequestor results: \n" + (Object)((Object)requestor));
        }
        JavaSearchBugsTests.assertEquals((String)"Wrong number of found types!", (int)packagesList.length, (int)collector.size());
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug160854() throws CoreException {
        char[][] packagesList = new char[][]{"java.lang".toCharArray()};
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames((char[][])packagesList, null, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames((char[][])packagesList, null, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Wrong types found!", "java.lang.CharSequence\njava.lang.Class\njava.lang.CloneNotSupportedException\njava.lang.Comparable\njava.lang.Enum\njava.lang.Error\njava.lang.Exception\njava.lang.IllegalMonitorStateException\njava.lang.InterruptedException\njava.lang.Object\njava.lang.RuntimeException\njava.lang.String\njava.lang.Throwable", (Object)requestor);
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug161028() throws CoreException {
        TypeNameMatch match1 = SearchEngine.createTypeNameMatch(null, (int)0);
        JavaSearchBugsTests.assertEquals((String)"Should be equals!", (Object)match1, (Object)match1);
        JavaSearchBugsTests.assertEquals((String)"Wrong toString value!", (String)"org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch@0", (String)match1.toString());
        TypeNameMatch match2 = SearchEngine.createTypeNameMatch(null, (int)0);
        JavaSearchBugsTests.assertFalse((String)"Should NOT be identical!", (match1 == match2 ? 1 : 0) != 0);
        JavaSearchBugsTests.assertTrue((String)"Should be equals!", (boolean)match1.equals(match2));
        JavaSearchBugsTests.assertTrue((String)"Should be equals!", (boolean)match2.equals(match1));
        JavaSearchBugsTests.assertEquals((String)"Wrong toString value!", (Object)match1, (Object)match2);
        JavaSearchBugsTests.assertEquals((String)"Should have same hashCode!", (int)match1.hashCode(), (int)match2.hashCode());
    }

    public void testBug161190() throws CoreException {
        char[][] packagesList = new char[][]{"xy".toCharArray()};
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        new SearchEngine().searchAllTypeNames((char[][])packagesList, null, this.getJavaSearchScopeBugs(), (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames((char[][])packagesList, null, this.getJavaSearchScopeBugs(), (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Wrong types found!", "xy.BE_124645\nxy.BX_124645\nxy.BY_124645", (Object)requestor);
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    public void testBug163984() throws CoreException {
        AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

            public String toString() {
                return this.toFullyQualifiedNamesString();
            }
        };
        IJavaScriptUnit[] elements = this.getCompilationUnits("JavaSearchBugs", "src", "b163984");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])elements);
        new SearchEngine().searchAllTypeNames(null, 0, new char[]{'*'}, 2, 0, scope, (TypeNameMatchRequestor)collector, 3, null);
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine().searchAllTypeNames(null, 0, new char[]{'*'}, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        JavaSearchBugsTests.assertEquals((String)"We should get 3 types!", (int)3, (int)collector.size());
        JavaSearchBugsTests.assertEquals((String)"Found types sounds not to be correct", (String)((Object)((Object)requestor)).toString(), (String)collector.toString());
    }

    private void setUpBug164121() throws CoreException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/JavaSearchBugs/src/A.js", "class A {\n     int x(int param) {\n         param = 2 + 2;\n         int x = param + 2;\n         return param - x;\n     }\n}\n");
    }

    public void testBug164121a() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug164121();
        ILocalVariable param = this.getLocalVariable((ISourceReference)this.workingCopies[0], "param", "param");
        this.search((IJavaScriptElement)param, 0);
        this.assertSearchResults("src/A.java int A.x(int).param [param] EXACT_MATCH");
    }

    public void testBug164121b() throws CoreException {
        this.resultCollector.showRule = true;
        this.setUpBug164121();
        ILocalVariable param = this.getLocalVariable((ISourceReference)this.workingCopies[0], "param", "param");
        this.search((IJavaScriptElement)param, 3);
        this.assertSearchResults("src/A.java int A.x(int).param [param] EXACT_MATCH\nsrc/A.java int A.x(int) [param] EXACT_MATCH\nsrc/A.java int A.x(int) [param] EXACT_MATCH\nsrc/A.java int A.x(int) [param] EXACT_MATCH");
    }

    public void testBug164791() throws CoreException {
        IType type = this.getClassFile("JavaSearchBugs", "lib/b164791.jar", "pack", "ELPM.class").getType();
        AbstractJavaSearchTests.JavaSearchResultCollector collector = new AbstractJavaSearchTests.JavaSearchResultCollector(){

            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                super.acceptSearchMatch(searchMatch);
                IJavaScriptElement element = (IJavaScriptElement)searchMatch.getElement();
                JavaSearchBugsTests.assertTrue((String)("Search match element " + element.getElementName() + " should exist!!!"), (boolean)element.exists());
            }
        };
        collector.showAccuracy = true;
        this.search((IJavaScriptElement)type, 2, this.getJavaSearchScopeBugs(), collector);
        this.assertSearchResults("lib/b164791.jar test.<anonymous> EXACT_MATCH\nlib/b164791.jar test.<anonymous> EXACT_MATCH", collector);
    }

    public void testBug166348() throws CoreException {
        this.search("Test166348", 0, 0);
        this.assertSearchResults("lib/b166348.jar pack.Test166348 [No source] EXACT_MATCH\nlib/b166348.jar test.Test166348 [No source] EXACT_MATCH");
    }

    public void testBug166348_Qualified() throws CoreException {
        this.search("test.Test166348", 0, 0);
        this.assertSearchResults("lib/b166348.jar test.Test166348 [No source] EXACT_MATCH");
    }

    public void testBug167190() throws CoreException, JavaScriptModelException {
        AbstractSearchScope scope = new AbstractSearchScope(){
            IJavaScriptSearchScope jsScope;
            {
                this.jsScope = JavaSearchBugsTests.this.getJavaSearchScopeBugs();
            }

            public void processDelta(IJavaScriptElementDelta delta) {
            }

            public boolean encloses(String resourcePath) {
                return this.jsScope.encloses(resourcePath);
            }

            public boolean encloses(IJavaScriptElement element) {
                return this.jsScope.encloses(element);
            }

            public IPath[] enclosingProjectsAndJars() {
                return this.jsScope.enclosingProjectsAndJars();
            }
        };
        AbstractJavaSearchTests.TypeNameMatchCollector requestor = new AbstractJavaSearchTests.TypeNameMatchCollector();
        new SearchEngine().searchAllTypeNames(null, 0, "C".toCharArray(), 1, 0, (IJavaScriptSearchScope)scope, (TypeNameMatchRequestor)requestor, 3, null);
        this.assertSearchResults("C (not open) [in C.class [in test [in lib/b124469.jar [in JavaSearchBugs]]]]\nC (not open) [in C.java [in b137984 [in src [in JavaSearchBugs]]]]\nC (not open) [in C.java [in b137984 [in src [in JavaSearchBugs]]]]\nC (not open) [in C.java [in b163984 [in src [in JavaSearchBugs]]]]\nC2 (not open) [in C [in C.java [in b137984 [in src [in JavaSearchBugs]]]]]\nC86293 (not open) [in C86293.class [in <default> [in lib/b86293.jar [in JavaSearchBugs]]]]\nCJ (not open) [in CJ.class [in <default> [in lib/b137984.jar [in JavaSearchBugs]]]]\nCJ2 (not open) [in CJ$CJ2.class [in <default> [in lib/b137984.jar [in JavaSearchBugs]]]]\nCJ3 (not open) [in CJ$CJ2$CJ3.class [in <default> [in lib/b137984.jar [in JavaSearchBugs]]]]\nC_124645 (not open) [in T_124645.java [in b124645 [in src [in JavaSearchBugs]]]]\nCharSequence (not open) [in CharSequence.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Class (not open) [in Class.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "CloneNotSupportedException (not open) [in CloneNotSupportedException.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Collection (not open) [in Collection.class [in b87627 [in lib/b87627.jar [in JavaSearchBugs]]]]\n" + "Comparable (not open) [in Comparable.class [in java.lang [in " + this.getExternalJCLPathString("1.5") + "]]]\n" + "Test (not open) [in Test.java [in b95794 [in src [in JavaSearchBugs]]]]", (Object)requestor);
    }

    class TestCollector
    extends AbstractJavaSearchTests.JavaSearchResultCollector {
        public List matches = new ArrayList();

        TestCollector() {
        }

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            super.acceptSearchMatch(searchMatch);
            this.matches.add(searchMatch);
        }
    }

    class TypeReferencesCollector
    extends AbstractJavaSearchTests.JavaSearchResultCollector {
        TypeReferencesCollector() {
        }

        protected IJavaScriptElement getElement(SearchMatch searchMatch) {
            IJavaScriptElement element = super.getElement(searchMatch);
            IJavaScriptElement localElement = null;
            TypeReferenceMatch typeRefMatch = (TypeReferenceMatch)this.match;
            localElement = typeRefMatch.getLocalElement();
            if (localElement != null) {
                return localElement;
            }
            return element;
        }

        protected void writeLine() throws CoreException {
            int length;
            super.writeLine();
            TypeReferenceMatch typeRefMatch = (TypeReferenceMatch)this.match;
            IJavaScriptElement[] others = typeRefMatch.getOtherElements();
            int n = length = others == null ? 0 : others.length;
            if (length > 0) {
                this.line.append("+[");
                int i = 0;
                while (i < length) {
                    IJavaScriptElement other = others[i];
                    if (i > 0) {
                        this.line.append(',');
                    }
                    this.line.append(other.getElementName());
                    ++i;
                }
                this.line.append(']');
            }
        }
    }
}

