/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddLibraryFileToIndex
extends IndexRequest {
    IPath absolutePath;

    public AddLibraryFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.absolutePath = resource.getLocation();
    }

    public AddLibraryFileToIndex(IPath jarPath, IndexManager manager) {
        super(jarPath, manager);
    }

    public boolean equals(Object o) {
        if (o instanceof AddLibraryFileToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddLibraryFileToIndex)o).containerPath);
        }
        return false;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            try {
                SearchParticipant participant;
                long initialTime;
                Path libraryFilePath;
                block20: {
                    block19: {
                        block18: {
                            libraryFilePath = null;
                            monitor.enterWrite();
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                            }
                            libraryFilePath = (Path)this.containerPath;
                            if (!this.isCancelled) break block18;
                            if (JobManager.VERBOSE) {
                                Util.verbose("-> indexing of " + libraryFilePath.toString() + " has been cancelled");
                            }
                            break block19;
                        }
                        if (JobManager.VERBOSE) {
                            Util.verbose("-> indexing " + libraryFilePath.toString());
                        }
                        initialTime = System.currentTimeMillis();
                        participant = SearchEngine.getDefaultSearchParticipant();
                        index = this.manager.recreateIndex(this.containerPath);
                        if (index != null) break block20;
                        this.manager.removeIndex(this.containerPath);
                    }
                    Object var13_6 = null;
                    monitor.exitWrite();
                    return false;
                }
                IPath filePath = this.absolutePath != null ? this.absolutePath : this.containerPath;
                File file = new File(filePath.toOSString());
                char[] classFileChars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(file, null);
                String packageName = libraryFilePath.lastSegment();
                JavaSearchDocument entryDocument = new JavaSearchDocument((IPath)libraryFilePath, classFileChars, participant, packageName);
                this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
                this.manager.saveIndex(index);
                if (JobManager.VERBOSE) {
                    Util.verbose("-> done indexing of " + libraryFilePath.toString() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                }
                Object var13_8 = null;
                monitor.exitWrite();
                return true;
            }
            catch (Throwable throwable) {
                Object var13_7 = null;
                monitor.exitWrite();
                throw throwable;
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

