/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.core.internal.model.XPath.DataTypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataTypes implements Enumerator
{
    NODESET(0, "nodeset", "nodeset"),
    BOOLEAN(1, "boolean", "boolean"),
    STRING(2, "string", "string"),
    NUMBER(3, "number", "number");

    public static final String copyright = " Copyright (c) 2008 Standards for Technology in Automotive Retail and others.\n All rights reserved. This program and the accompanying materials\n are made available under the terms of the Eclipse Public License v1.0\n which accompanies this distribution, and is available at\n http://www.eclipse.org/legal/epl-v10.html\n\n Contributors:\n     David Carver - initial API and implementation";
    public static final int NODESET_VALUE = 0;
    public static final int BOOLEAN_VALUE = 1;
    public static final int STRING_VALUE = 2;
    public static final int NUMBER_VALUE = 3;
    private static final DataTypes[] VALUES_ARRAY;
    public static final List<DataTypes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataTypes[]{NODESET, BOOLEAN, STRING, NUMBER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataTypes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataTypes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataTypes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataTypes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataTypes get(int value) {
        switch (value) {
            case 0: {
                return NODESET;
            }
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return NUMBER;
            }
        }
        return null;
    }

    private DataTypes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

