/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.actions.ActionMessages;

public class MultipleInputDialog
extends Dialog {
    protected static final String FIELD_NAME = "FIELD_NAME";
    protected static final int TEXT = 100;
    protected static final int BROWSE = 101;
    protected static final int VARIABLE = 102;
    protected static final int COMBO = 103;
    protected Composite panel;
    protected List<FieldSummary> fieldList = new ArrayList<FieldSummary>();
    protected List<Scrollable> controlList = new ArrayList<Scrollable>();
    protected List<Validator> validators = new ArrayList<Validator>();
    protected Map<Object, Comparable> valueMap = new HashMap<Object, Comparable>();
    private final String title;

    public MultipleInputDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.validateFields();
        return bar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        this.panel.setLayout((Layout)layout);
        this.panel.setLayoutData((Object)new GridData(768));
        for (FieldSummary field : this.fieldList) {
            switch (field.type) {
                case 100: {
                    this.createTextField(field.name, field.initialValue, field.allowsEmpty);
                    break;
                }
                case 102: {
                    this.createVariablesField(field.name, field.initialValue, field.allowsEmpty);
                    break;
                }
                case 103: {
                    this.createComboField(field.name, field.initialIndex, field.items);
                }
            }
        }
        this.fieldList = null;
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public void addBrowseField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(101, labelText, initialValue, allowsEmpty));
    }

    public void addTextField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(100, labelText, initialValue, allowsEmpty));
    }

    public void addVariablesField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(102, labelText, initialValue, allowsEmpty));
    }

    public void addComboField(String labelText, int initialIndex, String[] items) {
        this.fieldList.add(new FieldSummary(103, labelText, items, initialIndex));
    }

    protected void createTextField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        final Text text = new Text(this.panel, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add((Scrollable)text);
    }

    protected void createVariablesField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Text text = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        Button button = this.createButton(comp, 9, ActionMessages.VariablesFieldButton_Text, false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String variable;
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(MultipleInputDialog.this.getShell());
                int code = dialog.open();
                if (code == 0 && (variable = dialog.getVariableExpression()) != null) {
                    text.insert(variable);
                }
            }
        });
        this.controlList.add((Scrollable)text);
    }

    protected void createComboField(String labelText, int initialValue, String[] items) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Combo combo = new Combo(comp, 2060);
        combo.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, combo.getSize().y);
        combo.setItems(items);
        combo.select(initialValue);
        this.controlList.add((Scrollable)combo);
    }

    protected void okPressed() {
        for (Control control : this.controlList) {
            if (control instanceof Text) {
                this.valueMap.put(control.getData(FIELD_NAME), (Comparable)((Object)((Text)control).getText()));
                continue;
            }
            if (!(control instanceof Combo)) continue;
            Combo combo = (Combo)control;
            this.valueMap.put(control.getData(FIELD_NAME), new Integer(combo.getSelectionIndex()));
        }
        this.controlList = null;
        super.okPressed();
    }

    public int open() {
        MultipleInputDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    protected Object getValue(String key) {
        return this.valueMap.get(key);
    }

    protected String getStringValue(String key) {
        return (String)this.getValue(key);
    }

    protected int getIntValue(String key) {
        return (Integer)this.getValue(key);
    }

    protected void validateFields() {
        for (Validator validator : this.validators) {
            if (validator.validate()) continue;
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.wst.xsl.debug.ui.MULTIPLE_INPUT_DIALOG";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = XSLDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected class FieldSummary {
        int initialIndex;
        int type;
        String name;
        String initialValue;
        boolean allowsEmpty;
        String[] items;

        public FieldSummary(int type, String name, String initialValue, boolean allowsEmpty) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
        }

        public FieldSummary(int type, String name, String[] items, int initialIndex) {
            this.type = type;
            this.name = name;
            this.items = items;
        }
    }

    protected class Validator {
        protected Validator() {
        }

        boolean validate() {
            return true;
        }
    }
}

