/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.InstalledProcessorsBlock;
import org.eclipse.wst.xsl.internal.debug.ui.preferences.Messages;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class ProcessorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledProcessorsBlock processorsBlock;

    public ProcessorsPreferencePage() {
        this.setTitle(Messages.getString("ProcessorsPreferencePage.0"));
        this.setDescription(Messages.getString("ProcessorsPreferencePage.1"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        this.processorsBlock = new InstalledProcessorsBlock();
        this.processorsBlock.createControl(ancestor);
        Control control = this.processorsBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.initDefaultInstall();
        this.processorsBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IProcessorInstall install = ProcessorsPreferencePage.this.getCurrentDefaultProcessor();
                if (install == null) {
                    ProcessorsPreferencePage.this.setValid(false);
                    ProcessorsPreferencePage.this.setErrorMessage(Messages.getString("ProcessorsPreferencePage.2"));
                } else {
                    ProcessorsPreferencePage.this.setValid(true);
                    ProcessorsPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    public boolean performOk() {
        this.processorsBlock.saveColumnSettings();
        final boolean[] ok = new boolean[1];
        try {
            final IProcessorInstall[] installs = this.processorsBlock.getProcessors();
            final IProcessorInstall defaultProcessor = this.getCurrentDefaultProcessor();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        XSLTRuntime.saveProcessorPreferences((IProcessorInstall[])installs, (IProcessorInstall)defaultProcessor, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        XSLDebugUIPlugin.log(e);
                    }
                    ok[0] = !monitor.isCanceled();
                }
            };
            XSLDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            XSLDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            XSLDebugUIPlugin.log(e);
        }
        return ok[0];
    }

    private void initDefaultInstall() {
        IProcessorInstall realDefault = XSLTRuntime.getDefaultProcessor();
        if (realDefault != null) {
            IProcessorInstall[] installs;
            IProcessorInstall[] iProcessorInstallArray = installs = this.processorsBlock.getProcessors();
            int n = installs.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessorInstall fakeInstall = iProcessorInstallArray[n2];
                if (fakeInstall.getId().equals(realDefault.getId())) {
                    this.verifyDefaultVM(fakeInstall);
                    break;
                }
                ++n2;
            }
        }
    }

    private void verifyDefaultVM(IProcessorInstall install) {
        if (install != null) {
            this.processorsBlock.setCheckedInstall(install);
        } else {
            this.processorsBlock.setCheckedInstall(null);
        }
    }

    private IProcessorInstall getCurrentDefaultProcessor() {
        return this.processorsBlock.getCheckedInstall();
    }
}

