/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.resolver;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.tabs.processor.ProcessorMessages;

public class URIResolverBlock
extends ResourceSelectionBlock {
    private Button stylesheetRelativeRadio;
    private Button otherRadio;
    private Button workingDirRelativeRadio;

    public URIResolverBlock() {
        super(2, true, true, true);
    }

    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return ProcessorMessages.URIResolverBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return ProcessorMessages.URIResolverBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return ProcessorMessages.URIResolverBlock_DEFAULT_RADIO;
            }
            case 5: {
                return ProcessorMessages.URIResolverBlock_OTHER_RADIO;
            }
            case 6: {
                return ProcessorMessages.URIResolverBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return ProcessorMessages.URIResolverBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return ProcessorMessages.URIResolverBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return ProcessorMessages.URIResolverBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return ProcessorMessages.URIResolverBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return ProcessorMessages.URIResolverBlock_WORKSPACE_DIALOG_TITLE;
            }
        }
        return "" + type;
    }

    protected void setDefaultResource() {
    }

    public String getName() {
        return ProcessorMessages.URIResolverBlock_3;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
    }

    protected void createCheckboxAndText(Composite parent) {
        this.useDefaultCheckButton = this.createCheckButton(parent, this.getMessage(4));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.useDefaultCheckButton.setLayoutData((Object)gd);
        this.useDefaultCheckButton.addSelectionListener((SelectionListener)this.widgetListener);
        Composite specificFileComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        layout.marginHeight = 0;
        specificFileComp.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        specificFileComp.setLayoutData((Object)gd);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                URIResolverBlock.this.updateEnablement(URIResolverBlock.this.useDefaultCheckButton.getSelection());
            }
        };
        this.workingDirRelativeRadio = this.createRadioButton(specificFileComp, ProcessorMessages.URIResolverBlock_5);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.workingDirRelativeRadio.setLayoutData((Object)gd);
        this.workingDirRelativeRadio.addSelectionListener(listener);
        this.stylesheetRelativeRadio = this.createRadioButton(specificFileComp, ProcessorMessages.URIResolverBlock_6);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.stylesheetRelativeRadio.setLayoutData((Object)gd);
        this.stylesheetRelativeRadio.addSelectionListener(listener);
        this.otherRadio = this.createRadioButton(specificFileComp, ProcessorMessages.URIResolverBlock_8);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.otherRadio.setLayoutData((Object)gd);
        this.otherRadio.addSelectionListener(listener);
        this.resourceText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setFont(parent.getFont());
        this.resourceText.addModifyListener((ModifyListener)this.widgetListener);
    }

    protected void updateResourceText(boolean useDefault) {
        if (useDefault) {
            this.resourceText.setText(this.defaultOutputFile == null ? "" : this.defaultOutputFile);
        } else {
            this.resourceText.setText(this.outputFile == null ? "" : this.outputFile);
        }
        this.updateEnablement(useDefault);
    }

    protected void updateEnablement(boolean useDefault) {
        this.otherRadio.setEnabled(!useDefault);
        this.stylesheetRelativeRadio.setEnabled(!useDefault);
        this.workingDirRelativeRadio.setEnabled(!useDefault);
        boolean otherEnabled = !useDefault && this.otherRadio.getSelection();
        this.resourceText.setEnabled(otherEnabled);
        this.fFileSystemButton.setEnabled(otherEnabled);
        this.fVariablesButton.setEnabled(otherEnabled);
        this.fWorkspaceButton.setEnabled(otherEnabled);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.wst.xsl.launching.ATTR_BASE_URI_DIRECTORY", null);
    }
}

