/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.debugger;

public abstract class Variable {
    private static int idSequence = 0;
    public static final String LOCAL_SCOPE = "L";
    public static final String TUNNEL_SCOPE = "T";
    public static final String GLOBAL_SCOPE = "G";
    protected static final int MAXIMUM_VALUE_SIZE = 100;
    protected static final String UNRESOLVED = "unresolved";
    protected static final String BOOLEAN = "boolean";
    protected static final String NUMBER = "number";
    protected static final String STRING = "string";
    protected static final String NODESET = "nodeset";
    protected static final String OBJECT = "object";
    protected static final String UNKNOWN = "unknown";
    protected final String name;
    protected final String scope;
    protected final int slotNumber;
    private int id;

    public Variable(String name, String scope, int slotNumber) {
        this.name = name;
        this.scope = scope;
        this.slotNumber = slotNumber;
        this.id = idSequence++;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getType();

    public String getScope() {
        return this.scope;
    }

    public abstract String getValue();

    public String getValueFirstLine() {
        String value = this.getValue();
        if (value != null) {
            if ((value = value.replace('\n', '.')).length() > 100) {
                value = value.substring(0, 100);
            }
        } else {
            value = "";
        }
        return value;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int hashCode() {
        return 3 * this.scope.hashCode() + 5 * this.slotNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Variable) {
            Variable v = (Variable)obj;
            return v.scope.equals(this.scope) && this.slotNumber == v.slotNumber;
        }
        return false;
    }
}

