/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xsl.internal.launching.Feature;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.Messages;
import org.eclipse.wst.xsl.internal.launching.OutputProperty;
import org.eclipse.wst.xsl.launching.IFeature;
import org.eclipse.wst.xsl.launching.IOutputProperty;
import org.eclipse.wst.xsl.launching.IProcessorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorType
implements IProcessorType {
    private static final String DESC_SUFFIX = ".DESC";
    private static final String TYPE_SUFFIX = ".TYPE";
    private final String id;
    private final String name;
    private final String transFactoryName;
    private final URL featurePropertiesURL;
    private final URL outputPropertiesURL;
    private IFeature[] features;
    private IOutputProperty[] outputProperties;
    private Properties outputPropertyValues;
    private Map<String, String> featureValues;

    public ProcessorType(String id, String name, URL featurePropertiesURL, URL outputPropertiesURL, Map<String, String> featureValues, Properties outputPropertyValues, String transFactoryName) {
        this.id = id;
        this.name = name;
        this.featurePropertiesURL = featurePropertiesURL;
        this.outputPropertiesURL = outputPropertiesURL;
        this.featureValues = featureValues;
        this.transFactoryName = transFactoryName;
        this.outputPropertyValues = outputPropertyValues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public Map<String, String> getFeatureValues() {
        return this.featureValues;
    }

    @Override
    public IFeature[] getFeatures() {
        if (this.features == null) {
            this.features = this.featurePropertiesURL != null ? this.loadFeatures() : new IFeature[0];
        }
        return this.features;
    }

    @Override
    public Properties getOutputPropertyValues() {
        return this.outputPropertyValues;
    }

    @Override
    public boolean isJREDefault() {
        return "org.eclipse.wst.xsl.launching.processorType.jreDefault".equals(this.id);
    }

    @Override
    public String getTransformerFactoryName() {
        return this.transFactoryName;
    }

    @Override
    public IOutputProperty[] getOutputProperties() {
        if (this.outputProperties == null) {
            this.outputProperties = this.outputPropertiesURL != null ? this.loadOutputProperties() : new IOutputProperty[0];
        }
        return this.outputProperties;
    }

    private IOutputProperty[] loadOutputProperties() {
        ArrayList<OutputProperty> outputs;
        block16: {
            BufferedInputStream is = null;
            outputs = new ArrayList<OutputProperty>();
            Properties props = new Properties();
            try {
                try {
                    is = new BufferedInputStream(this.outputPropertiesURL.openStream());
                    props.load(is);
                    for (Object element : props.keySet()) {
                        String key = (String)element;
                        if (key.endsWith(DESC_SUFFIX)) continue;
                        String name = key;
                        String uri = props.getProperty(key);
                        String desc = props.getProperty(String.valueOf(key) + DESC_SUFFIX);
                        if (uri != null && name != null && desc != null) {
                            OutputProperty prop = new OutputProperty(uri.trim(), desc);
                            outputs.add(prop);
                            continue;
                        }
                        LaunchingPlugin.log(new CoreException((IStatus)new Status(2, "org.eclipse.wst.xsl.launching", String.valueOf(Messages.getString("ProcessorType.2")) + this.outputPropertiesURL + Messages.getString("ProcessorType.3") + key)));
                    }
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            LaunchingPlugin.log(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
        return outputs.toArray(new IOutputProperty[0]);
    }

    private IFeature[] loadFeatures() {
        ArrayList<Feature> featuresList;
        block16: {
            BufferedInputStream is = null;
            featuresList = new ArrayList<Feature>();
            try {
                try {
                    is = new BufferedInputStream(this.featurePropertiesURL.openStream());
                    Properties props = new Properties();
                    props.load(is);
                    for (Object element : props.keySet()) {
                        String key = (String)element;
                        if (key.endsWith(DESC_SUFFIX) || key.endsWith(TYPE_SUFFIX)) continue;
                        String uri = props.getProperty(key);
                        String type = props.getProperty(String.valueOf(key) + TYPE_SUFFIX);
                        String desc = props.getProperty(String.valueOf(key) + DESC_SUFFIX);
                        if (uri != null && type != null && desc != null) {
                            Feature feature = new Feature(uri.trim(), type.trim(), desc);
                            featuresList.add(feature);
                            continue;
                        }
                        LaunchingPlugin.log(new CoreException((IStatus)new Status(2, "org.eclipse.wst.xsl.launching", String.valueOf(Messages.getString("ProcessorType.4")) + this.featurePropertiesURL + Messages.getString("ProcessorType.5") + key)));
                    }
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            LaunchingPlugin.log(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LaunchingPlugin.log(e);
                }
            }
        }
        Object[] features = featuresList.toArray(new IFeature[0]);
        Arrays.sort(features);
        return features;
    }
}

