/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.launching.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xsl.internal.launching.DebuggerDescriptor;
import org.eclipse.wst.xsl.internal.launching.registry.AbstractRegistryReader;
import org.eclipse.wst.xsl.internal.launching.registry.DebuggerRegistry;

public class DebuggerRegistryReader
extends AbstractRegistryReader {
    public static final String TAG_DEBUGGER = "debugger";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASSNAME = "className";
    public static final String ATT_CLASSPATH = "classpath";
    public static final String ATT_NAME = "name";
    public static final String ATT_PROCESSOR_TYPE_ID = "processorTypeId";
    private DebuggerRegistry registry;

    protected boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(TAG_DEBUGGER)) {
            return false;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            DebuggerRegistryReader.logMissingAttribute(element, ATT_ID);
            return true;
        }
        String className = element.getAttribute(ATT_CLASSNAME);
        if (className == null) {
            DebuggerRegistryReader.logMissingAttribute(element, ATT_CLASSNAME);
            return true;
        }
        String classpath = element.getAttribute(ATT_CLASSPATH);
        if (classpath == null) {
            DebuggerRegistryReader.logMissingAttribute(element, ATT_CLASSPATH);
            return true;
        }
        String[] entries = classpath.split(";");
        int i = 0;
        while (i < entries.length) {
            String string = entries[i];
            entries[i] = string.trim();
            ++i;
        }
        String name = element.getAttribute(ATT_NAME);
        if (name == null) {
            DebuggerRegistryReader.logMissingAttribute(element, ATT_NAME);
            return true;
        }
        String processorTypeId = element.getAttribute(ATT_PROCESSOR_TYPE_ID);
        if (processorTypeId == null) {
            DebuggerRegistryReader.logMissingAttribute(element, ATT_PROCESSOR_TYPE_ID);
            return true;
        }
        this.registry.addDebugger(new DebuggerDescriptor(id, element.getContributor().getName(), className, entries, name, processorTypeId));
        return true;
    }

    public void readElement(DebuggerRegistry registry, IConfigurationElement element) {
        this.registry = registry;
        this.readElement(element);
    }

    public void addConfigs(DebuggerRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.registry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.wst.xsl.launching", TAG_DEBUGGER);
    }
}

