/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xsl.internal.launching.LaunchingPlugin;
import org.eclipse.wst.xsl.internal.launching.PluginProcessorJar;
import org.eclipse.wst.xsl.internal.launching.Utils;
import org.eclipse.wst.xsl.launching.IDebugger;
import org.eclipse.wst.xsl.launching.IProcessorInstall;
import org.eclipse.wst.xsl.launching.IProcessorJar;
import org.eclipse.wst.xsl.launching.IProcessorType;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class ProcessorInstall
implements IProcessorInstall {
    private final String id;
    private String name;
    private String type;
    private IProcessorJar[] jars;
    private final boolean contributed;
    private String debuggerId;
    private String supports;

    public ProcessorInstall(String id, String label, String typeId, IProcessorJar[] jars, String debuggerId, String supports, boolean contributed) {
        this.id = id;
        this.name = label;
        this.type = typeId;
        this.debuggerId = debuggerId;
        this.contributed = contributed;
        this.jars = jars;
        this.supports = supports;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IProcessorJar[] getProcessorJars() {
        return this.jars;
    }

    public void setProcessorJars(IProcessorJar[] jars) {
        this.jars = jars;
    }

    public String getProcessorTypeId() {
        return this.type;
    }

    public IProcessorType getProcessorType() {
        return XSLTRuntime.getProcessorType(this.type);
    }

    public void setProcessorTypeId(String id) {
        this.type = id;
    }

    public boolean isContributed() {
        return this.contributed;
    }

    public static IProcessorJar[] createJars(String bundleId, String classpath) {
        if (classpath == null) {
            return new IProcessorJar[0];
        }
        String[] jarstring = classpath.split(";");
        IProcessorJar[] jars = new IProcessorJar[jarstring.length];
        int i = 0;
        while (i < jarstring.length) {
            String jar = jarstring[i];
            try {
                if (jar.startsWith("${eclipse_orbit:") && jar.endsWith("}")) {
                    jar = jar.substring("${eclipse_orbit:".length());
                    jar = jar.substring(0, jar.length() - 1);
                    jars[i] = new PluginProcessorJar(jar, null);
                } else {
                    jar = Utils.getFileLocation(bundleId, jar);
                    jars[i] = new PluginProcessorJar(bundleId, (IPath)new Path(jar));
                }
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
            }
            ++i;
        }
        return jars;
    }

    public boolean hasDebugger() {
        return this.debuggerId != null;
    }

    public boolean supports(String xsltVersion) {
        return this.supports.indexOf(xsltVersion) >= 0;
    }

    public String getSupports() {
        return this.supports;
    }

    public void setSupports(String supports) {
        this.supports = supports;
    }

    public IDebugger getDebugger() {
        return XSLTRuntime.getDebugger(this.debuggerId);
    }

    public void setDebuggerId(String debuggerId) {
        this.debuggerId = debuggerId;
    }
}

