/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.internal.launching.PreferenceUtil;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchFeatures {
    private final Set<LaunchAttribute> features = new HashSet<LaunchAttribute>();

    public Set<LaunchAttribute> getFeatures() {
        return this.features;
    }

    public void addFeature(LaunchAttribute feature) {
        this.features.add(feature);
    }

    public LaunchAttribute getFeature(String uri) {
        for (LaunchAttribute tv : this.features) {
            if (!tv.uri.equals(uri)) continue;
            return tv;
        }
        return null;
    }

    public void removeFeature(String uri) {
        Iterator<LaunchAttribute> iter = this.features.iterator();
        while (iter.hasNext()) {
            LaunchAttribute feature = iter.next();
            if (!feature.uri.equals(uri)) continue;
            iter.remove();
        }
    }

    public String toXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element featuresEl = doc.createElement("Features");
        doc.appendChild(featuresEl);
        for (LaunchAttribute feature : this.features) {
            if (feature.value == null) continue;
            Element featureEl = doc.createElement("Feature");
            featureEl.setAttribute("name", feature.uri);
            featureEl.setAttribute("type", feature.type);
            featureEl.setAttribute("value", feature.value);
            featuresEl.appendChild(featureEl);
        }
        return PreferenceUtil.serializeDocument(doc);
    }

    public static LaunchFeatures fromXML(InputStream inputStream) throws CoreException {
        Document doc = PreferenceUtil.getDocument(inputStream);
        LaunchFeatures pdef = new LaunchFeatures();
        Element featuresEl = doc.getDocumentElement();
        NodeList featureEls = featuresEl.getElementsByTagName("Feature");
        int i = 0;
        while (i < featureEls.getLength()) {
            Element featureEl = (Element)featureEls.item(i);
            String name = featureEl.getAttribute("name");
            String type = featureEl.getAttribute("type");
            String value = featureEl.getAttribute("value");
            pdef.addFeature(new LaunchAttribute(name, type, value));
            ++i;
        }
        return pdef;
    }
}

