/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ProjectUnzipUtility {
    public static final String PROJECT_ZIPS_FOLDER = "projecttestfiles";
    private List fCreatedProjects = new ArrayList();
    static final int BUFFER = 2048;

    public void importFile(File fileToImport, String folderPath) {
        block6: {
            WorkspaceProgressMonitor importProgress = new WorkspaceProgressMonitor();
            try {
                try {
                    if (fileToImport.exists()) {
                        Path containerPath = new Path(folderPath);
                        FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
                        MyOverwriteQuery overwriteImplementor = new MyOverwriteQuery();
                        File[] filesToImport = new File[]{fileToImport};
                        ImportOperation importOp = new ImportOperation((IPath)containerPath, null, (IImportStructureProvider)provider, (IOverwriteQuery)overwriteImplementor, Arrays.asList(filesToImport));
                        importOp.setCreateContainerStructure(false);
                        importOp.setOverwriteResources(true);
                        importOp.run((IProgressMonitor)importProgress);
                        break block6;
                    }
                    System.out.println("handle source doesn't exist");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    importProgress.done();
                }
            }
            finally {
                importProgress.done();
            }
        }
    }

    public void unzipAndImport(File inFile, String destinationDirectory) {
        try {
            String inFileName = inFile.getAbsolutePath();
            File sourceZipFile = new File(inFileName);
            File unzipDestinationDirectory = new File(destinationDirectory);
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            String projectFolderName = null;
            IProject currentProject = null;
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(unzipDestinationDirectory, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
                if (projectFolderName == null) continue;
                this.importFile(destFile, projectFolderName);
            }
            zipFile.close();
            if (currentProject != null) {
                try {
                    Path projectLocation = new Path(Platform.getLocation().toOSString());
                    this.createProject(currentProject, (IPath)projectLocation, new WorkspaceProgressMonitor());
                }
                catch (CoreException cex) {
                    cex.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void refreshWorkspace() throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = wsRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            projects[i].refreshLocal(2, null);
            ++i;
        }
        wsRoot.refreshLocal(2, null);
    }

    public void deleteProjects() throws Exception {
        final IProject[] projects = this.getCreatedProjects();
        WorkspaceModifyOperation deleteOp = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < projects.length) {
                    projects[i].clearHistory(null);
                    projects[i].close(null);
                    projects[i].delete(true, true, null);
                    ++i;
                }
                ProjectUnzipUtility.this.refreshWorkspace();
            }
        };
        WorkspaceProgressMonitor progress = new WorkspaceProgressMonitor();
        deleteOp.run((IProgressMonitor)progress);
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public void deleteProject(String projectName) throws Exception {
        String name = projectName;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject proj = wsRoot.getProject(name);
        WorkspaceModifyOperation deleteOp = new WorkspaceModifyOperation((ISchedulingRule)proj){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (proj != null && proj.exists()) {
                    proj.clearHistory(null);
                    proj.refreshLocal(2, null);
                    try {
                        proj.delete(true, true, null);
                    }
                    catch (Exception exception) {
                        proj.refreshLocal(2, null);
                        proj.delete(true, true, null);
                    }
                }
                ProjectUnzipUtility.this.refreshWorkspace();
            }
        };
        WorkspaceProgressMonitor progress = new WorkspaceProgressMonitor();
        deleteOp.run((IProgressMonitor)progress);
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public IProject[] getCreatedProjects() {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] projectNames = this.fCreatedProjects.toArray(new String[this.fCreatedProjects.size()]);
        IProject[] projects = new IProject[projectNames.length];
        int i = 0;
        while (i < projectNames.length) {
            projects[i] = wsRoot.getProject(projectNames[i]);
            ++i;
        }
        return projects;
    }

    public void initJavaProject(String projName) throws CoreException {
        this.refreshWorkspace();
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (!proj.exists()) {
            proj.create((IProgressMonitor)new NullProgressMonitor());
        }
        String[] natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
        if (!proj.isOpen()) {
            proj.open(null);
        }
        IProjectDescription desc = proj.getDescription();
        desc.setNatureIds(natureIds);
        proj.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    private void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new WorkspaceProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void deleteProject(IProject fProject) throws InvocationTargetException, InterruptedException {
        final IProject proj = fProject;
        WorkspaceModifyOperation deleteOp = new WorkspaceModifyOperation((ISchedulingRule)proj){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (proj != null && proj.exists()) {
                    proj.clearHistory(null);
                    proj.refreshLocal(2, null);
                    proj.delete(true, true, null);
                }
                ProjectUnzipUtility.this.refreshWorkspace();
            }
        };
        deleteOp.run(null);
    }

    class MyOverwriteQuery
    implements IOverwriteQuery {
        MyOverwriteQuery() {
        }

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    }

    class WorkspaceProgressMonitor
    implements IProgressMonitor {
        private boolean finished = false;

        WorkspaceProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.finished;
        }

        public void setCanceled(boolean value) {
            if (value) {
                this.finished = true;
            }
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

