/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.editor;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;
import org.eclipse.wst.xsl.ui.internal.contentassist.XSLContentAssistProcessor;
import org.eclipse.wst.xsl.ui.tests.UnzippedProjectTester;

public class XSLCompletionTest
extends UnzippedProjectTester {
    protected String projectName = null;
    protected String fileName = null;
    protected IFile file = null;
    protected IEditorPart textEditorPart = null;
    protected ITextEditor editor = null;
    protected XMLDocumentLoader xmlDocumentLoader = null;
    protected IStructuredDocument document = null;
    protected StructuredTextViewer sourceViewer = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.projectName = "xsltestfiles";
        this.fileName = "utils.xsl";
        String xslFilePath = this.setupProject();
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(xslFilePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + this.fileName + " stylesheet."));
        }
        this.loadXSLFile();
        this.initializeSourceViewer();
    }

    protected void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.sourceViewer = new StructuredTextViewer(parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationXSL());
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void loadXSLFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.getNewModelForEdit(this.file, true);
        this.document = model.getStructuredDocument();
    }

    protected String setupProject() {
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        return xslFilePath;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private ICompletionProposal[] getProposals(int offset) throws Exception {
        return new XSLContentAssistProcessor().computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    public void testGetNodeAtLine15() throws Exception {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)631);
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:stylesheet", (String)node.getNodeName());
    }

    public void testGetNodeAtLine16() throws Exception {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)712);
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:template", (String)node.getNodeName());
    }

    public void testGetNodeAtLine17() throws Exception {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)748);
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:param", (String)node.getNodeName());
    }

    public void testSelectAttributeProposalsAvailable() throws Exception {
        ICompletionProposal[] proposals = this.getProposals(838);
        XSLCompletionTest.assertTrue((proposals.length > 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[3];
        XSLCompletionTest.assertEquals((String)"Wrong select item returned: ", (String)"..", (String)proposal.getDisplayString());
    }

    public void testTestAttributeProposalsAvailable() throws Exception {
        ICompletionProposal[] proposals = this.getProposals(1753);
        XSLCompletionTest.assertTrue((proposals.length >= 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[0];
        XSLCompletionTest.assertEquals((String)"Wrong attribute proposal returned:", (String)"default-collation", (String)proposal.getDisplayString());
    }

    public void testXSLElementProposalsAvailable() throws Exception {
        ICompletionProposal[] proposals = this.getProposals(1569);
        XSLCompletionTest.assertTrue((proposals.length >= 2 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[1];
        XSLCompletionTest.assertTrue((String)"Can't find XSL element proposals.", (boolean)proposal.getDisplayString().equals("xsl:otherwise"));
    }
}

