/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xml.xpath.core.internal.parser.XPathParser;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.eclipse.wst.xml.xpath.ui.internal.contentassist.XPathTemplateCompletionProcessor;
import org.eclipse.wst.xml.xpath.ui.internal.templates.TemplateContextTypeIdsXPath;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLContentAssistProcessor
extends XMLContentAssistProcessor
implements IPropertyChangeListener {
    private static final String ATTR_SELECT = "select";
    private static final String ATTR_TEST = "test";
    private static final String ATTR_MATCH = "match";
    private static final String XPATH_GLOBAL_VARIABLES = "/xsl:stylesheet/xsl:variable";
    private static final String XPATH_GLOBAL_PARAMS = "/xsl:stylesheet/xsl:param";
    private static final String XPATH_LOCAL_VARIABLES = "ancestor::xsl:template/descendant::xsl:variable";
    private static final String XPATH_LOCAL_PARAMS = "ancestor::xsl:template/descendant::xsl:param";
    private XPathTemplateCompletionProcessor fTemplateProcessor = null;
    private List<String> fTemplateContexts = new ArrayList<String>();
    private static final byte[] XPATH_LOCK = new byte[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.fTemplateContexts.clear();
        return super.computeCompletionProposals(textViewer, documentPosition);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        super.addAttributeValueProposals(contentAssistRequest);
        String attributeName = this.getAttributeName(contentAssistRequest);
        Element rootElement = contentAssistRequest.getNode().getOwnerDocument().getDocumentElement();
        if (attributeName != null) {
            int offset = contentAssistRequest.getReplacementBeginPosition() + 1;
            this.addAttributeValueOfProposals(contentAssistRequest, contentAssistRequest.getNode().getNamespaceURI(), rootElement, offset);
            if (XSLCore.isXSLNamespace((IDOMNode)((IDOMNode)contentAssistRequest.getNode()))) {
                this.addSelectAndTestProposals(contentAssistRequest, attributeName, rootElement, offset);
                this.addMatchProposals(contentAssistRequest, attributeName, offset);
            }
        }
    }

    private void addMatchProposals(ContentAssistRequest contentAssistRequest, String attributeName, int offset) {
        if (attributeName.equals(ATTR_MATCH)) {
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.AXIS, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.XPATH, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.CUSTOM, offset);
        }
    }

    private void addSelectAndTestProposals(ContentAssistRequest contentAssistRequest, String attributeName, Element rootElement, int offset) {
        if (attributeName.equals(ATTR_SELECT) || attributeName.equals(ATTR_TEST)) {
            this.addGlobalProposals(rootElement, contentAssistRequest, offset);
            this.addLocalProposals(contentAssistRequest.getNode(), contentAssistRequest, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.AXIS, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.XPATH, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.CUSTOM, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.OPERATOR, offset);
        }
    }

    private void addAttributeValueOfProposals(ContentAssistRequest contentAssistRequest, String namespace, Element rootElement, int offset) {
        if (contentAssistRequest.getMatchString().contains("{")) {
            this.addGlobalProposals(rootElement, contentAssistRequest, contentAssistRequest.getReplacementBeginPosition());
            this.addLocalProposals(contentAssistRequest.getNode(), contentAssistRequest, contentAssistRequest.getReplacementBeginPosition());
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.AXIS, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.XPATH, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.CUSTOM, offset);
            this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXPath.OPERATOR, offset);
        }
    }

    private void addLocalProposals(Node xpathnode, ContentAssistRequest contentAssistRequest, int offset) {
        this.addVariablesProposals(XPATH_LOCAL_VARIABLES, xpathnode, contentAssistRequest, offset);
        this.addVariablesProposals(XPATH_LOCAL_PARAMS, xpathnode, contentAssistRequest, offset);
    }

    private void addGlobalProposals(Node xpathnode, ContentAssistRequest contentAssistRequest, int offset) {
        this.addVariablesProposals(XPATH_GLOBAL_VARIABLES, xpathnode, contentAssistRequest, offset);
        this.addVariablesProposals(XPATH_GLOBAL_PARAMS, xpathnode, contentAssistRequest, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVariablesProposals(String xpath, Node xpathnode, ContentAssistRequest contentAssistRequest, int offset) {
        byte[] byArray = XPATH_LOCK;
        synchronized (XPATH_LOCK) {
            try {
                NodeList nodes = XSLTXPathHelper.selectNodeList((Node)xpathnode, (String)xpath);
                int startLength = this.getCursorPosition() - offset;
                if (this.hasNodes(nodes)) {
                    int nodecnt = 0;
                    while (nodecnt < nodes.getLength()) {
                        Node node = nodes.item(nodecnt);
                        String variableName = "$" + node.getAttributes().getNamedItem("name").getNodeValue();
                        CustomCompletionProposal proposal = new CustomCompletionProposal(variableName, offset, 0, startLength + variableName.length(), XSLPluginImageHelper.getInstance().getImage("icons/full/variable.gif"), variableName, null, null, 0);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        ++nodecnt;
                    }
                }
            }
            catch (TransformerException ex) {
                XSLUIPlugin.log(ex);
            }
            return;
        }
    }

    private boolean hasNodes(NodeList nodes) {
        return nodes != null && nodes.getLength() > 0;
    }

    private int getCursorPosition() {
        return this.fTextViewer.getTextWidget().getCaretOffset();
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (!this.fTemplateContexts.contains(context)) {
            boolean useProposalList;
            this.fTemplateContexts.add(context);
            boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
            if (this.getTemplateCompletionProcessor() != null) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    if (useProposalList) {
                        contentAssistRequest.addProposal(proposals[i]);
                    } else {
                        contentAssistRequest.addMacro(proposals[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private XPathTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XPathTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    private String getAttributeName(ContentAssistRequest contentAssistRequest) {
        IStructuredDocumentRegion open = ((IDOMNode)contentAssistRequest.getNode()).getFirstStructuredDocumentRegion();
        ITextRegionList openRegions = open.getRegions();
        int i = openRegions.indexOf(contentAssistRequest.getRegion());
        if (i >= 0) {
            ITextRegion nameRegion = null;
            while (i >= 0) {
                if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
            }
            return open.getText(nameRegion);
        }
        return null;
    }

    protected String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        String emptyString = "";
        if (this.isMatchStringEmpty(parent, aRegion, offset)) {
            return emptyString;
        }
        IDOMNode currentNode = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.fTextViewer, (int)offset);
        IDOMAttr attributeNode = this.isXPathRegion(currentNode, aRegion, offset);
        if (attributeNode != null) {
            String temp = this.extractXPathMatchString(attributeNode, aRegion, offset);
            return temp;
        }
        if (this.hasXMLMatchString(parent, aRegion, offset)) {
            return this.extractXMLMatchString(parent, aRegion, offset);
        }
        return emptyString;
    }

    protected String extractXPathMatchString(IDOMAttr node, ITextRegion aRegion, int offset) {
        if (node.getValue().length() == 0) {
            return "";
        }
        node.getValueRegionStartOffset();
        int column = offset - node.getValueRegionStartOffset();
        XPathParser parser = new XPathParser(node.getValue());
        int tokenStart = parser.getTokenStartOffset(1, column);
        if (tokenStart == column) {
            return "";
        }
        return node.getValue().substring(tokenStart - 1, column - 1);
    }

    protected IDOMAttr isXPathRegion(IDOMNode currentNode, ITextRegion aRegion, int offset) {
        if (XSLCore.isXSLNamespace((IDOMNode)currentNode)) {
            return this.getXPathNode((Node)currentNode, aRegion);
        }
        return null;
    }

    protected IDOMAttr getXPathNode(Node node, ITextRegion aRegion) {
        if (node.hasAttributes()) {
            if (this.hasAttributeAtTextRegion(ATTR_SELECT, node.getAttributes(), aRegion)) {
                return this.getAttributeAtTextRegion(ATTR_SELECT, node.getAttributes(), aRegion);
            }
            if (this.hasAttributeAtTextRegion(ATTR_TEST, node.getAttributes(), aRegion)) {
                return this.getAttributeAtTextRegion(ATTR_TEST, node.getAttributes(), aRegion);
            }
        }
        return null;
    }

    protected boolean hasAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr attrNode = (IDOMAttr)nodeMap.getNamedItem(attrName);
        return attrNode != null && attrNode.getValueRegion().getStart() == aRegion.getStart();
    }

    protected IDOMAttr getAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr node = (IDOMAttr)nodeMap.getNamedItem(attrName);
        if (node != null && node.getValueRegion().getStart() == aRegion.getStart()) {
            return node;
        }
        return null;
    }

    protected String extractXMLMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion));
    }

    protected boolean hasXMLMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return this.regionHasData(parent, aRegion) && this.isOffsetAfterStart(parent, aRegion, offset);
    }

    protected boolean isOffsetAfterStart(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return parent.getStartOffset(aRegion) < offset;
    }

    protected boolean regionHasData(IStructuredDocumentRegion parent, ITextRegion aRegion) {
        return parent.getText(aRegion).length() > 0;
    }

    protected boolean isXMLContentRegion(String regionType) {
        return regionType == "XML_CONTENT";
    }

    protected boolean isOffsetAfterEndOffset(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return offset > this.getRegionEndOffset(parent, aRegion);
    }

    protected int getRegionEndOffset(IStructuredDocumentRegion parent, ITextRegion aRegion) {
        return parent.getStartOffset(aRegion) + aRegion.getTextLength();
    }

    protected boolean isXMLTagOpen(String regionType) {
        return regionType == "XML_TAG_OPEN";
    }

    protected boolean isAttributeEqualsRegion(String regionType) {
        return regionType == "XML_TAG_ATTRIBUTE_EQUALS";
    }

    protected boolean isMatchStringEmpty(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        return this.isRegionNull(aRegion) || this.isCloseRegion(aRegion) || this.isAttributeEqualsRegion(aRegion.getType()) || this.isXMLTagOpen(aRegion.getType()) || this.isOffsetAfterEndOffset(parent, aRegion, offset) || this.isXMLContentRegion(aRegion.getType());
    }

    protected boolean isRegionNull(ITextRegion aRegion) {
        return aRegion == null;
    }

    protected ContentAssistRequest computeAttributeValueProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() && sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() != sdRegion.getStartOffset(completionRegion) + completionRegion.getLength()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            contentAssistRequest = this.newContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest);
            if (actualNode.getFirstStructuredDocumentRegion() != null && !actualNode.getFirstStructuredDocumentRegion().isEnded()) {
                this.addTagCloseProposals(contentAssistRequest);
            }
        } else if (!nodeAtOffset.getFirstStructuredDocumentRegion().isEnded() && documentPosition < sdRegion.getStartOffset(completionRegion)) {
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest);
        } else {
            IDOMAttr xpathNode = this.isXPathRegion(nodeAtOffset, completionRegion, documentPosition);
            if (xpathNode != null) {
                XPathParser parser = new XPathParser(xpathNode.getValue());
                int startOffset = xpathNode.getValueRegionStartOffset() + parser.getTokenStartOffset(1, documentPosition - xpathNode.getValueRegionStartOffset()) - 1;
                int replacementLength = documentPosition - startOffset;
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, startOffset, replacementLength, matchString);
            } else {
                contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
            }
            this.addAttributeValueProposals(contentAssistRequest);
        }
        return contentAssistRequest;
    }
}

