/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.IOperationRunnable;
import org.eclipse.jst.validation.test.internal.registry.ITestcaseMetaData;
import org.eclipse.jst.validation.test.internal.registry.MessageMetaData;
import org.eclipse.jst.validation.test.internal.registry.OperationTestcase;
import org.eclipse.jst.validation.test.internal.registry.RegistryConstants;
import org.eclipse.jst.validation.test.internal.registry.TestSetupImport;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.jst.validation.test.setup.IImportOperation;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public final class BVTValidationRegistryReader
implements RegistryConstants {
    private static BVTValidationRegistryReader inst = null;
    private static OperationTestReader _opReader = null;
    private static TestSetupReader _setupReader = null;
    private static ValidationTestReader _valReader = null;

    private BVTValidationRegistryReader() {
    }

    public ITestcaseMetaData[] getTests(IProgressMonitor monitor) {
        HashSet<ITestcaseMetaData> tests = new HashSet<ITestcaseMetaData>();
        ValidatorTestcase[] vts = this.getValidatorTests(monitor, (String)null);
        int j = 0;
        while (j < vts.length) {
            tests.add(vts[j]);
            ++j;
        }
        OperationTestcase[] ots = this.getOperationTests(monitor, (String)null);
        int k = 0;
        while (k < ots.length) {
            tests.add(ots[k]);
            ++k;
        }
        ITestcaseMetaData[] result = new ITestcaseMetaData[tests.size()];
        tests.toArray(result);
        return result;
    }

    public ITestcaseMetaData[] getTests(IProgressMonitor monitor, IProject[] projects) {
        HashSet<ITestcaseMetaData> tests = new HashSet<ITestcaseMetaData>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ValidatorTestcase[] vts = this.getValidatorTests(monitor, project);
            int j = 0;
            while (j < vts.length) {
                tests.add(vts[j]);
                ++j;
            }
            OperationTestcase[] ots = this.getOperationTests(monitor, project);
            int k = 0;
            while (k < ots.length) {
                tests.add(ots[k]);
                ++k;
            }
            ++i;
        }
        ITestcaseMetaData[] result = new ITestcaseMetaData[tests.size()];
        tests.toArray(result);
        return result;
    }

    public ValidatorTestcase[] getAllValidatorTests(IProgressMonitor monitor, IProject project) throws IllegalArgumentException {
        ValidationTestReader reader = this.getValidationTestReader();
        return reader.getValidatorTests(monitor, project.getName());
    }

    public ValidatorTestcase[] getAllValidatorTests(IProgressMonitor monitor, IProject project, String[] validatorNames) {
        HashSet<ValidatorTestcase> testSet = new HashSet<ValidatorTestcase>();
        ValidatorTestcase[] tests = this.getAllValidatorTests(monitor, project);
        int i = 0;
        while (i < validatorNames.length) {
            String validator = validatorNames[i];
            int j = 0;
            while (j < tests.length) {
                ValidatorTestcase tmd = tests[j];
                if (tmd.getValidatorClass().equals(validator)) {
                    testSet.add(tmd);
                    break;
                }
                ++j;
            }
            ++i;
        }
        ValidatorTestcase[] result = new ValidatorTestcase[testSet.size()];
        testSet.toArray(result);
        return result;
    }

    public ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, IProject project) throws IllegalArgumentException {
        return this.getValidatorTests(monitor, project.getName());
    }

    private ValidationTestReader getValidationTestReader() {
        if (_valReader == null) {
            _valReader = new ValidationTestReader();
        }
        return _valReader;
    }

    private OperationTestReader getOperationTestReader() {
        if (_opReader == null) {
            _opReader = new OperationTestReader();
        }
        return _opReader;
    }

    private TestSetupReader getTestSetupReader() {
        if (_setupReader == null) {
            _setupReader = new TestSetupReader();
        }
        return _setupReader;
    }

    public ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, String testName) throws IllegalArgumentException {
        return this.getValidationTestReader().getVisibleValidatorTests(monitor, testName);
    }

    public OperationTestcase[] getOperationTests(IProgressMonitor monitor, IProject project) throws IllegalArgumentException {
        return this.getOperationTests(monitor, project.getName());
    }

    public OperationTestcase[] getOperationTests(IProgressMonitor monitor, String testName) throws IllegalArgumentException {
        return this.getOperationTestReader().getOperationTests(monitor, testName);
    }

    public TestSetupImport[] getTestSetup(IBuffer buffer, String dir, ITestcaseMetaData tmd, boolean verbose) {
        return this.getTestSetupReader().getTestSetup(buffer, dir, tmd, verbose);
    }

    public static BVTValidationRegistryReader getReader() {
        if (inst == null) {
            inst = new BVTValidationRegistryReader();
        }
        return inst;
    }

    private class OperationTestReader {
        private Map _operationTests = null;

        OperationTestReader() {
        }

        public OperationTestcase[] getOperationTests(IProgressMonitor monitor, String testName) throws IllegalArgumentException {
            if (this._operationTests == null) {
                this._operationTests = new HashMap();
                this.readOperationTestcaseRegistry(monitor);
            }
            Collection tmds = null;
            if (testName == null) {
                tmds = new HashSet();
                Iterator iterator = this._operationTests.values().iterator();
                while (iterator.hasNext()) {
                    tmds.addAll((Collection)iterator.next());
                }
            } else {
                tmds = (Collection)this._operationTests.get(testName);
            }
            if (tmds == null || tmds.size() == 0) {
                return new OperationTestcase[0];
            }
            OperationTestcase[] result = new OperationTestcase[tmds.size()];
            tmds.toArray(result);
            return result;
        }

        private String getInputFileName(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "getInputFileName::IConfigurationElement is null");
                }
                return null;
            }
            return element.getAttribute("input");
        }

        private void addOperationTest(IProgressMonitor monitor, IExtension extension, IConfigurationElement[] testElements) {
            monitor.subTask("Reading test cases; please wait...");
            String pluginId = extension.getNamespace();
            int i = 0;
            while (i < testElements.length) {
                monitor.subTask("Reading test case " + (i + 1) + " of " + testElements.length);
                IConfigurationElement test = testElements[i];
                String projectName = this.getProject(test);
                if (projectName == null) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, "Every test must name the project that it verifies. " + test.toString());
                    }
                } else {
                    IOperationRunnable op = this.getOperation(test);
                    if (op != null) {
                        String inputFileName = this.getInputFileName(test);
                        if (inputFileName == null) {
                            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                logger.write(Level.SEVERE, "Every test must name the file to be imported and then tested." + test.toString());
                            }
                        } else {
                            String id = extension.getLabel();
                            OperationTestcase tmd = new OperationTestcase(pluginId, projectName, id, inputFileName, op);
                            HashSet<OperationTestcase> prjTmd = (HashSet<OperationTestcase>)this._operationTests.get(projectName);
                            if (prjTmd == null) {
                                prjTmd = new HashSet<OperationTestcase>();
                            }
                            prjTmd.add(tmd);
                            this._operationTests.put(projectName, prjTmd);
                        }
                    }
                }
                ++i;
            }
        }

        private void readOperationTestcaseExtension(IProgressMonitor monitor, IExtension extension) {
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements == null || elements.length == 0) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "No tests found for " + extension.getLabel());
                }
                return;
            }
            this.addOperationTest(monitor, extension, elements);
        }

        private void readOperationTestcaseRegistry(IProgressMonitor monitor) {
            IExtensionPoint opEP = this.getOperationTestcaseExtensionPoint();
            if (opEP == null) {
                return;
            }
            IExtension[] extensions = opEP.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                this.readOperationTestcaseExtension(monitor, extensions[i]);
                ++i;
            }
        }

        private String getProject(IConfigurationElement element) {
            if (element == null) {
                return null;
            }
            return element.getAttribute("project");
        }

        private IExtensionPoint getOperationTestcaseExtensionPoint() {
            Logger logger;
            IPluginRegistry registry = Platform.getPluginRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jst.validation.test", "opTest");
            if (extensionPoint == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, "org.eclipse.jst.validation.test.opTest has been removed from the validation TVT plugin.xml file");
            }
            return extensionPoint;
        }

        private IOperationRunnable getOperation(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "IConfigurationElement is null");
                }
                return null;
            }
            String opClass = element.getAttribute("operation");
            try {
                Logger logger;
                IOperationRunnable op;
                Logger logger2;
                if (opClass == null && (logger2 = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                    logger2.write(Level.SEVERE, "Cannot locate operation attribute");
                }
                if ((op = (IOperationRunnable)element.createExecutableExtension("operation")) == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "Could not find operation " + opClass);
                }
                return op;
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "Throwable caught while retrieving IValidator " + opClass);
                    logger.write(Level.SEVERE, exc);
                }
                return null;
            }
        }
    }

    private class TestSetupReader {
        private TestSetupImport[] _testSetup = null;

        TestSetupReader() {
        }

        private String getInputFileName(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "getInputFileName::IConfigurationElement is null");
                }
                return null;
            }
            return element.getAttribute("input");
        }

        public TestSetupImport[] getTestSetup(IBuffer buffer, String dir, ITestcaseMetaData tmd, boolean verbose) {
            if (this._testSetup == null) {
                this.readSetupRegistry(buffer, verbose);
            }
            if (tmd != null) {
                int j = 0;
                while (j < this._testSetup.length) {
                    TestSetupImport tsi = this._testSetup[j];
                    if (tsi.getFileName().endsWith(tmd.getInputFileName())) {
                        return new TestSetupImport[]{tsi};
                    }
                    ++j;
                }
                return new TestSetupImport[0];
            }
            return this._testSetup;
        }

        private void addSetup(IBuffer buffer, IConfigurationElement[] importElements, boolean verbose) {
            if (importElements == null || importElements.length == 0) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    String message = "No test setup found";
                    logger.write(Level.SEVERE, message);
                    buffer.write(message);
                }
                return;
            }
            TestSetupImport[] temp = new TestSetupImport[importElements.length];
            int count = 0;
            int i = 0;
            while (i < importElements.length) {
                IConfigurationElement importElement = importElements[i];
                String inputFileName = this.getInputFileName(importElement);
                if (inputFileName != null) {
                    IImportOperation op = this.getImportOperation(buffer, importElement);
                    if (op == null) {
                        buffer.write("Import operation cannot be found. Ignoring import.");
                    } else {
                        TestSetupImport ts = new TestSetupImport(op, inputFileName);
                        temp[count++] = ts;
                    }
                }
                ++i;
            }
            if (this._testSetup == null) {
                if (count == temp.length) {
                    this._testSetup = temp;
                } else {
                    this._testSetup = new TestSetupImport[count];
                    System.arraycopy(temp, 0, this._testSetup, 0, count);
                }
            } else {
                TestSetupImport[] newTestSetup = new TestSetupImport[this._testSetup.length + count];
                System.arraycopy(this._testSetup, 0, newTestSetup, 0, this._testSetup.length);
                System.arraycopy(temp, 0, newTestSetup, this._testSetup.length, count);
                this._testSetup = newTestSetup;
            }
        }

        private void readSetupExtension(IBuffer buffer, IExtension extension, boolean verbose) {
            IConfigurationElement[] elements = extension.getConfigurationElements();
            this.addSetup(buffer, elements, verbose);
        }

        private IExtensionPoint getSetupExtensionPoint() {
            Logger logger;
            IPluginRegistry registry = Platform.getPluginRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jst.validation.test", "testSetup");
            if (extensionPoint == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, "org.eclipse.jst.validation.test.testSetup has been removed from the validation TVT plugin.xml file");
            }
            return extensionPoint;
        }

        private void readSetupRegistry(IBuffer buffer, boolean verbose) {
            IExtensionPoint validatorEP = this.getSetupExtensionPoint();
            if (validatorEP == null) {
                buffer.write("Extension point is missing. Cannot import test cases.");
                return;
            }
            IExtension[] extensions = validatorEP.getExtensions();
            if (extensions.length == 0) {
                buffer.write("No extensions found. Cannot import test cases.");
                return;
            }
            buffer.getProgressMonitor().subTask("Reading setup <import> extensions; please wait...");
            int i = 0;
            while (i < extensions.length) {
                buffer.getProgressMonitor().subTask("Reading setup <import> " + (i + 1) + " of " + extensions.length);
                this.readSetupExtension(buffer, extensions[i], verbose);
                ++i;
            }
        }

        private IImportOperation getImportOperation(IBuffer buffer, IConfigurationElement element) {
            Object temp;
            block11: {
                String opClass;
                block10: {
                    Logger logger;
                    if (element == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                        String message = "IConfigurationElement is null";
                        logger.write(Level.SEVERE, message);
                        buffer.write(message);
                    }
                    opClass = element.getAttribute("operation");
                    try {
                        if (opClass != null) break block10;
                        Logger logger2 = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (logger2.isLoggingLevel(Level.SEVERE)) {
                            String message = "Because there is no operation attribute, assuming that the input is a workspace.";
                            logger2.write(Level.SEVERE, message);
                            buffer.write(message);
                        }
                        return null;
                    }
                    catch (Throwable exc) {
                        Logger logger3 = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (logger3.isLoggingLevel(Level.SEVERE)) {
                            String message = "Throwable caught while retrieving IImportOperation " + opClass + " Ignoring the test case.";
                            logger3.write(Level.SEVERE, message);
                            logger3.write(Level.SEVERE, exc);
                            buffer.write(message);
                        }
                        return null;
                    }
                }
                temp = element.createExecutableExtension("operation");
                if (temp != null) break block11;
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    String message = "operation " + opClass + " cannot be created. Ignoring the test case.";
                    logger.write(Level.SEVERE, message);
                    buffer.write(message);
                }
                return null;
            }
            if (temp instanceof IImportOperation) {
                return (IImportOperation)temp;
            }
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                String message = "operation must be an instance of IImportOperation. Ignoring the test case.";
                logger.write(Level.SEVERE, message);
                buffer.write(message);
            }
            return null;
        }
    }

    private class ValidationTestReader {
        private Map _validatorTests = null;

        ValidationTestReader() {
        }

        public ValidatorTestcase[] getVisibleValidatorTests(IProgressMonitor monitor, String testName) throws IllegalArgumentException {
            ValidatorTestcase[] vts = this.getValidatorTests(monitor, testName);
            ValidatorTestcase[] temp = new ValidatorTestcase[vts.length];
            int count = 0;
            int i = 0;
            while (i < vts.length) {
                ValidatorTestcase vt = vts[i];
                if (vt.isVisible()) {
                    temp[count++] = vt;
                }
                ++i;
            }
            ValidatorTestcase[] result = new ValidatorTestcase[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }

        public ValidatorTestcase[] getValidatorTests(IProgressMonitor monitor, String testName) throws IllegalArgumentException {
            if (this._validatorTests == null) {
                this._validatorTests = new HashMap();
                this.readTestcaseRegistry(monitor);
            }
            Collection tmds = null;
            if (testName == null) {
                tmds = new HashSet();
                Iterator iterator = this._validatorTests.values().iterator();
                while (iterator.hasNext()) {
                    tmds.addAll((Collection)iterator.next());
                }
            } else {
                tmds = (Collection)this._validatorTests.get(testName);
            }
            if (tmds == null || tmds.size() == 0) {
                return new ValidatorTestcase[0];
            }
            ValidatorTestcase[] result = new ValidatorTestcase[tmds.size()];
            tmds.toArray(result);
            return result;
        }

        private String getProject(IConfigurationElement element) {
            if (element == null) {
                return null;
            }
            return element.getAttribute("project");
        }

        private MessageMetaData[] getMessages(ValidatorTestcase tmd, IConfigurationElement testElement) {
            IConfigurationElement[] messages = testElement.getChildren("message");
            if (messages == null || messages.length == 0) {
                return null;
            }
            MessageMetaData[] mmdList = new MessageMetaData[messages.length];
            int count = 0;
            int i = 0;
            while (i < messages.length) {
                IConfigurationElement message = messages[i];
                String prefix = message.getAttribute("prefix");
                if (prefix == null) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, "Every <message> must have a prefix.");
                    }
                } else {
                    String resourceName = message.getAttribute("resource");
                    String location = message.getAttribute("location");
                    String text = message.getAttribute("text");
                    int lineNumber = -1;
                    MessageMetaData mmd = null;
                    if (location != null) {
                        try {
                            lineNumber = Integer.parseInt(location);
                            mmd = new MessageMetaData(tmd, prefix, resourceName, lineNumber, text);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (mmd == null) {
                        mmd = new MessageMetaData(tmd, prefix, resourceName, location, text);
                    }
                    mmdList[count++] = mmd;
                }
                ++i;
            }
            if (count == mmdList.length) {
                return mmdList;
            }
            MessageMetaData[] result = new MessageMetaData[count];
            System.arraycopy(mmdList, 0, result, 0, count);
            return result;
        }

        private void addTest(IProgressMonitor monitor, IExtension extension, IConfigurationElement[] testElements) {
            monitor.subTask("Reading test cases; please wait...");
            String pluginId = extension.getNamespace();
            int i = 0;
            while (i < testElements.length) {
                monitor.subTask("Reading test case " + (i + 1) + " of " + testElements.length);
                IConfigurationElement test = testElements[i];
                String projectName = this.getProject(test);
                if (projectName == null) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (logger.isLoggingLevel(Level.SEVERE)) {
                        logger.write(Level.SEVERE, "Every test must name the project that it verifies. " + test.toString());
                    }
                } else {
                    ValidatorMetaData vmd = this.getValidatorMetaData(test);
                    if (vmd != null) {
                        String inputFileName = this.getInputFileName(test);
                        if (inputFileName == null) {
                            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                            if (logger.isLoggingLevel(Level.SEVERE)) {
                                logger.write(Level.SEVERE, "Every test must name the file to be imported and then tested." + test.toString());
                            }
                        } else {
                            boolean visible = this.getVisible(test);
                            ValidatorTestcase tmd = new ValidatorTestcase(pluginId, projectName, vmd, inputFileName, visible);
                            tmd.setMessages(this.getMessages(tmd, test));
                            HashSet<ValidatorTestcase> prjTmd = (HashSet<ValidatorTestcase>)this._validatorTests.get(projectName);
                            if (prjTmd == null) {
                                prjTmd = new HashSet<ValidatorTestcase>();
                            }
                            prjTmd.add(tmd);
                            this._validatorTests.put(projectName, prjTmd);
                        }
                    }
                }
                ++i;
            }
        }

        private ValidatorMetaData getValidatorMetaData(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "IConfigurationElement is null");
                }
                return null;
            }
            String validatorClass = element.getAttribute("validator");
            try {
                Logger logger;
                ValidatorMetaData vmd;
                Logger logger2;
                if (validatorClass == null && (logger2 = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                    logger2.write(Level.SEVERE, "Cannot locate validator attribute");
                }
                if ((vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClass)) == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "Could not find validator " + validatorClass);
                }
                return vmd;
            }
            catch (Throwable exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "Throwable caught while retrieving IValidator " + validatorClass);
                    logger.write(Level.SEVERE, exc);
                }
                return null;
            }
        }

        private void readTestcaseRegistry(IProgressMonitor monitor) {
            IExtensionPoint validatorEP = this.getTestcaseExtensionPoint();
            if (validatorEP == null) {
                return;
            }
            IExtension[] extensions = validatorEP.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                this.readTestcaseExtension(monitor, extensions[i]);
                ++i;
            }
        }

        private void readTestcaseExtension(IProgressMonitor monitor, IExtension extension) {
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements == null || elements.length == 0) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "No tests found for " + extension.getLabel());
                }
                return;
            }
            this.addTest(monitor, extension, elements);
        }

        private IExtensionPoint getTestcaseExtensionPoint() {
            Logger logger;
            IPluginRegistry registry = Platform.getPluginRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jst.validation.test", "test");
            if (extensionPoint == null && (logger = BVTValidationPlugin.getPlugin().getMsgLogger()).isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, "org.eclipse.jst.validation.test.test has been removed from the validation TVT plugin.xml file");
            }
            return extensionPoint;
        }

        private boolean getVisible(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "getVisible::IConfigurationElement is null");
                }
                return false;
            }
            String attrib = element.getAttribute("visible");
            if (attrib == null) {
                return true;
            }
            return Boolean.valueOf(attrib);
        }

        private String getInputFileName(IConfigurationElement element) {
            if (element == null) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, "getInputFileName::IConfigurationElement is null");
                }
                return null;
            }
            return element.getAttribute("input");
        }
    }
}

