/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.junit;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.BufferedTaskStatus;
import org.eclipse.jst.validation.test.setup.IBuffer;

public class JUnitBuffer
implements IBuffer {
    private String _logFileName = null;
    private BufferedTaskStatus _status = null;

    JUnitBuffer(String logFileName) {
        this._status = new BufferedTaskStatus(this.getLogFileName(logFileName), (IProgressMonitor)new NullProgressMonitor());
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this._status.setProgressMonitor(monitor);
    }

    private String getLogFileName(String logFileName) {
        if (this._logFileName == null) {
            logFileName = logFileName.replace(' ', '_');
            IPath stateLocation = BVTValidationPlugin.getPlugin().getStateLocation();
            File log = new File(stateLocation.toOSString(), logFileName);
            this._logFileName = log.getAbsolutePath();
        }
        return this._logFileName;
    }

    public String getLogFileName() {
        return this._status.getLogFileName();
    }

    public void clear() {
        this._status.clear();
    }

    public void delineate(String taskName) {
        this._status.delineate(taskName);
    }

    public IProgressMonitor getProgressMonitor() {
        return this._status.getProgressMonitor();
    }

    public void report() {
        this._status.report();
    }

    public void write(String message) {
        this._status.write(message);
    }

    public void addElapsedTime(String taskName, long elapsedTime) {
        this._status.addElapsedTime(taskName, elapsedTime);
    }

    public void addExecutionStatus(String testcaseName, String subTaskName, int passOrFail, IBuffer buffer, String message) {
        this._status.addExecutionStatus(testcaseName, subTaskName, passOrFail, buffer, message);
    }

    public void addExecutionStatus(String testPassName, boolean pass) {
        this._status.addExecutionStatus(testPassName, pass);
    }

    public void addExecutionStatus(String testPassName, String subTaskName, boolean pass) {
        this._status.addExecutionStatus(testPassName, subTaskName, pass);
    }

    public boolean isSuccessful() {
        return this._status.isSuccessful();
    }

    public boolean isSuccessful(String testName) {
        return this._status.isSuccessful(testName);
    }
}

