/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.tests;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanAction
extends TestCase {
    public void testIt() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.scanProject(project);
                ++n2;
            }
        }
    }

    protected void scanProject(IProject project) {
        System.out.println("************************************");
        System.out.println("Project: " + project.getName());
        IFile file = project.getFile("plugin.properties");
        if (!file.exists()) {
            System.out.println("  plugin.properties not found");
            return;
        }
        Properties props = new Properties();
        InputStream in = null;
        try {
            try {
                in = file.getContents();
                props.load(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (Exception exception) {}
        ArrayList<String> propsFound = new ArrayList<String>();
        ArrayList<String> newProps = new ArrayList<String>();
        this.scanContainer((IContainer)project, props, propsFound, newProps);
        System.out.println("Unused properties:");
        if (props.size() == propsFound.size()) {
            System.out.println("  None");
        } else {
            for (String string : props.keySet()) {
                if (propsFound.contains(string)) continue;
                System.out.println("  " + string);
            }
        }
        System.out.println("New properties:");
        if (newProps.size() == 0) {
            System.out.println("  None");
        } else {
            for (String string : newProps) {
                System.out.println("  " + string);
            }
        }
    }

    protected void scanContainer(IContainer container, Properties props, List<String> propsFound, List<String> newProps) {
        if (container == null || !container.exists()) {
            return;
        }
        try {
            IResource[] resources = container.members();
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFile) {
                        String[] found = this.scanFile((IFile)resource);
                        if (found != null) {
                            String[] stringArray = found;
                            int n3 = found.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String f = stringArray[n4];
                                if (props.containsKey(f)) {
                                    if (!propsFound.contains(f)) {
                                        propsFound.add(f);
                                    }
                                } else {
                                    newProps.add(f);
                                }
                                ++n4;
                            }
                        }
                    } else if (resource instanceof IContainer) {
                        this.scanContainer((IContainer)resource, props, propsFound, newProps);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String[] scanFile(IFile file) {
        if (file == null || !file.exists()) {
            return new String[0];
        }
        if (!file.getName().endsWith("java") && !file.getName().endsWith("xml")) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(file.getContents()));
            String line = br.readLine();
            while (line != null) {
                int index = line.indexOf("%");
                while (index >= 0) {
                    int end = line.indexOf("\"", index + 1);
                    if (end >= 0) {
                        String s = line.substring(index + 1, end);
                        list.add(s);
                    }
                    index = line.indexOf("%", index + 1);
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }
}

