/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPBatchValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "batchvalidation";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/batchvalidation", "/batchvalidation");
        }
        JSPBatchValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testValidating2Files() throws Exception {
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath1 = "/batchvalidation/WebContent/ihaveerrors.jsp";
        IFile file1 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file1.exists());
        String filePath2 = "/batchvalidation/WebContent/ihaveerrors2.jsp";
        IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file2.exists());
        helper.setURIs(new String[]{filePath1, filePath2});
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPBatchValidatorTest.assertTrue((String)"jsp errors were not found in both files", (reporter.getMessages().size() == 2 ? 1 : 0) != 0);
    }
}

