/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.performance;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jst.j2ee.tests.performance.BasePerformanceTestCase;
import org.eclipse.jst.j2ee.tests.performance.PerformanceTestObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCaseSAXParser
extends DefaultHandler {
    private static Map performanceCases = null;
    private static final String TEST_CASE = "testCase";
    private static final String CLASS = "class";
    private static final String METHOD = "method";
    private static final String SHORT_NAME = "shortName";
    private static final String TAGGING = "tagging";
    private static final String METHOD_NAME = "name";
    private static final String GLOBAL = "GLOBAL";
    private static final String LOCAL = "LOCAL";
    private static Class currentClazz = null;

    public Map doLoad(File file) {
        performanceCases = new HashMap();
        TestCaseSAXParser handler = new TestCaseSAXParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException ex) {
            System.err.println("Failed to create SAX parser:" + ex);
        }
        catch (SAXException ex) {
            System.err.println("SAX parser exceeption:" + ex);
        }
        catch (IOException ex) {
            System.err.println("IO exeception:" + ex);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Invalid file argument" + ex);
        }
        return performanceCases;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (qualifiedName.equals(TEST_CASE)) {
            int i = 0;
            while (i < attributes.getLength()) {
                if (attributes.getQName(i).equalsIgnoreCase(CLASS)) {
                    try {
                        currentClazz = this.loadClass(attributes.getValue(i));
                        if (performanceCases.get(currentClazz) == null) {
                            ArrayList methodList = new ArrayList();
                            performanceCases.put(currentClazz, methodList);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        currentClazz = null;
                        System.err.println("Failed to load class:" + attributes.getValue(i));
                    }
                }
                ++i;
            }
        } else if (qualifiedName.equalsIgnoreCase(METHOD)) {
            String methodName = null;
            int tagging = 0;
            String shortName = null;
            if (currentClazz == null) {
                return;
            }
            int i = 0;
            while (i < attributes.getLength()) {
                if (attributes.getQName(i).equalsIgnoreCase(METHOD_NAME)) {
                    methodName = attributes.getValue(i);
                } else if (attributes.getQName(i).equalsIgnoreCase(TAGGING)) {
                    tagging = attributes.getValue(i).equalsIgnoreCase(GLOBAL) ? 2 : (attributes.getValue(i).equalsIgnoreCase(LOCAL) ? 1 : 0);
                } else if (attributes.getQName(i).equalsIgnoreCase(SHORT_NAME)) {
                    shortName = attributes.getValue(i);
                }
                ++i;
            }
            List methodList = (List)performanceCases.get(currentClazz);
            methodList.add(new PerformanceTestObject(methodName, tagging, shortName));
        }
    }

    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        if (qualifiedName.equals(TEST_CASE)) {
            currentClazz = null;
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        return this.getClassLoader().loadClass(className);
    }

    protected ClassLoader getClassLoader() {
        return BasePerformanceTestCase.getClassLoader();
    }
}

