/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.filesystem;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jst.validation.sample.filesystem.FilesystemLoader;
import org.eclipse.jst.validation.sample.filesystem.IFilesystemHelper;
import org.eclipse.wst.validation.internal.core.FileDelta;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class FilesystemManager {
    private static FilesystemManager _inst = null;
    private Set _loaders = new HashSet();

    private FilesystemManager() {
        try {
            this._loaders.add(new FilesystemLoader(new String[]{".properties"}, FilesystemManager.loadHelper("org.eclipse.jst.validation.sample.filesystemimpl.FilesystemPropertiesHelper"), FilesystemManager.loadValidator("org.eclipse.jst.validation.sample.PropertiesValidator")));
        }
        catch (IllegalArgumentException exc) {
            exc.printStackTrace();
        }
        catch (ClassNotFoundException exc) {
            exc.printStackTrace();
        }
        catch (IllegalAccessException exc) {
            exc.printStackTrace();
        }
        catch (InstantiationException exc) {
            exc.printStackTrace();
        }
    }

    private static IFilesystemHelper loadHelper(String className) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (IFilesystemHelper)FilesystemManager.loadClass(className);
    }

    private static IValidator loadValidator(String className) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (IValidator)FilesystemManager.loadClass(className);
    }

    private static Object loadClass(String className) throws IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (className == null) {
            throw new IllegalArgumentException("loadClass argument must not be null");
        }
        Class<?> clazz = Class.forName(className);
        return clazz.newInstance();
    }

    public static FilesystemManager getManager() {
        if (_inst == null) {
            _inst = new FilesystemManager();
        }
        return _inst;
    }

    public IFileDelta[] getFileDeltas(String[] fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            return null;
        }
        FileDelta[] files = new FileDelta[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            files[i] = new FileDelta(fileNames[i], 2);
            ++i;
        }
        return files;
    }

    public FilesystemLoader[] getLoaders(IFileDelta[] deltas) {
        if (deltas == null) {
            return this.getAllLoaders();
        }
        HashSet<FilesystemLoader> loaders = new HashSet<FilesystemLoader>();
        int i = 0;
        while (i < deltas.length) {
            FilesystemLoader[] loaderArray = this.getLoadersFor(deltas[i]);
            if (loaderArray != null) {
                int j = 0;
                while (j < loaderArray.length) {
                    loaders.add(loaderArray[j]);
                    ++j;
                }
            }
            ++i;
        }
        FilesystemLoader[] result = new FilesystemLoader[loaders.size()];
        loaders.toArray(result);
        return result;
    }

    public IFilesystemHelper getHelper(IValidator validator) {
        if (validator == null) {
            return null;
        }
        Iterator iterator = this._loaders.iterator();
        while (iterator.hasNext()) {
            FilesystemLoader loader = (FilesystemLoader)iterator.next();
            if (!validator.equals(loader.getValidator())) continue;
            return loader.getHelper();
        }
        return null;
    }

    public IValidator getValidator(String validatorClassName) {
        if (validatorClassName == null) {
            return null;
        }
        Iterator iterator = this._loaders.iterator();
        while (iterator.hasNext()) {
            FilesystemLoader loader = (FilesystemLoader)iterator.next();
            if (!validatorClassName.equals(loader.getValidator().getClass().getName())) continue;
            return loader.getValidator();
        }
        return null;
    }

    public FilesystemLoader[] getAllLoaders() {
        FilesystemLoader[] result = new FilesystemLoader[this._loaders.size()];
        this._loaders.toArray(result);
        return result;
    }

    public FilesystemLoader[] getLoadersFor(IFileDelta delta) {
        Iterator iterator = this._loaders.iterator();
        FilesystemLoader[] tempLoaders = new FilesystemLoader[this._loaders.size()];
        int count = 0;
        while (iterator.hasNext()) {
            FilesystemLoader loader = (FilesystemLoader)iterator.next();
            String[] fileExtensions = loader.getFileExtensions();
            if (fileExtensions == null) continue;
            int i = 0;
            while (i < fileExtensions.length) {
                if (delta.getFileName().endsWith(fileExtensions[i]) && (delta.getDeltaType() == 1 || delta.getDeltaType() == 2 || delta.getDeltaType() == 3)) {
                    tempLoaders[count++] = loader;
                }
                ++i;
            }
        }
        FilesystemLoader[] result = new FilesystemLoader[count];
        System.arraycopy(tempLoaders, 0, result, 0, count);
        return result;
    }
}

