/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.modelListeners;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfoSupplier;
import org.eclipse.jem.tests.modelListeners.IListenerTester;

public class TestBeaninfoAdapterFactory
extends BeaninfoAdapterFactory
implements IListenerTester {
    int callIndex = -1;
    AssertionFailedError exception;
    protected int[] callTypes;
    protected Object[] callArgs;
    public static final int MARK_ALL_STALE = 0;
    public static final int MARK_STALE_INTROSPECTION = 1;
    public static final int MARK_STALE_INTROSPECTION_PLUS_INNER = 2;
    public static final int MARK_PACKAGE_STALE = 3;
    private static final String[] callTypeNames = new String[]{"MARK_ALL_STALE", "MARK_STALE_INTROSPECTION", "MARK_STALE_INTROSPECTION_PLUS_INNER", "MARK_PACKAGE_STALE", "UNREGISTER_INTROSPECTION", "UNREGISTER_INTROSPECTION_PLUS_INNER"};

    public TestBeaninfoAdapterFactory(IBeaninfoSupplier supplier) {
        super(supplier);
    }

    public void setTestCases(int[] callTypes, Object[] callArgs) {
        this.callTypes = callTypes;
        this.callArgs = callArgs;
    }

    public void isException() throws AssertionFailedError {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void isComplete() throws AssertionFailedError {
        Assert.assertEquals((String)"Did not complete all notifcations. ", (int)this.callTypes.length, (int)(this.callIndex + 1));
    }

    protected boolean testCallType(int callType) {
        if (this.exception != null) {
            return false;
        }
        try {
            if (++this.callIndex >= this.callTypes.length) {
                Assert.fail((String)("An extra notification of type " + callTypeNames[callType] + " received."));
            }
            if (this.callTypes[this.callIndex] != callType) {
                Assert.assertEquals((String)callTypeNames[this.callTypes[this.callIndex]], (String)callTypeNames[callType]);
            }
        }
        catch (AssertionFailedError e) {
            this.exception = e;
            return false;
        }
        return true;
    }

    public void markAllStale() {
        this.testCallType(0);
    }

    public void markStaleIntrospection(String sourceName, boolean clearResults) {
        if (this.testCallType(1)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)sourceName);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)clearResults);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public void markStaleIntrospectionPlusInner(String sourceName, boolean clearResults) {
        if (this.testCallType(2)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)sourceName);
                Assert.assertEquals((boolean)((Boolean)((Object[])this.callArgs[this.callIndex])[1]), (boolean)clearResults);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }

    public void markPackageStale(String packageName) {
        if (this.testCallType(3)) {
            try {
                Assert.assertEquals((String)((String)((Object[])this.callArgs[this.callIndex])[0]), (String)packageName);
            }
            catch (AssertionFailedError e) {
                this.exception = e;
            }
        }
    }
}

