/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;

public class ComponentSummary {
    public static final String INDEX_COMPONENT_SUMMARY_XML = "index-comp-summary.xml";
    private static final String ROOT_TAG_NAME = "component-summary";
    private String timestamp;
    private Map entries = new HashMap(1);

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void add(ComponentEntry entry) {
        this.entries.put(entry.getCompName(), entry);
    }

    public ComponentEntry getEntry(String compName) {
        return (ComponentEntry)this.entries.get(compName);
    }

    public List getEntries() {
        return new ArrayList(this.entries.values());
    }

    protected void saveAsHTML(ILocation html, String xsl, String rootTagName) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream(xsl)));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.getBytes(html, rootTagName))), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
    }

    public void save(ILocation location) throws IOException {
        this.save(location, ROOT_TAG_NAME);
    }

    protected void save(ILocation location, String rootTagName) throws IOException {
        File file = new File(location.getAbsolutePath());
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(this.getBytes(location, rootTagName));
        fos.close();
    }

    protected byte[] getBytes(ILocation location, String rootTagName) throws UnsupportedEncodingException {
        String base = location.getAbsolutePath().replace('\\', '/');
        int index = base.lastIndexOf(47);
        if (index != -1) {
            base = base.substring(0, index);
        }
        Iterator it = this.entries.values().iterator();
        while (it.hasNext()) {
            ComponentEntry entry = (ComponentEntry)it.next();
            String ref = entry.getRef();
            if (ref == null || !ref.startsWith(base)) continue;
            StringBuffer newRef = new StringBuffer(".");
            newRef.append(ref.substring(base.length()));
            entry.setRef(newRef.toString());
        }
        return this.toString(rootTagName).getBytes();
    }

    public String toString(String rootTagName) {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<");
        sb.append(rootTagName);
        if (this.timestamp != null) {
            sb.append(" timestamp=\"");
            sb.append(this.timestamp);
            sb.append("\"");
        }
        sb.append(">");
        Iterator it = this.entries.values().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        sb.append("</");
        sb.append(rootTagName);
        sb.append(">");
        return sb.toString();
    }

    public String toString() {
        return this.toString(ROOT_TAG_NAME);
    }
}

