/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.SecondaryTableDialog;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecondaryTablesComposite<T extends Entity>
extends AbstractFormPane<T> {
    public AbstractSecondaryTablesComposite(AbstractFormPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    public AbstractSecondaryTablesComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(subjectHolder, parent, (FormToolkit)widgetFactory);
    }

    private void addSecondaryTableFromDialog(SecondaryTableDialog dialog, ObjectListSelectionModel listSelectionModel) {
        if (dialog.open() == 0) {
            int index = ((Entity)this.subject()).specifiedSecondaryTablesSize();
            String name = dialog.getSelectedName();
            String catalog = dialog.getSelectedCatalog();
            String schema = dialog.getSelectedSchema();
            SecondaryTable secondaryTable = ((Entity)this.subject()).addSpecifiedSecondaryTable(index);
            secondaryTable.setSpecifiedName(name);
            if (!dialog.isDefaultCatalogSelected()) {
                secondaryTable.setSpecifiedCatalog(catalog);
            }
            if (!dialog.isDefaultSchemaSelected()) {
                secondaryTable.setSpecifiedSchema(schema);
            }
            listSelectionModel.setSelectedValue((Object)secondaryTable);
        }
    }

    protected WritablePropertyValueModel<SecondaryTable> buildSecondaryTableHolder() {
        return new SimplePropertyValueModel();
    }

    protected ILabelProvider buildSecondaryTableLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                SecondaryTable secondaryTable = (SecondaryTable)element;
                if (secondaryTable.getName() != null) {
                    return secondaryTable.getName();
                }
                return "";
            }
        };
    }

    protected SecondaryTableDialog buildSecondaryTableDialogForAdd() {
        return new SecondaryTableDialog(this.getControl().getShell(), ((Entity)this.subject()).getJpaProject(), ((Entity)this.subject()).getTable().getDefaultSchema(), ((Entity)this.subject()).getTable().getDefaultCatalog());
    }

    protected AddRemovePane.Adapter buildSecondaryTablesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                SecondaryTableDialog dialog = AbstractSecondaryTablesComposite.this.buildSecondaryTableDialogForAdd();
                AbstractSecondaryTablesComposite.this.addSecondaryTableFromDialog(dialog, listSelectionModel);
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.SecondaryTablesComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                SecondaryTableDialog dialog = new SecondaryTableDialog(AbstractSecondaryTablesComposite.this.getControl().getShell(), secondaryTable, ((Entity)AbstractSecondaryTablesComposite.this.subject()).getJpaProject());
                AbstractSecondaryTablesComposite.this.editSecondaryTableFromDialog(dialog, secondaryTable);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Entity entity = (Entity)AbstractSecondaryTablesComposite.this.subject();
                int[] selectedIndices = listSelectionModel.selectedIndices();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    entity.removeSpecifiedSecondaryTable(selectedIndices[index]);
                }
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                if (listSelectionModel.selectedValuesSize() != 1) {
                    return false;
                }
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                return !secondaryTable.isVirtual();
            }

            @Override
            public boolean enableRemoveOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                if (listSelectionModel.selectedValue() == null) {
                    return false;
                }
                SecondaryTable secondaryTable = (SecondaryTable)listSelectionModel.selectedValue();
                return !secondaryTable.isVirtual();
            }
        };
    }

    private void editSecondaryTableDialogOkd(SecondaryTableDialog dialog, SecondaryTable secondaryTable) {
        String name = dialog.getSelectedName();
        String catalog = dialog.getSelectedCatalog();
        String schema = dialog.getSelectedSchema();
        if (secondaryTable.getSpecifiedName() == null || !secondaryTable.getSpecifiedName().equals(name)) {
            secondaryTable.setSpecifiedName(name);
        }
        if (dialog.isDefaultCatalogSelected()) {
            if (secondaryTable.getSpecifiedCatalog() != null) {
                secondaryTable.setSpecifiedCatalog(null);
            }
        } else if (secondaryTable.getSpecifiedCatalog() == null || !secondaryTable.getSpecifiedCatalog().equals(catalog)) {
            secondaryTable.setSpecifiedCatalog(catalog);
        }
        if (dialog.isDefaultSchemaSelected()) {
            if (secondaryTable.getSpecifiedSchema() != null) {
                secondaryTable.setSpecifiedSchema(null);
            }
        } else if (secondaryTable.getSpecifiedSchema() == null || !secondaryTable.getSpecifiedSchema().equals(schema)) {
            secondaryTable.setSpecifiedSchema(schema);
        }
    }

    private void editSecondaryTableFromDialog(SecondaryTableDialog dialog, SecondaryTable secondaryTable) {
        if (dialog.open() == 0) {
            this.editSecondaryTableDialogOkd(dialog, secondaryTable);
        }
    }
}

