/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EJBRelation;
import org.eclipse.jst.javaee.ejb.EJBRelationshipRole;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.InterceptorType;
import org.eclipse.jst.javaee.ejb.InterceptorsType;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.RelationshipRoleSourceType;
import org.eclipse.jst.javaee.ejb.Relationships;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.mergers.EjbJarMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class EjbJarMergerTest
extends TestCase {
    public void testZeroMerge() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNull((Object)merge.getEnterpriseBeans());
    }

    public void testZeroMerge2() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
    }

    public void testZeroMerge3() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNull((Object)merge.getEnterpriseBeans());
    }

    public void testSesionBeansBase() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        SessionBean sessionBean = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getSessionBeans().size());
    }

    public void testSesionBeansMerge() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        SessionBean sessionBean = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean.setEjbName("name");
        merge.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getSessionBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getSessionBeans().size());
    }

    public void testSesionBeansMergeSameBean() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        SessionBean sessionBean = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        merge.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getSessionBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getSessionBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getSessionBean("name", base.getEnterpriseBeans().getSessionBeans()));
    }

    private SessionBean getSessionBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            SessionBean sBean = (SessionBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    public void testSessionBeanComplex() throws Exception {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        SessionBean sessionBean = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean.setEjbName("name");
        SessionBean sessionBean1 = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean1.setEjbName("name1");
        SessionBean sessionBean2 = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean2.setEjbName("name2");
        SessionBean sessionBean3 = EjbFactory.eINSTANCE.createSessionBean();
        sessionBean3.setEjbName("name3");
        base.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        base.getEnterpriseBeans().getSessionBeans().add(sessionBean1);
        base.getEnterpriseBeans().getSessionBeans().add(sessionBean3);
        merge.getEnterpriseBeans().getSessionBeans().add(sessionBean);
        merge.getEnterpriseBeans().getSessionBeans().add(sessionBean2);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)4, (int)base.getEnterpriseBeans().getSessionBeans().size());
        EjbJarMergerTest.assertEquals((int)2, (int)merge.getEnterpriseBeans().getSessionBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getSessionBean("name", base.getEnterpriseBeans().getSessionBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getSessionBean("name1", base.getEnterpriseBeans().getSessionBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getSessionBean("name2", base.getEnterpriseBeans().getSessionBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getSessionBean("name3", base.getEnterpriseBeans().getSessionBeans()));
    }

    public void testMdbBeansBase() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        MessageDrivenBean sessionBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getMessageDrivenBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getMessageDrivenBeans().size());
    }

    public void tesMdbBeansMerge() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        MessageDrivenBean sessionBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        sessionBean.setEjbName("name");
        merge.getEnterpriseBeans().getMessageDrivenBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getMessageDrivenBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getMessageDrivenBeans().size());
    }

    public void testMdbBeansMergeSameBean() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        MessageDrivenBean sessionBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getMessageDrivenBeans().add(sessionBean);
        merge.getEnterpriseBeans().getMessageDrivenBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getMessageDrivenBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getMessageDrivenBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getMdbBean("name", base.getEnterpriseBeans().getMessageDrivenBeans()));
    }

    private MessageDrivenBean getMdbBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            MessageDrivenBean sBean = (MessageDrivenBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    public void testMdbBeanComplex() throws Exception {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        MessageDrivenBean messageBean = EjbFactory.eINSTANCE.createMessageDrivenBean();
        messageBean.setEjbName("name");
        MessageDrivenBean messageBean1 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        messageBean1.setEjbName("name1");
        MessageDrivenBean messageBean2 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        messageBean2.setEjbName("name2");
        MessageDrivenBean messageBean3 = EjbFactory.eINSTANCE.createMessageDrivenBean();
        messageBean3.setEjbName("name3");
        base.getEnterpriseBeans().getMessageDrivenBeans().add(messageBean);
        base.getEnterpriseBeans().getMessageDrivenBeans().add(messageBean1);
        base.getEnterpriseBeans().getMessageDrivenBeans().add(messageBean3);
        merge.getEnterpriseBeans().getMessageDrivenBeans().add(messageBean);
        merge.getEnterpriseBeans().getMessageDrivenBeans().add(messageBean2);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)4, (int)base.getEnterpriseBeans().getMessageDrivenBeans().size());
        EjbJarMergerTest.assertEquals((int)2, (int)merge.getEnterpriseBeans().getMessageDrivenBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getMdbBean("name", base.getEnterpriseBeans().getMessageDrivenBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getMdbBean("name1", base.getEnterpriseBeans().getMessageDrivenBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getMdbBean("name2", base.getEnterpriseBeans().getMessageDrivenBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getMdbBean("name3", base.getEnterpriseBeans().getMessageDrivenBeans()));
    }

    public void testEntityBeansBase() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        EntityBean sessionBean = EjbFactory.eINSTANCE.createEntityBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getEntityBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getEntityBeans().size());
    }

    public void testEntityBeansMerge() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        EntityBean sessionBean = EjbFactory.eINSTANCE.createEntityBean();
        sessionBean.setEjbName("name");
        merge.getEnterpriseBeans().getEntityBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getEntityBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getEntityBeans().size());
    }

    public void testEntityBeansMergeSameBean() throws ModelException {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        EntityBean sessionBean = EjbFactory.eINSTANCE.createEntityBean();
        sessionBean.setEjbName("name");
        base.getEnterpriseBeans().getEntityBeans().add(sessionBean);
        merge.getEnterpriseBeans().getEntityBeans().add(sessionBean);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getEnterpriseBeans().getEntityBeans().size());
        EjbJarMergerTest.assertEquals((int)1, (int)merge.getEnterpriseBeans().getEntityBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getEntityBean("name", base.getEnterpriseBeans().getEntityBeans()));
    }

    private EntityBean getEntityBean(String name, List enterpriseBeans) {
        for (Object bean : enterpriseBeans) {
            EntityBean sBean = (EntityBean)bean;
            if (!sBean.getEjbName().equals(name)) continue;
            return sBean;
        }
        return null;
    }

    public void testEntityBeanComplex() throws Exception {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        base.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        merge.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
        EntityBean entityBean = EjbFactory.eINSTANCE.createEntityBean();
        entityBean.setEjbName("name");
        EntityBean entityBean1 = EjbFactory.eINSTANCE.createEntityBean();
        entityBean1.setEjbName("name1");
        EntityBean entityBean2 = EjbFactory.eINSTANCE.createEntityBean();
        entityBean2.setEjbName("name2");
        EntityBean entityBean3 = EjbFactory.eINSTANCE.createEntityBean();
        entityBean3.setEjbName("name3");
        base.getEnterpriseBeans().getEntityBeans().add(entityBean);
        base.getEnterpriseBeans().getEntityBeans().add(entityBean1);
        base.getEnterpriseBeans().getEntityBeans().add(entityBean3);
        merge.getEnterpriseBeans().getEntityBeans().add(entityBean);
        merge.getEnterpriseBeans().getEntityBeans().add(entityBean2);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getEnterpriseBeans());
        EjbJarMergerTest.assertNotNull((Object)merge.getEnterpriseBeans());
        EjbJarMergerTest.assertEquals((int)4, (int)base.getEnterpriseBeans().getEntityBeans().size());
        EjbJarMergerTest.assertEquals((int)2, (int)merge.getEnterpriseBeans().getEntityBeans().size());
        EjbJarMergerTest.assertNotNull((Object)this.getEntityBean("name", base.getEnterpriseBeans().getEntityBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getEntityBean("name1", base.getEnterpriseBeans().getEntityBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getEntityBean("name2", base.getEnterpriseBeans().getEntityBeans()));
        EjbJarMergerTest.assertNotNull((Object)this.getEntityBean("name3", base.getEnterpriseBeans().getEntityBeans()));
    }

    public void testGenericCopyBase() throws Exception {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        InterceptorsType interceptorsType = EjbFactory.eINSTANCE.createInterceptorsType();
        InterceptorType type = EjbFactory.eINSTANCE.createInterceptorType();
        interceptorsType.getInterceptors().add(type);
        type.setInterceptorClass("test");
        base.setInterceptors(interceptorsType);
        Relationships relationships = EjbFactory.eINSTANCE.createRelationships();
        EJBRelation relation = EjbFactory.eINSTANCE.createEJBRelation();
        EJBRelationshipRole relationshipRole = EjbFactory.eINSTANCE.createEJBRelationshipRole();
        RelationshipRoleSourceType roleSourceType = EjbFactory.eINSTANCE.createRelationshipRoleSourceType();
        roleSourceType.setEjbName("testEjbName");
        String roleName = "RelationshpiRoleName";
        relationshipRole.setEjbRelationshipRoleName("nm");
        relationshipRole.setRelationshipRoleSource(roleSourceType);
        relation.getEjbRelationshipRoles().add(relationshipRole);
        relation.setEjbRelationName(roleName);
        relationships.getEjbRelations().add(relation);
        base.setRelationships(relationships);
        String clientJar = "ejbClientJar";
        base.setEjbClientJar(clientJar);
        String version = "99";
        base.setVersion(version);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getInterceptors());
        EjbJarMergerTest.assertNotNull((Object)base.getInterceptors().getInterceptors());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getInterceptors().getInterceptors().size());
        EjbJarMergerTest.assertEquals((String)"test", (String)((InterceptorType)base.getInterceptors().getInterceptors().get(0)).getInterceptorClass());
        EjbJarMergerTest.assertNotNull((Object)base.getRelationships());
        EjbJarMergerTest.assertNotNull((Object)base.getRelationships().getEjbRelations());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getRelationships().getEjbRelations().size());
        EjbJarMergerTest.assertEquals((String)roleName, (String)((EJBRelation)base.getRelationships().getEjbRelations().get(0)).getEjbRelationName());
        EjbJarMergerTest.assertEquals((String)clientJar, (String)base.getEjbClientJar());
    }

    public void testGenericCopyMerge() throws Exception {
        EJBJar base = EjbFactory.eINSTANCE.createEJBJar();
        EJBJar merge = EjbFactory.eINSTANCE.createEJBJar();
        InterceptorsType interceptorsType = EjbFactory.eINSTANCE.createInterceptorsType();
        InterceptorType type = EjbFactory.eINSTANCE.createInterceptorType();
        interceptorsType.getInterceptors().add(type);
        type.setInterceptorClass("test");
        merge.setInterceptors(interceptorsType);
        Relationships relationships = EjbFactory.eINSTANCE.createRelationships();
        EJBRelation relation = EjbFactory.eINSTANCE.createEJBRelation();
        EJBRelationshipRole relationshipRole = EjbFactory.eINSTANCE.createEJBRelationshipRole();
        RelationshipRoleSourceType roleSourceType = EjbFactory.eINSTANCE.createRelationshipRoleSourceType();
        roleSourceType.setEjbName("testEjbName");
        String roleName = "RelationshpiRoleName";
        relationshipRole.setEjbRelationshipRoleName("nm");
        relationshipRole.setRelationshipRoleSource(roleSourceType);
        relation.getEjbRelationshipRoles().add(relationshipRole);
        relation.setEjbRelationName(roleName);
        relationships.getEjbRelations().add(relation);
        merge.setRelationships(relationships);
        String clientJar = "ejbClientJar";
        merge.setEjbClientJar(clientJar);
        new EjbJarMerger((JavaEEObject)base, (JavaEEObject)merge, 0).process();
        EjbJarMergerTest.assertNotNull((Object)base.getInterceptors());
        EjbJarMergerTest.assertNotNull((Object)base.getInterceptors().getInterceptors());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getInterceptors().getInterceptors().size());
        EjbJarMergerTest.assertEquals((String)"test", (String)((InterceptorType)base.getInterceptors().getInterceptors().get(0)).getInterceptorClass());
        EjbJarMergerTest.assertNotNull((Object)base.getRelationships());
        EjbJarMergerTest.assertNotNull((Object)base.getRelationships().getEjbRelations());
        EjbJarMergerTest.assertEquals((int)1, (int)base.getRelationships().getEjbRelations().size());
        EjbJarMergerTest.assertEquals((String)roleName, (String)((EJBRelation)base.getRelationships().getEjbRelations().get(0)).getEjbRelationName());
        EjbJarMergerTest.assertEquals((String)clientJar, (String)base.getEjbClientJar());
    }
}

