/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.cleanupformat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;

public class FormatTester
extends TestCase {
    private static final boolean PRINT_FAILED_FORMAT_TESTS = false;
    protected IModelManager fModelManager = StructuredModelManager.getModelManager();
    protected FormatProcessorXML fFormatProcessor = new FormatProcessorXML();
    protected HTMLFormatProcessorImpl fHTMLFormatProcessor = new HTMLFormatProcessorImpl();

    public FormatTester(String name) {
        super(name);
    }

    public void testFormat261968() {
        IStructuredModel structuredModel = this.getModel("261968.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "261968.afterDefaultFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatTagOpen() {
        IStructuredModel structuredModel = this.getModel("tagOpen.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "tagOpen.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatTagOpenTagClose() {
        IStructuredModel structuredModel = this.getModel("tagOpenTagClose.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "tagOpenTagClose.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatTags() {
        IStructuredModel structuredModel = this.getModel("tags.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "tags.afterDefaultFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatEmpty() {
        IStructuredModel structuredModel = this.getModel("empty.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "empty.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatOneSpace() {
        IStructuredModel structuredModel = this.getModel("oneSpace.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "empty.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatOneChar() {
        IStructuredModel structuredModel = this.getModel("oneChar.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "oneChar.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatSpaces() {
        IStructuredModel structuredModel = this.getModel("spaces.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "empty.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatChars() {
        IStructuredModel structuredModel = this.getModel("chars.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "chars.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatSpacesAndChars() {
        IStructuredModel structuredModel = this.getModel("spacesAndChars.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "chars.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormat() {
        IStructuredModel structuredModel = this.getModel("small.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "small.afterDefaultFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatSplitLinesSplitMultiAttrs() {
        IStructuredModel structuredModel = this.getModel("small.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(true);
        formatPreferences.setLineWidth(72);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "small.afterSplitLinesSplitMultiAttrsFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatSplitLines() {
        IStructuredModel structuredModel = this.getModel("small.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(72);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "small.afterSplitLinesFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatBlockComments() {
        IStructuredModel structuredModel = this.getModel("blockComments.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "blockComments.afterDefaultFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatInlineComments() {
        IStructuredModel structuredModel = this.getModel("inlineComments.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(999);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "inlineComments.afterDefaultFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testFormatInlineCommentsSplitLinesSplitMultiAttrs() {
        IStructuredModel structuredModel = this.getModel("inlineComments.xml");
        IStructuredFormatPreferences formatPreferences = this.fFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(true);
        formatPreferences.setLineWidth(72);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fFormatProcessor.refreshFormatPreferences = false;
        this.fFormatProcessor.formatModel(structuredModel);
        this.fFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "inlineComments.afterSplitLinesSplitMultiAttrsFormat.xml";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    public void testHTMLFormat() {
        IStructuredModel structuredModel = this.getModel("HitCounterIntro.html");
        IStructuredFormatPreferences formatPreferences = this.fHTMLFormatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
        formatPreferences.setLineWidth(72);
        formatPreferences.setIndent("\t");
        formatPreferences.setClearAllBlankLines(false);
        this.fHTMLFormatProcessor.refreshFormatPreferences = false;
        this.fHTMLFormatProcessor.formatModel(structuredModel);
        this.fHTMLFormatProcessor.refreshFormatPreferences = true;
        String formatted = structuredModel.getStructuredDocument().get();
        String expectedFileName = "HitCounterIntro.afterDefaultFormat.html";
        String expected = this.getFile(expectedFileName);
        this.compare(expectedFileName, expected, formatted);
        structuredModel.releaseFromRead();
    }

    protected String readFile(String fileName) {
        String inputString = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
            byte[] inputBuffer = new byte[1024];
            inputString = new String();
            int bytesRead = -1;
            while ((bytesRead = fileInputStream.read(inputBuffer)) != -1) {
                String bufferString = new String(inputBuffer);
                bufferString = bufferString.substring(0, bytesRead);
                inputString = inputString.concat(bufferString);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException exception) {
            StringWriter s = new StringWriter();
            exception.printStackTrace(new PrintWriter(s));
            FormatTester.fail((String)s.toString());
        }
        return inputString;
    }

    protected static void printException(Exception exception) {
        exception.printStackTrace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStructuredModel getModel(String fileName) {
        IStructuredModel structuredModel = null;
        InputStream inputStream = null;
        try {
            try {
                String input = this.getFile(fileName);
                inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
                String id = inputStream.toString().concat(fileName);
                structuredModel = this.fModelManager.getModelForRead(id, inputStream, null);
            }
            catch (Exception exception) {
                StringWriter s = new StringWriter();
                exception.printStackTrace(new PrintWriter(s));
                FormatTester.fail((String)s.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                StringWriter s = new StringWriter();
                exception.printStackTrace(new PrintWriter(s));
                FormatTester.fail((String)s.toString());
            }
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (Exception exception) {
            StringWriter s = new StringWriter();
            exception.printStackTrace(new PrintWriter(s));
            FormatTester.fail((String)s.toString());
            return structuredModel;
        }
        inputStream.close();
        return structuredModel;
    }

    protected String getFile(String fileName) {
        return this.readFile("testfiles/".concat(fileName));
    }

    protected void compare(String testcaseName, String expected, String formatted) {
        if (formatted.compareTo(expected) != 0) {
            FormatTester.assertTrue((boolean)false);
        }
    }
}

