/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.taglibindex;

import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;

public class TestIndex
extends TestCase {
    String wtp_autotest_noninteractive = null;
    int MAX_RETRYS = 5;
    int PAUSE_TIME = 1;
    boolean DEBUG = true;

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
        this.removeAllProjects();
    }

    public void testAvailableAfterAddingJARToBuildPath() throws Exception {
        String url = "http://example.com/sample2_for_118251-e";
        IProject project = BundleResourceUtil.createSimpleProject("bug_118251-e", null, null);
        TestIndex.assertTrue((boolean)project.exists());
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-e"));
        TestIndex.assertEquals((String)"wrong number of taglib records found before unpacking", (int)0, (int)records.length);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_118251-e", "/bug_118251-e");
        ITaglibRecord taglibRecord = TaglibIndex.resolve((String)"/bug_118251-e/WebContent/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNull((String)("unexpected record found for " + url), (Object)taglibRecord);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-e/WebContent/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after unpacking but before copying", (int)2, (int)records.length);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/bug_118251-e/WebContent/WEB-INF/sample_tld.jar");
        url = "http://example.com/sample-taglib";
        taglibRecord = TaglibIndex.resolve((String)"/bug_118251-e/WebContent/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNotNull((String)("expected record missing for " + url), (Object)taglibRecord);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-e/WebContent/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)3, (int)records.length);
    }

    public void testAvailableAfterCopyingJARIntoProject() throws Exception {
        IProject project = BundleResourceUtil.createSimpleProject("bug_118251-f", null, null);
        TestIndex.assertTrue((boolean)project.exists());
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f"));
        TestIndex.assertEquals((String)"wrong number of taglib records found before unpacking", (int)0, (int)records.length);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_118251-f", "/bug_118251-f");
        String url = "http://example.com/sample-taglib";
        ITaglibRecord taglibRecord = TaglibIndex.resolve((String)"/bug_118251-f/WebContent/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNull((String)("unexpected record found for " + url), (Object)taglibRecord);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f/WebContent/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after unpacking but before copying", (int)3, (int)records.length);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/bug_118251-f/WebContent/WEB-INF/lib/sample_tld.jar");
        taglibRecord = TaglibIndex.resolve((String)"/bug_118251-f/WebContent/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNotNull((String)("no record found for " + url), (Object)taglibRecord);
        TestIndex.assertTrue((String)"record found was wrong type", (boolean)(taglibRecord instanceof IURLRecord));
        TestIndex.assertNotNull((String)"record has no base location", (Object)((IURLRecord)taglibRecord).getBaseLocation());
        TestIndex.assertEquals((String)"record has wrong short name", (String)"sample", (String)((IURLRecord)taglibRecord).getShortName());
        TestIndex.assertEquals((String)"record has wrong URI", (String)url, (String)((IURLRecord)taglibRecord).getDescriptor().getURI());
        URL recordURL = ((IURLRecord)taglibRecord).getURL();
        TestIndex.assertNotNull((String)"record has no URL", (Object)recordURL);
        TestIndex.assertTrue((String)"record has wrong URL", (recordURL.toString().length() > 4 ? 1 : 0) != 0);
        TestIndex.assertEquals((String)"record has wrong URL protocol", (String)"jar:", (String)recordURL.toString().substring(0, 4));
        TestIndex.assertEquals((String)"record has wrong URL", (String)"/bug_118251-f/WebContent/WEB-INF/lib/sample_tld.jar!/folder/sample_for_118251.tld", (String)recordURL.toString().substring(recordURL.toString().length() - 81));
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f/WebContent/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f/WebContent"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f/WebContent/WEB-INF"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-f/WebContent/WEB-INF/web.xml"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
    }

    public void testAvailableAfterCopyingJARIntoProject2() throws Exception {
        IProject project = BundleResourceUtil.createSimpleProject("bug_118251-g", null, null);
        TestIndex.assertTrue((boolean)project.exists());
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g"));
        TestIndex.assertEquals((String)"wrong number of taglib records found before unpacking", (int)0, (int)records.length);
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_118251-g", "/bug_118251-g");
        String url = "http://example.com/sample-taglib";
        ITaglibRecord taglibRecord = TaglibIndex.resolve((String)"/bug_118251-g/Web Content/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNull((String)("unexpected record found for " + url), (Object)taglibRecord);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g/Web Content/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after unpacking but before copying", (int)3, (int)records.length);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/bug_118251-g/Web Content/WEB-INF/lib/sample_tld.jar");
        taglibRecord = TaglibIndex.resolve((String)"/bug_118251-g/Web Content/test1.jsp", (String)url, (boolean)false);
        TestIndex.assertNotNull((String)("no record found for " + url), (Object)taglibRecord);
        TestIndex.assertTrue((String)"record found was wrong type", (boolean)(taglibRecord instanceof IURLRecord));
        TestIndex.assertNotNull((String)"record has no base location", (Object)((IURLRecord)taglibRecord).getBaseLocation());
        TestIndex.assertEquals((String)"record has wrong short name", (String)"sample", (String)((IURLRecord)taglibRecord).getShortName());
        TestIndex.assertEquals((String)"record has wrong URI", (String)url, (String)((IURLRecord)taglibRecord).getDescriptor().getURI());
        URL recordURL = ((IURLRecord)taglibRecord).getURL();
        TestIndex.assertNotNull((String)"record has no URL", (Object)recordURL);
        TestIndex.assertTrue((String)"record has wrong URL", (recordURL.toString().length() > 4 ? 1 : 0) != 0);
        TestIndex.assertEquals((String)"record has wrong URL protocol", (String)"jar:", (String)recordURL.toString().substring(0, 4));
        TestIndex.assertEquals((String)"record has wrong URL", (String)"/bug_118251-g/Web Content/WEB-INF/lib/sample_tld.jar!/folder/sample_for_118251.tld", (String)recordURL.toString().substring(recordURL.toString().length() - 82));
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g/Web Content/"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g/Web Content"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g/Web Content/WEB-INF"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_118251-g/Web Content/WEB-INF/web.xml"));
        TestIndex.assertEquals((String)"wrong number of taglib records found after copying", (int)4, (int)records.length);
    }

    /*
     * Exception decompiling
     */
    public void testUtilityProjectSupport() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 257->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testWebXMLTaglibMappingsToJARs() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("bug_148717");
        if (!project.exists()) {
            project = BundleResourceUtil.createSimpleProject("bug_148717", null, null);
            TestIndex.assertTrue((boolean)project.exists());
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_148717", "/bug_148717");
        }
        IFile file = project.getFile("/WebContent/WEB-INF/lib/internal.jar");
        TestIndex.assertTrue((boolean)file.exists());
        String uri = "http://example.com/external-uri";
        ITaglibRecord taglibRecord = TaglibIndex.resolve((String)"/bug_148717/WebContent/", (String)uri, (boolean)false);
        TestIndex.assertNotNull((String)("record not found for " + uri), (Object)taglibRecord);
        TestIndex.assertEquals((int)2, (int)taglibRecord.getRecordType());
        TestIndex.assertEquals((String)uri, (String)((IJarRecord)taglibRecord).getDescriptor().getURI());
        ITaglibRecord taglibRecord2 = null;
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/bug_148717/WebContent/"));
        int i = 0;
        while (i < records.length) {
            int type = records[i].getRecordType();
            switch (type) {
                case 2: {
                    taglibRecord2 = records[i];
                }
            }
            ++i;
        }
        TestIndex.assertNotNull((String)("record not returned for " + uri), taglibRecord2);
        TestIndex.assertEquals((int)2, (int)taglibRecord2.getRecordType());
        TestIndex.assertEquals((String)uri, (String)((IJarRecord)taglibRecord2).getDescriptor().getURI());
    }

    public void testRecordCacheCountBetweenSessions() throws Exception {
        TaglibIndex.shutdown();
        IProject project = BundleResourceUtil.createSimpleProject("testcache1", null, null);
        TestIndex.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testcache1", "/testcache1");
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/testcache1/WebContent/WEB-INF/lib/sample_tld.jar");
        TaglibIndex.startup();
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match", (int)5, (int)records.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        ITaglibRecord[] records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (1st restart)", (int)records.length, (int)records2.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (2nd restart)", (int)records.length, (int)records2.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (3rd restart)", (int)records.length, (int)records2.length);
    }

    public void testCachingWithAddingLibrary() throws Exception {
        IProject project = BundleResourceUtil.createSimpleProject("testcache2", null, null);
        TestIndex.assertTrue((boolean)project.exists());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testcache2", "/testcache2");
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache2/WebContent"));
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        ITaglibRecord[] records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (1st restart)", (int)records.length, (int)records2.length);
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/testcache2/WebContent/WEB-INF/lib/sample_tld.jar");
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (1st restart, added jar file)", (int)(records.length + 1), (int)records2.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (2nd restart)", (int)(records.length + 1), (int)records2.length);
        BundleResourceUtil.addLibraryEntry(project, "WebContent/WEB-INF/lib/sample_tld.jar");
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (3nd restart)", (int)(records.length + 1), (int)records2.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testcache2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match changed value (4th restart, add jar to build path)", (int)(records.length + 2), (int)records2.length);
    }

    public void testAvailableFromExportedOnBuildpathFromAnotherProject() throws Exception {
        TaglibIndex.shutdown();
        IProject project = BundleResourceUtil.createSimpleProject("testavailable1", null, null);
        TestIndex.assertTrue((boolean)project.isAccessible());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testavailable1", "/testavailable1");
        IProject project2 = BundleResourceUtil.createSimpleProject("testavailable2", null, null);
        TestIndex.assertTrue((boolean)project2.isAccessible());
        BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/testavailable2", "/testavailable2");
        BundleResourceUtil.copyBundleEntryIntoWorkspace("/testfiles/bug_118251-sample/sample_tld.jar", "/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar");
        TaglibIndex.startup();
        ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable1/WebContent"));
        TestIndex.assertEquals((String)"ITaglibRecords were found", (int)0, (int)records.length);
        ITaglibRecord[] records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable2/WebContent"));
        if (records2.length != 2) {
            int i = 0;
            while (i < records2.length) {
                System.err.println(records2[i]);
                ++i;
            }
        }
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match", (int)2, (int)records2.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records2 = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match after restart", (int)2, (int)records2.length);
        IJavaProject created = JavaCore.create((IProject)project2);
        TestIndex.assertTrue((String)"/availabletest2 not a Java project", (boolean)created.exists());
        IClasspathEntry[] entries = created.getRawClasspath();
        boolean found = false;
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getPath().equals((Object)new Path("/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar"))) {
                found = true;
                TestIndex.assertFalse((String)"was exported", (boolean)entry.isExported());
                ((ClasspathEntry)entry).isExported = true;
            }
            ++i;
        }
        TestIndex.assertTrue((String)"/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar was not found in build path", (boolean)found);
        IClasspathEntry[] entries2 = new IClasspathEntry[entries.length];
        System.arraycopy(entries, 1, entries2, 0, entries.length - 1);
        entries2[entries.length - 1] = entries[0];
        created.setRawClasspath(entries2, (IProgressMonitor)new NullProgressMonitor());
        entries = created.getRawClasspath();
        found = false;
        int i2 = 0;
        while (i2 < entries.length) {
            IClasspathEntry entry = entries[i2];
            if (entry.getPath().equals((Object)new Path("/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar"))) {
                found = true;
                TestIndex.assertTrue((String)"/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar was not exported", (boolean)((ClasspathEntry)entry).isExported);
            }
            ++i2;
        }
        TestIndex.assertTrue((String)"/testavailable2/WebContent/WEB-INF/lib/sample_tld.jar was not found (and exported) in build path", (boolean)found);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (after exporting jar)", (int)2, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (after exporting jar), classpath provider problem?", (int)1, (int)records.length);
        TaglibIndex.shutdown();
        TaglibIndex.startup();
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable2/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (after exporting jar and restarting)", (int)2, (int)records.length);
        records = TaglibIndex.getAvailableTaglibRecords((IPath)new Path("/testavailable1/WebContent"));
        TestIndex.assertEquals((String)"total ITaglibRecord count doesn't match (after exporting jar and restarting)", (int)1, (int)records.length);
    }

    private void removeAllProjects() throws CoreException, InterruptedException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        IProject project = null;
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            this.deleteProject(project);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void deleteProject(IProject project) throws CoreException, InterruptedException {
        nTrys = 0;
        while (project != null && project.exists() && nTrys < this.MAX_RETRYS) {
            block5: {
                block6: {
                    try {
                        ++nTrys;
                        project.delete(true, true, null);
                        continue;
                    }
                    catch (ResourceException e) {
                        if (!this.DEBUG) break block5;
                        System.out.println();
                        System.out.println("Could not delete project on attempt number: " + nTrys);
                        eStatus = e.getStatus();
                        if (!(eStatus instanceof MultiStatus)) break block6;
                        mStatus = (MultiStatus)eStatus;
                        iStatus = mStatus.getChildren();
                        j = 0;
                        ** while (j < iStatus.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        System.out.println("Status: " + j + " " + iStatus[j]);
                        ++j;
                        continue;
lbl20:
                        // 1 sources

                        break block5;
                    }
                }
                System.out.println("Status: " + eStatus);
            }
            Thread.sleep(this.PAUSE_TIME);
        }
        if (project != null && project.exists()) {
            TestIndex.fail((String)("Error in test infrastructure. Could not delete project " + project + " after " + this.MAX_RETRYS + "attempts."));
        }
    }
}

