/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.tests.jspeditor;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.ui.internal.jspeditor.JSFELHover;

public class TestJSFELHover
extends TestCase {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;
    private IType _myBeanType;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._testEnv.createProject(false);
        TestJSFELHover.assertNotNull((Object)this._testEnv);
        TestJSFELHover.assertNotNull((Object)this._testEnv.getTestProject());
        TestJSFELHover.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/faces-config_basic.xml.data", "/WEB-INF/faces-config.xml");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/basicELExpressions.jsp.data", "/basicELExpressions.jsp");
        TestJSFELHover.assertNotNull((Object)this._jspFile);
        TestJSFELHover.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        this._myBeanType = JavaCore.create((IProject)this._testEnv.getTestProject()).findType("beans.MyBean");
        TestJSFELHover.assertNotNull((Object)this._myBeanType);
        TestJSFELHover.assertTrue((boolean)this._myBeanType.exists());
    }

    public void testSanity() throws Exception {
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)579, (String)"value", (String)"#{myBean}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)614, (String)"value", (String)"#{myBean.property}");
        JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)706, (String)"action", (String)"#{myBean.actionMethod}");
        JSFCoreUtilHelper.assertELVariableSanity((IFile)this._jspFile, (String)"myBean");
    }

    public void testGetHoverInfo() throws Exception {
        this.testJavaHoverHelp(579, "MyBean.java", "<p><b>Name: </b>myBean</p><p><b>Type: </b>beans.MyBean</p><p><b>Scope: </b>none</p>");
        this.testJavaHoverHelp(614, "MyBean.java", "<p><b>Name: </b>myBean</p><p><b>Type: </b>beans.MyBean</p><p><b>Scope: </b>none</p>");
        this.testJavaHoverHelp(706, "MyBean.java", "<p><b>Name: </b>myBean</p><p><b>Type: </b>beans.MyBean</p><p><b>Scope: </b>none</p>");
        this.testJavaHoverHelp(622, "MyBean.java", "<p><b>Type: </b>java.lang.String[]</p><p><b>Access: </b>read-only</p>");
        this.testJavaHoverHelp(714, "MyBean.java", "<p><b>Signature:</b> String actionMethod()</p>");
    }

    private void testJavaHoverHelp(int regionStartOffset, String classFileName, String expectedInfo) throws Exception {
        TestableJSFELHover hoverHelp = new TestableJSFELHover();
        JSFCoreUtilHelper.ContextWrapper context = JSFCoreUtilHelper.getDocumentContext((IFile)this._jspFile, (int)regionStartOffset);
        IRegion region = hoverHelp.getHoverRegion(context.getContext(), regionStartOffset);
        TestJSFELHover.assertNotNull((Object)region);
        TestJSFELHover.assertEquals((String)expectedInfo, (String)hoverHelp.getHoverInfo());
    }

    private static class TestableJSFELHover
    extends JSFELHover {
        private TestableJSFELHover() {
        }

        public String getHoverInfo() {
            return super.getHoverInfo();
        }

        public IRegion getHoverRegion(IStructuredDocumentContext context, int documentPosition) {
            return super.getHoverRegion(context, documentPosition);
        }
    }
}

