/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.tests.performance;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class HeaderParserPerformanceTest {
    private static final String DATA_DIR = "TestData" + File.separatorChar + "headerParserTestData" + File.separatorChar;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSpeed() throws Exception {
        List data = this.getXMLData();
        long[] times = new long[data.size()];
        InputStream in = null;
        int i = 0;
        while (true) {
            block8: {
                Object var11_9;
                if (i >= data.size()) {
                    Arrays.sort(times);
                    if (times[0] * 2L < times[times.length - 1]) {
                        Assert.fail();
                    }
                    return;
                }
                try {
                    TestData testData = (TestData)data.get(i);
                    in = new FileInputStream(new File(this.getDataPath(testData.fileName)));
                    long start = System.currentTimeMillis();
                    JavaEEQuickPeek peek = new JavaEEQuickPeek(in);
                    long end = System.currentTimeMillis();
                    times[i] = end - start;
                    if (times[i] == 0L) {
                        times[i] = 10L;
                    }
                    Assert.assertEquals((int)testData.type, (int)peek.getType());
                    Assert.assertEquals((int)testData.modVersion, (int)peek.getVersion());
                    Assert.assertEquals((int)testData.eeVersion, (int)peek.getJavaEEVersion());
                }
                catch (Throwable throwable) {
                    var11_9 = null;
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                {
                    var11_9 = null;
                    if (in == null) break block8;
                }
                in.close();
            }
            ++i;
        }
    }

    private List getXMLData() {
        ArrayList<TestData> data = new ArrayList<TestData>();
        data.add(new TestData("application-client12.xml", 3, 12, 12));
        data.add(new TestData("application-client13.xml", 3, 13, 13));
        data.add(new TestData("application-client14.xml", 3, 14, 14));
        data.add(new TestData("application-client5.xml", 3, 50, 50));
        data.add(new TestData("application12.xml", 1, 12, 12));
        data.add(new TestData("application13.xml", 1, 13, 13));
        data.add(new TestData("application14.xml", 1, 14, 14));
        data.add(new TestData("application5.xml", 1, 50, 50));
        data.add(new TestData("ejb-jar11.xml", 0, 11, 12));
        data.add(new TestData("ejb-jar20.xml", 0, 20, 13));
        data.add(new TestData("ejb-jar21.xml", 0, 21, 14));
        data.add(new TestData("ejb-jar30.xml", 0, 30, 50));
        data.add(new TestData("ra10.xml", 2, 10, 13));
        data.add(new TestData("ra15.xml", 2, 15, 14));
        data.add(new TestData("web22.xml", 4, 22, 12));
        data.add(new TestData("web23.xml", 4, 23, 13));
        data.add(new TestData("web24.xml", 4, 24, 14));
        data.add(new TestData("web25.xml", 4, 25, 50));
        data.add(new TestData("notxml.xml", -1, -1, -1));
        data.add(new TestData("notjavaee.xml", -1, -1, -1));
        data.add(new TestData("application-client0.xml", 3, -1, -1));
        data.add(new TestData("application-client00.xml", 3, -1, -1));
        data.add(new TestData("application-client000.xml", 3, -1, -1));
        data.add(new TestData("application0.xml", 1, -1, -1));
        data.add(new TestData("application00.xml", 1, -1, -1));
        data.add(new TestData("application000.xml", 1, -1, -1));
        data.add(new TestData("ejb-jar0.xml", 0, -1, -1));
        data.add(new TestData("ejb-jar00.xml", 0, -1, -1));
        data.add(new TestData("ejb-jar000.xml", 0, -1, -1));
        data.add(new TestData("ra0.xml", 2, -1, -1));
        data.add(new TestData("ra00.xml", 2, -1, -1));
        data.add(new TestData("ra000.xml", 2, -1, -1));
        data.add(new TestData("web0.xml", 4, -1, -1));
        data.add(new TestData("web00.xml", 4, -1, -1));
        data.add(new TestData("web000.xml", 4, -1, -1));
        return data;
    }

    protected String getDataPath(String shortName) throws Exception {
        HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
        String pluginRelativeFileName = String.valueOf(DATA_DIR) + File.separatorChar + shortName;
        return ProjectUtility.getFullFileName((Plugin)plugin, (String)pluginRelativeFileName);
    }

    private class TestData {
        String fileName;
        int type;
        int modVersion;
        int eeVersion;
        Class modelObjectInterface;

        public TestData(String fileName, int type, int modVersion, int eeVersion) {
            this.fileName = fileName;
            this.type = type;
            this.modVersion = modVersion;
            this.eeVersion = eeVersion;
        }

        public TestData(String fileName, int type, int modVersion, int eeVersion, Class modelTypeClass) {
            this(fileName, type, modVersion, eeVersion);
            this.modelObjectInterface = modelTypeClass;
        }
    }
}

