/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentassist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPJavaTranslatorTest
extends TestCase {
    public JSPJavaTranslatorTest(String name) {
        super(name);
    }

    public void testAllFiles() throws UnsupportedEncodingException, IOException {
        this.testJSPInJavascript("testfiles/jspInJavascript.jsp");
    }

    void testJSPInJavascript(String filename) throws UnsupportedEncodingException, IOException {
        IStructuredModel sm = this.getStructuredModelForRead(filename);
        if (sm != null) {
            IDOMNode xmlNode = (IDOMNode)sm.getIndexedRegion(0);
            if (xmlNode != null) {
                JSPTranslator jspt = new JSPTranslator();
                jspt.reset(xmlNode, null);
                jspt.translate();
                String translation = jspt.getTranslation().toString();
                int cursorStart = translation.indexOf("out.print(\"\"+\n testJspString") + 14;
                JSPJavaTranslatorTest.assertEquals((String)("incorrect cursor position >" + cursorStart), (int)667, (int)cursorStart);
            }
            sm.releaseFromRead();
        }
    }

    public void testMultipleJSPSectionsInJavascript() throws Exception {
        String filename = "testfiles/jspInJavascript2.jsp";
        IStructuredModel sm = this.getStructuredModelForRead(filename);
        JSPJavaTranslatorTest.assertNotNull((String)"couldn't load JSP for test", (Object)sm);
        JSPTranslationUtil translationUtil = new JSPTranslationUtil((IDocument)sm.getStructuredDocument());
        String javaText = StringUtils.replace((String)translationUtil.getTranslation().getJavaText(), (String)"\r\n", (String)"\n");
        javaText = StringUtils.replace((String)javaText, (String)"\r", (String)"\n");
        sm.releaseFromRead();
        String translatedText = this.loadContents("testfiles/jspInJavascript2.javasource");
        JSPJavaTranslatorTest.assertEquals((String)"translated contents are not as expected", (String)translatedText, (String)javaText);
    }

    private String loadContents(String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename));
        char[] readBuffer = new char[2048];
        int n = reader.read(readBuffer);
        StringBuffer s = new StringBuffer();
        while (n > 0) {
            s.append(readBuffer, 0, n);
            n = reader.read(readBuffer);
        }
        String source = StringUtils.replace((String)s.toString(), (String)"\r\n", (String)"\n");
        source = StringUtils.replace((String)source, (String)"\r", (String)"\n");
        return source;
    }

    protected IStructuredModel getStructuredModelForRead(String filename) throws UnsupportedEncodingException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
        IStructuredModel sModel = modelManager.getModelForRead(filename, inStream, null);
        return sModel;
    }
}

