/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.io.File;
import java.io.IOException;
import org.eclipse.jst.validation.sample.parser.CompareProperties;
import org.eclipse.jst.validation.sample.parser.PropertyFile;

public class Main {
    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.out.println("prop -tr [-a | -ac | -am | -an | -al PREFIX | -ap PREFIX | -au | -b | -di | -dp | -l | -le <positive integer> | -p ] f:\\dir1\\dir2\\myPropertiesFile.properties");
            System.out.println("or ");
            System.out.println("prop [-c|-ct] f:\\dir1\\dir2\\myPropertiesFile.properties f:\\dir1\\dir2\\myNewPropertiesFile.properties");
            System.out.println("   -a: print all error/warning/info prefixes in the file");
            System.out.println("  -ac: print a count of messages with and without prefixes in the file");
            System.out.println("  -am: print all messages with a prefix");
            System.out.println("  -an: print all messages without an error prefix");
            System.out.println("  -al: print the last error/warning/info prefix, starting with PREFIX, in the file");
            System.out.println("  -ap: print any error/warning/info prefixes, starting with PREFIX, in the file");
            System.out.println("  -au: print all error/warning/info prefixes that are not used in the file");
            System.out.println("   -b: print any blank messages in the properties file");
            System.out.println("   -c: compare the two property files listed. The first is the older, and the second is the newer.");
            System.out.println("  -ct: compare the two property files listed. The first is the older, and the second is the newer. Output a list of the added, deleted, and changed strings, but print only the message id.");
            System.out.println("  -di: print any duplicate message ids and syntax errors in the properties file");
            System.out.println("  -dp: print any duplicate error/warning/info prefixes in the file");
            System.out.println("   -l: print the length of each message in the file");
            System.out.println("  -le: print the length of each message in the file if each parameter is <positive integer> characters long.");
            System.out.println("   -n: print the number of words in the file, including message prefixes and parameters");
            System.out.println("   -p: print the contents of the property file, sorted by message id");
            System.out.println("  -tr: print trace information while parsing the .properties file");
            System.out.println();
            System.out.println("The default action is to print the syntax errors, duplicates, and other types of errors in the given .properties file.");
            System.exit(-1);
        }
        int index = 0;
        String option = argv[index++].toLowerCase();
        boolean trace = false;
        if (option.equals("-tr")) {
            trace = true;
            option = argv[index++].toLowerCase();
        }
        if (option.equals("-a") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printAllErrorPrefix(trace, files);
        } else if (option.equals("-ac") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printPrefixCount(trace, files);
        } else if (option.equals("-al") && argv.length >= 3) {
            String[] files = new String[argv.length - 2];
            System.arraycopy(argv, 2, files, 0, files.length);
            Main.printErrorPrefix(trace, argv[index], files);
        } else if (option.equals("-am") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printErrorMessages(trace, files);
        } else if (option.equals("-an") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printMessagesWithoutPrefixes(trace, files);
        } else if (option.equals("-ap") && argv.length >= 3) {
            String[] files = new String[argv.length - 2];
            System.arraycopy(argv, 2, files, 0, files.length);
            Main.printErrorPrefixRange(trace, argv[index], files);
        } else if (option.equals("-au") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printAllMissingErrorPrefix(trace, files);
        } else if (option.equals("-b") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printBlanks(trace, files);
        } else if (option.equals("-c") && argv.length == 3) {
            File oldFile = new File(argv[index++]);
            File newFile = new File(argv[index]);
            Main.compareFiles(trace, oldFile, newFile);
        } else if (option.equals("-ct") && argv.length == 3) {
            File oldFile = new File(argv[index++]);
            File newFile = new File(argv[index]);
            Main.compareFilesForTranslation(trace, oldFile, newFile);
        } else if (option.equals("-di") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printDuplicateIds(trace, files);
        } else if (option.equals("-dp") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printDuplicatePrefixes(trace, files);
        } else if (option.equals("-l") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printStringLength(trace, files);
        } else if (option.equals("-le") && argv.length >= 3) {
            String[] files = new String[argv.length - 2];
            System.arraycopy(argv, 2, files, 0, files.length);
            Main.printExpectedStringLength(trace, argv[index], files);
        } else if (option.equals("-n") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printWordCount(trace, files);
        } else if (option.equals("-p") && argv.length >= 2) {
            String[] files = new String[argv.length - 1];
            System.arraycopy(argv, 1, files, 0, files.length);
            Main.printFileContents(trace, files);
        } else {
            Main.printDefault(trace, argv);
        }
    }

    public static void printAllErrorPrefix(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printAllMessagePrefixes();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printAllMissingErrorPrefix(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printAllMissingMessagePrefixes();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printBlanks(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printAllMessagesWhichAreBlank();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printMessagesWithoutPrefixes(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printAllMessagesWithoutAMessagePrefix();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void compareFiles(boolean trace, File oldFile, File newFile) {
        if (oldFile.isFile() && newFile.isFile()) {
            try {
                PropertyFile oldPropFile = new PropertyFile(oldFile.getAbsolutePath(), trace);
                PropertyFile newPropFile = new PropertyFile(newFile.getAbsolutePath(), trace);
                CompareProperties cp = new CompareProperties(oldPropFile, newPropFile);
                cp.printResults();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else if (oldFile.isDirectory() && newFile.isDirectory()) {
            String[] oldChildren = oldFile.list();
            int i = 0;
            while (i < oldChildren.length) {
                File newChild = new File(newFile, oldChildren[i]);
                if (newChild.exists()) {
                    Main.compareFiles(trace, new File(oldFile, oldChildren[i]), newChild);
                }
                ++i;
            }
        } else {
            System.out.println("Compare two files or two directories. Do not compare a file to a directory (" + oldFile.getName() + ", " + newFile.getName() + ").");
        }
    }

    public static void compareFilesForTranslation(boolean trace, File oldFile, File newFile) {
        if (oldFile.isFile() && newFile.isFile()) {
            try {
                PropertyFile oldPropFile = new PropertyFile(oldFile.getAbsolutePath(), trace);
                PropertyFile newPropFile = new PropertyFile(newFile.getAbsolutePath(), trace);
                CompareProperties cp = new CompareProperties(oldPropFile, newPropFile);
                cp.printResultsForTranslation();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else if (oldFile.isDirectory() && newFile.isDirectory()) {
            String[] oldChildren = oldFile.list();
            int i = 0;
            while (i < oldChildren.length) {
                File newChild = new File(newFile, oldChildren[i]);
                if (newChild.exists()) {
                    Main.compareFilesForTranslation(trace, new File(oldFile, oldChildren[i]), newChild);
                }
                ++i;
            }
        } else {
            System.out.println("Compare two files or two directories. Do not compare a file to a directory (" + oldFile.getName() + ", " + newFile.getName() + ").");
        }
    }

    public static void printDuplicateIds(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printDuplicateMessageId();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printErrorPrefix(boolean trace, String prefix, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printLastMessagePrefixStartingWith(prefix);
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printErrorPrefixRange(boolean trace, String prefix, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printMessagePrefixStartingWith(prefix);
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printDuplicatePrefixes(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printDuplicateMessagePrefix();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printStringLength(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printStringLength();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printExpectedStringLength(boolean trace, String slength, String[] files) {
        int length = 0;
        try {
            length = new Integer(slength);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println();
            System.out.println("Parameter must be an integer.");
            System.out.println();
            return;
        }
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printExpectedStringLength(length);
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printErrorMessages(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printAllMessagesWithAMessagePrefix();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printWordCount(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                System.out.println(String.valueOf(propFile.getQualifiedFileName()) + ":: Number of words :: " + propFile.getNumWords());
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printPrefixCount(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                System.out.println("Usually the number of unique prefixes and the number of prefixes is the same, but if a .properties file has variations of a message (slightly different wording for a different context), then the number of prefix messages will be larger than the number of unique prefixes.");
                System.out.println(String.valueOf(propFile.getQualifiedFileName()) + ":: Number of unique prefixes :: " + propFile.getNumUniquePrefixes());
                System.out.println(String.valueOf(propFile.getQualifiedFileName()) + ":: Number of messages with prefixes :: " + propFile.getNumPrefixes());
                System.out.println(String.valueOf(propFile.getQualifiedFileName()) + ":: Number of messages without prefixes :: " + propFile.getNumWithoutPrefixes());
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printFileContents(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printContents();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void printDefault(boolean trace, String[] files) {
        int i = 0;
        while (i < files.length) {
            try {
                System.out.println("******************************************");
                PropertyFile propFile = new PropertyFile(files[i], trace);
                propFile.printSyntaxWarnings();
                propFile.printDuplicateMessageId();
                propFile.printDuplicateMessagePrefix();
                System.out.println("******************************************");
                System.out.println();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            ++i;
        }
    }

    public static void print(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            System.out.println(String.valueOf(i) + ". " + argv[i]);
            ++i;
        }
    }
}

