/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.basic;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;

public class TestWorkbenchUtils112678
extends TestCase {
    public static final String FILE_RESOURCE_PATH = "Test Basic/workbenchUtil/FileResource.xmi";
    public static final String NOT_FOUND_FILE_RESOURCE_PATH = "Test Basic/workbenchUtil/NoFileResource.xmi";

    public TestWorkbenchUtils112678() {
    }

    public TestWorkbenchUtils112678(String name) {
        super(name);
    }

    public void testGetIFilePlatformResource() {
        URI uri = URI.createPlatformResourceURI((String)FILE_RESOURCE_PATH);
        IFile file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)file);
        TestWorkbenchUtils112678.assertTrue((boolean)file.exists());
        uri = URI.createPlatformResourceURI((String)NOT_FOUND_FILE_RESOURCE_PATH);
        file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)file);
        TestWorkbenchUtils112678.assertFalse((boolean)file.exists());
        uri = URI.createPlatformResourceURI((String)"NotProject/file.xmi");
        file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNull((Object)file);
    }

    public void testGetIFileProjectRelativeResource() {
        URI uri = URI.createURI((String)FILE_RESOURCE_PATH);
        IFile file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)file);
        TestWorkbenchUtils112678.assertTrue((boolean)file.exists());
        uri = URI.createURI((String)NOT_FOUND_FILE_RESOURCE_PATH);
        file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)file);
        TestWorkbenchUtils112678.assertFalse((boolean)file.exists());
        uri = URI.createURI((String)"NotProject/file.xmi");
        file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNull((Object)file);
    }

    public void testGetIFileNotPlatformResource() {
        URI uri = URI.createURI((String)"platform:/plugin/xyz/abc");
        IFile file = WorkbenchResourceHelperBase.getIFile((URI)uri);
        TestWorkbenchUtils112678.assertNull((Object)file);
    }

    public void testGetResourcePlatformResource() {
        URI uri = URI.createPlatformResourceURI((String)FILE_RESOURCE_PATH);
        Resource res = WorkbenchResourceHelperBase.getResource((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)res);
        TestWorkbenchUtils112678.assertTrue((boolean)res.isLoaded());
        uri = URI.createPlatformResourceURI((String)NOT_FOUND_FILE_RESOURCE_PATH);
        boolean good = false;
        try {
            res = WorkbenchResourceHelperBase.getResource((URI)uri);
        }
        catch (WrappedException wrappedException) {
            good = true;
        }
        TestWorkbenchUtils112678.assertTrue((boolean)good);
        uri = URI.createPlatformResourceURI((String)"NotProject/file.xmi");
        res = WorkbenchResourceHelperBase.getResource((URI)uri);
        TestWorkbenchUtils112678.assertNull((Object)res);
    }

    public void testGetResourceProjectRelativeResource() {
        URI uri = URI.createURI((String)FILE_RESOURCE_PATH);
        Resource res = WorkbenchResourceHelperBase.getResource((URI)uri);
        TestWorkbenchUtils112678.assertNotNull((Object)res);
        TestWorkbenchUtils112678.assertTrue((boolean)res.isLoaded());
        boolean good = false;
        uri = URI.createURI((String)NOT_FOUND_FILE_RESOURCE_PATH);
        try {
            res = WorkbenchResourceHelperBase.getResource((URI)uri);
        }
        catch (WrappedException wrappedException) {
            good = true;
        }
        TestWorkbenchUtils112678.assertTrue((boolean)good);
        uri = URI.createURI((String)"NotProject/file.xmi");
        res = WorkbenchResourceHelperBase.getResource((URI)uri);
        TestWorkbenchUtils112678.assertNull((Object)res);
    }
}

