/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;
import org.eclipse.jem.tests.proxy.AbstractTestProxy;
import org.eclipse.jem.tests.proxy.ExpressionThreadTransferCallBack;

public class ExpressionTest
extends AbstractTestProxy {
    static /* synthetic */ Class class$0;

    public ExpressionTest() {
    }

    public ExpressionTest(String name) {
        super(name);
    }

    public void testIProxyBeanTypeProxy() throws CoreException, IllegalStateException, ThrowableProxy, NoExpressionValueException {
        this.recreateRegistry();
        IExpression exp = this.proxyFactory.createExpression();
        IProxyBeanType beanTypeProxy = this.proxyTypeFactory.getBeanTypeProxy(exp, "testPackage.TestAccess");
        ExpressionTest.assertNotNull((Object)beanTypeProxy);
        ExpressionTest.assertTrue((boolean)beanTypeProxy.isExpressionProxy());
        final IBeanTypeProxy[] resolution = new IBeanTypeProxy[1];
        ((ExpressionProxy)beanTypeProxy).addProxyListener(new ExpressionProxy.ProxyListener(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                resolution[0] = (IBeanTypeProxy)event.getProxy();
            }

            public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.fail((String)"Proxy should not be void.");
            }

            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.fail((String)"Proxy should of resolved.");
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertNotNull((Object)resolution[0]);
        IBeanTypeProxy beanTypeProxy2 = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        ExpressionTest.assertNotNull((Object)beanTypeProxy2);
        ExpressionTest.assertTrue((boolean)beanTypeProxy2.isBeanProxy());
        ExpressionTest.assertTrue((boolean)beanTypeProxy2.isValid());
        ExpressionTest.assertSame((Object)beanTypeProxy2, (Object)resolution[0]);
    }

    public void testIProxyMethodProxy() throws CoreException, IllegalStateException, ThrowableProxy, NoExpressionValueException {
        this.recreateRegistry();
        IExpression exp = this.proxyFactory.createExpression();
        IProxyBeanType beanTypeProxy = this.proxyTypeFactory.getBeanTypeProxy(exp, "testPackage.TestAccess");
        IProxyMethod methodProxy = beanTypeProxy.getMethodProxy(exp, "xyz");
        ExpressionTest.assertNotNull((Object)methodProxy);
        ExpressionTest.assertTrue((boolean)methodProxy.isExpressionProxy());
        final IMethodProxy[] resolution = new IMethodProxy[1];
        final boolean[] wasVoid = new boolean[1];
        ((ExpressionProxy)methodProxy).addProxyListener(new ExpressionProxy.ProxyListener(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                resolution[0] = (IMethodProxy)event.getProxy();
            }

            public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                wasVoid[0] = true;
            }

            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            }
        });
        IProxyMethod methodProxy2 = beanTypeProxy.getMethodProxy(exp, "xyz");
        ExpressionTest.assertSame((Object)methodProxy, (Object)methodProxy2);
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, methodProxy, true, 0);
        exp.createClassInstanceCreation(ForExpression.METHOD_RECEIVER, beanTypeProxy, 0);
        exp.invokeExpression();
        ExpressionTest.assertFalse((boolean)wasVoid[0]);
        ExpressionTest.assertNotNull((Object)resolution[0]);
        IMethodProxy methodProxy3 = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess").getMethodProxy("xyz");
        ExpressionTest.assertNotNull((Object)methodProxy3);
        ExpressionTest.assertTrue((boolean)methodProxy3.isBeanProxy());
        ExpressionTest.assertTrue((boolean)methodProxy3.isValid());
    }

    public void testIProxyFieldProxy() throws CoreException, IllegalStateException, ThrowableProxy, NoExpressionValueException {
        this.recreateRegistry();
        IExpression exp = this.proxyFactory.createExpression();
        IProxyBeanType beanTypeProxy = this.proxyTypeFactory.getBeanTypeProxy(exp, "testPackage.TestAccess");
        IProxyField fieldProxy = beanTypeProxy.getFieldProxy(exp, "STATIC_FIELD");
        ExpressionTest.assertNotNull((Object)fieldProxy);
        ExpressionTest.assertTrue((boolean)fieldProxy.isExpressionProxy());
        final IFieldProxy[] resolution = new IFieldProxy[1];
        final boolean[] wasVoid = new boolean[1];
        ((ExpressionProxy)fieldProxy).addProxyListener(new ExpressionProxy.ProxyListener(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                resolution[0] = (IFieldProxy)event.getProxy();
            }

            public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                wasVoid[0] = true;
            }

            public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            }
        });
        IProxyField fieldProxy2 = beanTypeProxy.getFieldProxy(exp, "STATIC_FIELD");
        ExpressionTest.assertSame((Object)fieldProxy, (Object)fieldProxy2);
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, fieldProxy, true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, beanTypeProxy, 0);
        IBeanProxy v = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)v);
        ExpressionTest.assertEquals((int)3, (int)((IIntegerBeanProxy)v).intValue());
        ExpressionTest.assertFalse((boolean)wasVoid[0]);
        ExpressionTest.assertNotNull((Object)resolution[0]);
        IFieldProxy fieldProxy3 = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess").getFieldProxy("STATIC_FIELD");
        ExpressionTest.assertNotNull((Object)fieldProxy3);
        ExpressionTest.assertTrue((boolean)fieldProxy3.isBeanProxy());
        ExpressionTest.assertTrue((boolean)fieldProxy3.isValid());
    }

    public void testCastStringType() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createCastExpression(ForExpression.ROOTEXPRESSION, "short");
        exp.createPrimitiveLiteral(ForExpression.CAST_EXPRESSION, 10L);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((short)10, (short)((INumberBeanProxy)result).shortValue());
    }

    public void testCastProxyType() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createCastExpression(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("short"));
        exp.createPrimitiveLiteral(ForExpression.CAST_EXPRESSION, 'a');
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((short)97, (short)((INumberBeanProxy)result).shortValue());
    }

    public void testCastError() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        block2: {
            IExpression exp = this.proxyFactory.createExpression();
            exp.createCastExpression(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("short"));
            try {
                exp.createProxyExpression(ForExpression.CAST_EXPRESSION, (IProxy)this.proxyFactory.createBeanProxyWith(Boolean.TRUE));
                exp.getExpressionValue();
                ExpressionTest.fail((String)"Should of thrown ClassCastException");
            }
            catch (ThrowableProxy e) {
                if (e.getTypeProxy().getFormalTypeName().equals("java.lang.ClassCastException")) break block2;
                throw e;
            }
        }
    }

    public void testCastFailed() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createCastExpression(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("short"));
        try {
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should of gotton IllegalStateException");
        }
        catch (IllegalStateException e) {
            System.out.println("From testCastFailed (This is successful): " + e.getLocalizedMessage());
        }
    }

    public void testInstanceofStringType() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInstanceofExpression(ForExpression.ROOTEXPRESSION, "java.lang.String");
        exp.createStringLiteral(ForExpression.INSTANCEOF_VALUE, "asdf");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testInstanceofProxyType() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInstanceofExpression(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.String"));
        exp.createStringLiteral(ForExpression.INSTANCEOF_VALUE, "asdf");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testInstanceofFailed() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInstanceofExpression(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.String"));
        try {
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should of gotton IllegalStateException");
        }
        catch (IllegalStateException e) {
            System.out.println("From testInstanceofFailed (This is successful): " + e.getLocalizedMessage());
        }
    }

    public void testTypeLiteral() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTypeLiteral(ForExpression.ROOTEXPRESSION, "java.lang.String");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertTrue((String)"Not a bean type proxy.", (boolean)(result instanceof IBeanTypeProxy));
        IBeanTypeProxy type = (IBeanTypeProxy)result;
        ExpressionTest.assertTrue((String)"Not valid.", (boolean)type.isValid());
        ExpressionTest.assertEquals((String)"java.lang.String", (String)type.getFormalTypeName());
    }

    public void testTypeFails() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        try {
            exp.createTypeLiteral(ForExpression.ROOTEXPRESSION, "java.lang.Stng");
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should not of gotton a result.");
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((String)"java.lang.ClassNotFoundException", (String)e.getTypeProxy().getFormalTypeName());
        }
    }

    public void testNesting() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInstanceofExpression(ForExpression.ROOTEXPRESSION, "short");
        exp.createCastExpression(ForExpression.INSTANCEOF_VALUE, "short");
        exp.createPrimitiveLiteral(ForExpression.CAST_EXPRESSION, (short)10);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testPrefixPlus() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_PLUS);
        exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, 10);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)10, (int)((INumberBeanProxy)result).intValue());
    }

    public void testPrefixMinus() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_MINUS);
        exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, 10);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)-10, (int)((INumberBeanProxy)result).intValue());
    }

    public void testPrefixMinusChar() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_MINUS);
        exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, 'a');
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)-97, (int)((INumberBeanProxy)result).intValue());
    }

    public void testPrefixComplement() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_COMPLEMENT);
        exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, (short)10);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)-11, (int)((INumberBeanProxy)result).intValue());
    }

    public void testPrefixNot() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_NOT);
        exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, true);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testPrefixFail() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createPrefixExpression(ForExpression.ROOTEXPRESSION, PrefixOperator.PRE_NOT);
        try {
            exp.createPrimitiveLiteral(ForExpression.PREFIX_OPERAND, 10);
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should of failed.");
        }
        catch (ThrowableProxy e) {
            System.out.println("Test was successful: " + e.getProxyLocalizedMessage());
        }
    }

    public void testTimes() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_TIMES, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)12, (int)((INumberBeanProxy)result).intValue());
    }

    public void testTimesExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_TIMES, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 5.0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"double", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((double)60.0, (double)((INumberBeanProxy)result).doubleValue(), (double)0.0);
    }

    public void testTimesExtendedNested() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_TIMES, 1);
        exp.createInfixExpression(ForExpression.INFIX_LEFT, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 10);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 5.0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"double", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((double)100.0, (double)((INumberBeanProxy)result).doubleValue(), (double)0.0);
    }

    public void testDivide() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_DIVIDE, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)2, (int)((INumberBeanProxy)result).intValue());
    }

    public void testDivideExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_DIVIDE, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 12);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2.0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"double", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((double)2.0, (double)((INumberBeanProxy)result).doubleValue(), (double)0.0);
    }

    public void testRemainder() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_REMAINDER, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
    }

    public void testRemainderExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_REMAINDER, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 12);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 9);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2.0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"double", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((double)1.0, (double)((INumberBeanProxy)result).doubleValue(), (double)0.0);
    }

    public void testMinus() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
    }

    public void testMinusExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_MINUS, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 12);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 9);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2.0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"double", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((double)1.0, (double)((INumberBeanProxy)result).doubleValue(), (double)0.0);
    }

    public void testLeftShift() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_LEFT_SHIFT, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)32, (int)((INumberBeanProxy)result).intValue());
    }

    public void testLeftShiftExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_LEFT_SHIFT, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 12);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 9);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)24576.0f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testRightShiftSigned() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_RIGHT_SHIFT_SIGNED, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)-1250000, (int)((INumberBeanProxy)result).intValue());
    }

    public void testRightShiftSignedExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_RIGHT_SHIFT_SIGNED, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)-156250.0f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testRightShiftUnSigned() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_RIGHT_SHIFT_UNSIGNED, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)535620912, (int)((INumberBeanProxy)result).intValue());
    }

    public void testRightShiftUnSignedExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_RIGHT_SHIFT_UNSIGNED, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)6.6952616E7f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testLess() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_LESS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testLessEquals() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_LESS_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testGreater() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_GREATER, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testGreaterEquals() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_GREATER_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 2);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testEqualsPrimitives() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3.0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testEqualsObjects() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        Class<?> clazz;
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_EQUALS, 0);
        exp.createTypeLiteral(ForExpression.INFIX_LEFT, "java.lang.String");
        exp.createTypeLiteral(ForExpression.INFIX_RIGHT, "java.lang.String");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ExpressionTest.assertEquals((clazz2 == clazz ? 1 : 0) != 0, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testNotEqualsPrimitives() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_NOT_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3.0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testNotEqualsObjects() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        Class<?> clazz;
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_NOT_EQUALS, 0);
        exp.createTypeLiteral(ForExpression.INFIX_LEFT, "java.lang.String");
        exp.createTypeLiteral(ForExpression.INFIX_RIGHT, "java.lang.String");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ExpressionTest.assertEquals((clazz2 != clazz ? 1 : 0) != 0, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testXOR() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_XOR, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)result).intValue());
    }

    public void testXORExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_XOR, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 23);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 9);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)28.0f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testAnd() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_AND, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
    }

    public void testAndExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_AND, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 13);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 15);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 1);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)1.0f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testOr() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_OR, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)7, (int)((INumberBeanProxy)result).intValue());
    }

    public void testOrExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_OR, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 13);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 6);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((float)15.0f, (float)((INumberBeanProxy)result).intValue(), (float)0.0f);
    }

    public void testPlus() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((int)7, (int)((INumberBeanProxy)result).intValue());
    }

    public void testPlusExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 2);
        exp.createPrimitiveLiteral(ForExpression.INFIX_EXTENDED, 2L);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"long", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((long)9L, (long)((INumberBeanProxy)result).intValue());
    }

    public void testPlusStringLeft() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createProxyExpression(ForExpression.INFIX_LEFT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)"abc2", (String)((IStringBeanProxy)result).stringValue());
    }

    public void testPlusStringRight() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 2);
        exp.createProxyExpression(ForExpression.INFIX_RIGHT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)"2abc", (String)((IStringBeanProxy)result).stringValue());
    }

    public void testPlusStringLeftNull() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createProxyExpression(ForExpression.INFIX_LEFT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        exp.createNull(ForExpression.INFIX_RIGHT);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)("abc" + null), (String)((IStringBeanProxy)result).stringValue());
    }

    public void testPlusStringRightNull() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createNull(ForExpression.INFIX_LEFT);
        exp.createProxyExpression(ForExpression.INFIX_RIGHT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)(null + "abc"), (String)((IStringBeanProxy)result).stringValue());
    }

    public void testPlusStringLeftChar() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createProxyExpression(ForExpression.INFIX_LEFT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 'a');
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)"abca", (String)((IStringBeanProxy)result).stringValue());
    }

    public void testPlusStringRightChar() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 'a');
        exp.createProxyExpression(ForExpression.INFIX_RIGHT, (IProxy)this.proxyFactory.createBeanProxyWith("abc"));
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((String)"aabc", (String)((IStringBeanProxy)result).stringValue());
    }

    public void testConditionalAnd() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_AND, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, true);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalAndExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_AND, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, true);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        exp.createInfixExpression(ForExpression.INFIX_EXTENDED, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalAndFalseLast() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_AND, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, true);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, false);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalAndFalseFirst() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_AND, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, false);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalAndExtendedAndFalseFirst() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_AND, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, false);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        exp.createInfixExpression(ForExpression.INFIX_EXTENDED, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalOr() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_OR, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, false);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalOrExtended() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_OR, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, false);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, false);
        exp.createInfixExpression(ForExpression.INFIX_EXTENDED, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalOrTrueFirst() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_OR, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, true);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, false);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testConditionalOrExtendedAndTrueMiddle() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_CONDITIONAL_OR, 1);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, false);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        exp.createInfixExpression(ForExpression.INFIX_EXTENDED, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
    }

    public void testArrayAccess() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IArrayBeanProxy array = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), 1);
        array.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), 0);
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayAccess(ForExpression.ROOTEXPRESSION, 1);
        exp.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)array);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((short)((INumberBeanProxy)result).shortValue(), (short)3);
    }

    public void testArrayAccessSet() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IArrayBeanProxy array = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), 1);
        array.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), 0);
        IExpression exp = this.proxyFactory.createExpression();
        exp.createAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createArrayAccess(ForExpression.ASSIGNMENT_LEFT, 1);
        exp.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)array);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, (short)33);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short", (String)result.getTypeProxy().getTypeName());
        ExpressionTest.assertEquals((short)((INumberBeanProxy)result).shortValue(), (short)33);
    }

    public void testMultiArrayAccess() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IArrayBeanProxy array = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), new int[]{2, 1});
        int[] nArray = new int[2];
        nArray[0] = 1;
        array.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), nArray);
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayAccess(ForExpression.ROOTEXPRESSION, 1);
        exp.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)array);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 1);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short[]", (String)result.getTypeProxy().getFormalTypeName());
    }

    public void testMultiArrayAccessSet() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IArrayBeanProxy array = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), new int[]{2, 1});
        int[] nArray = new int[2];
        nArray[0] = 1;
        array.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), nArray);
        IExpression exp = this.proxyFactory.createExpression();
        exp.createAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createArrayAccess(ForExpression.ASSIGNMENT_LEFT, 1);
        exp.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)array);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 1);
        IArrayBeanProxy newArray = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), new int[]{3});
        exp.createProxyExpression(ForExpression.ASSIGNMENT_RIGHT, (IProxy)newArray);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short[]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)3, (int)((IArrayBeanProxy)result).getLength());
    }

    public void testMultiArrayAccess1() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IArrayBeanProxy array = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("short"), new int[]{2, 1});
        int[] nArray = new int[2];
        nArray[0] = 1;
        array.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), nArray);
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayAccess(ForExpression.ROOTEXPRESSION, 2);
        exp.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)array);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((short)3, (short)((INumberBeanProxy)result).shortValue());
    }

    public void testArrayCreation() throws IllegalStateException, IllegalArgumentException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[]", 1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)result).getLength());
    }

    public void testMultiArrayCreation() throws IllegalStateException, IllegalArgumentException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][]", 2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)4, (int)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).getLength());
    }

    public void testMultiPartialArrayCreation() throws IllegalStateException, IllegalArgumentException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][][]", 2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)4, (int)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).getLength());
        ExpressionTest.assertNull((Object)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).get(0));
    }

    public void testArrayInitializerEmpty() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[]", 0);
        exp.createArrayInitializer(0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)0, (int)((IArrayBeanProxy)result).getLength());
    }

    public void testArrayInitializerOneDim() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[]", 0);
        exp.createArrayInitializer(1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)1, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)3, (int)((INumberBeanProxy)((IArrayBeanProxy)result).get(0)).intValue());
    }

    public void testArrayInitializerTwoDimEmpty() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][]", 0);
        exp.createArrayInitializer(0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)0, (int)((IArrayBeanProxy)result).getLength());
    }

    public void testArrayInitializerTwoDim() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][]", 0);
        exp.createArrayInitializer(1);
        exp.createArrayInitializer(0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)1, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)0, (int)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).getLength());
    }

    public void testArrayInitializerTwoDimNotEmpty() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][]", 0);
        exp.createArrayInitializer(2);
        exp.createNull(ForExpression.ARRAYINITIALIZER_EXPRESSION);
        exp.createArrayInitializer(2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 3);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertNull((Object)((IArrayBeanProxy)result).get(0));
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)((IArrayBeanProxy)result).get(1)).getLength());
        ExpressionTest.assertEquals((int)4, (int)((INumberBeanProxy)((IArrayBeanProxy)((IArrayBeanProxy)result).get(1)).get(1)).intValue());
    }

    public void testArrayInitializerShortInt() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "short[]", 0);
        exp.createArrayInitializer(1);
        exp.createPrimitiveLiteral(ForExpression.ARRAYINITIALIZER_EXPRESSION, 3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"short[]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)1, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)3, (int)((INumberBeanProxy)((IArrayBeanProxy)result).get(0)).intValue());
    }

    public void testClassInstanceCreationDefault() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, "java.lang.Object", 0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.Object", (String)result.getTypeProxy().getFormalTypeName());
    }

    public void testClassInstanceCreationDefaultWithBeanTypeProxy() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Object"), 0);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.Object", (String)result.getTypeProxy().getFormalTypeName());
    }

    public void testClassInstanceCreationOneArg() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, "java.lang.Integer", 1);
        exp.createStringLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, "3");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.Integer", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)3, (int)((INumberBeanProxy)result).intValue());
    }

    public void testClassInstanceCreationOneArgWithPrimWidening() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, "java.lang.Short", 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, (byte)3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.Short", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((short)3, (short)((INumberBeanProxy)result).shortValue());
    }

    public void testClassInstanceCreationNullArg() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, "testPackage.TestCtorWithNull", 1);
        exp.createNull(ForExpression.CLASSINSTANCECREATION_ARGUMENT);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"testPackage.TestCtorWithNull", (String)result.getTypeProxy().getFormalTypeName());
    }

    public void testClassInstanceCreationMismatchArg() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createClassInstanceCreation(ForExpression.ROOTEXPRESSION, "testPackage.TestCtorWithNull", 1);
        try {
            exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 1);
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Exception should of been thrown.");
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((String)"java.lang.NoSuchMethodException", (String)e.getTypeProxy().getFormalTypeName());
        }
    }

    public void testFieldAccessStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, "RED", true);
        exp.createTypeReceiver("java.awt.Color");
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.awt.Color", (String)result.getTypeProxy().getFormalTypeName());
        IBeanTypeProxy colorType = result.getTypeProxy();
        IMethodProxy red = colorType.getMethodProxy("getRed");
        IMethodProxy green = colorType.getMethodProxy("getGreen");
        IMethodProxy blue = colorType.getMethodProxy("getBlue");
        ExpressionTest.assertEquals((int)255, (int)((INumberBeanProxy)red.invoke(result)).intValue());
        ExpressionTest.assertEquals((int)0, (int)((INumberBeanProxy)green.invoke(result)).intValue());
        ExpressionTest.assertEquals((int)0, (int)((INumberBeanProxy)blue.invoke(result)).intValue());
    }

    public void testFieldAccessSetStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createFieldAccess(ForExpression.ASSIGNMENT_LEFT, "STATIC_FIELD", true);
        exp.createTypeReceiver("testPackage.TestAccess");
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 23);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)23, (int)((INumberBeanProxy)result).intValue());
    }

    public void testFieldAccessNonStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, "x", true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "java.awt.Point", 2);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
    }

    public void testFieldAccessSetNonStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createFieldAccess(ForExpression.ASSIGNMENT_LEFT, "x", true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "java.awt.Point", 2);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 2);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 23);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)23, (int)((INumberBeanProxy)result).intValue());
    }

    public void testFieldAccessSetNonStaticSimple() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IFieldProxy xFieldProxy = pointType.getFieldProxy("x");
        IBeanProxy pointProxy = pointType.getConstructorProxy(new String[]{"int", "int"}).newInstance(new IBeanProxy[]{this.proxyFactory.createBeanProxyWith(1), this.proxyFactory.createBeanProxyWith(2)});
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy ep = exp.createSimpleFieldSet((IProxyField)xFieldProxy, (IProxy)pointProxy, (IProxy)this.proxyFactory.createBeanProxyWith(23), true);
        ep.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy result = event.getProxy();
                ExpressionTest.assertNotNull((Object)result);
                ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)23, (int)((INumberBeanProxy)result).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testFieldAccessNonStaticSimple() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IFieldProxy xFieldProxy = pointType.getFieldProxy("x");
        IBeanProxy pointProxy = pointType.getConstructorProxy(new String[]{"int", "int"}).newInstance(new IBeanProxy[]{this.proxyFactory.createBeanProxyWith(1), this.proxyFactory.createBeanProxyWith(2)});
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy ep = exp.createSimpleFieldAccess((IProxyField)xFieldProxy, (IProxy)pointProxy);
        ep.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy result = event.getProxy();
                ExpressionTest.assertNotNull((Object)result);
                ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testFieldAccessNonStaticWithProxy() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IExpression exp = this.proxyFactory.createExpression();
        exp.createFieldAccess(ForExpression.ROOTEXPRESSION, (IProxyField)pointType.getFieldProxy("x"), true);
        exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "java.awt.Point", 2);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 2);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)1, (int)((INumberBeanProxy)result).intValue());
    }

    public void testFieldAccessFailWithExpressionProxy() throws IllegalStateException, NoExpressionValueException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IExpression exp = this.proxyFactory.createExpression();
        try {
            exp.createFieldAccess(ForExpression.ROOTEXPRESSION, pointType.getFieldProxy(exp, "z"), true);
            exp.createClassInstanceCreation(ForExpression.FIELD_RECEIVER, "java.awt.Point", 2);
            exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 1);
            exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 2);
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should of had exception");
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((String)"java.lang.NoSuchFieldException", (String)e.getTypeProxy().getFormalTypeName());
        }
    }

    public void testMethodInvokeStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, "valueOf", true, 1);
        exp.createTypeReceiver("java.lang.String");
        exp.createPrimitiveLiteral(ForExpression.METHOD_ARGUMENT, true);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"java.lang.String", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((String)"true", (String)((IStringBeanProxy)result).stringValue());
    }

    public void testMethodInvokeProxyFail() throws IllegalStateException, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        IBeanTypeProxy intType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        try {
            exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, intType.getMethodProxy(exp, "goobldy-gook"), true, 1);
            exp.createClassInstanceCreation(ForExpression.METHOD_RECEIVER, (IProxyBeanType)intType, 1);
            exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 3);
            exp.createClassInstanceCreation(ForExpression.METHOD_ARGUMENT, "java.lang.Integer", 1);
            exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 4);
            exp.getExpressionValue();
            ExpressionTest.fail((String)"Should of gotten exception");
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((String)"java.lang.NoSuchMethodException", (String)e.getTypeProxy().getFormalTypeName());
        }
    }

    public void testMethodInvokeNonStatic() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, "compareTo", true, 1);
        exp.createClassInstanceCreation(ForExpression.METHOD_RECEIVER, "java.lang.Integer", 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 3);
        exp.createClassInstanceCreation(ForExpression.METHOD_ARGUMENT, "java.lang.Integer", 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertTrue((String)"CompareTo wasn't less than 0.", (((INumberBeanProxy)result).intValue() < 0 ? 1 : 0) != 0);
    }

    public void testMethodInvokeNonStaticWithProxy() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IExpression exp = this.proxyFactory.createExpression();
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, (IProxyMethod)integerType.getMethodProxy("compareTo", new IBeanTypeProxy[]{integerType}), true, 1);
        exp.createClassInstanceCreation(ForExpression.METHOD_RECEIVER, "java.lang.Integer", 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 3);
        exp.createClassInstanceCreation(ForExpression.METHOD_ARGUMENT, "java.lang.Integer", 1);
        exp.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 4);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertTrue((String)"CompareTo wasn't less than 0.", (((INumberBeanProxy)result).intValue() < 0 ? 1 : 0) != 0);
    }

    public void testConditionalTrue() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createConditionalExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_TRUE, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)result).intValue());
    }

    public void testConditionalFalse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createConditionalExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_TRUE, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)0, (int)((INumberBeanProxy)result).intValue());
    }

    public void testNestedConditionalTrueTrue() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createConditionalExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createConditionalExpression(ForExpression.CONDITIONAL_TRUE);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_TRUE, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)4);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)8, (int)((INumberBeanProxy)result).intValue());
    }

    public void testNestedConditionalFalseFalse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createConditionalExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)2);
        exp.createConditionalExpression(ForExpression.CONDITIONAL_TRUE);
        exp.createInfixExpression(ForExpression.CONDITIONAL_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)2);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_TRUE, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)4);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createInfixExpression(ForExpression.CONDITIONAL_FALSE, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)5);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((INumberBeanProxy)result).intValue());
    }

    public void testVoidReturnType() throws IllegalStateException, ThrowableProxy {
        block2: {
            IExpression exp = this.proxyFactory.createExpression();
            try {
                exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
                exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
                exp.createMethodInvocation(ForExpression.INFIX_RIGHT, "gc", true, 0);
                exp.createTypeReceiver("java.lang.System");
                exp.getExpressionValue();
                ExpressionTest.fail((String)"Should of received no expression value exception.");
            }
            catch (NoExpressionValueException e) {
                if (e.getLocalizedMessage() == null) break block2;
                System.out.println("Test was successful: " + e.getLocalizedMessage());
            }
        }
    }

    public void testWrongReturnType() throws ThrowableProxy, IllegalStateException, NoExpressionValueException {
        block2: {
            IExpression exp = this.proxyFactory.createExpression();
            try {
                exp.createInfixExpression(ForExpression.ROOTEXPRESSION, InfixOperator.IN_PLUS, 0);
                exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, 3);
                exp.createMethodInvocation(ForExpression.INFIX_RIGHT, "getSecurityManager", true, 0);
                exp.createTypeReceiver("java.lang.System");
                exp.getExpressionValue();
                ExpressionTest.fail((String)"Should of received class cast proxy exception.");
            }
            catch (ThrowableProxy e) {
                if (e.getTypeProxy().getFormalTypeName().equals("java.lang.IllegalArgumentException")) break block2;
                throw e;
            }
        }
    }

    public void testInvoke() throws ThrowableProxy, IllegalStateException, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, "getSecurityManager", true, 0);
        exp.createTypeReceiver("java.lang.System");
        exp.invokeExpression();
    }

    public void testInvokeFail() throws ThrowableProxy, IllegalStateException, NoExpressionValueException {
        block2: {
            IExpression exp = this.proxyFactory.createExpression();
            try {
                exp.createMethodInvocation(ForExpression.ROOTEXPRESSION, "getenv", true, 1);
                exp.createTypeReceiver("java.lang.System");
                exp.createStringLiteral(ForExpression.METHOD_ARGUMENT, "xyz");
                exp.invokeExpression();
            }
            catch (ThrowableProxy e) {
                if (e.getTypeProxy().getFormalTypeName().equals("java.lang.Error")) break block2;
                throw e;
            }
        }
    }

    public void testAssignment() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy ep = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        final long[] time = new long[1];
        ep.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                time[0] = ((INumberBeanProxy)event.getProxy()).longValue();
            }
        });
        exp.createMethodInvocation(ForExpression.ASSIGNMENT_RIGHT, "currentTimeMillis", true, 0);
        exp.createTypeReceiver("java.lang.System");
        exp.invokeExpression();
        ExpressionTest.assertTrue((0L != time[0] ? 1 : 0) != 0);
    }

    public void testReassignment() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy ep = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        final long[] time = new long[1];
        ep.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                time[0] = ((INumberBeanProxy)event.getProxy()).longValue();
            }
        });
        exp.createMethodInvocation(ForExpression.ASSIGNMENT_RIGHT, "currentTimeMillis", true, 0);
        exp.createTypeReceiver("java.lang.System");
        exp.createProxyReassignmentExpression(ForExpression.ROOTEXPRESSION, ep);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, -23L);
        exp.invokeExpression();
        ExpressionTest.assertEquals((long)-23L, (long)time[0]);
    }

    public void testAssignmentVoid() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy ep = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        ExpressionVoid epl = new ExpressionVoid();
        ep.addProxyListener((ExpressionProxy.ProxyListener)epl);
        exp.createMethodInvocation(ForExpression.ASSIGNMENT_RIGHT, "testVoid", true, 0);
        exp.createTypeReceiver("testPackage.TestAccess");
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)epl.voidCalled);
    }

    public void testAssignmentNot() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createConditionalExpression(ForExpression.ROOTEXPRESSION);
        exp.createPrimitiveLiteral(ForExpression.CONDITIONAL_CONDITION, true);
        exp.createPrimitiveLiteral(ForExpression.CONDITIONAL_TRUE, true);
        ExpressionProxy ep = exp.createProxyAssignmentExpression(ForExpression.CONDITIONAL_FALSE);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, false);
        ExpressionNotResolved epl = new ExpressionNotResolved();
        ep.addProxyListener((ExpressionProxy.ProxyListener)epl);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)epl.notResolvedCalled);
    }

    public void testAssignmentLaterUsage() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy epArg = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 3);
        ExpressionProxy epInteger = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer"), 1);
        exp.createInfixExpression(ForExpression.CLASSINSTANCECREATION_ARGUMENT, InfixOperator.IN_PLUS, 0);
        exp.createProxyExpression(ForExpression.INFIX_LEFT, (IProxy)epArg);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 1);
        epInteger.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((int)((INumberBeanProxy)event.getProxy()).intValue(), (int)4);
            }
        });
        exp.invokeExpression();
    }

    public void ExpressionPerformanceSmall() throws IllegalStateException, NoExpressionValueException, ThrowableProxy, AmbiguousMethodException, NoSuchMethodException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IMethodProxy setLocation = pointType.getMethodProxy("setLocation", new String[]{"int", "int"});
        IMethodProxy getLocation = pointType.getMethodProxy("getLocation");
        IExpression exp = this.proxyFactory.createExpression();
        int i = 1000;
        while (i-- > 0) {
            exp.createArrayCreation(ForExpression.ROOTEXPRESSION, this.registry.getBeanTypeProxyFactory().getBeanTypeProxy(exp, "java.lang.Object", 1), 0);
            exp.createArrayInitializer(0);
        }
        exp.invokeExpression();
        int times = 100;
        int batchSize = 10;
        long start = System.currentTimeMillis();
        i = times;
        while (i-- > 0) {
            this.expressionSetting(pointType, setLocation, getLocation, batchSize);
        }
        long expressionTime = System.currentTimeMillis() - start;
        long startNormal = System.currentTimeMillis();
        i = times;
        while (i-- > 0) {
            this.normalSetting(pointType, setLocation, getLocation, batchSize);
        }
        long normalTime = System.currentTimeMillis() - startNormal;
        System.out.println("Small Batch results: Batch size=" + batchSize + " Number of runs=" + times);
        System.out.println("Expression Time: " + expressionTime + " Avg: " + (double)expressionTime / (double)times);
        System.out.println("Normal Time: " + normalTime + " Avg: " + (double)normalTime / (double)times);
        if (normalTime == 0L) {
            normalTime = 1L;
        }
        int improvement = (int)((1.0 - (double)expressionTime / (double)normalTime) * 100.0);
        System.out.println("Improvement of expression over normal time: " + improvement + '%');
        if (!(this.proxyFactory instanceof IDEStandardBeanProxyFactory)) {
            ExpressionTest.assertTrue((String)("Less than 30% improvement: " + improvement + '%'), (improvement >= 30 ? 1 : 0) != 0);
        }
    }

    public void ExpressionPerformanceLarge() throws IllegalStateException, NoExpressionValueException, ThrowableProxy, AmbiguousMethodException, NoSuchMethodException {
        IBeanTypeProxy pointType = this.proxyTypeFactory.getBeanTypeProxy("java.awt.Point");
        IMethodProxy setLocation = pointType.getMethodProxy("setLocation", new String[]{"int", "int"});
        IMethodProxy getLocation = pointType.getMethodProxy("getLocation");
        IExpression exp = this.proxyFactory.createExpression();
        int i = 1000;
        while (i-- > 0) {
            exp.createArrayCreation(ForExpression.ROOTEXPRESSION, this.registry.getBeanTypeProxyFactory().getBeanTypeProxy(exp, "java.lang.Object", 1), 0);
            exp.createArrayInitializer(0);
        }
        exp.invokeExpression();
        int times = 25;
        int batchSize = 100;
        long start = System.currentTimeMillis();
        i = times;
        while (i-- > 0) {
            this.expressionSetting(pointType, setLocation, getLocation, batchSize);
        }
        long expressionTime = System.currentTimeMillis() - start;
        long startNormal = System.currentTimeMillis();
        i = times;
        while (i-- > 0) {
            this.normalSetting(pointType, setLocation, getLocation, batchSize);
        }
        long normalTime = System.currentTimeMillis() - startNormal;
        System.out.println("Large Batch results: Batch size=" + batchSize + " Number of runs=" + times);
        System.out.println("Expression Time: " + expressionTime + " Avg: " + (double)expressionTime / (double)times);
        System.out.println("Normal Time: " + normalTime + " Avg: " + (double)normalTime / (double)times);
        if (normalTime == 0L) {
            normalTime = 1L;
        }
        int improvement = (int)((1.0 - (double)expressionTime / (double)normalTime) * 100.0);
        System.out.println("Improvement of expression over normal time: " + improvement + '%');
        if (!(this.proxyFactory instanceof IDEStandardBeanProxyFactory)) {
            ExpressionTest.assertTrue((String)("Less than 75% improvement: " + improvement + '%'), (improvement >= 75 ? 1 : 0) != 0);
        }
    }

    private void expressionSetting(IBeanTypeProxy pointType, IMethodProxy setLocation, IMethodProxy getLocation, int times) throws ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        int i = 0;
        while (i < times) {
            ExpressionProxy epPoint = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            exp.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, (IProxyBeanType)pointType, 0);
            exp.createSimpleMethodInvoke((IProxyMethod)setLocation, (IProxy)epPoint, new IProxy[]{this.proxyFactory.createBeanProxyWith(3), this.proxyFactory.createBeanProxyWith(4)}, false);
            ExpressionProxy epLoc = exp.createSimpleMethodInvoke((IProxyMethod)getLocation, (IProxy)epPoint, null, true);
            epLoc.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter());
            ++i;
        }
        exp.invokeExpression();
    }

    private void normalSetting(IBeanTypeProxy pointType, IMethodProxy setLocation, IMethodProxy getLocation, int times) throws ThrowableProxy, AmbiguousMethodException, NoSuchMethodException {
        int i = 0;
        while (i < times) {
            IBeanProxy epPoint = pointType.newInstance();
            setLocation.invokeCatchThrowableExceptions(epPoint, new IBeanProxy[]{this.proxyFactory.createBeanProxyWith(3), this.proxyFactory.createBeanProxyWith(4)});
            getLocation.invokeCatchThrowableExceptions(epPoint);
            ++i;
        }
    }

    public void testBlock() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        int blocknum = exp.createBlockBegin();
        ExpressionProxy epArg = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, true);
        exp.createBlockBreak(blocknum);
        ExpressionProxy epBoolean = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), 1);
        exp.createInfixExpression(ForExpression.CLASSINSTANCECREATION_ARGUMENT, InfixOperator.IN_CONDITIONAL_AND, 0);
        exp.createProxyExpression(ForExpression.INFIX_LEFT, (IProxy)epArg);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, true);
        exp.createBlockEnd();
        ExpressionNotResolved epBooleanl = new ExpressionNotResolved();
        epBoolean.addProxyListener((ExpressionProxy.ProxyListener)epBooleanl);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)epBooleanl.notResolvedCalled);
    }

    public void testTryCatchNoThrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTry2CatchNoThrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy runtimeCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver2 = new ExpressionNotResolved();
        runtimeCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver2);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver2.notResolvedCalled);
    }

    public void testTry2CatchThrowTry1() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy wProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy runtimeCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved wProxyResolver = new ExpressionNotResolved();
        wProxy.addProxyListener((ExpressionProxy.ProxyListener)wProxyResolver);
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        runtimeCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)wProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTry2CatchThrowTry2Catch() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy wProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        wProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved runtimeCatchExceptionProxyResolver2 = new ExpressionNotResolved();
        runtimeCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver2);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver2.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
    }

    public void testTry2CatchThrowTry2Catch1() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy illegalArgumentCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy wProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved illegalArgumentCatchProxyResolver = new ExpressionNotResolved();
        illegalArgumentCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalArgumentCatchProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved wProxyResolver = new ExpressionNotResolved();
        wProxy.addProxyListener((ExpressionProxy.ProxyListener)wProxyResolver);
        runtimeCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalArgumentCatchProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)wProxyResolver.notResolvedCalled);
    }

    public void testTry2CatchThrowTry2Finally2Catch1() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy illegalArgumentCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy vProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy wProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved illegalArgumentCatchProxyResolver = new ExpressionNotResolved();
        illegalArgumentCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalArgumentCatchProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        vProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved wProxyResolver = new ExpressionNotResolved();
        wProxy.addProxyListener((ExpressionProxy.ProxyListener)wProxyResolver);
        runtimeCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalArgumentCatchProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)wProxyResolver.notResolvedCalled);
    }

    public void testTry2CatchThrowTry2Finally2NoCatch() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy illegalArgumentCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy vProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionProxy wProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy illegalArgumentCatchExceptionProxy2 = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved illegalArgumentCatchProxyResolver = new ExpressionNotResolved();
        illegalArgumentCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalArgumentCatchProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        vProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved wProxyResolver = new ExpressionNotResolved();
        wProxy.addProxyListener((ExpressionProxy.ProxyListener)wProxyResolver);
        ExpressionNotResolved illegalArgumentCatchExceptionProxyResolver2 = new ExpressionNotResolved();
        illegalArgumentCatchExceptionProxy2.addProxyListener((ExpressionProxy.ProxyListener)illegalArgumentCatchExceptionProxyResolver2);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        boolean didit = false;
        try {
            exp.invokeExpression();
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((Object)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), (Object)e.getTypeProxy());
            didit = true;
        }
        ExpressionTest.assertTrue((boolean)didit);
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalArgumentCatchProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)wProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalArgumentCatchExceptionProxyResolver2.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
    }

    public void testTryCatchThrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
    }

    public void testTryCatchRethrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createRethrow();
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        try {
            exp.invokeExpression();
            ExpressionTest.fail((String)"Should of thrown NPE.");
        }
        catch (ThrowableProxy e) {
            ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)e.getTypeProxy().getTypeName());
        }
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
    }

    public void testTryCatchExplicitThrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        exp.createThrow();
        exp.createClassInstanceCreation(ForExpression.THROW_OPERAND, (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), 0);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2NoThrow() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy illegalCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved illegalCatchExceptionProxyResolver = new ExpressionNotResolved();
        illegalCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalCatchExceptionProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalCatchExceptionProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2Throw1() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2Throw2() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy illegalCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved illegalCatchExceptionProxyResolver = new ExpressionNotResolved();
        illegalCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalCatchExceptionProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatchThrowFinally() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy fProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        fProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2Throw1Finally() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy fProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        fProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2Throw2Finally() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("booleanValue"), null, null, true);
        ExpressionProxy illegalCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy nullCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.NullPointerException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy fProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        ExpressionNotResolved xProxyResolver = new ExpressionNotResolved();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)xProxyResolver);
        ExpressionNotResolved illegalCatchExceptionProxyResolver = new ExpressionNotResolved();
        illegalCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalCatchExceptionProxyResolver);
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        nullCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                ExpressionTest.assertEquals((String)"java.lang.NullPointerException", (String)event.getProxy().getTypeProxy().getTypeName());
            }
        });
        fProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)xProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatchNoThrowFinally() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy fProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        fProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testTryCatch2NoThrowFinally() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createTry();
        ExpressionProxy xProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(true)}, true);
        ExpressionProxy illegalCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.IllegalArgumentException"), true);
        ExpressionProxy yProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        ExpressionProxy runtimeCatchExceptionProxy = exp.createTryCatchClause((IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException"), true);
        ExpressionProxy zProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryFinallyClause();
        ExpressionProxy fProxy = exp.createSimpleMethodInvoke((IProxyMethod)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean").getMethodProxy("valueOf", new String[]{"boolean"}), null, new IProxy[]{this.proxyFactory.createBeanProxyWith(false)}, true);
        exp.createTryEnd();
        xProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertTrue((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        ExpressionNotResolved yProxyResolver = new ExpressionNotResolved();
        yProxy.addProxyListener((ExpressionProxy.ProxyListener)yProxyResolver);
        ExpressionNotResolved illegalCatchExceptionProxyResolver = new ExpressionNotResolved();
        illegalCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)illegalCatchExceptionProxyResolver);
        ExpressionNotResolved runtimeCatchExceptionProxyResolver = new ExpressionNotResolved();
        runtimeCatchExceptionProxy.addProxyListener((ExpressionProxy.ProxyListener)runtimeCatchExceptionProxyResolver);
        ExpressionNotResolved zProxyResolver = new ExpressionNotResolved();
        zProxy.addProxyListener((ExpressionProxy.ProxyListener)zProxyResolver);
        fProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy proxy = event.getProxy();
                ExpressionTest.assertEquals((String)("Not a Boolean proxy:" + proxy.getTypeProxy().getTypeName()), (Object)ExpressionTest.this.proxyTypeFactory.getBeanTypeProxy("java.lang.Boolean"), (Object)proxy.getTypeProxy());
                ExpressionTest.assertFalse((boolean)((IBooleanBeanProxy)event.getProxy()).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertTrue((boolean)yProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)illegalCatchExceptionProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)zProxyResolver.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)runtimeCatchExceptionProxyResolver.notResolvedCalled);
    }

    public void testIfElseTrueWithElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(true);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.IF_TRUE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy falseProxy = exp.createProxyAssignmentExpression(ForExpression.IF_ELSE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)value).intValue());
            }
        });
        falseProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        exp.invokeExpression();
    }

    public void testIfElseFalseWithElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(true);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.IF_TRUE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy falseProxy = exp.createProxyAssignmentExpression(ForExpression.IF_ELSE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        falseProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)0, (int)((INumberBeanProxy)value).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testIfElseTrueWithoutElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(false);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.IF_TRUE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)value).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testIfElseFalseWithoutElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(false);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.IF_TRUE);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        exp.invokeExpression();
    }

    public void testIfElseBlocksTrueWithElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(true);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockBegin();
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        exp.createBlockBegin();
        ExpressionProxy falseProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)value).intValue());
            }
        });
        falseProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        exp.invokeExpression();
    }

    public void testIfElseBlocksFalseWithElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(true);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockBegin();
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        exp.createBlockBegin();
        ExpressionProxy falseProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_MINUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        falseProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)0, (int)((INumberBeanProxy)value).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testIfElseBlockTrueWithoutElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(false);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockBegin();
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"int", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((int)6, (int)((INumberBeanProxy)value).intValue());
            }
        });
        exp.invokeExpression();
    }

    public void testIfElseBlockFalseWithoutElse() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createIfElse(false);
        exp.createInfixExpression(ForExpression.IF_CONDITION, InfixOperator.IN_EQUALS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)4);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockBegin();
        ExpressionProxy trueProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_PLUS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, (byte)3);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, (short)3);
        exp.createBlockEnd();
        trueProxy.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionNotResolved());
        exp.invokeExpression();
    }

    public void testNewInitStringPrimitive() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        Expression exp = (Expression)this.proxyFactory.createExpression();
        ExpressionProxy result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
        result.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"boolean", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)value).booleanValue());
            }
        });
        exp.invokeExpression();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMark() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        Expression exp = (Expression)this.proxyFactory.createExpression();
        int mark = exp.mark();
        try {
            ExpressionProxy result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
            result.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    IBeanProxy value = event.getProxy();
                    ExpressionTest.assertNotNull((Object)value);
                    ExpressionTest.assertEquals((String)"boolean", (String)value.getTypeProxy().getFormalTypeName());
                    ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)value).booleanValue());
                }
            });
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            exp.endMark(mark);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        exp.endMark(mark);
        exp.invokeExpression();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMark2() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        Expression exp = (Expression)this.proxyFactory.createExpression();
        int mark0 = exp.mark();
        final boolean[] resultResolved = new boolean[1];
        ExpressionNotResolved ep1 = null;
        final boolean[] resultResolved2 = new boolean[1];
        try {
            ExpressionProxy result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            result.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    IBeanProxy value = event.getProxy();
                    ExpressionTest.assertNotNull((Object)value);
                    ExpressionTest.assertEquals((String)"boolean", (String)value.getTypeProxy().getFormalTypeName());
                    ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)value).booleanValue());
                    resultResolved[0] = true;
                }
            });
            exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
            exp.createTry();
            int mark = exp.mark();
            try {
                try {
                    ExpressionProxy result1 = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                    ep1 = new ExpressionNotResolved();
                    result1.addProxyListener((ExpressionProxy.ProxyListener)ep1);
                    exp.createNewInstance(ForExpression.ASSIGNMENT_LEFT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
                }
                catch (IllegalStateException illegalStateException) {}
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                exp.endMark(mark);
                throw throwable;
            }
            {
                Object var9_11 = null;
            }
            exp.endMark(mark);
            exp.createTryEnd();
            ExpressionProxy result2 = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            result2.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    IBeanProxy value = event.getProxy();
                    ExpressionTest.assertNotNull((Object)value);
                    ExpressionTest.assertEquals((String)"boolean", (String)value.getTypeProxy().getFormalTypeName());
                    ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)value).booleanValue());
                    resultResolved2[0] = true;
                }
            });
            exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            exp.endMark(mark0);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        exp.endMark(mark0);
        exp.invokeExpression();
        ExpressionTest.assertNotNull((Object)ep1);
        ExpressionTest.assertTrue((boolean)ep1.notResolvedCalled);
        ExpressionTest.assertTrue((boolean)resultResolved[0]);
        ExpressionTest.assertTrue((boolean)resultResolved2[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMarkError() throws IllegalStateException, ThrowableProxy, NoExpressionValueException {
        ExpressionProxy result;
        Expression exp = (Expression)this.proxyFactory.createExpression();
        int mark = exp.mark();
        ExpressionNotResolved epl = null;
        try {
            try {
                result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                epl = new ExpressionNotResolved();
                result.addProxyListener((ExpressionProxy.ProxyListener)epl);
                exp.createNewInstance(ForExpression.ASSIGNMENT_LEFT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            exp.endMark(mark);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        exp.endMark(mark);
        result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
        result.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy value = event.getProxy();
                ExpressionTest.assertNotNull((Object)value);
                ExpressionTest.assertEquals((String)"boolean", (String)value.getTypeProxy().getFormalTypeName());
                ExpressionTest.assertEquals((boolean)false, (boolean)((IBooleanBeanProxy)value).booleanValue());
            }
        });
        exp.invokeExpression();
        ExpressionTest.assertNotNull((Object)epl);
        ExpressionTest.assertTrue((boolean)epl.notResolvedCalled);
    }

    public void testMarkNestError() {
        Expression exp = (Expression)this.proxyFactory.createExpression();
        int mark = exp.mark();
        ExpressionNotResolved epl = null;
        try {
            exp.createTry();
            ExpressionProxy result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            epl = new ExpressionNotResolved();
            result.addProxyListener((ExpressionProxy.ProxyListener)epl);
            exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
            exp.endMark(mark);
            exp.createTryFinallyClause();
            exp.createTryEnd();
        }
        catch (IllegalStateException illegalStateException) {
            exp.close();
            ExpressionTest.assertNotNull(epl);
            ExpressionTest.assertTrue((boolean)epl.notResolvedCalled);
            return;
        }
        exp.close();
        ExpressionTest.fail((String)"Should not of gotten here.");
    }

    public void testMarkNestError2() {
        Expression exp = (Expression)this.proxyFactory.createExpression();
        ExpressionNotResolved epl = null;
        try {
            exp.createTry();
            int mark = exp.mark();
            ExpressionProxy result = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            epl = new ExpressionNotResolved();
            result.addProxyListener((ExpressionProxy.ProxyListener)epl);
            exp.createNewInstance(ForExpression.ASSIGNMENT_RIGHT, "false", (IProxyBeanType)this.proxyTypeFactory.getBeanTypeProxy("boolean"));
            exp.createTryFinallyClause();
            exp.createTryEnd();
            exp.endMark(mark);
        }
        catch (IllegalStateException illegalStateException) {
            exp.close();
            ExpressionTest.assertNotNull(epl);
            ExpressionTest.assertTrue((boolean)epl.notResolvedCalled);
            return;
        }
        exp.close();
        ExpressionTest.fail((String)"Should not of gotten here.");
    }

    public void testExpressionTransfer() throws Throwable {
        IExpression exp = this.proxyFactory.createExpression();
        ExpressionProxy epInfix = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createInfixExpression(ForExpression.ASSIGNMENT_RIGHT, InfixOperator.IN_LESS, 0);
        exp.createPrimitiveLiteral(ForExpression.INFIX_LEFT, -10000000);
        exp.createPrimitiveLiteral(ForExpression.INFIX_RIGHT, 3);
        Expression expression = (Expression)exp;
        expression.beginTransferThread();
        IBeanTypeProxy callbackType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.tests.proxy.vm.TestExpressionThreadTransfer");
        ExpressionTest.assertNotNull((Object)callbackType);
        IBeanProxy callbackProxy = callbackType.newInstance();
        ExpressionThreadTransferCallBack cb = new ExpressionThreadTransferCallBack(expression);
        this.registry.getCallbackRegistry().registerCallback(callbackProxy, (ICallback)cb);
        IInvokable start = callbackType.getInvokable("start");
        start.invokeCatchThrowableExceptions(callbackProxy);
        epInfix.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                IBeanProxy result = event.getProxy();
                ExpressionTest.assertNotNull((Object)result);
                ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
                ExpressionTest.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)result).booleanValue());
            }
        });
        if (cb.error != null) {
            throw cb.error;
        }
        cb.ep.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionResolved(){

            public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                Class<?> clazz;
                IBeanProxy result = event.getProxy();
                ExpressionTest.assertNotNull((Object)result);
                ExpressionTest.assertEquals((String)"boolean", (String)result.getTypeProxy().getTypeName());
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((clazz = class$0) == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ExpressionTest.assertEquals((clazz2 == clazz ? 1 : 0) != 0, (boolean)((IBooleanBeanProxy)result).booleanValue());
            }
        });
        expression.transferThread();
        exp.invokeExpression();
    }

    public void testSubexpression() throws IllegalStateException, IllegalArgumentException, ThrowableProxy, NoExpressionValueException {
        IExpression exp = this.proxyFactory.createExpression();
        exp.createArrayCreation(ForExpression.ROOTEXPRESSION, "int[][][]", 2);
        exp.createPrimitiveLiteral(ForExpression.ARRAYCREATION_DIMENSION, 2);
        ExpressionProxy secondDimensionProxy = null;
        exp.createSubexpression();
        exp.createTry();
        secondDimensionProxy = exp.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        exp.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 4);
        exp.createTryEnd();
        exp.createSubexpressionEnd();
        exp.createProxyExpression(ForExpression.ARRAYCREATION_DIMENSION, (IProxy)secondDimensionProxy);
        IBeanProxy result = exp.getExpressionValue();
        ExpressionTest.assertNotNull((Object)result);
        ExpressionTest.assertEquals((String)"int[][][]", (String)result.getTypeProxy().getFormalTypeName());
        ExpressionTest.assertEquals((int)2, (int)((IArrayBeanProxy)result).getLength());
        ExpressionTest.assertEquals((int)4, (int)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).getLength());
        ExpressionTest.assertNull((Object)((IArrayBeanProxy)((IArrayBeanProxy)result).get(0)).get(0));
    }

    protected class ExpressionNotResolved
    implements ExpressionProxy.ProxyListener {
        public boolean notResolvedCalled = false;

        protected ExpressionNotResolved() {
        }

        public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            this.notResolvedCalled = true;
        }

        public void proxyResolved(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy should not of been resolved. It should be unresolved.");
        }

        public void proxyVoid(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy must not be void assignment. It should be unresolved.");
        }
    }

    protected abstract class ExpressionResolved
    implements ExpressionProxy.ProxyListener {
        protected ExpressionResolved() {
        }

        public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy must not be unresolved.");
        }

        public void proxyVoid(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy must not be void assignment.");
        }
    }

    protected class ExpressionVoid
    implements ExpressionProxy.ProxyListener {
        public boolean voidCalled = false;

        protected ExpressionVoid() {
        }

        public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy should of been void and not unresolved.");
        }

        public void proxyResolved(ExpressionProxy.ProxyEvent event) {
            ExpressionTest.fail((String)"Proxy should not of been resolved, it should of been void..");
        }

        public void proxyVoid(ExpressionProxy.ProxyEvent event) {
            this.voidCalled = true;
        }
    }
}

