/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy;

import java.io.IOException;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.core.CollectionBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.IteratorBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.ListBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.ListIteratorBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.tests.proxy.AbstractTestProxy;
import org.eclipse.jem.tests.proxy.TestCallback;
import org.eclipse.jem.tests.proxy.TestCallbackStream;

public class TestStandard
extends AbstractTestProxy {
    public TestStandard() {
    }

    public TestStandard(String name) {
        super(name);
    }

    public void testObject() {
        IBeanTypeProxy objectType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Object");
        TestStandard.assertNotNull((Object)objectType);
        TestStandard.assertFalse((boolean)objectType.isArray());
        TestStandard.assertEquals((String)"java.lang.Object", (String)objectType.getTypeName());
    }

    public void testTypeOf() {
        IBeanTypeProxy objectType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Object");
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        TestStandard.assertNotNull((Object)integerType);
        TestStandard.assertEquals((String)"java.lang.Integer", (String)integerType.getTypeName());
        TestStandard.assertTrue((boolean)integerType.isKindOf(objectType));
    }

    public void testMethodInvoke() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IMethodProxy mthd = integerType.getMethodProxy("valueOf", "java.lang.String");
        TestStandard.assertNotNull((Object)mthd);
        IIntegerBeanProxy anInt = (IIntegerBeanProxy)mthd.invoke(null, (IBeanProxy)this.proxyFactory.createBeanProxyWith("5"));
        TestStandard.assertNotNull((Object)anInt);
        TestStandard.assertEquals((int)5, (int)anInt.intValue());
        try {
            mthd.invoke(null, (IBeanProxy)this.proxyFactory.createBeanProxyWith(5));
            TestStandard.fail((String)"Exception not thrown like it should of been.");
        }
        catch (ThrowableProxy e) {
            TestStandard.assertEquals((String)"java.lang.IllegalArgumentException", (String)e.getTypeProxy().getTypeName());
        }
    }

    public void testInvoke() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IInvokable invokable = integerType.getInvokable("valueOf", "java.lang.String");
        TestStandard.assertNotNull((Object)invokable);
        IIntegerBeanProxy anInt = (IIntegerBeanProxy)invokable.invoke(null, (IBeanProxy)this.proxyFactory.createBeanProxyWith("5"));
        TestStandard.assertNotNull((Object)anInt);
        TestStandard.assertEquals((int)5, (int)anInt.intValue());
        try {
            invokable.invoke(null, (IBeanProxy)this.proxyFactory.createBeanProxyWith(5));
            TestStandard.fail((String)"Exception not thrown like it should of been.");
        }
        catch (ThrowableProxy e) {
            TestStandard.assertEquals((String)"java.lang.IllegalArgumentException", (String)e.getTypeProxy().getTypeName());
        }
    }

    public void testSimpleInitString() throws ThrowableProxy, InstantiationException {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IIntegerBeanProxy anInt = (IIntegerBeanProxy)integerType.newInstance("new java.lang.Integer(6)");
        TestStandard.assertNotNull((Object)anInt);
        TestStandard.assertEquals((int)6, (int)anInt.intValue());
        IStringBeanProxy aString = (IStringBeanProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.String").newInstance("\"abcd\"");
        TestStandard.assertNotNull((Object)aString);
        TestStandard.assertEquals((String)"abcd", (String)aString.stringValue());
    }

    public void testGetConstructors() {
        IBeanTypeProxy stringType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.String");
        IConstructorProxy[] ctors = stringType.getConstructors();
        TestStandard.assertNotNull((Object)ctors);
        int expectedCtors = System.getProperty("java.version", "").startsWith("1.5") ? 13 : 11;
        TestStandard.assertEquals((int)expectedCtors, (int)ctors.length);
    }

    public void testGetDeclaredConstructors() {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IConstructorProxy[] ctors = testAccessType.getDeclaredConstructors();
        TestStandard.assertNotNull((Object)ctors);
        TestStandard.assertEquals((int)4, (int)ctors.length);
    }

    public void testSimpleConstructor() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IConstructorProxy ctor = integerType.getConstructorProxy(new String[]{"java.lang.String"});
        TestStandard.assertNotNull((Object)ctor);
        IIntegerBeanProxy anInt = (IIntegerBeanProxy)ctor.newInstance(new IBeanProxy[]{this.proxyFactory.createBeanProxyWith("0")});
        TestStandard.assertEquals((int)0, (int)anInt.intValue());
        IIntegerBeanProxy aZero = this.proxyFactory.createBeanProxyWith(new Integer(0));
        TestStandard.assertSame((Object)anInt, (Object)aZero);
    }

    public void testSimpleDeclaredConstructor() throws ThrowableProxy {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IConstructorProxy ctor = testAccessType.getDeclaredConstructorProxy(new String[]{"java.lang.RuntimeException"});
        TestStandard.assertNotNull((Object)ctor);
    }

    public void testPrimitiveReturn() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IMethodProxy mthdPrim = integerType.getMethodProxy("intValue");
        IIntegerBeanProxy anInt = (IIntegerBeanProxy)mthdPrim.invoke((IBeanProxy)this.proxyFactory.createBeanProxyWith(5));
        TestStandard.assertEquals((String)"int", (String)anInt.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)5, (int)anInt.intValue());
        IFieldProxy fieldPrim = integerType.getFieldProxy("MIN_VALUE");
        anInt = (IIntegerBeanProxy)fieldPrim.get(null);
        TestStandard.assertEquals((String)"int", (String)anInt.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)Integer.MIN_VALUE, (int)anInt.intValue());
    }

    public void testPrimitiveArrayType() {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("[I");
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[I", (String)arrayType.getTypeName());
        TestStandard.assertEquals((Object)this.proxyTypeFactory.getBeanTypeProxy("int"), (Object)arrayType.getComponentType());
    }

    public void testObjectArrayType() {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("[Ljava.lang.Integer;");
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[Ljava.lang.Integer;", (String)arrayType.getTypeName());
        TestStandard.assertEquals((Object)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer"), (Object)arrayType.getComponentType());
    }

    public void testPrimitive2DArrayType() {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("[[I");
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[[I", (String)arrayType.getTypeName());
        TestStandard.assertEquals((Object)this.proxyTypeFactory.getBeanTypeProxy("[I"), (Object)arrayType.getComponentType());
        arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("int", 2);
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[[I", (String)arrayType.getTypeName());
    }

    public void testObject2DArrayType() {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("[[Ljava.lang.Integer;");
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayType.getTypeName());
        TestStandard.assertEquals((Object)this.proxyTypeFactory.getBeanTypeProxy("[Ljava.lang.Integer;"), (Object)arrayType.getComponentType());
        arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 2);
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayType.getTypeName());
    }

    public void testArrayTypeFromArrayType() {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("[Ljava.lang.Integer;", 2);
        TestStandard.assertNotNull((Object)arrayType);
        TestStandard.assertTrue((boolean)arrayType.isArray());
        TestStandard.assertEquals((String)"[[[Ljava.lang.Integer;", (String)arrayType.getTypeName());
    }

    public void testArrayFromAccessorSimpleType() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith(integerType, new int[]{3, 4});
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)3, (int)arrayProxy.getLength());
        arrayProxy = (IArrayBeanProxy)arrayProxy.get(0);
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((int)4, (int)arrayProxy.getLength());
    }

    public void testArrayFromAccessorArrayType() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, new int[]{1});
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)1, (int)arrayProxy.getLength());
    }

    public void testArrayFromAccessorArrayTypeMultiDim() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, new int[]{2, 3});
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)2, (int)arrayProxy.getLength());
        IArrayBeanProxy idx1 = (IArrayBeanProxy)arrayProxy.get(0);
        TestStandard.assertNotNull((Object)idx1);
        TestStandard.assertEquals((int)3, (int)idx1.getLength());
        IBeanProxy idx2 = arrayProxy.get(new int[]{1, 2});
        TestStandard.assertNull((Object)idx2);
    }

    public void testArraySet() throws ThrowableProxy {
        IIntegerBeanProxy anInt = this.proxyFactory.createBeanProxyWith(new Integer(23));
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, new int[]{2, 3});
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)2, (int)arrayProxy.getLength());
        IArrayBeanProxy idx1 = (IArrayBeanProxy)arrayProxy.get(0);
        idx1.set((IBeanProxy)anInt, 2);
        int[] nArray = new int[2];
        nArray[1] = 2;
        IBeanProxy idx3 = arrayProxy.get(nArray);
        TestStandard.assertNotNull((Object)idx3);
        TestStandard.assertEquals((String)"java.lang.Integer", (String)idx3.getTypeProxy().getTypeName());
        TestStandard.assertEquals((Object)anInt, (Object)idx3);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        arrayProxy.set((IBeanProxy)anInt, nArray2);
        TestStandard.assertEquals((Object)anInt, (Object)idx1.get(1));
    }

    public void testArraySnapshot2DimArray() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 2);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, new int[]{2, 3});
        TestStandard.assertNotNull((Object)arrayProxy);
        IArrayBeanProxy idx0 = (IArrayBeanProxy)arrayProxy.get(0);
        IArrayBeanProxy idx1 = (IArrayBeanProxy)arrayProxy.get(1);
        IBeanProxy[] snapshot = arrayProxy.getSnapshot();
        TestStandard.assertEquals((Object)idx0, (Object)snapshot[0]);
        TestStandard.assertEquals((Object)idx1, (Object)snapshot[1]);
    }

    public void testArraySnapshotPrimitiveArray() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("int", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, new int[]{2});
        TestStandard.assertNotNull((Object)arrayProxy);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(2), 0);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(3), 1);
        IIntegerBeanProxy idx0 = (IIntegerBeanProxy)arrayProxy.get(0);
        IIntegerBeanProxy idx1 = (IIntegerBeanProxy)arrayProxy.get(1);
        TestStandard.assertEquals((int)2, (int)idx0.intValue());
        TestStandard.assertEquals((int)3, (int)idx1.intValue());
        IBeanProxy[] snapshot = arrayProxy.getSnapshot();
        TestStandard.assertEquals((Object)idx0, (Object)snapshot[0]);
        TestStandard.assertEquals((Object)idx1, (Object)snapshot[1]);
    }

    public void testEmptyArray() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, null);
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)0, (int)arrayProxy.getLength());
    }

    public void testEmpty2DArray() throws ThrowableProxy {
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 2), null);
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)0, (int)arrayProxy.getLength());
    }

    public void test2DArray() throws ThrowableProxy {
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith(this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 2), 3);
        TestStandard.assertNotNull((Object)arrayProxy);
        TestStandard.assertEquals((String)"[[Ljava.lang.Integer;", (String)arrayProxy.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)3, (int)arrayProxy.getLength());
        IArrayBeanProxy idx1 = (IArrayBeanProxy)arrayProxy.get(0);
        TestStandard.assertNull((Object)idx1);
    }

    public void testPrimitiveArray() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("int", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(44), 1);
        IBeanProxy idx1 = arrayProxy.get(1);
        TestStandard.assertNotNull((Object)idx1);
        TestStandard.assertEquals((String)"int", (String)idx1.getTypeProxy().getTypeName());
        TestStandard.assertEquals((int)44, (int)((IIntegerBeanProxy)idx1).intValue());
    }

    public void testArrayEquals() throws ThrowableProxy {
        this.primIntEquals();
        this.primBoolEquals();
        this.primByteEquals();
        this.primShortEquals();
        this.primCharEquals();
        this.primDoubleEquals();
        this.primFloatEquals();
        this.primLongEquals();
        this.objectEquals();
    }

    private void primIntEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("int", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(44), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(44), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(55), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
        IArrayBeanTypeProxy array3Type = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("long", 1);
        IArrayBeanProxy array3Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)array3Type, 3);
        array3Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(44L), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array3Proxy));
    }

    private void primBoolEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("boolean", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(true), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(true), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(false), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primByteEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("byte", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((byte)3), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((byte)3), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((byte)4), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primShortEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("short", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)3), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith((short)4), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primCharEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("char", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith('a'), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith('a'), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith('b'), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primDoubleEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("double", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(4.3), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(4.3), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(10.0), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primFloatEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("float", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(4.3f), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(4.3f), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(10.0f), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void primLongEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("long", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(1L), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(1L), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(2L), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    private void objectEquals() throws ThrowableProxy {
        IArrayBeanTypeProxy arrayType = (IArrayBeanTypeProxy)this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer", 1);
        IArrayBeanProxy arrayProxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        arrayProxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(new Integer(1)), 1);
        IArrayBeanProxy array2Proxy = this.proxyFactory.createBeanProxyWith((IBeanTypeProxy)arrayType, 3);
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(new Integer(1)), 1);
        TestStandard.assertTrue((boolean)arrayProxy.equals((Object)array2Proxy));
        array2Proxy.set((IBeanProxy)this.proxyFactory.createBeanProxyWith(new Integer(2)), 1);
        TestStandard.assertFalse((boolean)arrayProxy.equals((Object)array2Proxy));
    }

    public void testCollections() throws ThrowableProxy {
        IBeanTypeProxy vectorType = this.proxyTypeFactory.getBeanTypeProxy("java.util.Vector");
        IBeanProxy vectorProxy = vectorType.newInstance();
        CollectionBeanProxyWrapper col = new CollectionBeanProxyWrapper(vectorProxy);
        TestStandard.assertTrue((boolean)col.add((IBeanProxy)this.proxyFactory.createBeanProxyWith(33)));
        TestStandard.assertEquals((int)1, (int)col.size());
        IArrayBeanProxy arrayOut = col.toArray();
        TestStandard.assertEquals((int)1, (int)arrayOut.getLength());
        TestStandard.assertEquals((int)33, (int)((IIntegerBeanProxy)arrayOut.get(0)).intValue());
        IArrayBeanProxy arrayInto = this.proxyFactory.createBeanProxyWith(arrayOut.getTypeProxy(), arrayOut.getLength());
        IArrayBeanProxy arrayOut2 = col.toArray(arrayInto);
        TestStandard.assertTrue((boolean)arrayInto.sameAs((IBeanProxy)arrayOut2));
        TestStandard.assertEquals((int)33, (int)((IIntegerBeanProxy)arrayOut.get(0)).intValue());
        try {
            col = new CollectionBeanProxyWrapper((IBeanProxy)arrayOut);
            TestStandard.fail((String)"ClassCastException should of been thrown.");
        }
        catch (ClassCastException classCastException) {}
    }

    public void testIterator() throws ThrowableProxy {
        IBeanTypeProxy vectorType = this.proxyTypeFactory.getBeanTypeProxy("java.util.Vector");
        IBeanProxy vectorProxy = vectorType.newInstance();
        CollectionBeanProxyWrapper col = new CollectionBeanProxyWrapper(vectorProxy);
        col.add((IBeanProxy)this.proxyFactory.createBeanProxyWith(33));
        IteratorBeanProxyWrapper itrProxy = col.iterator();
        TestStandard.assertNotNull((Object)itrProxy);
        int iterations = 0;
        while (itrProxy.hasNext()) {
            TestStandard.assertTrue((++iterations < 2 ? 1 : 0) != 0);
            IBeanProxy itrValue = itrProxy.next();
            TestStandard.assertEquals((int)33, (int)((IIntegerBeanProxy)itrValue).intValue());
        }
    }

    public void testListInterface() throws ThrowableProxy {
        IBeanTypeProxy vectorType = this.proxyTypeFactory.getBeanTypeProxy("java.util.Vector");
        IBeanProxy vectorProxy = vectorType.newInstance();
        ListBeanProxyWrapper list = new ListBeanProxyWrapper(vectorProxy);
        TestStandard.assertTrue((boolean)list.add((IBeanProxy)this.proxyFactory.createBeanProxyWith(33)));
        list.add(0, (IBeanProxy)this.proxyFactory.createBeanProxyWith(true));
        TestStandard.assertEquals((int)2, (int)list.size());
        TestStandard.assertEquals((boolean)true, (boolean)((IBooleanBeanProxy)list.get(0)).booleanValue());
        TestStandard.assertEquals((int)33, (int)((IIntegerBeanProxy)list.get(1)).intValue());
    }

    public void testListIterator() throws ThrowableProxy {
        IBeanTypeProxy vectorType = this.proxyTypeFactory.getBeanTypeProxy("java.util.Vector");
        IBeanProxy vectorProxy = vectorType.newInstance();
        ListBeanProxyWrapper list = new ListBeanProxyWrapper(vectorProxy);
        list.add((IBeanProxy)this.proxyFactory.createBeanProxyWith(33));
        list.add(0, (IBeanProxy)this.proxyFactory.createBeanProxyWith(true));
        ListIteratorBeanProxyWrapper lItrProxy = list.listIterator();
        TestStandard.assertNotNull((Object)lItrProxy);
        TestStandard.assertTrue((boolean)lItrProxy.hasNext());
        IBooleanBeanProxy bool1 = (IBooleanBeanProxy)lItrProxy.next();
        TestStandard.assertEquals((boolean)true, (boolean)bool1.booleanValue());
        IIntegerBeanProxy int1 = (IIntegerBeanProxy)lItrProxy.next();
        TestStandard.assertEquals((int)33, (int)int1.intValue());
        TestStandard.assertFalse((boolean)lItrProxy.hasNext());
        TestStandard.assertEquals((int)1, (int)lItrProxy.previousIndex());
    }

    public void testMethodAccessors() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IBeanTypeProxy classTypeProxy = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Class");
        IMethodProxy getMethodMethod = classTypeProxy.getMethodProxy("getMethod", new String[]{"java.lang.String", "[Ljava.lang.Class;"});
        IBeanProxy[] iBeanProxyArray = new IBeanProxy[2];
        iBeanProxyArray[0] = this.proxyFactory.createBeanProxyWith("byteValue");
        IBeanProxy method = getMethodMethod.invoke((IBeanProxy)integerType, iBeanProxyArray);
        TestStandard.assertNotNull((Object)method);
        TestStandard.assertTrue((boolean)(method instanceof IMethodProxy));
        IBeanProxy byteValue = ((IMethodProxy)method).invoke((IBeanProxy)this.proxyFactory.createBeanProxyWith(new Integer(254)));
        TestStandard.assertNotNull((Object)byteValue);
        TestStandard.assertEquals((String)"byte", (String)byteValue.getTypeProxy().getTypeName());
        TestStandard.assertEquals((byte)-2, (byte)((INumberBeanProxy)byteValue).byteValue());
    }

    public void testInvokableAccessors() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IBeanTypeProxy classTypeProxy = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Class");
        IInvokable getMethodInvokable = classTypeProxy.getInvokable("getMethod", new String[]{"java.lang.String", "[Ljava.lang.Class;"});
        IBeanProxy[] iBeanProxyArray = new IBeanProxy[2];
        iBeanProxyArray[0] = this.proxyFactory.createBeanProxyWith("byteValue");
        IBeanProxy method = getMethodInvokable.invoke((IBeanProxy)integerType, iBeanProxyArray);
        TestStandard.assertNotNull((Object)method);
        TestStandard.assertTrue((boolean)(method instanceof IMethodProxy));
        IBeanProxy byteValue = ((IMethodProxy)method).invoke((IBeanProxy)this.proxyFactory.createBeanProxyWith(new Integer(254)));
        TestStandard.assertNotNull((Object)byteValue);
        TestStandard.assertEquals((String)"byte", (String)byteValue.getTypeProxy().getTypeName());
        TestStandard.assertEquals((byte)-2, (byte)((INumberBeanProxy)byteValue).byteValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallback() throws ThrowableProxy {
        System.out.println("--- Starting the callback test ---");
        IBeanTypeProxy callbackType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.tests.proxy.vm.TestCallback");
        TestStandard.assertNotNull((Object)callbackType);
        Object testObject = new Object();
        IBeanProxy callbackProxy = callbackType.newInstance();
        TestCallback cb = new TestCallback(testObject, this.registry);
        this.registry.getCallbackRegistry().registerCallback(callbackProxy, (ICallback)cb);
        IInvokable start = callbackType.getInvokable("start");
        IInvokable stop = callbackType.getInvokable("stop");
        Object object = testObject;
        synchronized (object) {
            start.invokeCatchThrowableExceptions(callbackProxy);
            try {
                testObject.wait(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        stop.invokeCatchThrowableExceptions(callbackProxy);
        this.registry.getCallbackRegistry().deregisterCallback(callbackProxy);
        cb.testCompleted();
        System.out.println("If there is anything in the .log file, then the test failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackStream() throws ThrowableProxy, IOException {
        System.out.println("--- Starting the callback stream test ---");
        IBeanTypeProxy callbackType = this.proxyTypeFactory.getBeanTypeProxy("org.eclipse.jem.tests.proxy.vm.TestCallbackStream");
        TestStandard.assertNotNull((Object)callbackType);
        Object testObject = new Object();
        IBeanProxy callbackProxy = callbackType.newInstance();
        TestCallbackStream cb = new TestCallbackStream(testObject);
        this.registry.getCallbackRegistry().registerCallback(callbackProxy, (ICallback)cb);
        IMethodProxy start = callbackType.getMethodProxy("start");
        Object object = testObject;
        synchronized (object) {
            start.invokeCatchThrowableExceptions(callbackProxy);
            try {
                testObject.wait(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.registry.getCallbackRegistry().deregisterCallback(callbackProxy);
        cb.testComplete();
        System.out.println("If there is anything in the .log file, then the test failed.");
    }

    public void testSimpleGetField() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IFieldProxy field = integerType.getFieldProxy("MAX_VALUE");
        TestStandard.assertNotNull((Object)field);
    }

    public void testSimpleGetDeclaredField() throws ThrowableProxy {
        IBeanTypeProxy integerType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer");
        IFieldProxy field = integerType.getDeclaredFieldProxy("value");
        TestStandard.assertNotNull((Object)field);
    }

    public void testGetFields() {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IFieldProxy[] fields = testAccessType.getFields();
        TestStandard.assertNotNull((Object)fields);
        TestStandard.assertEquals((int)2, (int)fields.length);
    }

    public void testGetDeclaredFields() {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IFieldProxy[] fields = testAccessType.getDeclaredFields();
        TestStandard.assertNotNull((Object)fields);
        TestStandard.assertEquals((int)3, (int)fields.length);
    }

    public void testSimpleGetMethod() throws ThrowableProxy {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IMethodProxy method = testAccessType.getMethodProxy("xyz");
        TestStandard.assertNotNull((Object)method);
    }

    public void testSimpleGetDeclaredMethod() throws ThrowableProxy {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IMethodProxy method = testAccessType.getDeclaredMethodProxy("qxr", null);
        TestStandard.assertNotNull((Object)method);
    }

    public void testGetMethods() {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IBeanTypeProxy testObjectType = this.proxyTypeFactory.getBeanTypeProxy("java.lang.Object");
        IMethodProxy[] methods = testAccessType.getMethods();
        IMethodProxy[] objectMethods = testObjectType.getMethods();
        TestStandard.assertNotNull((Object)methods);
        TestStandard.assertNotNull((Object)objectMethods);
        TestStandard.assertEquals((int)7, (int)(methods.length - objectMethods.length));
    }

    public void testGetDeclaredMethods() {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IMethodProxy[] methods = testAccessType.getDeclaredMethods();
        TestStandard.assertNotNull((Object)methods);
        TestStandard.assertEquals((int)8, (int)methods.length);
    }

    public void testFindCompatibleConstructor() throws AmbiguousMethodException, NoSuchMethodException, IllegalAccessException {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IConstructorProxy ctor = testAccessType.getCompatibleConstructor(new IBeanTypeProxy[]{this.proxyTypeFactory.getBeanTypeProxy("java.lang.ArrayStoreException")});
        IConstructorProxy comp = testAccessType.getDeclaredConstructorProxy(new IBeanTypeProxy[]{this.proxyTypeFactory.getBeanTypeProxy("java.lang.RuntimeException")});
        TestStandard.assertNotNull((Object)ctor);
        TestStandard.assertNotNull((Object)comp);
        TestStandard.assertEquals((Object)ctor, (Object)comp);
    }

    public void testFindCompatibleMethod() throws AmbiguousMethodException, NoSuchMethodException {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        IMethodProxy method = testAccessType.getCompatibleMethod("xyz", new IBeanTypeProxy[]{this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer")});
        IMethodProxy comp = testAccessType.getDeclaredMethodProxy("xyz", new IBeanTypeProxy[]{this.proxyTypeFactory.getBeanTypeProxy("java.lang.Number")});
        TestStandard.assertNotNull((Object)method);
        TestStandard.assertNotNull((Object)comp);
        TestStandard.assertEquals((Object)method, (Object)comp);
    }

    public void testFindAmbiguousMethod() throws NoSuchMethodException {
        IBeanTypeProxy testAccessType = this.proxyTypeFactory.getBeanTypeProxy("testPackage.TestAccess");
        try {
            testAccessType.getCompatibleMethod("ddd", new IBeanTypeProxy[]{this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer"), this.proxyTypeFactory.getBeanTypeProxy("java.lang.Integer")});
            TestStandard.fail((String)"Should of been ambiguous");
        }
        catch (AmbiguousMethodException ambiguousMethodException) {}
    }
}

