package oracle.adfdemo.view.faces.menu;
import java.beans.IntrospectionException;

import java.util.List;
import oracle.adf.view.faces.model.MenuModel;
import oracle.adf.view.faces.model.ViewIdPropertyMenuModel;

/**
 * This class facilitates the construction of a ViewIdPropertyMenuModel instance
 * via managed-beans. ViewIdPropertyMenuModel does not have a no-arg constructor.
 * This class does, and so can be instantiated as a managed-bean.
 * Two properties need to be set: "viewIdProperty" and "instance"
 */
public class MenuModelAdapter implements java.io.Serializable
{
  public MenuModelAdapter()
  {
  }

  private String _propertyName = null;
  private Object _instance = null;
  private transient MenuModel _model = null;
  private List _aliasList = null;

  public MenuModel getModel() throws IntrospectionException
  {
    if (_model == null)
    {
      ViewIdPropertyMenuModel model = 
                             new ViewIdPropertyMenuModel(getInstance(),
                                                         getViewIdProperty());
                                                         
      if(_aliasList != null && !_aliasList.isEmpty())    
      {
        int size = _aliasList.size();
        if (size % 2 == 1)
          size = size - 1;
          
        for ( int i = 0; i < size; i=i+2)
        {
          model.addViewId(_aliasList.get(i).toString(),
                         _aliasList.get(i+1).toString());
        }
      }
      
      _model = model;
    }
    return _model;
  }

  public String getViewIdProperty()
  {
    return _propertyName;
  }

  /**
   * Sets the property to use to get at view id
   * @param propertyName
   */
  public void setViewIdProperty(String propertyName)
  {
    _propertyName = propertyName;
    _model = null;
  }

  public Object getInstance()
  {
    return _instance;
  }

  /**
   * Sets the treeModel
   * @param instance must be something that can be converted into a TreeModel
   */
  public void setInstance(Object instance)
  {
    _instance = instance;
    _model = null;
  }
  

  public List getAliasList()
  {
    return _aliasList;
  }

  public void setAliasList(List aliasList)
  {
    _aliasList = aliasList;
  }  
}
