/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.ui.internal.adt.design.ImageOverlayDescriptor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDCommonUIUtils {
    public static Image getUpdatedImage(XSDConcreteComponent input, Image baseImage, boolean isReadOnly) {
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(input, false);
        if (xsdAnnotation != null && xsdAnnotation.getApplicationInformation().size() > 0) {
            String imageName = String.valueOf(input.getClass().getName()) + isReadOnly;
            Image newImage = XSDEditorPlugin.getDefault().getImageRegistry().get(imageName);
            if (newImage == null) {
                ImageOverlayDescriptor ovr = new ImageOverlayDescriptor(baseImage, isReadOnly);
                newImage = ovr.getImage();
                XSDEditorPlugin.getDefault().getImageRegistry().put(imageName, newImage);
            }
            return newImage;
        }
        return baseImage;
    }

    public static XSDAnnotation getInputXSDAnnotation(XSDConcreteComponent input, boolean createIfNotExist) {
        XSDAnnotation xsdAnnotation = null;
        XSDFactory factory = XSDFactory.eINSTANCE;
        if (input instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration xsdComp = (XSDAttributeDeclaration)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition xsdComp = (XSDAttributeGroupDefinition)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdComp = (XSDElementDeclaration)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDNotationDeclaration) {
            XSDNotationDeclaration xsdComp = (XSDNotationDeclaration)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDXPathDefinition) {
            XSDXPathDefinition xsdComp = (XSDXPathDefinition)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDModelGroup) {
            XSDModelGroup xsdComp = (XSDModelGroup)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition xsdComp = (XSDModelGroupDefinition)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDIdentityConstraintDefinition) {
            XSDIdentityConstraintDefinition xsdComp = (XSDIdentityConstraintDefinition)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (input instanceof XSDWildcard) {
            XSDWildcard xsdComp = (XSDWildcard)input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else {
            if (input instanceof XSDSchema) {
                XSDSchema xsdComp = (XSDSchema)input;
                EList list = xsdComp.getAnnotations();
                if (list.size() > 0) {
                    xsdAnnotation = (XSDAnnotation)list.get(0);
                } else if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = factory.createXSDAnnotation();
                    if (xsdComp.getContents() != null) {
                        xsdComp.getContents().add(0, (Object)xsdAnnotation);
                    }
                }
                return xsdAnnotation;
            }
            if (input instanceof XSDFacet) {
                XSDFacet xsdComp = (XSDFacet)input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (input instanceof XSDTypeDefinition) {
                XSDTypeDefinition xsdComp = (XSDTypeDefinition)input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (input instanceof XSDInclude) {
                XSDInclude xsdComp = (XSDInclude)input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (input instanceof XSDImport) {
                XSDImport xsdComp = (XSDImport)input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else {
                if (input instanceof XSDRedefine) {
                    XSDRedefine xsdComp = (XSDRedefine)input;
                    EList list = xsdComp.getAnnotations();
                    if (list.size() > 0) {
                        xsdAnnotation = (XSDAnnotation)list.get(0);
                    } else if (createIfNotExist) {
                        // empty if block
                    }
                    return xsdAnnotation;
                }
                if (input instanceof XSDAnnotation) {
                    xsdAnnotation = (XSDAnnotation)input;
                }
            }
        }
        if (createIfNotExist) {
            XSDCommonUIUtils.formatAnnotation(xsdAnnotation);
        }
        return xsdAnnotation;
    }

    private static void formatAnnotation(XSDAnnotation annotation) {
        Element element = annotation.getElement();
        XSDCommonUIUtils.formatChild(element);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatChild(Node child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode(child);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.changedModel();
    }

    public static String createUniqueElementName(String prefix, List elements) {
        ArrayList<String> usedNames = new ArrayList<String>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            usedNames.add(XSDCommonUIUtils.getDisplayName((XSDNamedComponent)i.next()));
        }
        int i2 = 1;
        String testName = prefix;
        while (usedNames.contains(testName)) {
            testName = String.valueOf(prefix) + i2++;
        }
        return testName;
    }

    public static String getDisplayName(XSDNamedComponent component) {
        if (component instanceof XSDTypeDefinition) {
            return XSDCommonUIUtils.getDisplayNameFromXSDType((XSDTypeDefinition)component);
        }
        if (component instanceof XSDFeature) {
            XSDFeature feature = (XSDFeature)component;
            if (feature.getName() != null) {
                return feature.getName();
            }
            if (feature.getResolvedFeature() != null && feature.getResolvedFeature().getName() != null) {
                return feature.getResolvedFeature().getName();
            }
        }
        return component.getName();
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type) {
        return XSDCommonUIUtils.getDisplayNameFromXSDType(type, true);
    }

    public static String getDisplayNameFromXSDType(XSDTypeDefinition type, boolean returnPrimitiveParents) {
        if (type == null) {
            return null;
        }
        if (type.getName() == null || type.getName().length() == 0) {
            if (returnPrimitiveParents && XSDCommonUIUtils.isPrimitiveType(type)) {
                return XSDCommonUIUtils.getDisplayNameFromXSDType(type.getBaseType());
            }
            EObject container = type.eContainer();
            while (container != null) {
                if (container instanceof XSDNamedComponent && ((XSDNamedComponent)container).getName() != null) {
                    return ((XSDNamedComponent)container).getName();
                }
                container = container.eContainer();
            }
            return null;
        }
        return type.getName();
    }

    public static boolean isPrimitiveType(XSDTypeDefinition type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return false;
        }
        XSDTypeDefinition baseType = null;
        if (type != null) {
            XSDTypeDefinition origType = baseType = type.getBaseType();
            while (baseType != null && !XSDConstants.isAnySimpleType((XSDTypeDefinition)baseType) && !XSDConstants.isAnyType((XSDTypeDefinition)baseType) && origType != baseType) {
                type = baseType;
                baseType = type.getBaseType();
            }
        } else {
            return false;
        }
        baseType = type;
        return "http://www.w3.org/2001/XMLSchema".equals(baseType.getTargetNamespace());
    }

    public static XSDSimpleTypeDefinition getAnonymousSimpleType(XSDFeature input, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        XSDSimpleTypeDefinition anonymousSimpleType = null;
        XSDTypeDefinition localType = null;
        if (input instanceof XSDElementDeclaration) {
            localType = ((XSDElementDeclaration)input).getAnonymousTypeDefinition();
        } else if (input instanceof XSDAttributeDeclaration) {
            localType = ((XSDAttributeDeclaration)input).getAnonymousTypeDefinition();
        }
        if (localType instanceof XSDSimpleTypeDefinition) {
            anonymousSimpleType = (XSDSimpleTypeDefinition)localType;
        }
        return anonymousSimpleType;
    }

    public static List getChildElements(XSDModelGroup group) {
        ArrayList<XSDParticleContent> children = new ArrayList<XSDParticleContent>();
        if (group == null) {
            return children;
        }
        Iterator i = group.getContents().iterator();
        while (i.hasNext()) {
            XSDParticle next = (XSDParticle)i.next();
            if (next.getContent() instanceof XSDFeature) {
                children.add(next.getContent());
                continue;
            }
            if (!(next.getTerm() instanceof XSDModelGroup)) continue;
            children.addAll(XSDCommonUIUtils.getChildElements((XSDModelGroup)next.getTerm()));
        }
        return children;
    }

    public static List getAllAttributes(XSDComplexTypeDefinition xsdComplexType) {
        List attributes = XSDCommonUIUtils.getChildElements(xsdComplexType);
        attributes.addAll(XSDCommonUIUtils.getChildAttributes(xsdComplexType));
        return attributes;
    }

    public static List getAllAttributes(XSDModelGroupDefinition xsdModelGroupDefinition) {
        List attributes = XSDCommonUIUtils.getChildElements(xsdModelGroupDefinition);
        return attributes;
    }

    public static List getInheritedAttributes(XSDComplexTypeDefinition ct) {
        ArrayList attrs = new ArrayList();
        XSDTypeDefinition parent = ct.getBaseTypeDefinition();
        if (parent != null && parent instanceof XSDComplexTypeDefinition && ct.isSetDerivationMethod()) {
            attrs.addAll(XSDCommonUIUtils.getAllAttributes((XSDComplexTypeDefinition)parent));
            if (!ct.isCircular()) {
                attrs.addAll(XSDCommonUIUtils.getInheritedAttributes((XSDComplexTypeDefinition)parent));
            }
        }
        return attrs;
    }

    public static List getChildElements(XSDComplexTypeDefinition ct) {
        return XSDCommonUIUtils.getChildElements(XSDCommonUIUtils.getModelGroup(ct));
    }

    public static List getChildElements(XSDModelGroupDefinition xsdModelGroupDefinition) {
        return XSDCommonUIUtils.getChildElements(xsdModelGroupDefinition.getModelGroup());
    }

    public static XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDComplexTypeContent content;
        XSDParticle particle = cType.getComplexType();
        if (particle == null || particle.eContainer() != cType) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        if ((group.getContents().isEmpty() || group.eResource() != cType.eResource()) && (content = cType.getContent()) instanceof XSDParticle) {
            group = (XSDModelGroup)((XSDParticle)content).getContent();
        }
        return group;
    }

    public static List getChildAttributes(XSDComplexTypeDefinition ct) {
        EList attrContents = ct.getAttributeContents();
        ArrayList<XSDAttributeDeclaration> attrs = new ArrayList<XSDAttributeDeclaration>();
        int i = 0;
        while (i < attrContents.size()) {
            Object next = attrContents.get(i);
            if (next instanceof XSDAttributeUse) {
                attrs.add(((XSDAttributeUse)next).getContent().getResolvedAttributeDeclaration());
            } else {
                boolean cfr_ignored_0 = next instanceof XSDAttributeGroupDefinition;
            }
            ++i;
        }
        return attrs;
    }

    public static Image getImageWithErrorOverlay(XSDConcreteComponent input, Image baseImage, boolean isReadOnly) {
        Image extensionImage = XSDCommonUIUtils.getUpdatedImage(input, baseImage, isReadOnly);
        ImageDescriptor errorOverlay = XSDEditorPlugin.getImageDescriptor("icons/ovr16/error_ovr.gif");
        if (baseImage == extensionImage) {
            String imageName = String.valueOf(input.getClass().getName()) + "_error_" + isReadOnly;
            Image newImage = XSDEditorPlugin.getDefault().getImageRegistry().get(imageName);
            if (newImage == null) {
                DecorationOverlayIcon ovr = new DecorationOverlayIcon(baseImage, errorOverlay, 0);
                newImage = ovr.createImage();
                XSDEditorPlugin.getDefault().getImageRegistry().put(imageName, newImage);
            }
            return newImage;
        }
        String imageName = String.valueOf(input.getClass().getName()) + "_extension_error_" + isReadOnly;
        Image newImage = XSDEditorPlugin.getDefault().getImageRegistry().get(imageName);
        if (newImage == null) {
            DecorationOverlayIcon ovr = new DecorationOverlayIcon(extensionImage, errorOverlay, 0);
            newImage = ovr.createImage();
            XSDEditorPlugin.getDefault().getImageRegistry().put(imageName, newImage);
        }
        return newImage;
    }
}

