/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.text.XSDModelReconcileAdapter;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaLocationResolverAdapterFactory;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDModelAdapter
implements INodeAdapter {
    protected ResourceSet resourceSet;
    protected XSDSchema schema;
    private ModelReconcileAdapter modelReconcileAdapter;
    static /* synthetic */ Class class$0;

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
    }

    public void clear() {
        if (this.schema != null) {
            Document doc = this.schema.getDocument();
            if (doc instanceof IDOMDocument) {
                IDOMDocument domDocument = (IDOMDocument)doc;
                domDocument.getModel().removeModelStateListener((IModelStateListener)this.getModelReconcileAdapter());
                domDocument.removeAdapter((INodeAdapter)this.getModelReconcileAdapter());
                domDocument.removeAdapter((INodeAdapter)this);
            }
            this.schema = null;
        }
        this.resourceSet = null;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public ModelReconcileAdapter getModelReconcileAdapter() {
        return this.modelReconcileAdapter;
    }

    public XSDSchema createSchema(Document document) {
        try {
            this.schema = XSDFactory.eINSTANCE.createXSDSchema();
            this.resourceSet = XSDSchemaImpl.createResourceSet();
            this.resourceSet.getAdapterFactories().add((Object)new XSDSchemaLocationResolverAdapterFactory());
            IDOMNode domNode = (IDOMNode)document;
            String baseLocation = domNode.getModel().getBaseLocation();
            URI uri = this.getURI(baseLocation);
            XSDResourceImpl resource = new XSDResourceImpl();
            resource.setURI(uri);
            this.schema = XSDFactory.eINSTANCE.createXSDSchema();
            resource.getContents().add((Object)this.schema);
            this.resourceSet.getResources().add((Object)resource);
            this.schema.setDocument(document);
            final Element element = document.getDocumentElement();
            if (element != null) {
                String schemaForSchemaNamespace = element.getNamespaceURI();
                XSDSchemaImpl.getSchemaForSchema((String)schemaForSchemaNamespace);
            }
            IRunnableWithProgress setElementOperation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    Map loadOptions = XSDModelAdapter.this.resourceSet.getLoadOptions();
                    loadOptions.put(XSDResourceImpl.XSD_PROGRESS_MONITOR, monitor);
                    XSDModelAdapter.this.schema.setElement(element);
                    loadOptions.remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                }
            };
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.busyCursorWhile(setElementOperation);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.modelReconcileAdapter = new XSDModelReconcileAdapter(document, this.schema);
            domNode.getModel().addModelStateListener((IModelStateListener)this.modelReconcileAdapter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.schema;
    }

    public XSDSchema createSchema(Element element) {
        return this.createSchema(element.getOwnerDocument());
    }

    public XSDSchema resetSchema(Document document) {
        try {
            IDOMNode domNode = (IDOMNode)document;
            this.schema.setDocument(document);
            this.schema.setElement(document.getDocumentElement());
            this.resourceSet = this.schema.eResource().getResourceSet();
            String baseLocation = domNode.getModel().getBaseLocation();
            URI uri = this.getURI(baseLocation);
            this.schema.eResource().setURI(uri);
            this.modelReconcileAdapter = new XSDModelReconcileAdapter(document, this.schema);
            domNode.getModel().addModelStateListener((IModelStateListener)this.modelReconcileAdapter);
        }
        catch (Exception exception) {}
        return this.schema;
    }

    public static XSDModelAdapter lookupOrCreateModelAdapter(Document document) {
        XSDModelAdapter adapter = null;
        if (document instanceof INodeNotifier) {
            INodeNotifier notifier = (INodeNotifier)document;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.text.XSDModelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (XSDModelAdapter)notifier.getAdapterFor((Object)clazz)) == null) {
                adapter = new XSDModelAdapter();
                notifier.addAdapter((INodeAdapter)adapter);
            }
        }
        return adapter;
    }

    public static XSDSchema lookupOrCreateSchema(Document document) {
        XSDSchema result = null;
        XSDModelAdapter adapter = XSDModelAdapter.lookupOrCreateModelAdapter(document);
        if (adapter.getSchema() == null) {
            adapter.createSchema(document);
        }
        result = adapter.getSchema();
        return result;
    }

    private URI getURI(String baseLocation) {
        URI uri = null;
        uri = baseLocation.startsWith("/") ? URI.createPlatformResourceURI((String)baseLocation) : (baseLocation.startsWith("http") ? URI.createURI((String)baseLocation) : URI.createFileURI((String)baseLocation));
        return uri;
    }
}

