/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.consumption.core.utils;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.data.DataModel;
import org.eclipse.jst.ws.axis2.consumption.core.data.Model;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDLPropertyReader;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;

public class DefaultCodegenUtil {
    private WSDLPropertyReader reader;
    private Model model;
    private List serviceQNameList = null;
    IStatus status;

    public DefaultCodegenUtil(DataModel model) {
        this.model = model;
    }

    public DefaultCodegenUtil(org.eclipse.jst.ws.axis2.creation.core.data.DataModel model) {
        this.model = model;
    }

    public void populateModelParamsFromWSDL() {
        this.status = Status.OK_STATUS;
        if (this.reader == null) {
            this.reader = new WSDLPropertyReader(this.model);
        }
        try {
            String lname = this.model.getWsdlURI();
            if (!"".equals(lname.trim())) {
                this.reader.readWSDL(this.model.getWebProjectName(), lname);
                this.serviceQNameList = this.reader.getServiceList();
                if (!this.serviceQNameList.isEmpty()) {
                    Object serviceQnameInstance = this.serviceQNameList.get(0);
                    Class QNameClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.xml.namespace.QName");
                    Method GetLocalPartMethod = QNameClass.getMethod("getLocalPart", null);
                    Object resultLocalPart = GetLocalPartMethod.invoke(serviceQnameInstance, null);
                    this.model.setServiceName(resultLocalPart.toString());
                    this.loadPortNames();
                }
                this.populatePackageName();
            }
        }
        catch (Exception e) {
            this.status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_INVALID_WSDL_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    private void loadPortNames() {
        List ports = this.reader.getPortNameList(this.serviceQNameList.get(0));
        this.model.setPortName(ports.get(0).toString());
    }

    private void populatePackageName() {
        this.model.setPackageText(this.reader.packageFromTargetNamespace());
    }
}

