/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientJarCreationHelper;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEjbClientProjectRemovalDataModelProperties;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.InvertClientJARDependencyCompoundOperation;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class EJBClientJARRemovalOperation
extends AbstractDataModelOperation
implements IEjbClientProjectRemovalDataModelProperties {
    protected IProject ejbProject;
    protected IProject clientProject;
    protected IPath clientProjectPath;
    protected IPath ejbProjectPath;
    protected List sourceContainers;
    protected List libraryContainers;
    protected IContainer ejbSourceContainer;
    protected IPath ejbSourcePath;
    protected IPath outputPath;
    protected boolean shouldDelete = true;
    protected boolean yesToAll = false;
    protected IWorkspace workspace;
    protected IProgressMonitor monitor;
    protected IProgressMonitor moveResourceMonitor;
    protected IOperationHandler operationHandler;

    public EJBClientJARRemovalOperation(IDataModel dataModel) {
        super(dataModel);
    }

    protected void initialize() {
        this.ejbProject = (IProject)this.model.getProperty("IEjbClientProjectRemovalDataModelProperties.EJB_PROJECT");
        this.clientProject = (IProject)this.model.getProperty("IEjbClientProjectRemovalDataModelProperties.EJB_CLIENT_VIEW_PROJECT");
        this.operationHandler = (IOperationHandler)this.model.getProperty("IEjbClientProjectRemovalDataModelProperties.OP_HANDLER");
        this.workspace = this.ejbProject.getWorkspace();
        this.clientProjectPath = this.clientProject.getFullPath();
        this.ejbProjectPath = this.ejbProject.getFullPath();
        this.sourceContainers = JemProjectUtilities.getSourceContainers((IProject)this.clientProject);
        this.libraryContainers = JemProjectUtilities.getLibraryContainers((IProject)this.clientProject);
        IJavaProject proj = JavaCore.create((IProject)this.clientProject);
        try {
            this.outputPath = proj.getOutputLocation().removeFirstSegments(1);
        }
        catch (JavaModelException javaModelException) {}
        IContainer container = J2EEProjectUtilities.getSourceFolderOrFirst((IProject)this.ejbProject, null);
        if (container.getType() == 2) {
            this.ejbSourceContainer = container;
        }
        this.ejbSourcePath = this.ejbSourceContainer.getFullPath();
    }

    protected void addAdditionalFilesForValidateEdit(final List roFiles) throws CoreException {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.isDerived()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 4: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (!resource.isReadOnly()) break;
                        roFiles.add(resource);
                        break;
                    }
                }
                return false;
            }
        };
        this.clientProject.accept(visitor);
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        this.initialize();
        try {
            if (!this.verifyFilesInSync()) {
                this.monitor.done();
                throw new OperationCanceledException();
            }
            this.monitor.beginTask(ClientJARCreationConstants.REMOVING_CLIENT_JAR, 10);
            this.ensureEJBJARInAllEARs();
            this.updateEJBModuleJARDependencies();
            EJBClientJarCreationHelper.copyOutgoingClasspathEntries(this.clientProject, this.ejbProject, false);
            this.moveIncomingJARDependencies();
            this.updateDD();
            this.removeClientProjectFromEARs();
            this.moveFiles();
            this.addSourceContainersToClassPath();
            if (this.moveResourceMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.deleteClientProject();
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return OK_STATUS;
    }

    private void addSourceContainersToClassPath() throws JavaModelException {
        int x = 0;
        while (x < this.sourceContainers.size()) {
            if (this.sourceContainers.get(x) instanceof IResource) {
                IResource resource = (IResource)this.sourceContainers.get(x);
                if (this.clientProject == resource) {
                    return;
                }
                IPath srcPath = this.ejbProjectPath.append(resource.getProjectRelativePath());
                IFolder existing = this.workspace.getRoot().getFolder(srcPath);
                if (existing != null && existing.exists()) {
                    JemProjectUtilities.appendJavaClassPath((IProject)this.ejbProject, (IClasspathEntry)JavaCore.newSourceEntry((IPath)srcPath));
                }
            }
            ++x;
        }
    }

    private void updateDD() {
        IModelProvider ejbModel = ModelProviderManager.getModelProvider((IProject)this.ejbProject);
        ejbModel.modify(new Runnable(){

            public void run() {
                IModelProvider writableEjbModel = ModelProviderManager.getModelProvider((IProject)EJBClientJARRemovalOperation.this.ejbProject);
                Object modelObject = writableEjbModel.getModelObject();
                if (modelObject instanceof EJBJar) {
                    EJBJar ejbres = (EJBJar)writableEjbModel.getModelObject();
                    if (ejbres != null) {
                        ejbres.setEjbClientJar(null);
                    }
                } else {
                    org.eclipse.jst.j2ee.ejb.EJBJar ejbres = (org.eclipse.jst.j2ee.ejb.EJBJar)writableEjbModel.getModelObject();
                    ejbres.setEjbClientJar(null);
                }
            }
        }, null);
    }

    private void ensureEJBJARInAllEARs() {
    }

    private void updateEJBModuleJARDependencies() throws InvocationTargetException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf(this.clientProject.getName()) + ".jar");
        IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)this.ejbProject);
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
        dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.ejbProject.getName());
        dataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", list);
        dataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProjects[0].getName());
        dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 1);
        dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)this.clientProject.getName());
        try {
            dataModel.getDefaultOperation().execute(this.createSubProgressMonitor(1), null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        ArchiveManifest clientMf = J2EEProjectUtilities.readManifest((IProject)this.clientProject);
        if (clientMf == null) {
            return;
        }
        String[] mfEntries = clientMf.getClassPathTokenized();
        if (mfEntries.length == 0) {
            return;
        }
        this.createSubProgressMonitor(earProjects.length);
        int i = 0;
        while (i < earProjects.length) {
            List result = EJBClientJarCreationHelper.normalize(mfEntries, earProjects[i], this.ejbProject, false);
            IDataModel dataModel2 = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
            dataModel2.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.ejbProject.getName());
            dataModel2.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)result);
            dataModel2.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProjects[i].getName());
            dataModel2.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
            try {
                dataModel2.getDefaultOperation().execute(this.createSubProgressMonitor(1), null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    private void moveIncomingJARDependencies() throws InvocationTargetException, InterruptedException {
        InvertClientJARDependencyCompoundOperation op = new InvertClientJARDependencyCompoundOperation(J2EEProjectUtilities.getReferencingEARProjects((IProject)this.ejbProject), this.clientProject, this.ejbProject);
        try {
            op.execute(this.createSubProgressMonitor(1), null);
        }
        catch (ExecutionException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void moveFiles() throws CoreException {
        this.moveResourceMonitor = this.createSubProgressMonitor(1);
        IResourceVisitor visitor = this.getRootResourceVisitor();
        this.clientProject.accept(visitor);
    }

    private IResourceVisitor getRootResourceVisitor() {
        return new IResourceVisitor(){
            private boolean projectIsSource;
            {
                this.projectIsSource = EJBClientJARRemovalOperation.this.sourceContainers.contains(EJBClientJARRemovalOperation.this.clientProject);
            }

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived()) {
                            this.visitFile((IFile)resource);
                        }
                        return false;
                    }
                    case 2: {
                        return this.visitFolder((IFolder)resource);
                    }
                    case 4: {
                        return true;
                    }
                }
                return false;
            }

            private void visitFile(IFile file) throws CoreException {
                if (this.isMetaFile(file)) {
                    return;
                }
                if (this.projectIsSource) {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbSourcePath);
                } else {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbProjectPath);
                }
            }

            private boolean isMetaFile(IFile file) {
                String segment = file.getProjectRelativePath().toString();
                return ".classpath".equals(segment) || ".project".equals(segment) || ".runtime".equals(segment) || segment.endsWith(".component") || segment.startsWith(".settings");
            }

            private boolean visitFolder(IFolder folder) throws CoreException {
                if (this.isSourceFolder(folder)) {
                    this.visitSourceFolder(folder);
                    return false;
                }
                if (this.isOutputFolder(folder)) {
                    return false;
                }
                if (this.isClassesFolder(folder)) {
                    this.visitClassesFolder(folder);
                    return false;
                }
                return true;
            }

            private boolean isOutputFolder(IFolder folder) {
                IPath path = folder.getProjectRelativePath();
                while (path.segmentCount() > 0 && EJBClientJARRemovalOperation.this.outputPath != null) {
                    if (path.equals((Object)EJBClientJARRemovalOperation.this.outputPath)) {
                        return true;
                    }
                    path = path.removeLastSegments(1);
                }
                return false;
            }

            private boolean isSourceFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.sourceContainers.contains(folder);
            }

            private void visitSourceFolder(IFolder folder) throws CoreException {
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), this.computeEJBSourceFolder(folder)));
            }

            private IPath computeEJBSourceFolder(IFolder clientProjectFolder) {
                IPath clientFolderRelativePath = clientProjectFolder.getProjectRelativePath();
                return EJBClientJARRemovalOperation.this.ejbProjectPath.append(clientFolderRelativePath);
            }

            private boolean isClassesFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.libraryContainers.contains(folder);
            }

            protected void visitClassesFolder(IFolder folder) throws CoreException {
                IPath classesPath = this.getEJBClassesPath();
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), classesPath));
            }

            private IPath getEJBClassesPath() throws CoreException {
                IFolder folder = EJBClientJARRemovalOperation.this.ejbProject.getFolder("imported_classes");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                JemProjectUtilities.appendJavaClassPath((IProject)EJBClientJARRemovalOperation.this.ejbProject, (IClasspathEntry)JavaCore.newLibraryEntry((IPath)folder.getFullPath(), null, null, (boolean)true));
                return folder.getFullPath();
            }
        };
    }

    private IResourceVisitor getFolderResourceVisitor(final IPath sourceRoot, final IPath destinationRoot) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived() && !this.isManifest(sourceRoot, resource.getFullPath())) {
                            EJBClientJARRemovalOperation.this.moveFile((IFile)resource, sourceRoot, destinationRoot);
                        }
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            private boolean isManifest(IPath new_sourceRoot, IPath path) {
                String relativeURI = path.removeFirstSegments(new_sourceRoot.segmentCount()).toString();
                return "META-INF/MANIFEST.MF".equals(relativeURI);
            }
        };
    }

    private void moveFile(IFile file, IPath sourceRoot, IPath destinationRoot) throws CoreException {
        IPath filePath = file.getFullPath();
        IPath relativeFilePath = filePath.removeFirstSegments(sourceRoot.segmentCount());
        IPath newPath = destinationRoot.append(relativeFilePath);
        this.mkdirs(newPath, this.workspace.getRoot());
        IFile existing = this.workspace.getRoot().getFile(newPath);
        if (!this.yesToAll && existing.exists()) {
            String message = MessageFormat.format(ClientJARCreationConstants.SHOULD_OVERWRITE, filePath.toString(), newPath.toString());
            int answer = 1;
            if (this.operationHandler != null) {
                answer = this.operationHandler.canContinueWithAllCheckAllowCancel(message);
            }
            switch (answer) {
                case 0: {
                    break;
                }
                case 1: {
                    this.yesToAll = true;
                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    this.moveResourceMonitor.setCanceled(true);
                    return;
                }
            }
        }
        if (!existing.exists()) {
            file.move(newPath, true, this.moveResourceMonitor);
        } else {
            existing.setContents(file.getContents(), true, true, this.moveResourceMonitor);
        }
    }

    private void removeClientProjectFromEARs() {
        IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)this.clientProject);
        int i = 0;
        while (i < earProjects.length) {
            this.removeClientProjectFromEAR(earProjects[i]);
            ++i;
        }
    }

    private void removeClientProjectFromEAR(IProject earProject) {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.clientProject);
        if (earComp.exists() && component.exists()) {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RemoveReferenceComponentsDataModelProvider());
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
            List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            modList.add(component);
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
            try {
                dm.getDefaultOperation().execute(this.monitor, null);
            }
            catch (ExecutionException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
    }

    private void deleteClientProject() throws CoreException {
        if (this.shouldDelete) {
            this.clientProject.delete(true, true, this.createSubProgressMonitor(1));
        }
    }

    protected IProgressMonitor createSubProgressMonitor(int ticks) {
        return new SubProgressMonitor(this.monitor, ticks);
    }

    protected boolean verifyFilesInSync() throws CoreException {
        if (this.verifyFilesInSync(this.ejbProject)) {
            return this.verifyFilesInSync(this.clientProject);
        }
        return false;
    }

    protected boolean verifyFilesInSync(IProject project) throws CoreException {
        if (!project.exists()) {
            return true;
        }
        if (!project.isSynchronized(2)) {
            String message = MessageFormat.format(ClientJARCreationConstants.FILES_OUT_OF_SYNC, project.getName());
            if (this.operationHandler == null || this.operationHandler.canContinue(message)) {
                this.ejbProject.refreshLocal(2, this.createSubProgressMonitor(1));
            } else {
                return false;
            }
        }
        return true;
    }

    protected void mkdirs(IPath newPath, IWorkspaceRoot root) throws CoreException {
        if (newPath.segmentCount() <= 2) {
            return;
        }
        IPath parentPath = newPath.removeLastSegments(1);
        IFolder folder = root.getFolder(parentPath);
        if (!folder.exists()) {
            this.mkdirs(parentPath, root);
            folder.create(true, true, null);
        }
    }
}

