/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinColumn
extends AbstractOrmBaseColumn<XmlJoinColumn>
implements OrmJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected XmlJoinColumn joinColumn;
    private boolean doContinue;

    public GenericOrmJoinColumn(OrmJpaContextNode parent, OrmJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initializeFrom(JoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public String getReferencedColumnName() {
        return this.getSpecifiedReferencedColumnName() == null ? this.getDefaultReferencedColumnName() : this.getSpecifiedReferencedColumnName();
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.getColumnResource().setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    public void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public OrmJoinColumn.Owner getOwner() {
        return (OrmJoinColumn.Owner)this.owner;
    }

    public Table dbReferencedColumnTable() {
        return this.getOwner().getDbReferencedColumnTable();
    }

    @Override
    public Column getDbReferencedColumn() {
        Table table = this.dbReferencedColumnTable();
        return table == null ? null : table.columnNamed(this.getReferencedColumnName());
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getDbReferencedColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        TextRange textRange;
        if (this.getColumnResource() != null && (textRange = this.getColumnResource().getReferencedColumnNameTextRange()) != null) {
            return textRange;
        }
        return this.getOwner().getValidationTextRange();
    }

    @Override
    protected XmlJoinColumn getColumnResource() {
        return this.joinColumn;
    }

    @Override
    protected void addColumnResource() {
    }

    @Override
    protected void removeColumnResource() {
    }

    @Override
    public void initialize(XmlJoinColumn column) {
        this.joinColumn = column;
        super.initialize(column);
        this.specifiedReferencedColumnName = this.specifiedReferencedColumnName(column);
        this.defaultReferencedColumnName = this.defaultReferencedColumnName();
    }

    @Override
    public void update(XmlJoinColumn column) {
        this.joinColumn = column;
        super.update(column);
        this.setSpecifiedReferencedColumnName_(this.specifiedReferencedColumnName(column));
        this.setDefaultReferencedColumnName(this.defaultReferencedColumnName());
    }

    protected String specifiedReferencedColumnName(XmlJoinColumn column) {
        return column == null ? null : column.getReferencedColumnName();
    }

    @Override
    protected String defaultName() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!this.getOwner().getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return MappingTools.buildJoinColumnDefaultName(this);
    }

    protected String defaultReferencedColumnName() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this);
    }

    @Override
    protected String defaultTable() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!relationshipMapping.isRelationshipOwner()) {
            return null;
        }
        return super.defaultTable();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.doContinue = this.connectionProfileIsActive();
        OrmRelationshipMapping mapping = (OrmRelationshipMapping)this.getOwner().getRelationshipMapping();
        if (this.doContinue && !this.isResolved()) {
            if (mapping.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{mapping.getName(), this.getName()}, this, this.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
            }
        }
    }
}

