/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.tests.internal;

import java.util.List;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.analyzer.MessageAnalyzer;
import org.eclipse.wst.wsi.tests.internal.CoreConformanceTest;

public class CoreMessageLogConformanceTest
extends CoreConformanceTest {
    public static final String MESSAGE_LOG_BASE_DIRECTORY = "testResources/samples/messageLogs";
    public static final String MESSAGE_LOG_EXTENSION = ".wsimsg";
    public static final String WSDL_BASE_DIRECTORY = "testResources/samples/wsdl";
    public static final String WSDL_EXTENSION = ".wsdl";

    public CoreMessageLogConformanceTest(String name) {
        super(name);
    }

    protected void runTest(String category, String testName, String tadID) {
        this.tadID = tadID;
        CoreMessageLogConformanceTest.assertNotNull((String)"Problems determining base url", (Object)this.pluginURI);
        String testDirectory = String.valueOf(this.pluginURI) + MESSAGE_LOG_BASE_DIRECTORY + "/" + category + "/" + testName;
        String messageLogFile = "file://" + testDirectory + "/" + testName + MESSAGE_LOG_EXTENSION;
        String testcaseFile = String.valueOf(testDirectory) + "/" + "testcase.xml";
        MessageAnalyzer analyzer = this.validateConformance(messageLogFile, tadID);
        CoreMessageLogConformanceTest.assertNotNull((String)"Unknown problems during validation", (Object)analyzer);
        List expectedErrors = this.getExpectedAssertionFailures(testcaseFile);
        CoreMessageLogConformanceTest.assertNotNull((String)"Problems retrieving expected failures", (Object)expectedErrors);
        this.analyzeResults(analyzer.getAssertionErrors(), expectedErrors);
    }

    protected MessageAnalyzer validateConformance(String filename, String tadID) {
        MessageAnalyzer analyzer = null;
        try {
            WSIPreferences preferences = new WSIPreferences();
            preferences.setComplianceLevel("0");
            preferences.setTADFile(this.getTADURI(tadID));
            analyzer = new MessageAnalyzer(filename, preferences);
            analyzer.validateConformance();
        }
        catch (Exception exception) {
            return null;
        }
        return analyzer;
    }

    protected void runTestWithWSDL(String category, String testName, String[] WSData) {
        CoreMessageLogConformanceTest.assertNotNull((String)"Problems determining base url", (Object)this.pluginURI);
        String testDirectory = String.valueOf(this.pluginURI) + MESSAGE_LOG_BASE_DIRECTORY + "/" + category + "/" + testName;
        String messageLogFile = "file://" + testDirectory + "/" + testName + MESSAGE_LOG_EXTENSION;
        String testcaseFile = String.valueOf(testDirectory) + "/" + "testcase.xml";
        String wsdlFile = "file://" + this.pluginURI + WSDL_BASE_DIRECTORY + "/" + category + "/" + testName + WSDL_EXTENSION;
        MessageAnalyzer analyzer = this.validateConformanceWithWSDL(messageLogFile, wsdlFile, WSData);
        CoreMessageLogConformanceTest.assertNotNull((String)"Unknown problems during validation", (Object)analyzer);
        List expectedErrors = this.getExpectedAssertionFailures(testcaseFile);
        CoreMessageLogConformanceTest.assertNotNull((String)"Problems retrieving expected failures", (Object)expectedErrors);
        this.analyzeResults(analyzer.getAssertionErrors(), expectedErrors);
    }

    protected MessageAnalyzer validateConformanceWithWSDL(String filename, String wsdlFile, String[] WSData) {
        MessageAnalyzer analyzer = null;
        try {
            WSIPreferences preferences = new WSIPreferences();
            preferences.setComplianceLevel("0");
            preferences.setTADFile(this.getTADURI(this.tadID));
            analyzer = new MessageAnalyzer(filename, wsdlFile, WSData[0], WSData[1], WSData[2], WSData[3], preferences);
            analyzer.validateConformance();
        }
        catch (Exception exception) {
            return null;
        }
        return analyzer;
    }
}

