/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SuiteHelper {
    private Hashtable allTests = new Hashtable();

    public SuiteHelper(TestSuite suite) {
        this.addTest((Test)suite);
    }

    private void addTest(Test test) {
        if (test instanceof TestSuite) {
            Enumeration tests = ((TestSuite)test).tests();
            while (tests.hasMoreElements()) {
                Test t = (Test)tests.nextElement();
                this.allTests.put(t.toString(), t);
            }
            return;
        }
        this.allTests.put(test.toString(), test);
    }

    public String[] getAllTests() {
        ArrayList testList = new ArrayList();
        Enumeration enumeration = this.allTests.keys();
        while (enumeration.hasMoreElements()) {
            testList.add(enumeration.nextElement());
        }
        Collections.sort(testList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        String[] strArray = new String[testList.size()];
        int i = 0;
        while (i < strArray.length) {
            strArray[i] = (String)testList.get(i);
            ++i;
        }
        return strArray;
    }

    public TestSuite buildSuite(String[] completeTests, String[] partialTests) {
        TestSuite suite = new TestSuite();
        int i = 0;
        while (i < completeTests.length) {
            suite.addTest((Test)this.allTests.get(completeTests[i]));
            ++i;
        }
        i = 0;
        while (i < partialTests.length) {
            suite.addTest(this.getTest(partialTests[i]));
            ++i;
        }
        return suite;
    }

    public String[] getTestMethods(String testName) {
        ArrayList<String> methodList = new ArrayList<String>();
        Test test = (Test)this.allTests.get(testName);
        if (test instanceof TestSuite) {
            Enumeration testsEnum = ((TestSuite)test).tests();
            while (testsEnum.hasMoreElements()) {
                Test t = (Test)testsEnum.nextElement();
                methodList.add(t.toString());
            }
        }
        Collections.sort(methodList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        String[] strArray = new String[methodList.size()];
        int i = 0;
        while (i < strArray.length) {
            strArray[i] = (String)methodList.get(i);
            ++i;
        }
        return strArray;
    }

    private Test getSubTest(TestSuite suite, String testName) {
        if (suite != null) {
            Enumeration tests = suite.tests();
            while (tests.hasMoreElements()) {
                Test t = (Test)tests.nextElement();
                if (!t.toString().equals(testName)) continue;
                return t;
            }
        }
        return null;
    }

    private Test getTest(String testName) {
        int firstIndex = testName.indexOf(".");
        String suiteName = testName.substring(0, firstIndex);
        String subTestName = testName.substring(firstIndex + 1);
        TestSuite suite = (TestSuite)this.allTests.get(suiteName);
        Test test = this.getSubTest(suite, subTestName);
        if (test != null) {
            return test;
        }
        Enumeration keys = this.allTests.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!testName.startsWith(key) || (test = this.getSubTest(suite = (TestSuite)this.allTests.get(key), subTestName = testName.substring(key.length() + 1))) == null) continue;
            return test;
        }
        return null;
    }
}

