/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.performance;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import javax.wsdl.WSDLException;
import junit.framework.Assert;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSISSBPContext;
import org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLValidator;

public class ValidateOAGISWSITestcase
extends PerformanceTestCase {
    private WSDLValidator validator;

    protected void setUp() throws Exception {
        super.setUp();
        WSPlugin wsui = WSPlugin.getInstance();
        PersistentWSISSBPContext wsicontext = wsui.getWSISSBPContext();
        wsicontext.updateWSICompliances("0");
        wsicontext = wsui.getWSIAPContext();
        wsicontext.updateWSICompliances("0");
    }

    public void testValidateWSDL() throws MalformedURLException, WSDLException {
        File dir;
        String oagis80Dir = System.getProperty("oagis80Dir");
        Assert.assertNotNull((Object)oagis80Dir);
        if (!oagis80Dir.endsWith("/") && !oagis80Dir.endsWith("\\")) {
            oagis80Dir = String.valueOf(oagis80Dir) + "/";
        }
        if ((dir = new File(String.valueOf(oagis80Dir) + "OAGIS8.0/ws/wsdl")).exists() && dir.isDirectory()) {
            File[] wsdls = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".wsdl");
                }
            });
            this.tagAsSummary("Validate OAGIS WSDL with WS-I", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.validator = WSDLValidator.getInstance();
            this.startMeasuring();
            int i = 0;
            while (i < wsdls.length) {
                this.validateWSDL(wsdls[i].toURL().toString());
                ++i;
            }
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            ValidateOAGISWSITestcase.fail((String)dir.toString());
        }
    }

    private void validateWSDL(String location) throws WSDLException {
        this.validator.validate(location);
    }
}

