/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.catalog.tests.internal.AbstractCatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.TestPlugin;

public class CatalogResolverTest
extends AbstractCatalogTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CatalogResolverTest(String name) {
        super(name);
    }

    public final void testResolveResolver() throws Exception {
        String pluginBase = CatalogResolverTest.resolvePluginLocation(TestPlugin.getDefault().getBundle().getSymbolicName()).toString();
        String resolvedActual = this.defaultCatalog.resolvePublic("InvoiceId_test", null);
        String resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/Invoice/Invoice.dtd");
        CatalogResolverTest.assertEquals((String)resolvedURI, (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveSystem("http://personal/personal.dtd");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/Personal/personal.dtd");
        CatalogResolverTest.assertEquals((String)resolvedURI, (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveURI("http://apache.org/xml/xcatalog/example");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/example/example.xsd");
        CatalogResolverTest.assertEquals((String)resolvedURI, (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveURI("http://www.w3.org/2001/XMLSchema");
        resolvedURI = this.resolvePath("", "platform:/plugin/org.eclipse.xsd/cache/www.w3.org/2001/XMLSchema.xsd");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, resolvedURI);
        CatalogResolverTest.assertEquals((String)resolvedURI, (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolvePublic("InvoiceId_test", null);
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/Invoice/Invoice.dtd");
        CatalogResolverTest.assertEquals((String)resolvedURI, (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveSystem("Invoice.dtd");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/Invoice/Invoice.dtd");
        CatalogResolverTest.assertEquals((String)URIHelper.ensureFileURIProtocolFormat((String)resolvedURI), (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveURI("http://www.test.com/Invoice.dtd");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/Invoice/Invoice.dtd");
        CatalogResolverTest.assertEquals((String)URIHelper.ensureFileURIProtocolFormat((String)resolvedURI), (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolvePublic("http://www.eclipse.org/webtools/Catalogue_001", null);
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/PublicationCatalogue/Catalogue.xsd");
        CatalogResolverTest.assertEquals((String)URIHelper.ensureFileURIProtocolFormat((String)resolvedURI), (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolvePublic("http://www.eclipse.org/webtools/Catalogue_002", null);
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/PublicationCatalogue/Catalogue.xsd");
        CatalogResolverTest.assertEquals((String)URIHelper.ensureFileURIProtocolFormat((String)resolvedURI), (String)resolvedActual);
        resolvedActual = this.defaultCatalog.resolveSystem("Catalogue.xsd");
        resolvedURI = CatalogResolverTest.makeAbsolute(pluginBase, "data/PublicationCatalogue/Catalogue.xsd");
        CatalogResolverTest.assertEquals((String)URIHelper.ensureFileURIProtocolFormat((String)resolvedURI), (String)resolvedActual);
    }
}

