/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Publisher;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.command.SetPublisherEnablementCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerAutoPublishDefaultCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerAutoPublishTimeCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerConfigurationFolderCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerHostnameCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerNameCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerRuntimeCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerStartTimeoutCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerStopTimeoutCommand;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.BaseLabelProvider;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class OverviewEditorPart
extends ServerEditorPart {
    protected Text serverName;
    protected Text serverConfiguration;
    protected Text hostname;
    protected Combo runtimeCombo;
    protected Button browse;
    protected Button autoPublishDisable;
    protected Button autoPublishEnable;
    protected Spinner autoPublishTime;
    protected Table publishersTable;
    protected CheckboxTableViewer publishersViewer;
    protected Spinner startTimeoutSpinner;
    protected Spinner stopTimeoutSpinner;
    protected ManagedForm managedForm;
    protected boolean updating;
    protected IRuntime[] runtimes;
    protected PropertyChangeListener listener;
    protected IRuntimeLifecycleListener runtimeListener;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("configuration-id") && OverviewEditorPart.this.serverConfiguration != null) {
                    OverviewEditorPart.this.validate();
                }
                if (OverviewEditorPart.this.updating) {
                    return;
                }
                OverviewEditorPart.this.updating = true;
                if (event.getPropertyName().equals("name")) {
                    OverviewEditorPart.this.updateNames();
                } else if (event.getPropertyName().equals("hostname") && OverviewEditorPart.this.hostname != null) {
                    OverviewEditorPart.this.hostname.setText((String)event.getNewValue());
                } else if (event.getPropertyName().equals("runtime-id")) {
                    String runtimeId = (String)event.getNewValue();
                    IRuntime runtime = null;
                    if (runtimeId != null) {
                        runtime = ServerCore.findRuntime((String)runtimeId);
                    }
                    if (OverviewEditorPart.this.runtimeCombo != null) {
                        int size = OverviewEditorPart.this.runtimes.length;
                        int i = 0;
                        while (i < size) {
                            if (OverviewEditorPart.this.runtimes[i].equals(runtime)) {
                                OverviewEditorPart.this.runtimeCombo.select(i);
                            }
                            ++i;
                        }
                    }
                } else if (event.getPropertyName().equals("configuration-id") && OverviewEditorPart.this.serverConfiguration != null) {
                    String path = (String)event.getNewValue();
                    OverviewEditorPart.this.serverConfiguration.setText(path);
                } else if (event.getPropertyName().equals("auto-publish-time")) {
                    Integer curAutoPublishTime = (Integer)event.getNewValue();
                    OverviewEditorPart.this.autoPublishTime.setSelection(curAutoPublishTime.intValue());
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.autoPublishTime);
                    OverviewEditorPart.this.validate();
                } else if (event.getPropertyName().equals("auto-publish-setting")) {
                    Integer autoPublishSetting = (Integer)event.getNewValue();
                    int setting = autoPublishSetting;
                    OverviewEditorPart.this.autoPublishEnable.setSelection(setting == 2);
                    OverviewEditorPart.this.autoPublishDisable.setSelection(setting == 1);
                    OverviewEditorPart.this.autoPublishTime.setEnabled(setting == 2);
                    OverviewEditorPart.this.validate();
                } else if (event.getPropertyName().equals("start-timeout")) {
                    Integer time = (Integer)event.getNewValue();
                    OverviewEditorPart.this.startTimeoutSpinner.setSelection(time.intValue());
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.startTimeoutSpinner);
                } else if (event.getPropertyName().equals("stop-timeout")) {
                    Integer time = (Integer)event.getNewValue();
                    OverviewEditorPart.this.stopTimeoutSpinner.setSelection(time.intValue());
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.stopTimeoutSpinner);
                } else if ("publishers".equals(event.getPropertyName())) {
                    if (OverviewEditorPart.this.publishersViewer == null) {
                        return;
                    }
                    List list = (List)event.getNewValue();
                    for (String id : list) {
                        Publisher pub;
                        int ind = id.indexOf(":");
                        boolean enabled = false;
                        if ("true".equals(id.substring(ind + 1))) {
                            enabled = true;
                        }
                        if ((pub = ServerPlugin.findPublisher((String)(id = id.substring(0, ind)))) == null) continue;
                        OverviewEditorPart.this.publishersViewer.setChecked((Object)pub, enabled);
                    }
                }
                OverviewEditorPart.this.updating = false;
            }
        };
        if (this.server != null) {
            this.server.addPropertyChangeListener(this.listener);
        }
    }

    protected void updateNames() {
        if (this.serverName != null) {
            this.serverName.setText(this.server.getName());
        }
    }

    public final void createPartControl(Composite parent) {
        this.managedForm = new ManagedForm(parent);
        this.setManagedForm((IManagedForm)this.managedForm);
        ScrolledForm form = this.managedForm.getForm();
        FormToolkit toolkit = this.managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.serverEditorOverviewPageTitle);
        form.setImage(ImageResource.getImage("server"));
        form.getBody().setLayout((Layout)new GridLayout());
        Composite columnComp = toolkit.createComposite(form.getBody());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        columnComp.setLayout((Layout)layout);
        columnComp.setLayoutData((Object)new GridData(784));
        Composite leftColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        leftColumnComp.setLayout((Layout)layout);
        leftColumnComp.setLayoutData((Object)new GridData(784));
        this.createGeneralSection(leftColumnComp, toolkit);
        this.insertSections(leftColumnComp, "org.eclipse.wst.server.editor.overview.left");
        Composite rightColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        rightColumnComp.setLayout((Layout)layout);
        rightColumnComp.setLayoutData((Object)new GridData(784));
        this.createPublishSection(rightColumnComp, toolkit);
        this.createTimeoutSection(rightColumnComp, toolkit);
        this.insertSections(rightColumnComp, "org.eclipse.wst.server.editor.overview.right");
        form.reflow(true);
        this.initialize();
    }

    protected void createGeneralSection(Composite leftColumnComp, FormToolkit toolkit) {
        ILaunchConfigurationType launchType;
        IServerType serverType;
        Section section = toolkit.createSection(leftColumnComp, 384);
        section.setText(Messages.serverEditorOverviewGeneralSection);
        section.setDescription(Messages.serverEditorOverviewGeneralDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        int decorationWidth = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        if (this.server != null) {
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerName);
            this.serverName = toolkit.createText(composite, this.server.getName());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            data.horizontalIndent = decorationWidth;
            this.serverName.setLayoutData((Object)data);
            this.serverName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerNameCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.serverName.getText()));
                    OverviewEditorPart.this.updating = false;
                    OverviewEditorPart.this.validate();
                }
            });
            whs.setHelp((Control)this.serverName, "org.eclipse.wst.server.ui.seop0002");
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerHostname);
            this.hostname = toolkit.createText(composite, this.server.getHost());
            final ControlDecoration hostnameDecoration = new ControlDecoration((Control)this.hostname, 16512);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.horizontalIndent = decorationWidth;
            this.hostname.setLayoutData((Object)data);
            this.hostname.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerHostnameCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.hostname.getText()));
                    OverviewEditorPart.this.updating = false;
                }
            });
            whs.setHelp((Control)this.hostname, "org.eclipse.wst.server.ui.seop0006");
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration fd = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            hostnameDecoration.setImage(fd.getImage());
            hostnameDecoration.setDescriptionText(fd.getDescription());
            hostnameDecoration.hide();
            this.hostname.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    hostnameDecoration.show();
                }

                public void focusLost(FocusEvent e) {
                    hostnameDecoration.hide();
                }
            });
            List<String> hosts = ServerUIPlugin.getPreferences().getHostnames();
            String[] hosts2 = hosts.toArray(new String[hosts.size()]);
            new AutoCompleteField((Control)this.hostname, (IControlContentAdapter)new TextContentAdapter(), hosts2);
        }
        if (this.server != null && this.server.getServerType() != null && this.server.getServerType().hasRuntime()) {
            final IRuntime runtime = this.server.getRuntime();
            if (runtime != null && ServerUIPlugin.hasWizardFragment(runtime.getRuntimeType().getId())) {
                Hyperlink link = toolkit.createHyperlink(composite, Messages.serverEditorOverviewRuntime, 0);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        OverviewEditorPart.this.editRuntime(runtime);
                    }
                });
            } else {
                this.createLabel(toolkit, composite, Messages.serverEditorOverviewRuntime);
            }
            IRuntimeType runtimeType = this.server.getServerType().getRuntimeType();
            this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
            this.runtimeCombo = new Combo(composite, 8);
            GridData data = new GridData(768);
            data.horizontalIndent = decorationWidth;
            data.horizontalSpan = 2;
            this.runtimeCombo.setLayoutData((Object)data);
            this.updateRuntimeCombo();
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                if (this.runtimes[i].equals(runtime)) {
                    this.runtimeCombo.select(i);
                }
                ++i;
            }
            this.runtimeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if (OverviewEditorPart.this.updating) {
                            return;
                        }
                        OverviewEditorPart.this.updating = true;
                        IRuntime newRuntime = OverviewEditorPart.this.runtimes[OverviewEditorPart.this.runtimeCombo.getSelectionIndex()];
                        OverviewEditorPart.this.execute((IUndoableOperation)new SetServerRuntimeCommand(OverviewEditorPart.this.getServer(), newRuntime));
                        OverviewEditorPart.this.updating = false;
                    }
                    catch (Exception exception) {}
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            whs.setHelp((Control)this.runtimeCombo, "org.eclipse.wst.server.ui.seop0008");
            this.runtimeListener = new IRuntimeLifecycleListener(){

                public void runtimeChanged(final IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (runtime2.equals(OverviewEditorPart.this.getServer().getRuntime())) {
                                try {
                                    if ((this).OverviewEditorPart.this.updating) {
                                        return;
                                    }
                                    (this).OverviewEditorPart.this.updating = true;
                                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerRuntimeCommand(OverviewEditorPart.this.getServer(), runtime2));
                                    (this).OverviewEditorPart.this.updating = false;
                                }
                                catch (Exception exception) {}
                            }
                            if ((this).OverviewEditorPart.this.runtimeCombo != null && !(this).OverviewEditorPart.this.runtimeCombo.isDisposed()) {
                                OverviewEditorPart.this.updateRuntimeCombo();
                                int size2 = (this).OverviewEditorPart.this.runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if ((this).OverviewEditorPart.this.runtimes[i].equals(runtime)) {
                                        (this).OverviewEditorPart.this.runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }

                public void runtimeAdded(IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if ((this).OverviewEditorPart.this.runtimeCombo != null && !(this).OverviewEditorPart.this.runtimeCombo.isDisposed()) {
                                OverviewEditorPart.this.updateRuntimeCombo();
                                int size2 = (this).OverviewEditorPart.this.runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if ((this).OverviewEditorPart.this.runtimes[i].equals(runtime)) {
                                        (this).OverviewEditorPart.this.runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }

                public void runtimeRemoved(IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if ((this).OverviewEditorPart.this.runtimeCombo != null && !(this).OverviewEditorPart.this.runtimeCombo.isDisposed()) {
                                OverviewEditorPart.this.updateRuntimeCombo();
                                int size2 = (this).OverviewEditorPart.this.runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if ((this).OverviewEditorPart.this.runtimes[i].equals(runtime)) {
                                        (this).OverviewEditorPart.this.runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }
            };
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
        if (this.server != null && this.server.getServerType() != null && this.server.getServerType().hasServerConfiguration()) {
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerConfigurationPath);
            IFolder folder = this.server.getServerConfiguration();
            this.serverConfiguration = folder == null ? toolkit.createText(composite, Messages.elementUnknownName) : toolkit.createText(composite, "" + this.server.getServerConfiguration().getFullPath());
            this.serverConfiguration.setEditable(false);
            GridData data = new GridData(768);
            data.horizontalIndent = decorationWidth;
            data.widthHint = 75;
            this.serverConfiguration.setLayoutData((Object)data);
            whs.setHelp((Control)this.serverConfiguration, "org.eclipse.wst.server.ui.seop0004");
            final IFolder currentFolder = this.server.getServerConfiguration();
            this.browse = toolkit.createButton(composite, Messages.serverEditorOverviewServerConfigurationBrowse, 8);
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] result;
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(OverviewEditorPart.this.serverConfiguration.getShell(), (IContainer)currentFolder, true, Messages.serverEditorOverviewServerConfigurationBrowseMessage);
                    dialog.showClosedProjects(false);
                    if (dialog.open() != 1 && (result = dialog.getResult()) != null && result.length == 1) {
                        IPath path = (IPath)result[0];
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IResource resource = root.findMember(path);
                        if (resource != null && resource instanceof IFolder) {
                            IFolder folder2 = (IFolder)resource;
                            if (OverviewEditorPart.this.updating) {
                                return;
                            }
                            OverviewEditorPart.this.updating = true;
                            OverviewEditorPart.this.execute((IUndoableOperation)new SetServerConfigurationFolderCommand(OverviewEditorPart.this.getServer(), folder2));
                            OverviewEditorPart.this.serverConfiguration.setText(folder2.getFullPath().toString());
                            OverviewEditorPart.this.updating = false;
                        }
                    }
                }
            });
            this.browse.setLayoutData((Object)new GridData(128));
        }
        if (this.server != null && this.server.getServerType() != null && ((serverType = this.server.getServerType()).supportsLaunchMode("run") || serverType.supportsLaunchMode("debug") || serverType.supportsLaunchMode("profile")) && (launchType = ((ServerType)serverType).getLaunchConfigurationType()) != null && launchType.isPublic()) {
            final Hyperlink link = toolkit.createHyperlink(composite, Messages.serverEditorOverviewOpenLaunchConfiguration, 0);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            link.setLayoutData((Object)data);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        ILaunchConfiguration launchConfig = ((Server)OverviewEditorPart.this.getServer()).getLaunchConfiguration(true, null);
                        DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)link.getShell(), (ILaunchConfiguration)launchConfig, (String)"org.eclipse.debug.ui.launchGroup.run");
                    }
                    catch (CoreException ce) {
                        Trace.trace((byte)3, "Could not create launch configuration", ce);
                    }
                }
            });
        }
    }

    protected void createPublishSection(Composite rightColumnComp, FormToolkit toolkit) {
        Section section = toolkit.createSection(rightColumnComp, 394);
        section.setText(Messages.serverEditorOverviewPublishSection);
        section.setDescription(Messages.serverEditorOverviewPublishDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        if (this.server != null) {
            Server svr = (Server)this.server;
            int publishSetting = svr.getAutoPublishSetting();
            GridData data = new GridData(768);
            this.autoPublishDisable = toolkit.createButton(composite, Messages.serverEditorOverviewAutoPublishDisable, 16);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.autoPublishDisable.setLayoutData((Object)data);
            this.autoPublishDisable.setSelection(publishSetting == 1);
            whs.setHelp((Control)this.autoPublishDisable, "org.eclipse.wst.server.ui.seop0016");
            this.autoPublishEnable = toolkit.createButton(composite, Messages.serverEditorOverviewAutoPublishEnabled, 16);
            this.autoPublishEnable.setSelection(publishSetting == 2);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.autoPublishEnable.setLayoutData((Object)data);
            whs.setHelp((Control)this.autoPublishEnable, "org.eclipse.wst.server.ui.seop0012");
            final Label autoPublishTimeLabel = this.createLabel(toolkit, composite, Messages.serverEditorOverviewAutoPublishEnabledInterval);
            data = new GridData();
            data.horizontalIndent = 20;
            autoPublishTimeLabel.setLayoutData((Object)data);
            autoPublishTimeLabel.setEnabled(this.autoPublishEnable.getSelection());
            this.autoPublishTime = new Spinner(composite, 2048);
            this.autoPublishTime.setMinimum(0);
            this.autoPublishTime.setIncrement(5);
            this.autoPublishTime.setMaximum(120);
            this.autoPublishTime.setSelection(svr.getAutoPublishTime());
            data = new GridData(128);
            data.widthHint = 30;
            this.autoPublishTime.setLayoutData((Object)data);
            this.autoPublishTime.setEnabled(this.autoPublishEnable.getSelection());
            SWTUtil.setSpinnerTooltip(this.autoPublishTime);
            whs.setHelp((Control)this.autoPublishTime, "org.eclipse.wst.server.ui.seop0012");
            this.autoPublishEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OverviewEditorPart.this.updating || !OverviewEditorPart.this.autoPublishEnable.getSelection()) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishDefaultCommand(OverviewEditorPart.this.getServer(), 2));
                    OverviewEditorPart.this.updating = false;
                    autoPublishTimeLabel.setEnabled(OverviewEditorPart.this.autoPublishEnable.getSelection());
                    OverviewEditorPart.this.autoPublishTime.setEnabled(OverviewEditorPart.this.autoPublishEnable.getSelection());
                    OverviewEditorPart.this.validate();
                }
            });
            this.autoPublishDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OverviewEditorPart.this.updating || !OverviewEditorPart.this.autoPublishDisable.getSelection()) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishDefaultCommand(OverviewEditorPart.this.getServer(), 1));
                    OverviewEditorPart.this.updating = false;
                    autoPublishTimeLabel.setEnabled(OverviewEditorPart.this.autoPublishEnable.getSelection());
                    OverviewEditorPart.this.autoPublishTime.setEnabled(OverviewEditorPart.this.autoPublishEnable.getSelection());
                    OverviewEditorPart.this.validate();
                }
            });
            this.autoPublishTime.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishTimeCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.autoPublishTime.getSelection()));
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.autoPublishTime);
                    OverviewEditorPart.this.updating = false;
                    OverviewEditorPart.this.validate();
                }
            });
            Publisher[] pubs = ((Server)this.server).getAllPublishers();
            if (pubs != null && pubs.length > 0) {
                Publisher[] pubs2;
                Label label = toolkit.createLabel(composite, Messages.serverEditorOverviewPublishers);
                data = new GridData(768);
                data.horizontalSpan = 2;
                label.setLayoutData((Object)data);
                this.publishersTable = toolkit.createTable(composite, 66336);
                this.publishersTable.setHeaderVisible(false);
                this.publishersTable.setLinesVisible(false);
                whs.setHelp((Control)this.publishersTable, "org.eclipse.wst.server.ui.seop0018");
                data = new GridData(784);
                data.horizontalSpan = 2;
                data.heightHint = 80;
                this.publishersTable.setLayoutData((Object)data);
                this.publishersViewer = new CheckboxTableViewer(this.publishersTable);
                this.publishersViewer.setColumnProperties(new String[]{"name"});
                this.publishersViewer.setContentProvider((IContentProvider)new PublisherContentProvider(pubs));
                this.publishersViewer.setLabelProvider((IBaseLabelProvider)new PublishLabelProvider());
                this.publishersViewer.setInput((Object)"root");
                Publisher[] publisherArray = pubs2 = ((Server)this.server).getEnabledPublishers();
                int n = pubs2.length;
                int n2 = 0;
                while (n2 < n) {
                    Publisher p = publisherArray[n2];
                    this.publishersViewer.setChecked((Object)p, true);
                    ++n2;
                }
                this.publishersViewer.addCheckStateListener(new ICheckStateListener(){

                    public void checkStateChanged(CheckStateChangedEvent event) {
                        Object element = event.getElement();
                        if (element == null || !(element instanceof Publisher)) {
                            return;
                        }
                        if (OverviewEditorPart.this.updating) {
                            return;
                        }
                        OverviewEditorPart.this.updating = true;
                        OverviewEditorPart.this.execute((IUndoableOperation)new SetPublisherEnablementCommand(OverviewEditorPart.this.getServer(), (Publisher)element, event.getChecked()));
                        OverviewEditorPart.this.updating = false;
                    }
                });
            }
        }
    }

    protected void createTimeoutSection(Composite rightColumnComp, FormToolkit toolkit) {
        Section section = toolkit.createSection(rightColumnComp, 394);
        section.setText(Messages.serverEditorOverviewTimeoutSection);
        section.setDescription(Messages.serverEditorOverviewTimeoutDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        if (this.server != null) {
            Server svr = (Server)this.server;
            Label startTimeoutLabel = this.createLabel(toolkit, composite, Messages.serverEditorOverviewStartTimeout);
            GridData data = new GridData(768);
            data.horizontalIndent = 20;
            startTimeoutLabel.setLayoutData((Object)data);
            this.startTimeoutSpinner = new Spinner(composite, 2048);
            this.startTimeoutSpinner.setEnabled(true);
            this.startTimeoutSpinner.setMinimum(1);
            this.startTimeoutSpinner.setMaximum(1800);
            this.startTimeoutSpinner.setIncrement(5);
            this.startTimeoutSpinner.setSelection(svr.getStartTimeout());
            SWTUtil.setSpinnerTooltip(this.startTimeoutSpinner);
            data = new GridData(128);
            data.widthHint = 30;
            this.startTimeoutSpinner.setLayoutData((Object)data);
            whs.setHelp((Control)this.startTimeoutSpinner, "org.eclipse.wst.server.uispge0026");
            Label stopTimeoutLabel = this.createLabel(toolkit, composite, Messages.serverEditorOverviewStopTimeout);
            data = new GridData(768);
            data.horizontalIndent = 20;
            stopTimeoutLabel.setLayoutData((Object)data);
            this.stopTimeoutSpinner = new Spinner(composite, 2048);
            this.stopTimeoutSpinner.setEnabled(true);
            this.stopTimeoutSpinner.setMinimum(1);
            this.stopTimeoutSpinner.setMaximum(1800);
            this.stopTimeoutSpinner.setIncrement(5);
            this.stopTimeoutSpinner.setSelection(svr.getStopTimeout());
            SWTUtil.setSpinnerTooltip(this.stopTimeoutSpinner);
            data = new GridData(128);
            data.widthHint = 30;
            this.stopTimeoutSpinner.setLayoutData((Object)data);
            whs.setHelp((Control)this.stopTimeoutSpinner, "org.eclipse.wst.server.uispge0027");
            this.startTimeoutSpinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerStartTimeoutCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.startTimeoutSpinner.getSelection()));
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.startTimeoutSpinner);
                    OverviewEditorPart.this.updating = false;
                    OverviewEditorPart.this.validate();
                }
            });
            this.stopTimeoutSpinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerStopTimeoutCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.stopTimeoutSpinner.getSelection()));
                    SWTUtil.setSpinnerTooltip(OverviewEditorPart.this.stopTimeoutSpinner);
                    OverviewEditorPart.this.updating = false;
                    OverviewEditorPart.this.validate();
                }
            });
        }
    }

    protected void editRuntime(IRuntime runtime) {
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        if (this.showWizard(runtimeWorkingCopy) != 1) {
            try {
                runtimeWorkingCopy.save(false, null);
            }
            catch (Exception exception) {}
        }
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = Messages.wizEditRuntimeWizardTitle;
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(runtimeWorkingCopy.getRuntimeType().getId());
        if (fragment2 == null) {
            return 1;
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        WizardFragment fragment = new WizardFragment(){

            @Override
            protected void createChildFragments(List<WizardFragment> list) {
                list.add(fragment2);
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.getEditorSite().getShell(), (IWizard)wizard);
        return dialog.open();
    }

    protected void updateRuntimeCombo() {
        int i;
        IRuntimeType runtimeType = this.server.getServerType().getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (SocketUtil.isLocalhost((String)this.server.getHost()) && this.runtimes != null) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (!runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
        }
        int size = this.runtimes.length;
        String[] items = new String[size];
        i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].getName();
            ++i;
        }
        this.runtimeCombo.setItems(items);
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        super.dispose();
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
        if (this.runtimeListener != null) {
            ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
        if (this.managedForm != null) {
            this.managedForm.dispose();
            this.managedForm = null;
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.serverName == null) {
            return;
        }
        this.updating = true;
        if (this.server != null) {
            Server svr;
            int publishSetting;
            this.serverName.setText(this.server.getName());
            if (this.readOnly) {
                this.serverName.setEditable(false);
            } else {
                this.serverName.setEditable(true);
            }
            this.hostname.setText(this.server.getHost());
            if (this.readOnly) {
                this.hostname.setEditable(false);
            } else {
                this.hostname.setEditable(true);
            }
            if (this.runtimeCombo != null) {
                this.updateRuntimeCombo();
                IRuntime runtime = this.server.getRuntime();
                int size2 = this.runtimes.length;
                int i = 0;
                while (i < size2) {
                    if (this.runtimes[i].equals(runtime)) {
                        this.runtimeCombo.select(i);
                    }
                    ++i;
                }
                if (this.readOnly) {
                    this.runtimeCombo.setEnabled(false);
                } else {
                    this.runtimeCombo.setEnabled(true);
                }
            }
            if (this.serverConfiguration != null) {
                IFolder folder = this.server.getServerConfiguration();
                if (folder == null) {
                    this.serverConfiguration.setText(Messages.elementUnknownName);
                } else {
                    this.serverConfiguration.setText("" + this.server.getServerConfiguration().getFullPath());
                }
                if (this.readOnly) {
                    this.serverConfiguration.setEditable(false);
                    this.browse.setEnabled(false);
                } else {
                    this.serverConfiguration.setEditable(true);
                    this.browse.setEnabled(true);
                }
            }
            this.autoPublishDisable.setSelection((publishSetting = (svr = (Server)this.server).getAutoPublishSetting()) == 1);
            this.autoPublishEnable.setSelection(publishSetting == 2);
            this.autoPublishTime.setSelection(svr.getAutoPublishTime());
            if (this.readOnly) {
                this.autoPublishDisable.setEnabled(false);
                this.autoPublishEnable.setEnabled(false);
                this.autoPublishTime.setEnabled(false);
            } else {
                this.autoPublishDisable.setEnabled(true);
                this.autoPublishEnable.setEnabled(true);
                this.autoPublishTime.setEnabled(publishSetting == 2);
            }
        }
        this.updating = false;
        this.validate();
    }

    protected void validate() {
        IManagedForm mForm = this.getManagedForm();
        if (mForm == null) {
            return;
        }
        mForm.getMessageManager().removeMessage((Object)"name", (Control)this.serverName);
        if (this.server != null && this.serverName != null && ServerPlugin.isNameInUse((Object)this.server, (String)this.serverName.getText().trim())) {
            mForm.getMessageManager().addMessage((Object)"name", Messages.errorDuplicateName, null, 3, (Control)this.serverName);
        }
        if (this.serverConfiguration != null) {
            IFolder folder;
            mForm.getMessageManager().removeMessage((Object)"config", (Control)this.serverConfiguration);
            if (this.server != null && this.server.getServerType() != null && this.server.getServerType().hasServerConfiguration() && ((folder = this.getServer().getServerConfiguration()) == null || !folder.exists())) {
                mForm.getMessageManager().addMessage((Object)"config", Messages.errorMissingConfiguration, null, 3, (Control)this.serverConfiguration);
            }
        }
        mForm.getMessageManager().update();
    }

    protected void updateDecoration(ControlDecoration decoration, IStatus status) {
        if (status != null) {
            Image newImage = null;
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            switch (status.getSeverity()) {
                case 1: {
                    newImage = registry.getFieldDecoration("DEC_REQUIRED").getImage();
                    break;
                }
                case 2: {
                    newImage = registry.getFieldDecoration("DEC_WARNING").getImage();
                    break;
                }
                case 4: {
                    newImage = registry.getFieldDecoration("DEC_ERROR").getImage();
                }
            }
            decoration.setDescriptionText(status.getMessage());
            decoration.setImage(newImage);
            decoration.show();
        } else {
            decoration.setDescriptionText(null);
            decoration.hide();
        }
    }

    public void setFocus() {
        if (this.serverName != null) {
            this.serverName.setFocus();
        } else if (this.serverConfiguration != null) {
            this.serverConfiguration.setFocus();
        }
    }

    class PublishLabelProvider
    extends BaseLabelProvider {
        PublishLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Publisher) {
                Publisher pub = (Publisher)element;
                return pub.getName();
            }
            return "";
        }
    }

    class PublisherContentProvider
    extends BaseContentProvider {
        protected Publisher[] pubs;

        public PublisherContentProvider(Publisher[] pubs) {
            this.pubs = pubs;
        }

        public Object[] getElements(Object inputElement) {
            return this.pubs;
        }
    }
}

