/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.editor;

import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryExtension;
import org.eclipse.wst.sse.ui.internal.util.Assert;

public class EditorModelUtil {
    public static void addFactoriesTo(final IStructuredModel structuredModel) {
        if (structuredModel == null) {
            return;
        }
        AdapterFactoryRegistry adapterRegistry = SSEUIPlugin.getDefault().getAdapterFactoryRegistry();
        String contentTypeId = structuredModel.getContentTypeIdentifier();
        Iterator adapterFactoryProviders = null;
        adapterFactoryProviders = adapterRegistry instanceof AdapterFactoryRegistryExtension ? ((AdapterFactoryRegistryExtension)((Object)adapterRegistry)).getAdapterFactories(contentTypeId) : adapterRegistry.getAdapterFactories();
        FactoryRegistry factoryRegistry = structuredModel.getFactoryRegistry();
        Assert.isNotNull(factoryRegistry, SSEUIMessages.EditorModelUtil_0);
        while (adapterFactoryProviders.hasNext()) {
            try {
                final AdapterFactoryProvider provider = (AdapterFactoryProvider)adapterFactoryProviders.next();
                if (!provider.isFor((IDocumentTypeHandler)structuredModel.getModelHandler())) continue;
                SafeRunner.run((ISafeRunnable)new SafeRunnable(SSEUIMessages.EditorModelUtil_1){

                    public void run() {
                        provider.addAdapterFactories(structuredModel);
                    }
                });
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }
}

