/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Iterator;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.ui.internal.commands.AddFaultCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageReferenceCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public final class AddOperationCommand
extends WSDLElementCommand {
    private PortType portType;
    private String name;
    private Operation operation;
    private Operation originalOperation;
    private boolean copyInOutFault;
    private boolean createInput = false;
    private boolean createOutput = false;
    private boolean createFault = false;
    private final String DEFAULT_INPUT_NAME = "";
    private final String DEFAULT_OUTPUT_NAME = "";
    private final String DEFAULT_FAULT_NAME = "";

    public AddOperationCommand(PortType portType, String name) {
        this.portType = portType;
        this.name = name;
    }

    public AddOperationCommand(PortType portType, String name, boolean createInput, boolean createOutput, boolean createFault) {
        this.portType = portType;
        this.name = name;
        this.createInput = createInput;
        this.createOutput = createOutput;
        this.createFault = createFault;
    }

    public AddOperationCommand(PortType portType, Operation originalOperation, String name, boolean copyInOutFault) {
        this.portType = portType;
        this.originalOperation = originalOperation;
        this.name = name;
        this.copyInOutFault = copyInOutFault;
    }

    public void run() {
        this.operation = WSDLFactory.eINSTANCE.createOperation();
        this.operation.setName(this.name);
        this.operation.setEnclosingDefinition(this.portType.getEnclosingDefinition());
        this.portType.addOperation((javax.wsdl.Operation)this.operation);
        if (this.originalOperation == null) {
            AddMessageReferenceCommand command = null;
            if (this.createInput) {
                command = new AddInputCommand(this.operation, "", true);
                command.run();
            }
            if (this.createOutput) {
                command = new AddOutputCommand(this.operation, "", true);
                command.run();
            }
            if (this.createFault) {
                command = new AddFaultCommand(this.operation, "", true);
                command.run();
            }
        } else if (this.copyInOutFault) {
            AddMessageReferenceCommand command = null;
            if (this.originalOperation.getEOutput() != null) {
                Output output = this.originalOperation.getEOutput();
                command = new AddOutputCommand(this.operation, output, NameUtil.buildUniqueOutputName(this.portType, this.operation.getName(), ""));
                command.run();
            }
            if (this.originalOperation.getEInput() != null) {
                Input input = this.originalOperation.getEInput();
                command = new AddInputCommand(this.operation, input, NameUtil.buildUniqueInputName(this.portType, this.operation.getName(), ""));
                command.run();
            }
            if (this.originalOperation.getEFaults() != null) {
                Iterator it = this.originalOperation.getEFaults().iterator();
                while (it.hasNext()) {
                    Fault fault = (Fault)it.next();
                    command = new AddFaultCommand(this.operation, fault, NameUtil.buildUniqueFaultName(this.originalOperation, fault.getName()));
                    command.run();
                }
            }
        }
    }

    public WSDLElement getWSDLElement() {
        return this.operation;
    }

    public void setName(String name) {
        this.name = name;
    }
}

