/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaIdMappingTests
extends ContextModelTestCase {
    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private void createGeneratedValueAnnotation() throws Exception {
        this.createAnnotationAndMembers("GeneratedValue", "");
    }

    private void createTemporalAnnotation() throws Exception {
        this.createAnnotationAndMembers("Temporal", "TemporalType value();");
    }

    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithTemporal() throws Exception {
        this.createEntityAnnotation();
        this.createTemporalAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Temporal", "javax.persistence.TemporalType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Temporal(TemporalType.TIMESTAMP)").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdMappingGeneratedValue() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        this.createGeneratedValueAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.GeneratedValue"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@GeneratedValue").append(CR);
            }
        });
    }

    public JavaIdMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((BasicMapping)persistentAttribute.getMapping()).getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((BasicMapping)persistentAttribute.getMapping()).getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaIdMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)persistentAttribute.getMapping()).getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIME, (Object)((VersionMapping)persistentAttribute.getMapping()).getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        idMapping.addGeneratedValue();
        idMapping.addTableGenerator();
        idMapping.addSequenceGenerator();
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Column"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
    }

    public void testGetTemporal() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getTemporal());
    }

    public void testGetTemporal2() throws Exception {
        this.createTestEntityWithTemporal();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.TIMESTAMP, (Object)idMapping.getTemporal());
    }

    public void testSetTemporal() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getTemporal());
        idMapping.setTemporal(org.eclipse.jpt.core.context.TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        JavaIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        idMapping.setTemporal(null);
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getTemporal());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.addAnnotation("javax.persistence.Temporal");
        temporal.setValue(TemporalType.DATE);
        JavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.TemporalType.DATE, (Object)idMapping.getTemporal());
        attributeResource.removeAnnotation("javax.persistence.Temporal");
        JavaIdMappingTests.assertNull((Object)idMapping.getTemporal());
        JavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        JavaIdMappingTests.assertSame((Object)idMapping, (Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testGetColumn() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getName());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ColumnAnnotation column = (ColumnAnnotation)attributeResource.addAnnotation("javax.persistence.Column");
        column.setName("foo");
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getSpecifiedName());
        JavaIdMappingTests.assertEquals((String)"foo", (String)idMapping.getColumn().getName());
        JavaIdMappingTests.assertEquals((String)"id", (String)idMapping.getColumn().getDefaultName());
    }

    public void testGetSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.SequenceGenerator");
        JavaIdMappingTests.assertNotNull((Object)idMapping.getSequenceGenerator());
        JavaIdMappingTests.assertEquals((int)1, (int)attributeResource.annotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
        idMapping.getSequenceGenerator().setName("foo");
        JavaIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
    }

    public void testAddSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getSequenceGenerator());
        idMapping.addSequenceGenerator();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getSequenceGenerator());
        try {
            idMapping.addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.SequenceGenerator");
        idMapping.removeSequenceGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getSequenceGenerator());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.SequenceGenerator"));
        try {
            idMapping.removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getTableGenerator());
        JavaIdMappingTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.TableGenerator");
        JavaIdMappingTests.assertNotNull((Object)idMapping.getTableGenerator());
        JavaIdMappingTests.assertEquals((int)1, (int)attributeResource.annotationsSize());
        JavaIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
        idMapping.getTableGenerator().setName("foo");
        JavaIdMappingTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)idMapping.getPersistenceUnit().allGenerators()));
    }

    public void testAddTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getTableGenerator());
        idMapping.addTableGenerator();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getTableGenerator());
        try {
            idMapping.addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.TableGenerator");
        idMapping.removeTableGenerator();
        JavaIdMappingTests.assertNull((Object)idMapping.getTableGenerator());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.TableGenerator"));
        try {
            idMapping.removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testGetGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.GeneratedValue");
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)1, (int)attributeResource.annotationsSize());
    }

    public void testGetGeneratedValue2() throws Exception {
        this.addXmlClassRef("test.AnnotationTestType");
        this.createTestEntityWithIdMappingGeneratedValue();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertEquals((int)1, (int)attributeResource.annotationsSize());
    }

    public void testAddGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        idMapping.addGeneratedValue();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
        JavaIdMappingTests.assertNotNull((Object)idMapping.getGeneratedValue());
        try {
            idMapping.addGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveGeneratedValue() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getSpecifiedMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        attributeResource.addAnnotation("javax.persistence.GeneratedValue");
        idMapping.removeGeneratedValue();
        JavaIdMappingTests.assertNull((Object)idMapping.getGeneratedValue());
        JavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.GeneratedValue"));
        try {
            idMapping.removeGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        JavaIdMappingTests.fail((String)"IllegalStateException not thrown");
    }
}

