/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaJoinColumnTests
extends ContextModelTestCase {
    public JavaJoinColumnTests(String name) {
        super(name);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createOneToOneAnnotation() throws Exception {
        this.createAnnotationAndMembers("OneToOne", "");
    }

    private void createJoinColumnAnnotation() throws Exception {
        this.createAnnotationAndMembers("JoinColumn", "String name() default \"\"; String referencedColumnName() default \"\"; boolean unique() default false; boolean nullable() default true; boolean insertable() default true; boolean updatable() default true; String columnDefinition() default \"\"; String table() default \"\";");
    }

    private ICompilationUnit createTestEntityWithOneToOne() throws Exception {
        this.createEntityAnnotation();
        this.createOneToOneAnnotation();
        this.createJoinColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToOne() throws Exception {
        this.createEntityAnnotation();
        this.createOneToOneAnnotation();
        this.createJoinColumnAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
                sb.append("    private Project project;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        JavaJoinColumnTests.assertEquals((String)"FOO", (String)javaJoinColumn.getName());
        javaJoinColumn.setName(null);
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"foo", (String)joinColumn.getSpecifiedName());
        JavaJoinColumnTests.assertEquals((String)"foo", (String)javaJoinColumn.getName());
        joinColumn.setSpecifiedName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedName());
        JavaJoinColumnTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinColumn"));
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidOneToOne();
        this.createTargetEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        oneToOneMapping.getDefaultJoinColumn();
    }

    public void testUpdateSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setReferencedColumnName("BAR");
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getReferencedColumnName());
        javaJoinColumn.setReferencedColumnName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertNull((String)"BAR", (Object)javaJoinColumn.getReferencedColumnName());
    }

    public void testModifySpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedReferencedColumnName("BAR");
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getReferencedColumnName());
        joinColumn.setSpecifiedReferencedColumnName(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedReferencedColumnName());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getReferencedColumnName());
    }

    public void testDefaultReferencedColumnName() throws Exception {
    }

    public void testUpdateTable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setTable("BAR");
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedTable());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getTable());
        javaJoinColumn.setTable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedTable());
        JavaJoinColumnTests.assertNull((String)"BAR", (Object)javaJoinColumn.getTable());
    }

    public void testModifyTable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedTable("BAR");
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)joinColumn.getSpecifiedTable());
        JavaJoinColumnTests.assertEquals((String)"BAR", (String)javaJoinColumn.getTable());
        joinColumn.setSpecifiedTable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedTable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getTable());
    }

    public void testDefaultTable() throws Exception {
    }

    public void testUpdateUnique() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setUnique(Boolean.TRUE);
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)javaJoinColumn.getUnique());
        javaJoinColumn.setUnique(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUnique());
    }

    public void testModifyUnique() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)javaJoinColumn.getUnique());
        joinColumn.setSpecifiedUnique(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUnique());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUnique());
    }

    public void testUpdateNullable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setNullable(Boolean.FALSE);
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getNullable());
        javaJoinColumn.setNullable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getNullable());
    }

    public void testModifyNullable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getNullable());
        joinColumn.setSpecifiedNullable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedNullable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getNullable());
    }

    public void testUpdateInsertable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setInsertable(Boolean.FALSE);
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getInsertable());
        javaJoinColumn.setInsertable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getInsertable());
    }

    public void testModifyInsertable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getInsertable());
        joinColumn.setSpecifiedInsertable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedInsertable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getInsertable());
    }

    public void testUpdateUpdatable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((int)0, (int)oneToOneMapping.specifiedJoinColumnsSize());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn);
        javaJoinColumn = (JoinColumnAnnotation)attributeResource.addAnnotation("javax.persistence.JoinColumn");
        javaJoinColumn.setName("FOO");
        javaJoinColumn.setUpdatable(Boolean.FALSE);
        JavaJoinColumn joinColumn = (JavaJoinColumn)oneToOneMapping.specifiedJoinColumns().next();
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getUpdatable());
        javaJoinColumn.setUpdatable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUpdatable());
    }

    public void testModifyUpdatable() throws Exception {
        this.createTestEntityWithOneToOne();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaOneToOneMapping oneToOneMapping = (JavaOneToOneMapping)((JavaPersistentAttribute)this.javaPersistentType().attributes().next()).getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaJoinColumn joinColumn = oneToOneMapping.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("foo");
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        JoinColumnAnnotation javaJoinColumn = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)javaJoinColumn.getUpdatable());
        joinColumn.setSpecifiedUpdatable(null);
        JavaJoinColumnTests.assertNull((Object)joinColumn.getSpecifiedUpdatable());
        JavaJoinColumnTests.assertNull((Object)javaJoinColumn.getUpdatable());
    }
}

