/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmGeneratedValueTests
extends ContextModelTestCase {
    public OrmGeneratedValueTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmGeneratedValue ormGeneratedValue = ormIdMapping.addGeneratedValue();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        XmlGeneratedValue generatedValueResource = idResource.getGeneratedValue();
        generatedValueResource.setGenerator("FOO");
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)ormGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)generatedValueResource.getGenerator());
        generatedValueResource.setGenerator(null);
        OrmGeneratedValueTests.assertNull((Object)ormGeneratedValue.getSpecifiedGenerator());
        OrmGeneratedValueTests.assertNull((Object)generatedValueResource.getGenerator());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmGeneratedValue ormGeneratedValue = ormIdMapping.addGeneratedValue();
        XmlId idResource = (XmlId)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        XmlGeneratedValue generatedValueResource = idResource.getGeneratedValue();
        ormGeneratedValue.setSpecifiedGenerator("FOO");
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)generatedValueResource.getGenerator());
        OrmGeneratedValueTests.assertEquals((String)"FOO", (String)ormGeneratedValue.getSpecifiedGenerator());
        ormGeneratedValue.setSpecifiedGenerator(null);
        OrmGeneratedValueTests.assertNull((Object)generatedValueResource.getGenerator());
        OrmGeneratedValueTests.assertNull((Object)ormGeneratedValue.getSpecifiedGenerator());
    }
}

